/*
 * Decompiled with CFR 0.152.
 */
package Jet.Time;

import AceJet.Ace;
import Jet.Lex.Tokenizer;
import Jet.Time.NumberAnnotator;
import Jet.Time.TimeAnnotator;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;

public class TimeMain {
    private static final String DOC_DIR = "docs";
    private static final String RESULT_DIR = "result";
    private static final String RULE_FILE = "data/time_rules.yaml";
    private static final Pattern YMDpattern = Pattern.compile("(^|\\D)((199|200)\\d{5})($|\\D)");
    public static TimeAnnotator timeAnnotator;

    public static void main(String[] stringArray) throws IOException {
        timeAnnotator = new TimeAnnotator(RULE_FILE);
        File file = new File(DOC_DIR);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            TimeMain.processDocument(fileArray[i]);
        }
    }

    private static void processDocument(File file) throws IOException {
        String string = TimeMain.readFileToString(file);
        Document document = new Document(string);
        document.annotateWithTag("DATETIME");
        document.annotateWithTag("TEXT");
        TimeMain.processDocument(document);
        File file2 = new File(RESULT_DIR);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File file3 = new File(file2, file.getName());
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
        bufferedWriter.write(document.writeSGML("TIMEX2").toString());
        ((Writer)bufferedWriter).close();
    }

    public static void processDocument(Document document) {
        DateTime dateTime;
        Object object2;
        Vector<Annotation> vector;
        Vector<Annotation> vector2 = document.annotationsOfType("DATETIME");
        if (vector2 == null || vector2.size() == 0) {
            vector2 = document.annotationsOfType("DATE_TIME");
        }
        NumberAnnotator numberAnnotator = new NumberAnnotator();
        DateTime object3 = new DateTime();
        boolean bl = false;
        if (vector2 != null && vector2.size() > 0) {
            vector = vector2.get(0);
            Tokenizer.tokenize(document, ((Annotation)((Object)vector)).span());
            numberAnnotator.annotate(document, ((Annotation)((Object)vector)).span());
            timeAnnotator.annotate(document, ((Annotation)((Object)vector)).span(), object3);
            object2 = document.annotationsOfType("TIMEX2", ((Annotation)((Object)vector)).span());
            if (object2 != null && ((Vector)object2).size() > 0) {
                Annotation object4 = (Annotation)((Vector)object2).get(0);
                if (object4.get("VAL") != null) {
                    object3 = new DateTime(object4.get("VAL"));
                    bl = true;
                } else {
                    System.out.println("*** Cannot analyze DATETIME time expression " + document.text(object4));
                }
            } else {
                System.out.println("*** Cannot analyze DATETIME " + document.text((Annotation)((Object)vector)));
            }
        }
        if (!bl && (vector = Ace.getDocId(document)) != null && ((Matcher)(object2 = YMDpattern.matcher((CharSequence)((Object)vector)))).find() && (dateTime = TimeMain.parseDocIdDate(((Matcher)object2).group(2))) != null) {
            object3 = dateTime;
            bl = true;
        }
        if (!bl) {
            System.out.println("*** Using today's date as reference date.");
        }
        if ((vector = document.annotationsOfType("TEXT")) == null) {
            object2 = document.fullSpan();
            if (document.annotationsOfType("token") == null) {
                Tokenizer.tokenize(document, object2);
            }
            numberAnnotator.annotate(document, (Span)object2);
            timeAnnotator.annotate(document, (Span)object2, object3);
        } else {
            for (Annotation annotation : vector) {
                Span span = annotation.span();
                if (document.annotationsOfType("token", span) == null) {
                    Tokenizer.tokenize(document, span);
                }
                numberAnnotator.annotate(document, span);
                timeAnnotator.annotate(document, span, object3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileToString(File file) throws IOException {
        char[] cArray = new char[4096];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = bufferedReader.read(cArray)) >= 0) {
                stringWriter.write(cArray, 0, n);
            }
        }
        finally {
            TimeMain.closeQuitely(bufferedReader);
        }
        return stringWriter.toString();
    }

    private static void closeQuitely(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static DateTime parseDocIdDate(String string) {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6, 8));
        try {
            return new DateTime(n, n2, n3, 0, 0, 0, 0);
        }
        catch (IllegalFieldValueException illegalFieldValueException) {
            return null;
        }
    }
}

