/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.LearnRelations;
import Jet.Control;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.StatParser;
import Jet.Pat.NewAnnotationAction;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SpecialZoner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PerfectAce
extends Resolve {
    static HashMap entityMentionMap = null;

    public static void main(String[] stringArray) throws IOException {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String string2 = string + "ACE 05/V4/";
        String string3 = string2 + "perfect-parses/un-sgm.txt";
        PerfectAce.parseCollection(string3);
    }

    private static void parseCollection(String string) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace perfect just parser.properties");
        Pat.trace = false;
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        block0: for (int i = 0; i < documentCollection.size(); ++i) {
            Object object;
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            Vector<Annotation> vector = externalDocument.annotationsOfType("sentence");
            if (vector != null) {
                for (int j = 0; j < vector.size(); ++j) {
                    object = vector.get(j);
                    if (((Annotation)object).get("parse") == null) continue;
                    System.out.println("\nSkipping document " + externalDocument.fileName() + ", already parsed");
                    continue block0;
                }
            }
            SpecialZoner.findSpecialZones(externalDocument);
            String string2 = externalDocument.fullFileName();
            object = string2.replaceAll(".sgm", ".apf.xml");
            AceDocument aceDocument = new AceDocument(string2, (String)object);
            Ace.monocase = Ace.allLowerCase(externalDocument);
            Control.processDocument(externalDocument, null, i == -1, i);
            PerfectAce.createPerfectNames(externalDocument, aceDocument);
            Vector<Annotation> vector2 = externalDocument.annotationsOfType("sentence");
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation = vector2.get(j);
                StatParser.parse(externalDocument, annotation.span());
            }
            externalDocument.removeAnnotationsOfType("ENAMEX");
            StatParser.clearInputAnnotations(externalDocument);
            externalDocument.removeAnnotationsOfType("tagger");
            externalDocument.save();
        }
    }

    static void createPerfectNames(ExternalDocument externalDocument, AceDocument aceDocument) {
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = arrayList.get(i);
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                Object object;
                int n;
                Annotation annotation;
                Vector<Annotation> vector;
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                LearnRelations.doc = externalDocument;
                Span span = aceEntityMention.jetHead;
                String string = aceEntityMention.type;
                if (string.equals("PRE") && (vector = externalDocument.annotationsAt(span.start(), "ENAMEX")) != null && (annotation = vector.get(0)).end() == span.end()) {
                    string = "NAM";
                }
                if (!string.equals("NAM")) continue;
                int n2 = n = span.start();
                int n3 = span.end();
                while (n2 < n3) {
                    object = externalDocument.tokenAt(n2);
                    if (object == null) {
                        n2 = n3;
                        continue;
                    }
                    n2 = ((Annotation)object).end();
                }
                object = new Span(n, n2);
                NewAnnotationAction.hideAnnotations(externalDocument, "constit", (Span)object);
                NewAnnotationAction.hideAnnotations(externalDocument, "token", (Span)object);
                Annotation annotation2 = new Annotation("constit", (Span)object, new FeatureSet("cat", "name", "pa", new FeatureSet("head", aceEntity.type.toLowerCase(), "number", "singular")));
                externalDocument.addAnnotation(annotation2);
            }
        }
    }

    static void buildEntityMentionMap(ExternalDocument externalDocument, AceDocument aceDocument) {
        entityMentionMap = new HashMap();
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = arrayList.get(i);
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                LearnRelations.doc = externalDocument;
                Span span = aceEntityMention.jetHead;
                entityMentionMap.put(new Integer(span.start()), new Object[]{aceEntity, aceEntityMention});
            }
        }
    }

    public static boolean validMention(Document document, Annotation annotation, String string) {
        if (entityMentionMap == null) {
            System.err.println("*** PerfectAce.validMention:  no entityMentionMap");
            return true;
        }
        if (string == "title") {
            Annotation[] annotationArray = Tokenizer.gatherTokens(document, annotation.span());
            for (int i = 0; i < annotationArray.length; ++i) {
                Integer n = new Integer(annotationArray[i].start());
                if (entityMentionMap.get(n) == null) continue;
                return true;
            }
            return false;
        }
        Integer n = new Integer(annotation.start());
        boolean bl = entityMentionMap.get(n) != null;
        return bl;
    }

    public static String getEntityID(Annotation annotation) {
        if (entityMentionMap == null) {
            return null;
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            return null;
        }
        AceEntity aceEntity = (AceEntity)objectArray[0];
        return aceEntity.id;
    }

    public static String getTypeSubtype(Annotation annotation) {
        if (entityMentionMap == null) {
            return null;
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            System.err.println("*** No entityMentionMap entry for " + n);
            return "OTHER";
        }
        AceEntity aceEntity = (AceEntity)objectArray[0];
        if (aceEntity.subtype != null && !aceEntity.subtype.equals("")) {
            return aceEntity.type + ":" + aceEntity.subtype;
        }
        return aceEntity.type;
    }

    static String getMentionRole(Annotation annotation) {
        if (entityMentionMap == null) {
            return "GPE";
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            return "GPE";
        }
        AceEntityMention aceEntityMention = (AceEntityMention)objectArray[1];
        return aceEntityMention.role;
    }

    static String getMentionType(Annotation annotation) {
        if (entityMentionMap == null) {
            return "NOMINAL";
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            return "NOMINAL";
        }
        AceEntityMention aceEntityMention = (AceEntityMention)objectArray[1];
        return aceEntityMention.type;
    }
}

