/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityName;
import Jet.JetTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class NameSubtyper {
    static PrintStream writer;
    static String featureFile;
    static String modelFile;
    static GISModel model;

    public static void main(String[] stringArray) throws IOException {
        String string;
        if (stringArray.length < 5 || stringArray.length % 2 == 0) {
            System.err.println("NameSubtyper requires 3+2n arguments");
            System.err.println("  year feature-file model-file (apfDirectory apfFileList)+");
            System.exit(1);
        }
        if ((string = stringArray[0]).equals("2004")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = false;
        } else if (string.equals("2005")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = true;
        } else {
            System.err.println("Invalid year (must be 2004 or 2005)");
            System.exit(1);
        }
        featureFile = stringArray[1];
        modelFile = stringArray[2];
        writer = new PrintStream(new FileOutputStream(featureFile));
        for (int i = 3; i < stringArray.length; i += 2) {
            NameSubtyper.processFileList(stringArray[i], stringArray[i + 1]);
        }
        NameSubtyper.createModel();
        NameSubtyper.store(modelFile);
        System.out.println("Finished.");
    }

    private static void processFileList(String string, String string2) throws IOException {
        String string3;
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string3);
            String string4 = string + string3 + ".sgm";
            String string5 = string + string3 + ".apf.xml";
            NameSubtyper.analyzeDocument(string4, string5);
        }
    }

    private static void analyzeDocument(String string, String string2) {
        AceDocument aceDocument = new AceDocument(string, string2);
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = arrayList.get(i);
            String string3 = aceEntity.type;
            String string4 = aceEntity.subtype;
            ArrayList arrayList2 = aceEntity.names;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityName aceEntityName = (AceEntityName)arrayList2.get(j);
                String string5 = aceEntityName.text;
                String[] stringArray = string5.split("\\s");
                String[] stringArray2 = NameSubtyper.NEfeatures(stringArray, string3);
                for (int k = 0; k < stringArray2.length; ++k) {
                    writer.print(stringArray2[k] + " ");
                }
                writer.println(string4);
            }
        }
    }

    private static String[] NEfeatures(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string = string.substring(0, 3);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = string + "=" + stringArray[i].toLowerCase();
        }
        return stringArray2;
    }

    public static void createModel() {
        boolean bl = false;
        boolean bl2 = true;
        try {
            FileReader fileReader = new FileReader(new File(featureFile));
            BasicEventStream basicEventStream = new BasicEventStream(new PlainTextByLineDataStream(fileReader));
            GIS.SMOOTHING_OBSERVATION = 0.1;
            model = GIS.trainModel(basicEventStream, 100, 2, bl, bl2);
        }
        catch (Exception exception) {
            System.err.print("Unable to create model due to exception: ");
            System.err.println(exception);
        }
    }

    public static void store(String string) {
        try {
            File file = new File(string);
            SuffixSensitiveGISModelWriter suffixSensitiveGISModelWriter = new SuffixSensitiveGISModelWriter(model, file);
            suffixSensitiveGISModelWriter.persist();
        }
        catch (IOException iOException) {
            System.err.println("MaxEntNE.saveModel: unable to save model");
            System.err.println(iOException);
        }
    }

    public static void load() {
        String string = JetTest.getConfigFile("Ace.NameSubtypeModel.fileName");
        if (string != null) {
            NameSubtyper.load(string);
        } else {
            System.err.println("NameSubtyper.load:  no file name specified in config file");
        }
    }

    public static void load(String string) {
        try {
            model = (GISModel)new SuffixSensitiveGISModelReader(new File(string)).getModel();
            System.err.println("GIS model loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public static String classify(String string, String string2) {
        if (model == null) {
            NameSubtyper.load();
        }
        String[] stringArray = string.split("\\s");
        String[] stringArray2 = NameSubtyper.NEfeatures(stringArray, string2);
        String string3 = model.getBestOutcome(model.eval(stringArray2));
        return string3;
    }
}

