import java.io.File;
import java.io.IOException;
import java.util.Scanner;

import javax.print.PrintException;

import Geometry.Point;
import Geometry.rectCube;
import Polynomial.*;

public class outputObj{
	public static void main(String[] args) throws PrintException{
		String path="./testcases/pv1.txt";
		double xmin=-8;
		double ymin=-8;
		double zmin=-8;
		double xmax=8;
		double ymax=8;
		double zmax=8;
		int sizeFactor=4;
		
		
		Poly3 p=null;
		
		Point A=null;
		Point B=null;
		rectCube rc=null;
		
		SurfaceR sphere;
		double ratio=2.0;
		
		long time=System.currentTimeMillis();
		
		
		String a=" ";
		try{
			Scanner scan=new Scanner(new File("./para.txt"));
			a=scan.nextLine();
			System.out.println(a);	 
		}catch (IOException e) {
			System.err.println("IOException");
		}
		String[] para=a.split(" ");
		
		if (para.length>0){
			ratio=Double.parseDouble(para[0]);
			if (para.length>1){
				path=para[1];
				if (para.length>2){
					sizeFactor=Integer.parseInt(para[2]);
					if (para.length>8){
						xmin=Double.parseDouble(para[3]);
						ymin=Double.parseDouble(para[4]);
						zmin=Double.parseDouble(para[5]);
						xmax=Double.parseDouble(para[6]);
						ymax=Double.parseDouble(para[7]);
						zmax=Double.parseDouble(para[8]);
					}
				}
			}
		}
		p=new Poly3(Polynomial.getS(path));
		A=new Point(xmin,ymin,zmin);
		B=new Point(xmax,ymax,zmax);
		rc=new rectCube(A, B);
		
		sphere = new SurfaceR(p,rc,ratio,sizeFactor);
		
		String[] eg=path.split("/");
		sphere.outputObj("./output/"+"rect_"+ratio+"_"+eg[eg.length-1]+".obj");
		//sphere.outputBox("./output/"+"boxes_rect_"+ratio+"_"+eg[eg.length-1]+".obj");
		System.out.println(System.currentTimeMillis()-time);
	}
}