//cxyz algorithm
import java.awt.*;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Stack;

import javax.print.PrintException;

import Geometry.*;
import Geometry.Point;
import Polynomial.*;

public class SurfaceR extends Shape3D {
	double vertices[][];
	double temp_vertices[][];
	int faces[][];
	LinkedList<rectCube> boxes=new LinkedList<rectCube>();
	Matrix3D mTrans = new Matrix3D(); // Transformation Matrix
	Material material = new Material();
	int counter = 1;
	double ratio = 1;

	PriorityQueue<rectCube> AddAgainx = new PriorityQueue<rectCube>(10,
			new sizeComparatorX()); // Cxyz cubes
	PriorityQueue<rectCube> AddAgainy = new PriorityQueue<rectCube>(10,
			new sizeComparatorY()); // Cxyz cubes
	PriorityQueue<rectCube> AddAgainz = new PriorityQueue<rectCube>(10,
			new sizeComparatorZ()); // Cxyz cubes
	
	rectCube testCube;
	
	public SurfaceR(Poly3 p, rectCube c, double r, int sizeFactor)
			throws PrintException {
		ratio = r;

		Poly3 px = p.derivative('x');
		Poly3 py = p.derivative('y');
		Poly3 pz = p.derivative('z');
		HashMap<Point, Integer> v = new HashMap<Point, Integer>();

		LinkedList<rectCube> Q0 = new LinkedList<rectCube>();
		PriorityQueue<rectCube> Qxy = new PriorityQueue<rectCube>(10,
				new sizeComparatorXY()); // Cxyz cubes
		PriorityQueue<rectCube> Qyz = new PriorityQueue<rectCube>(10,
				new sizeComparatorYZ()); // Cxyz cubes
		PriorityQueue<rectCube> Qzx = new PriorityQueue<rectCube>(10,
				new sizeComparatorZX()); // Cxyz cubes
		PriorityQueue<rectCube> Qx = new PriorityQueue<rectCube>(10,
				new sizeComparatorX()); // Cxyz cubes
		PriorityQueue<rectCube> Qy = new PriorityQueue<rectCube>(10,
				new sizeComparatorY()); // Cxyz cubes
		PriorityQueue<rectCube> Qz = new PriorityQueue<rectCube>(10,
				new sizeComparatorZ()); // Cxyz cubes

		ArrayList<Point[]> f = new ArrayList<Point[]>();

		Q0.add(c);
		/****************************
		 *subdivision criteria
		 ****************************/
		while (!Q0.isEmpty()) {
			rectCube t1 = Q0.poll();
			if (t1.C0(p)) {
				// C0.add(t1);
			} else if (t1.Cxyz(p, px, py, pz)) {
				Qx.add(t1);
			} else {
				rectCube[] temp = t1.childX();
				if ((this.C0(temp, p) || this.Cxyz(temp, p, px, py, pz))
						&& t1.ratioX() < ratio) {
					ArrayList<rectCube> tempQ = t1.splitX();
					counter++;
					for (int i = 0; i < tempQ.size(); ++i) {
						Q0.add(tempQ.get(i));
					}
					continue;
				}
				temp = t1.childY();
				if ((this.C0(temp, p) || this.Cxyz(temp, p, px, py, pz))
						&& t1.ratioY() < ratio) {
					ArrayList<rectCube> tempQ = t1.splitY();
					counter++;
					for (int i = 0; i < tempQ.size(); ++i) {
						Q0.add(tempQ.get(i));
					}
					continue;
				}
				temp = t1.childZ();
				if ((this.C0(temp, p) || this.Cxyz(temp, p, px, py, pz))
						&& t1.ratioZ() < ratio) {
					ArrayList<rectCube> tempQ = t1.splitZ();
					counter++;
					for (int i = 0; i < tempQ.size(); ++i) {
						Q0.add(tempQ.get(i));
					}
					continue;
				}

				temp = t1.childXY();
				if ((this.C0(temp, p) || this.Cxyz(temp, p, px, py, pz))
						&& t1.ratioXY() < ratio) {
					ArrayList<rectCube> tempQ = t1.splitXY();
					counter += 3;
					for (int i = 0; i < tempQ.size(); ++i) {
						Q0.add(tempQ.get(i));
					}
					continue;
				}
				temp = t1.childYZ();
				if ((this.C0(temp, p) || this.Cxyz(temp, p, px, py, pz))
						&& t1.ratioYZ() < ratio) {
					ArrayList<rectCube> tempQ = t1.splitYZ();
					counter += 3;
					for (int i = 0; i < tempQ.size(); ++i) {
						Q0.add(tempQ.get(i));
					}
					continue;
				}
				temp = t1.childZX();
				if ((this.C0(temp, p) || this.Cxyz(temp, p, px, py, pz))
						&& t1.ratioZX() < ratio) {
					ArrayList<rectCube> tempQ = t1.splitZX();
					counter += 3;
					for (int i = 0; i < tempQ.size(); ++i) {
						Q0.add(tempQ.get(i));
					}
					continue;
				}

				ArrayList<rectCube> tempQ = t1.splitXYZ();
				counter += 7;
				for (int i = 0; i < tempQ.size(); i++) {
					Q0.add(tempQ.get(i));
				}
			}
		}
		System.out.println("subdivision criteria");
		System.out.println("subidivision times=" + counter);
		System.out.println();
		System.out.println("startbalance");
		/****************************
		 *balance
		 ****************************/
		Qxy = balance(Qx, p);
		Qxy = adjust(Qxy, p);
		if (numberofSplit != 0)
			Qxy = balance(Qxy, p);
		while (numberofSplit != 0) {
			System.out.println(numberofSplit);
			// System.out.println("check0="+check0);
			// check0 = 1;
			Qxy = adjust(Qxy, p);
			Qxy = balance(Qxy, p);
		}
		System.out.println(Qxy.size());

		System.out.println("balance");
		System.out.println("subidivision times=" + counter);
		System.out.println();
		// checkDuplication(Qx);
		// checkInclusion(Qx);

		/****************************
		 *disambiguation
		 ****************************/
		Qy = disambiguousX(Qxy, p);
		Qz = disambiguousY(Qy, p);
		Qxy = disambiguousZ(Qz, p);
		
		Qyz = disambiguousXY(Qxy, p);
//		rectCube[] aa=Qyz.toArray(new rectCube[0]);
//		System.out.println(aa.length);
//		for (int i=0; i<aa.length; ++i)
//			if (aa[i].equal(new rectCube(new Point(-2.65625, -2.46875, -0.5), new Point(-2.5625, -2.375, -0.3125)))){
//				System.out.println("hihi");
//				testCube=aa[i];
//			}
		Qzx = disambiguousYZ(Qyz, p);
		Qx = disambiguousZX(Qzx, p);
		
		
		// this.checkDuplication(AddAgainx);

		while (!AddAgainx.isEmpty()) {
			rectCube tc = AddAgainx.poll();
			tc.getSign(p);
			tc.addVX(p);
			AddAgainy.add(tc);
		}
		System.out.println("add x finished");

		while (!AddAgainy.isEmpty()) {
			rectCube tc = AddAgainy.poll();
			tc.addVY(p);
			AddAgainz.add(tc);
		}
		System.out.println("add y finished");
		while (!AddAgainz.isEmpty()) {
			rectCube tc = AddAgainz.poll();
			tc.addVZ(p);
			// Qx.add(tc);
		}

		System.out.println("addV complete");
		System.out.println();

		System.out.println("disambiguation complete");
		System.out.println("disambiguation time: " + counter);
		System.out.println();

		/****************************
		 *construction
		 ****************************/
		// int a=0;
		while (!Qx.isEmpty()) {
			rectCube tc = Qx.poll();
			// a++;

			Iterator<Point> iter = tc.getVertices().iterator();
			while (iter.hasNext())
				v.put(iter.next(), 0);
//			if (tc.equal(new rectCube(new Point(-2.65625, -2.46875, -0.5), new Point(-2.5625, -2.375, -0.3125)))){
//				System.out.println(p.value(new Point(-2.65625, -2.421875 ,-0.3125)));
//				tc.printAll();
//				System.out.println("size"+tc.getyNeighborN().size());
//				tc.getyNeighborN().get(0).printAll();
//				System.out.println("size"+tc.getyNeighborP().size());
//				tc.getyNeighborP().get(0).printAll();
//			}
			tc.linkCxyz(p, px, py, pz);
			Qxy.add(tc);
		}

		while (!Qxy.isEmpty()) {
			rectCube tc = Qxy.poll();
			// a++;

			// Iterator<Point> iter = tc.getVertices().iterator();
			// while (iter.hasNext())
			// v.put(iter.next(), 0);
			//			
			// tc.linkCxyz(p, px, py, pz);
			// if (a==109){
			// tc.printAll();
			// System.out.println(tc.para+" "+tc.linkedFaces);
			// System.exit(0);
			// }
			if (tc.linkedFaces < 6) {
				if (tc.linkedFaces == 5) {
					// linked based on the other face;
					tc.linkFace5();
				} else { // tc.linkedFaces == 4
					if (tc.para == 0) {
						Stack<rectCube> stack = new Stack<rectCube>();
						stack.push(tc);
						rectCube tempTC = tc.getxNeighborN().get(0);
						tempTC.linkCxyz(p, px, py, pz);

						while (tempTC.linkedFaces == 4) {
							// if (tempTC.getSize()!=tc.getSize())
							// System.out.println("error in different size and 4");
							stack.push(tempTC);
							tempTC = tempTC.getxNeighborN().get(0);
							tempTC.linkCxyz(p, px, py, pz);

						}
						// if (tempTC.linkedFaces==6){
						// tempTC=stack.pop();
						// ++tempTC.linkedFaces;
						// tempTC.linkedFace[0]=true;
						// }
						tempTC.linkFace5();
						while (!stack.isEmpty()) {
							tempTC = stack.pop();
							tempTC.linkFace5();
						}
					} else if (tc.para == 1) {
						Stack<rectCube> stack = new Stack<rectCube>();
						stack.push(tc);
						rectCube tempTC = tc.getyNeighborN().get(0);
						tempTC.linkCxyz(p, px, py, pz);

						while (tempTC.linkedFaces == 4) {
							stack.push(tempTC);
							tempTC = tempTC.getyNeighborN().get(0);
							tempTC.linkCxyz(p, px, py, pz);

						}

						tempTC.linkFace5();
						while (!stack.isEmpty()) {
							tempTC = stack.pop();
							tempTC.linkFace5();
						}
					} else {
						Stack<rectCube> stack = new Stack<rectCube>();
						stack.push(tc);
						rectCube tempTC = tc.getzNeighborN().get(0);
						tempTC.linkCxyz(p, px, py, pz);

						while (tempTC.linkedFaces == 4) {
							stack.push(tempTC);
							tempTC = tempTC.getzNeighborN().get(0);
							tempTC.linkCxyz(p, px, py, pz);

						}

						tempTC.linkFace5();

						while (!stack.isEmpty()) {
							tempTC = stack.pop();
							tempTC.linkFace5();
						}
					}
				}
			}

			Qx.add(tc);
		}

		System.out.println("link complete");
		System.out.println();

		while (!Qx.isEmpty()) {
			rectCube tc = Qx.poll();
			tc.findLoop();

			tc.triangulate(v);
			for (int i = 0; i < tc.getFaces().size(); ++i)
				f.add(tc.getFaces().get(i));
			if (tc.C0(p))
				System.out.println("c0");
			boxes.add(tc);
		}
		// System.out.println("add to map complete");
		// System.out.println();
		//
		// while (!Qxy.isEmpty()) {
		// rectCube tc = Qxy.poll();
		// tc.linkCxyz(p, px, py, pz);
		// Qx.add(tc);
		// }

		// while (!Qyz.isEmpty()) {
		// rectCube tc = Qyz.poll();
		// tc.linkCxyz(p, px, py, pz);
		// Qzx.add(tc);
		// }
		//
		// while (!Qzx.isEmpty()) {
		// rectCube tc = Qzx.poll();
		// tc.linkCxyz(p, px, py, pz);
		// Qx.add(tc);
		// }

		// System.out.println("link complete");
		// System.out.println();
		//
		// while (!Qx.isEmpty()) {
		// rectCube tc = Qx.poll();
		// tc.findLoop();
		// Qxy.add(tc);
		// }
		//
		// System.out.println("find loop complete");
		// System.out.println();
		//
		// while (!Qxy.isEmpty()) {
		// rectCube tc = Qxy.poll();
		// tc.triangulate(v);
		// for (int i = 0; i < tc.getFaces().size(); ++i)
		// f.add(tc.getFaces().get(i));
		// }

		System.out.println("triangulate complete");
		System.out.println();

		// /////////////////////////////////////////////////////////////////////////////
		// /////////////////////////////////////////////////////////////////////////////

		vertices = new double[v.size()][6];
		temp_vertices = new double[v.size()][6];
		faces = new int[f.size()][3];
		int t = 0;
		Iterator<Map.Entry<Point, Integer>> iter = v.entrySet().iterator();
		Point[] temp = new Point[v.size()];
		while (iter.hasNext()) {
			Map.Entry<Point, Integer> e = iter.next();
			Point pp = e.getKey();
			vertices[t][0] = pp.getX() / sizeFactor;
			vertices[t][1] = pp.getY() / sizeFactor;
			vertices[t][2] = pp.getZ() / sizeFactor;
			vertices[t][3] = px.value(pp) / sizeFactor;
			vertices[t][4] = py.value(pp) / sizeFactor;
			vertices[t][5] = pz.value(pp) / sizeFactor;
			// normalize(vertices[t]);
			temp_vertices[t][0] = pp.getX() / sizeFactor;
			temp_vertices[t][1] = pp.getY() / sizeFactor;
			temp_vertices[t][2] = pp.getZ() / sizeFactor;
			temp_vertices[t][3] = px.value(pp) / sizeFactor;
			temp_vertices[t][4] = py.value(pp) / sizeFactor;
			temp_vertices[t][5] = pz.value(pp) / sizeFactor;
			// normalize(temp_vertices[t]);
			temp[t] = pp;
			++t;
		}

		for (int s = 0; s < temp.length; ++s)
			v.put(temp[s], s);

		for (int u = 0; u < faces.length; ++u) {
			Point[] pf = f.get(u);
			faces[u][0] = v.get(pf[0]);
			faces[u][1] = v.get(pf[1]);
			faces[u][2] = v.get(pf[2]);
		}
	}

	public boolean C0(rectCube[] c, Poly3 p) {
		for (int i = 0; i < c.length; ++i)
			if (c[i].C0(p))
				return true;
		return false;
	}

	public boolean Cxyz(rectCube[] c, Poly3 p, Poly3 px, Poly3 py, Poly3 pz) {
		for (int i = 0; i < c.length; ++i)
			if (c[i].Cxyz(p, px, py, pz))
				return true;
		return false;
	}

	public int numFaces() {
		return faces.length;
	}

	public void getFace(int j, double triangle[][]) {
		for (int i = 0; i < 6; i++) {
			triangle[0][i] = temp_vertices[faces[j][0]][i]; // first vertice
			triangle[1][i] = temp_vertices[faces[j][1]][i]; // second vertice
			triangle[2][i] = temp_vertices[faces[j][2]][i]; // third vertice
		}
	}

	// Set Sphere's material to be used in Phong's algorithm
	public void setMaterial(double ar, double ag, double ab, double dr,
			double dg, double db, double sr, double sg, double sb, int sp) {
		material.setAmbient(ar, ag, ab);
		material.setDiffuse(dr, dg, db);
		material.setSpecular(sr, sg, sb, sp);
	}

	public Material getMaterial() {
		return material;
	}

	public void transform() {
		for (int i = 0; i < faces.length; i++)
			for (int j = 0; j < 3; j++) // transform all 3 vertices
			{
				mTrans.transform(vertices[faces[i][j]],
						temp_vertices[faces[i][j]]); // transform x,y,z
			}
	}

	public void transformPerspective() {
		for (int i = 0; i < faces.length - 1; i++)
			for (int j = 0; j < 3; j++) // transform all 3 vertices
			{
				mTrans.transformPerspective(vertices[faces[i][j]],
						temp_vertices[faces[i][j]]); // transform x,y,z
			}
	}

	public void transform(Matrix3D m) {
		mTrans.copy(m);
		transform();
	}

	public void transformPerspective(Matrix3D m) {
		mTrans.copy(m);
		transformPerspective();
	}

	public Matrix3D getMatrix() {
		return mTrans;
	}

	public void clearMatrix() {
		mTrans.identity();
	}

	public void rotateX(double theta) {
		mTrans.rotateX(theta);
	}

	public void rotateY(double theta) {
		mTrans.rotateY(theta);
	}

	public void rotateZ(double theta) {
		mTrans.rotateZ(theta);
	}

	public void translate(double x, double y, double z) {
		mTrans.translate(x, y, z);
	}

	public void scale(double x, double y, double z) {
		mTrans.scale(x, y, z);
	}

	// This function draws the sphere in the graphic
	public void render(Graphics g, int w, int h) {
		// draw one polygon per face
		for (int i = 0; i < faces.length - 1; i++)
			drawFace(g, i, w, h);
	};

	public void drawFace(Graphics g, int index, int w, int h) {
		int x1, y1, x2, y2;

		// Each face is a polygon with 3 vertices, so we have to draw 3 lines
		for (int j = 0; j < 3; j++) {
			x1 = x(temp_vertices[faces[index][j]][0], w);
			y1 = y(temp_vertices[faces[index][j]][1], w, h);
			if (j + 1 < 3) {
				x2 = x(temp_vertices[faces[index][j + 1]][0], w);
				y2 = y(temp_vertices[faces[index][j + 1]][1], w, h);
			} else // x1,y1 is the last point and has to be connected to the
			// first point
			{
				x2 = x(temp_vertices[faces[index][0]][0], w);
				y2 = y(temp_vertices[faces[index][0]][1], w, h);
			}
			g.drawLine(x1, y1, x2, y2);
		}
	}

	// CONVERT X COORDINATE TO SCREEN PIXELS
	private int x(double x, int w) {
		return (int) (w / 2 + x * w / 2);
	}

	// CONVERT Y COORDINATE TO SCREEN PIXELS
	private int y(double y, int w, int h) {
		return (int) (h / 2 - y * w / 2);
	}

	int numberofSplit = 0;
	// int numberofAdjust = 0;
	PriorityQueue<rectCube> modified = new PriorityQueue<rectCube>(10,
			new sizeComparatorX());

	// int loop = 0;
	// int testsplit=0;

	private PriorityQueue<rectCube> balance(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> temp = new PriorityQueue<rectCube>();
		PriorityQueue<rectCube> temp1 = new PriorityQueue<rectCube>();
		// loop = 0;
		// do {
		// loop++;
		numberofSplit = 0;
		temp = balanceX(Q, p);
		temp1 = balanceY(temp, p);
		Q = balanceZ(temp1, p);
		// System.out.println("loop="+loop+", numberofSplit= " + numberofSplit);
		// if (numberofSplit == 0)
		// check0 *= 2;
		// } while (numberofSplit > 0);
		return Q;
	}

	private PriorityQueue<rectCube> adjust(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> temp = new PriorityQueue<rectCube>();
		PriorityQueue<rectCube> temp1 = new PriorityQueue<rectCube>();

		// do {
		// numberofAdjust = 0;
		temp = adjustX(Q, p);
		temp1 = adjustY(temp, p);
		Q = adjustZ(temp1, p);
		// System.out.println("numberofAdjust= " + numberofAdjust);
		// } while (numberofAdjust > 0);
		// check0 *= 3;
		return Q;
	}

	private PriorityQueue<rectCube> balanceX(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> B = new PriorityQueue<rectCube>(100000,
				new sizeComparatorY());
		while (!Q.isEmpty()) {
			rectCube temp = Q.peek();
			boolean done = true;
			ArrayList<rectCube> tempyp = temp.getyNeighborP();
			ArrayList<rectCube> tempyn = temp.getyNeighborN();
			ArrayList<rectCube> tempzp = temp.getzNeighborP();
			ArrayList<rectCube> tempzn = temp.getzNeighborN();

			if (!this.balanceListX(Q, p, tempyp, temp))
				done = false;
			if (!this.balanceListX(Q, p, tempyn, temp))
				done = false;
			if (!this.balanceListX(Q, p, tempzp, temp))
				done = false;
			if (!this.balanceListX(Q, p, tempzn, temp))
				done = false;

			for (int i = 0; i < tempyp.size(); ++i) {
				rectCube tempC = tempyp.get(i);
				ArrayList<rectCube> tempCzp = tempC.getzNeighborP();
				ArrayList<rectCube> tempCzn = tempC.getzNeighborN();

				if (!balanceEdgeListX(Q, p, tempCzp, temp))
					done = false;
				if (!balanceEdgeListX(Q, p, tempCzn, temp))
					done = false;
			}

			for (int i = 0; i < tempyn.size(); ++i) {
				rectCube tempC = tempyn.get(i);
				ArrayList<rectCube> tempCzp = tempC.getzNeighborP();
				ArrayList<rectCube> tempCzn = tempC.getzNeighborN();

				if (!balanceEdgeListX(Q, p, tempCzp, temp))
					done = false;
				if (!balanceEdgeListX(Q, p, tempCzn, temp))
					done = false;
			}

			// if (temp.equal(new rectCube(new Point(-3.1875,-3.0625,-0.0625),
			// new Point(-3.15625,-3.0,0.0))))
			// if (loop==1 && done){
			// System.out.println("done");
			// System.out.println(tempyp.size());
			// tempyp.get(0).print();
			// System.out.println(tempyp.get(0).getzNeighborP().size());
			// tempyp.get(0).getzNeighborP().get(0).print();
			// for (int i=0; i<tempyp.size(); ++i){
			// rectCube tempcc=tempyp.get(i);
			// for (int j=0; j<tempcc.getzNeighborP().size(); ++j)
			// tempcc.getzNeighborP().get(j).print();
			// }
			// }
			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}// end while (!Q.isEmpty())
		return B;
	}

	private PriorityQueue<rectCube> balanceY(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> B = new PriorityQueue<rectCube>(100000,
				new sizeComparatorZ());
		while (!Q.isEmpty()) {
			rectCube temp = Q.peek();
			boolean done = true;

			ArrayList<rectCube> tempxp = temp.getxNeighborP();
			ArrayList<rectCube> tempxn = temp.getxNeighborN();
			ArrayList<rectCube> tempzp = temp.getzNeighborP();
			ArrayList<rectCube> tempzn = temp.getzNeighborN();

			if (!this.balanceListY(Q, p, tempxp, temp))
				done = false;
			if (!this.balanceListY(Q, p, tempxn, temp))
				done = false;
			if (!this.balanceListY(Q, p, tempzp, temp))
				done = false;
			if (!this.balanceListY(Q, p, tempzn, temp))
				done = false;

			for (int i = 0; i < tempxp.size(); ++i) {
				rectCube tempC = tempxp.get(i);
				ArrayList<rectCube> tempCzp = tempC.getzNeighborP();
				ArrayList<rectCube> tempCzn = tempC.getzNeighborN();

				if (!balanceEdgeListY(Q, p, tempCzp, temp))
					done = false;
				if (!balanceEdgeListY(Q, p, tempCzn, temp))
					done = false;
			}

			for (int i = 0; i < tempxn.size(); ++i) {
				rectCube tempC = tempxn.get(i);
				ArrayList<rectCube> tempCzp = tempC.getzNeighborP();
				ArrayList<rectCube> tempCzn = tempC.getzNeighborN();

				if (!balanceEdgeListY(Q, p, tempCzp, temp))
					done = false;
				if (!balanceEdgeListY(Q, p, tempCzn, temp))
					done = false;
			}

			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}// end while (!Q.isEmpty())
		return B;
	}

	private PriorityQueue<rectCube> balanceZ(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> B = new PriorityQueue<rectCube>(100000,
				new sizeComparatorX());
		while (!Q.isEmpty()) {
			rectCube temp = Q.peek();

			boolean done = true;

			ArrayList<rectCube> tempxp = temp.getxNeighborP();
			ArrayList<rectCube> tempxn = temp.getxNeighborN();
			ArrayList<rectCube> tempyp = temp.getyNeighborP();
			ArrayList<rectCube> tempyn = temp.getyNeighborN();

			if (!this.balanceListZ(Q, p, tempxp, temp))
				done = false;
			if (!this.balanceListZ(Q, p, tempxn, temp))
				done = false;
			if (!this.balanceListZ(Q, p, tempyp, temp))
				done = false;
			if (!this.balanceListZ(Q, p, tempyn, temp))
				done = false;

			for (int i = 0; i < tempxp.size(); ++i) {
				rectCube tempC = tempxp.get(i);
				ArrayList<rectCube> tempCyp = tempC.getyNeighborP();
				ArrayList<rectCube> tempCyn = tempC.getyNeighborN();

				if (!balanceEdgeListZ(Q, p, tempCyp, temp))
					done = false;
				if (!balanceEdgeListZ(Q, p, tempCyn, temp))
					done = false;
			}

			for (int i = 0; i < tempxn.size(); ++i) {
				rectCube tempC = tempxn.get(i);
				ArrayList<rectCube> tempCyp = tempC.getyNeighborP();
				ArrayList<rectCube> tempCyn = tempC.getyNeighborN();

				if (!balanceEdgeListZ(Q, p, tempCyp, temp))
					done = false;
				if (!balanceEdgeListZ(Q, p, tempCyn, temp))
					done = false;
			}

			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}// end while (!Q.isEmpty())
		return B;
	}

	public boolean balanceListX(PriorityQueue<rectCube> Q, Poly3 p,
			ArrayList<rectCube> list, rectCube c) {
		boolean done = true;
		for (int i = 0; i < list.size(); ++i) {
			rectCube tempC = list.get(i);
			if (tempC.getSizeX() > 2 * c.getSizeX()) {
				done = false;
				Q.remove(tempC);
				ArrayList<rectCube> tempL = tempC.splitX();
				counter += 1;
				++numberofSplit;
				for (int j = 0; j < tempL.size(); ++j) {
					if (tempL.get(j).C0(p)) {
						rectCube t1 = tempL.get(j);
						removeC0(t1);
					} else
						Q.add(tempL.get(j));
				}
			}
		}
		return done;
	}

	public boolean balanceListY(PriorityQueue<rectCube> Q, Poly3 p,
			ArrayList<rectCube> list, rectCube c) {
		boolean done = true;
		for (int i = 0; i < list.size(); ++i) {
			rectCube tempC = list.get(i);
			if (tempC.getSizeY() > 2 * c.getSizeY()) {
				done = false;
				Q.remove(tempC);
				ArrayList<rectCube> tempL = tempC.splitY();
				counter += 1;
				++numberofSplit;
				for (int j = 0; j < tempL.size(); ++j) {
					if (tempL.get(j).C0(p)) {
						rectCube t1 = tempL.get(j);
						removeC0(t1);
					} else
						Q.add(tempL.get(j));
				}
			}
		}
		return done;
	}

	public boolean balanceListZ(PriorityQueue<rectCube> Q, Poly3 p,
			ArrayList<rectCube> list, rectCube c) {
		boolean done = true;
		for (int i = 0; i < list.size(); ++i) {
			rectCube tempC = list.get(i);
			if (tempC.getSizeZ() > 2 * c.getSizeZ()) {
				done = false;
				Q.remove(tempC);
				ArrayList<rectCube> tempL = tempC.splitZ();
				counter += 1;
				++numberofSplit;
				for (int j = 0; j < tempL.size(); ++j) {
					if (tempL.get(j).C0(p)) {
						rectCube t1 = tempL.get(j);
						removeC0(t1);
					} else
						Q.add(tempL.get(j));
				}
			}
		}
		return done;
	}

	public boolean balanceEdgeListX(PriorityQueue<rectCube> Q, Poly3 p,
			ArrayList<rectCube> list, rectCube c) {
		boolean done = true;
		for (int i = 0; i < list.size(); ++i) {
			rectCube tempC = list.get(i);
			if (rectCube.cubeOverlap(tempC, c))
				if (tempC.getSizeX() > 2 * c.getSizeX()) {
					done = false;
					Q.remove(tempC);
					ArrayList<rectCube> tempL = tempC.splitX();
					counter += 1;
					// if (loop==2 && numberofSplit==0){
					// System.out.println("loop==2 && numberofSplit>0"+numberofSplit);
					// c.print();
					// tempC.print();
					// System.out.println(rectCube.cubeOverlap(tempC, c));
					// System.exit(0);
					// }
					++numberofSplit;
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p)) {
							rectCube t1 = tempL.get(j);
							removeC0(t1);
						} else
							Q.add(tempL.get(j));
					}
				}
		}
		return done;
	}

	public boolean balanceEdgeListY(PriorityQueue<rectCube> Q, Poly3 p,
			ArrayList<rectCube> list, rectCube c) {
		boolean done = true;
		for (int i = 0; i < list.size(); ++i) {
			rectCube tempC = list.get(i);
			if (rectCube.cubeOverlap(tempC, c))
				if (tempC.getSizeY() > 2 * c.getSizeY()) {
					done = false;
					Q.remove(tempC);
					ArrayList<rectCube> tempL = tempC.splitY();
					counter += 1;
					++numberofSplit;
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p)) {
							rectCube t1 = tempL.get(j);
							removeC0(t1);
						} else
							Q.add(tempL.get(j));
					}
				}
		}
		return done;
	}

	public boolean balanceEdgeListZ(PriorityQueue<rectCube> Q, Poly3 p,
			ArrayList<rectCube> list, rectCube c) {
		boolean done = true;
		for (int i = 0; i < list.size(); ++i) {
			rectCube tempC = list.get(i);
			if (rectCube.cubeOverlap(tempC, c))
				if (tempC.getSizeZ() > 2 * c.getSizeZ()) {
					done = false;
					Q.remove(tempC);
					ArrayList<rectCube> tempL = tempC.splitZ();
					counter += 1;
					++numberofSplit;
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p)) {
							rectCube t1 = tempL.get(j);
							removeC0(t1);
						} else
							Q.add(tempL.get(j));
					}
				}
		}
		return done;
	}

	private PriorityQueue<rectCube> adjustX(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> B = new PriorityQueue<rectCube>(100000,
				new sizeComparatorY());
		while (!Q.isEmpty()) {
			rectCube temp = Q.peek();

			boolean done = true;
			ArrayList<rectCube> tempyp = temp.getyNeighborP();
			ArrayList<rectCube> tempyn = temp.getyNeighborN();

			for (int i = 0; i < tempyp.size(); ++i) {
				rectCube tempI = tempyp.get(i);

				if (tempI.getSizeX() > temp.getSizeX()
						&& tempI.getSizeZ() < temp.getSizeZ()) {

					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioX() < ratio) {
					tempL = tempI.splitX();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {

						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			for (int i = 0; i < tempyn.size(); ++i) {
				rectCube tempI = tempyn.get(i);

				if (tempI.getSizeX() > temp.getSizeX()
						&& tempI.getSizeZ() < temp.getSizeZ()) {

					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioX() < ratio) {
					tempL = tempI.splitX();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {

						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			ArrayList<rectCube> tempzp = temp.getzNeighborP();
			ArrayList<rectCube> tempzn = temp.getzNeighborN();

			for (int i = 0; i < tempzp.size(); ++i) {
				rectCube tempI = tempzp.get(i);

				if (tempI.getSizeX() > temp.getSizeX()
						&& tempI.getSizeY() < temp.getSizeY()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioX() < ratio) {
					tempL = tempI.splitX();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {

						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			for (int i = 0; i < tempzn.size(); ++i) {
				rectCube tempI = tempzn.get(i);

				if (tempI.getSizeX() > temp.getSizeX()
						&& tempI.getSizeY() < temp.getSizeY()) {

					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioX() < ratio) {
					tempL = tempI.splitX();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {

						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}// end while (!Q.isEmpty())
		return B;
	}

	private PriorityQueue<rectCube> adjustY(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> B = new PriorityQueue<rectCube>(100000,
				new sizeComparatorZ());
		while (!Q.isEmpty()) {
			rectCube temp = Q.peek();
			boolean done = true;

			ArrayList<rectCube> tempxp = temp.getxNeighborP();
			ArrayList<rectCube> tempxn = temp.getxNeighborN();

			for (int i = 0; i < tempxp.size(); ++i) {
				rectCube tempI = tempxp.get(i);
				if (tempI.getSizeY() > temp.getSizeY()
						&& tempI.getSizeZ() < temp.getSizeZ()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioY() < ratio) {
					tempL = tempI.splitY();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			for (int i = 0; i < tempxn.size(); ++i) {
				rectCube tempI = tempxn.get(i);
				if (tempI.getSizeY() > temp.getSizeY()
						&& tempI.getSizeZ() < temp.getSizeZ()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioY() < ratio) {
					tempL = tempI.splitY();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			ArrayList<rectCube> tempzp = temp.getzNeighborP();
			ArrayList<rectCube> tempzn = temp.getzNeighborN();

			for (int i = 0; i < tempzp.size(); ++i) {
				rectCube tempI = tempzp.get(i);
				if (tempI.getSizeY() > temp.getSizeY()
						&& tempI.getSizeX() < temp.getSizeX()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioY() < ratio) {
					tempL = tempI.splitY();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			for (int i = 0; i < tempzn.size(); ++i) {
				rectCube tempI = tempzn.get(i);
				if (tempI.getSizeY() > temp.getSizeY()
						&& tempI.getSizeX() < temp.getSizeX()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioY() < ratio) {
					tempL = tempI.splitY();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}// end while (!Q.isEmpty())
		return B;
	}

	private PriorityQueue<rectCube> adjustZ(PriorityQueue<rectCube> Q, Poly3 p) {
		PriorityQueue<rectCube> B = new PriorityQueue<rectCube>(100000,
				new sizeComparatorX());
		while (!Q.isEmpty()) {
			rectCube temp = Q.peek();
			boolean done = true;

			ArrayList<rectCube> tempxp = temp.getxNeighborP();
			ArrayList<rectCube> tempxn = temp.getxNeighborN();

			for (int i = 0; i < tempxp.size(); ++i) {
				rectCube tempI = tempxp.get(i);
				if (tempI.getSizeZ() > temp.getSizeZ()
						&& tempI.getSizeY() < temp.getSizeY()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioZ() < ratio) {
					tempL = tempI.splitZ();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			for (int i = 0; i < tempxn.size(); ++i) {
				rectCube tempI = tempxn.get(i);
				if (tempI.getSizeZ() > temp.getSizeZ()
						&& tempI.getSizeY() < temp.getSizeY()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioZ() < ratio) {
					tempL = tempI.splitZ();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			ArrayList<rectCube> tempyp = temp.getyNeighborP();
			ArrayList<rectCube> tempyn = temp.getyNeighborN();

			for (int i = 0; i < tempyp.size(); ++i) {
				rectCube tempI = tempyp.get(i);
				if (tempI.getSizeZ() > temp.getSizeZ()
						&& tempI.getSizeX() < temp.getSizeX()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioZ() < ratio) {
					tempL = tempI.splitZ();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			for (int i = 0; i < tempyn.size(); ++i) {
				rectCube tempI = tempyn.get(i);
				if (tempI.getSizeZ() > temp.getSizeZ()
						&& tempI.getSizeX() < temp.getSizeX()) {
					done = false;
					Q.remove(tempI);
					ArrayList<rectCube> tempL;
					// if (tempI.ratioZ() < ratio) {
					tempL = tempI.splitZ();
					counter++;
					numberofSplit++;
					// } else {
					// tempL = tempI.splitXYZ();
					// counter += 7;
					// numberofAdjust++;
					// }
					for (int j = 0; j < tempL.size(); ++j) {
						if (tempL.get(j).C0(p))
							removeC0(tempL.get(j));
						else
							Q.add(tempL.get(j));
					}
				}
			}

			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}// end while (!Q.isEmpty())
		return B;
	}

	public void removeC0(rectCube t1) {
		for (int g = 0; g < t1.getxNeighborN().size(); ++g)
			t1.getxNeighborN().get(g).getxNeighborP().remove(t1);
		for (int g = 0; g < t1.getxNeighborP().size(); ++g)
			t1.getxNeighborP().get(g).getxNeighborN().remove(t1);
		for (int g = 0; g < t1.getyNeighborN().size(); ++g)
			t1.getyNeighborN().get(g).getyNeighborP().remove(t1);
		for (int g = 0; g < t1.getyNeighborP().size(); ++g)
			t1.getyNeighborP().get(g).getyNeighborN().remove(t1);
		for (int g = 0; g < t1.getzNeighborN().size(); ++g)
			t1.getzNeighborN().get(g).getzNeighborP().remove(t1);
		for (int g = 0; g < t1.getzNeighborP().size(); ++g)
			t1.getzNeighborP().get(g).getzNeighborN().remove(t1);
	}

	void normalize(double l[]) {
		double t = l[0] * l[0] + l[1] * l[1] + l[2] * l[2];
		if (t != 0 && t != 1) {
			t = (double) (1 / Math.sqrt(t));
		}
		l[0] = l[0] * t;
		l[1] = l[1] * t;
		l[2] = l[2] * t;
	}

	void checkDuplication(PriorityQueue<rectCube> Q) {
		rectCube[] abc = Q.toArray(new rectCube[0]);
		for (int i = 0; i < abc.length; ++i)
			for (int j = i + 1; j < abc.length; ++j)
				if (abc[i].equal(abc[j]))
					System.out.println("duplicate!!!!!!!!!!!!!");
	}

	void checkInclusion(PriorityQueue<rectCube> Q) {
		rectCube[] abc = Q.toArray(new rectCube[0]);
		for (int i = 0; i < abc.length; ++i)
			for (int j = i + 1; j < abc.length; ++j)
				if (include(abc[i], abc[j]) || include(abc[j], abc[i]))
					System.out.println("include!!!!!!!!!!!!!");
	}

	boolean include(rectCube a, rectCube b) {
		Point a1 = a.getA();
		Point a2 = a.getB();
		Point b1 = b.getA();
		Point b2 = b.getB();
		return (a1.getX() <= b1.getX() && a1.getY() <= b1.getY()
				&& a1.getZ() <= b1.getZ() && a2.getX() >= b2.getX()
				&& a2.getY() >= b2.getY() && a2.getZ() >= b2.getZ());
	}
	
	public PriorityQueue<rectCube> disambiguousX(PriorityQueue<rectCube> Q2,
			Poly3 p) {
		PriorityQueue<rectCube> Q3 = new PriorityQueue<rectCube>(10,
				new sizeComparatorY());
		double size = Q2.peek().getSizeX();
		double size1 = Q2.peek().getSizeX();
		while (size1 == size && !Q2.isEmpty()) {
			rectCube tc = Q2.poll();
			tc.addVX(p);
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSizeX();
		}// finish dealing with the smallest size
		PriorityQueue<rectCube> suspend = new PriorityQueue<rectCube>(10,
				new sizeComparatorX());
		while (!Q2.isEmpty()) {
			rectCube tc = Q2.peek();
			if (tc.getSizeX() <= size1) {// deal with small size
				tc = Q2.poll();
				if (tc.ambiguous1(p).equals("x")) {// ambiguous
				// System.out.println("ambiguity x");
					ArrayList<rectCube> temp = tc.splitX();
					AddAgainx.remove(tc);
					LinkedList<Point> vs = tc.getVertices();
					counter += 1;
					// re-balance
					PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
							10, new sizeComparatorX());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							rectCube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.addVX(p);
							Q3.add(tc1);
							AddAgainx.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalanceAdjust(rebalanceQ, p, Q2, suspend);
					Q2.addAll(suspend);
					suspend.clear();
					// System.out.println(++balanceT);
				} else {// not ambiguous
					suspend.add(tc);
				}
			} else {
				Iterator<rectCube> iter = suspend.iterator();
				while (iter.hasNext()) {
					rectCube tempI = iter.next();
					// if (tempI.C0(p)){
					// System.out.println("exit c0 box");
					// }
					// else{
					tempI.addVX(p);
					Q3.add(tempI);
					// }
				}
				suspend.clear();

				size1 = tc.getSizeX();
			}
		}

		Iterator<rectCube> iter = suspend.iterator();
		while (iter.hasNext()) {
			rectCube tempI = iter.next();
			// if (tempI.C0(p)){
			// System.out.println("exit c0 box");
			// }
			// else{
			tempI.addVX(p);
			Q3.add(tempI);
			// }
		}
		suspend.clear();
		return Q3;
	}

	public PriorityQueue<rectCube> disambiguousY(PriorityQueue<rectCube> Q2,
			Poly3 p) {
		PriorityQueue<rectCube> Q3 = new PriorityQueue<rectCube>(10,
				new sizeComparatorZ());
		double size = Q2.peek().getSizeY();
		double size1 = Q2.peek().getSizeY();
		while (size1 == size && !Q2.isEmpty()) {
			rectCube tc = Q2.poll();
			tc.addVY(p);
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSizeY();
		}// finish dealing with the smallest size
		PriorityQueue<rectCube> suspend = new PriorityQueue<rectCube>(10,
				new sizeComparatorY());
		while (!Q2.isEmpty()) {
			rectCube tc = Q2.peek();
			if (tc.getSizeY() <= size1) {// deal with small size
				tc = Q2.poll();
				// if (tc.getSizeY()<size1){
				// System.out.println("wrong size");
				// }
				// if (tc.ambiguous1(p).equals("x"))
				// System.out.println("ambiguous x apprears again!");
				if (tc.ambiguous1(p).equals("y")) {// ambiguous
				// System.out.println("ambiguity y");
					ArrayList<rectCube> temp = tc.splitY();
					AddAgainx.remove(tc);
					LinkedList<Point> vs = tc.getVertices();
					counter += 1;
					// re-balance
					PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
							10, new sizeComparatorY());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							rectCube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.addVY(p);
							Q3.add(tc1);
							AddAgainx.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalanceAdjust(rebalanceQ, p, Q2, suspend);
					Q2.addAll(suspend);
					suspend.clear();
					// System.out.println(++balanceT);
				} else {// not ambiguous
					suspend.add(tc);
				}
			} else {
				Iterator<rectCube> iter = suspend.iterator();
				while (iter.hasNext()) {
					rectCube tempI = iter.next();
					// if (tempI.C0(p)){
					// System.out.println("exit c0 box");
					// }
					// else{
					tempI.addVY(p);
					Q3.add(tempI);
					// }
				}
				suspend.clear();

				size1 = tc.getSizeY();
			}
		}

		Iterator<rectCube> iter = suspend.iterator();
		while (iter.hasNext()) {
			rectCube tempI = iter.next();
			// if (tempI.C0(p)){
			// System.out.println("exit c0 box");
			// }
			// else{
			tempI.addVY(p);
			Q3.add(tempI);
			// }
		}
		suspend.clear();
		return Q3;
	}

	public PriorityQueue<rectCube> disambiguousZ(PriorityQueue<rectCube> Q2,
			Poly3 p) {
		PriorityQueue<rectCube> Q3 = new PriorityQueue<rectCube>(10,
				new sizeComparatorXY());
		double size = Q2.peek().getSizeZ();
		double size1 = Q2.peek().getSizeZ();
		while (size1 == size && !Q2.isEmpty()) {
			rectCube tc = Q2.poll();
			tc.getSign(p);
			tc.addVZ(p);
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSizeZ();
		}// finish dealing with the smallest size
		PriorityQueue<rectCube> suspend = new PriorityQueue<rectCube>(10,
				new sizeComparatorZ());
		while (!Q2.isEmpty()) {
			rectCube tc = Q2.peek();
			if (tc.getSizeZ() <= size1) {// deal with small size
				tc = Q2.poll();
				// if (tc.getSizeZ()<size1){
				// System.out.println("wrong size");
				// }
				// if (tc.ambiguous1(p).equals("x") ||
				// tc.ambiguous1(p).equals("y"))
				// System.out.println("ambiguous x or y apprears again!");
				if (tc.ambiguous1(p).equals("z")) {// ambiguous
				// System.out.println("ambiguity z");
					ArrayList<rectCube> temp = tc.splitZ();
					AddAgainx.remove(tc);
					LinkedList<Point> vs = tc.getVertices();
					counter += 1;
					// re-balance
					PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
							10, new sizeComparatorZ());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							rectCube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.getSign(p);
							tc1.addVZ(p);
							Q3.add(tc1);
							AddAgainx.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalanceAdjust(rebalanceQ, p, Q2, suspend);
					Q2.addAll(suspend);
					suspend.clear();
					// System.out.println(++balanceT);
				} else {// not ambiguous
					suspend.add(tc);
				}
			} else {
				Iterator<rectCube> iter = suspend.iterator();
				while (iter.hasNext()) {
					rectCube tempI = iter.next();
					// if (tempI.C0(p)){
					// System.out.println("exit c0 box");
					// }
					// else{
					tempI.getSign(p);
					tempI.addVZ(p);
					Q3.add(tempI);
					// }
				}
				suspend.clear();

				size1 = tc.getSizeZ();
			}
		}

		Iterator<rectCube> iter = suspend.iterator();
		while (iter.hasNext()) {
			rectCube tempI = iter.next();
			// if (tempI.C0(p)){
			// System.out.println("exit c0 box");
			// }
			// else{
			tempI.getSign(p);
			tempI.addVZ(p);
			Q3.add(tempI);
			// }
		}
		suspend.clear();
		return Q3;
	}

	public PriorityQueue<rectCube> disambiguousXY(PriorityQueue<rectCube> Q2,
			Poly3 p) {
		PriorityQueue<rectCube> Q3 = new PriorityQueue<rectCube>(10,
				new sizeComparatorYZ());
		double size = Q2.peek().getSizeX();
		double size1 = Q2.peek().getSizeX();
		while (size1 == size && !Q2.isEmpty()) {
			rectCube tc = Q2.poll();
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSizeX();
		}// finish dealing with the smallest size
		PriorityQueue<rectCube> suspend = new PriorityQueue<rectCube>(10,
				new sizeComparatorXY());
		while (!Q2.isEmpty()) {
			rectCube tc = Q2.peek();
			if (tc.getSizeX() <= size1) {// deal with small size
				tc = Q2.poll();
				if (tc.ambiguous(p) && tc.para == 2) {// ambiguous
				// System.out.println("ambiguity x");
					ArrayList<rectCube> temp = tc.splitXY();
					AddAgainx.remove(tc);
					LinkedList<Point> vs = tc.getVertices();
					counter += 3;
					// re-balance
					PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
							10, new sizeComparatorX());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							rectCube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.addVX(p);
							tc1.addVY(p);
							Q3.add(tc1);
							AddAgainx.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalanceAdjust(rebalanceQ, p, Q2, suspend);
					Q2.addAll(suspend);
					suspend.clear();
					// System.out.println(++balanceT);
				} else {// not ambiguous
					if (tc.para == 2) {
						rectCube tempTC = tc.ambiguous2(p);
						if (tempTC != null) {
							Q2.remove(tempTC);
							ArrayList<rectCube> temp;
							if (tc.getSizeX()<tempTC.getSizeX()){
								if (tc.getSizeY()<tempTC.getSizeY()){
									temp = tempTC.splitXY();
									counter+=3;
								}
								else{
									temp=tempTC.splitX();
									counter+=1;
								}
							}
							else{
								temp=tempTC.splitY();
								counter+=1;
							}
							AddAgainx.remove(tempTC);
							LinkedList<Point> vs = tempTC.getVertices();
							counter += 3;
							// re-balance
							PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
									10, new sizeComparatorX());
							for (int i = 0; i < temp.size(); ++i)
								if (temp.get(i).C0(p))
									removeC0(temp.get(i));
								else {
									rectCube tc1 = temp.get(i);
									for (int k = 0; k < vs.size(); ++k) {
										if (tc1.containPoint(vs.get(k))) {
											Point vp = vs.get(k);
											tc1.getVertices().add(vp);
											if (tc1.belongLeft(vp))
												tc1.getLeftV().add(vp);
											if (tc1.belongRight(vp))
												tc1.getRightV().add(vp);
											if (tc1.belongTop(vp))
												tc1.getTopV().add(vp);
											if (tc1.belongBottom(vp))
												tc1.getBottomV().add(vp);
											if (tc1.belongFront(vp))
												tc1.getFrontV().add(vp);
											if (tc1.belongBack(vp))
												tc1.getBackV().add(vp);
										}
									}
									tc1.addVX(p);
									tc1.addVY(p);
									Q2.add(tc1);
									AddAgainx.add(tc1);
									rebalanceQ.add(tc1);
								}
							reBalanceAdjust(rebalanceQ, p, Q2, suspend);
						}
					}
					suspend.add(tc);
				}
			} else {
				Iterator<rectCube> iter = suspend.iterator();
				while (iter.hasNext()) {
					rectCube tempI = iter.next();
					tempI.addVX(p);
					tempI.addVY(p);
					Q3.add(tempI);
				}
				suspend.clear();

				size1 = tc.getSizeX();
			}
		}

		Iterator<rectCube> iter = suspend.iterator();
		while (iter.hasNext()) {
			rectCube tempI = iter.next();
			tempI.addVX(p);
			tempI.addVY(p);
			Q3.add(tempI);
		}
		suspend.clear();
		return Q3;
	}

	public PriorityQueue<rectCube> disambiguousYZ(PriorityQueue<rectCube> Q2,
			Poly3 p) {
		PriorityQueue<rectCube> Q3 = new PriorityQueue<rectCube>(10,
				new sizeComparatorZX());
		double size = Q2.peek().getSizeY();
		double size1 = Q2.peek().getSizeY();
		while (size1 == size && !Q2.isEmpty()) {
			rectCube tc = Q2.poll();
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSizeY();
		}// finish dealing with the smallest size
		PriorityQueue<rectCube> suspend = new PriorityQueue<rectCube>(10,
				new sizeComparatorYZ());
		while (!Q2.isEmpty()) {
			rectCube tc = Q2.peek();
			if (tc.getSizeY() <= size1) {// deal with small size
				tc = Q2.poll();
				if (tc.ambiguous(p) && tc.para == 0) {// ambiguous
				// System.out.println("ambiguity x");
					ArrayList<rectCube> temp = tc.splitYZ();
					AddAgainx.remove(tc);
					LinkedList<Point> vs = tc.getVertices();
					counter += 3;
					// re-balance
					PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
							10, new sizeComparatorY());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							rectCube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.addVY(p);
							tc1.addVZ(p);
							
							Q3.add(tc1);
							AddAgainx.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalanceAdjust(rebalanceQ, p, Q2, suspend);
					Q2.addAll(suspend);
					suspend.clear();
					// System.out.println(++balanceT);
				} else {// not ambiguous
					if (tc.para == 0) {
						rectCube tempTC = tc.ambiguous2(p);
						if (tempTC != null) {
							Q2.remove(tempTC);
							ArrayList<rectCube> temp;
							if (tc.getSizeY()<tempTC.getSizeY()){
								if (tc.getSizeZ()<tempTC.getSizeZ()){
									temp = tempTC.splitYZ();
									counter+=3;
								}
								else{
									temp=tempTC.splitY();
									counter+=1;
								}
							}
							else{
								temp=tempTC.splitZ();
								counter+=1;
							}
							
							AddAgainx.remove(tempTC);
							LinkedList<Point> vs = tempTC.getVertices();
//							counter += 3;
							// re-balance
							PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
									10, new sizeComparatorY());
							for (int i = 0; i < temp.size(); ++i)
								if (temp.get(i).C0(p))
									removeC0(temp.get(i));
								else {
									rectCube tc1 = temp.get(i);
									for (int k = 0; k < vs.size(); ++k) {
										if (tc1.containPoint(vs.get(k))) {
											Point vp = vs.get(k);
											tc1.getVertices().add(vp);
											if (tc1.belongLeft(vp))
												tc1.getLeftV().add(vp);
											if (tc1.belongRight(vp))
												tc1.getRightV().add(vp);
											if (tc1.belongTop(vp))
												tc1.getTopV().add(vp);
											if (tc1.belongBottom(vp))
												tc1.getBottomV().add(vp);
											if (tc1.belongFront(vp))
												tc1.getFrontV().add(vp);
											if (tc1.belongBack(vp))
												tc1.getBackV().add(vp);
										}
									}
//									if (tc1.equal(new rectCube(new Point(-2.65625, -2.46875, -0.5), new Point(-2.5625, -2.375, -0.3125)))){
//										System.out.println("hihihihihiihihihihihihi");
//										tc.printAll();
//										tempTC.printAll();
//										tc1.printAll();
//										System.out.println("hihihihihiihihihihihihi");
//									}
									tc1.addVY(p);
									tc1.addVZ(p);
									Q2.add(tc1);
									AddAgainx.add(tc1);
									rebalanceQ.add(tc1);
								}
							reBalanceAdjust(rebalanceQ, p, Q2, suspend);
						}
					}
					suspend.add(tc);
				}
			} else {
				Iterator<rectCube> iter = suspend.iterator();
				while (iter.hasNext()) {
					rectCube tempI = iter.next();
					tempI.addVY(p);
					tempI.addVZ(p);
					Q3.add(tempI);
				}
				suspend.clear();

				size1 = tc.getSizeY();
			}
		}

		Iterator<rectCube> iter = suspend.iterator();
		while (iter.hasNext()) {
			rectCube tempI = iter.next();
			tempI.addVY(p);
			tempI.addVZ(p);
			Q3.add(tempI);
		}
		suspend.clear();
		return Q3;
	}

	public PriorityQueue<rectCube> disambiguousZX(PriorityQueue<rectCube> Q2,
			Poly3 p) {
		PriorityQueue<rectCube> Q3 = new PriorityQueue<rectCube>(10,
				new sizeComparatorX());
		double size = Q2.peek().getSizeZ();
		double size1 = Q2.peek().getSizeZ();
		while (size1 == size && !Q2.isEmpty()) {
			rectCube tc = Q2.poll();
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSizeZ();
		}// finish dealing with the smallest size
		PriorityQueue<rectCube> suspend = new PriorityQueue<rectCube>(10,
				new sizeComparatorZX());
		while (!Q2.isEmpty()) {
			rectCube tc = Q2.peek();
			if (tc.getSizeZ() <= size1) {// deal with small size
				tc = Q2.poll();
				if (tc.ambiguous(p) && tc.para == 1) {// ambiguous
				// System.out.println("ambiguity x");
					ArrayList<rectCube> temp = tc.splitZX();
					AddAgainx.remove(tc);
					LinkedList<Point> vs = tc.getVertices();
					counter += 3;
					// re-balance
					PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
							10, new sizeComparatorZ());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							rectCube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.addVZ(p);
							tc1.addVX(p);
							Q3.add(tc1);
							AddAgainx.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalanceAdjust(rebalanceQ, p, Q2, suspend);
					Q2.addAll(suspend);
					suspend.clear();
					// System.out.println(++balanceT);
				} else {// not ambiguous
					if (tc.para == 1) {
						rectCube tempTC = tc.ambiguous2(p);
						if (tempTC != null) {
							Q2.remove(tempTC);
							ArrayList<rectCube> temp;
							if (tc.getSizeZ()<tempTC.getSizeZ()){
								if (tc.getSizeX()<tempTC.getSizeX()){
									temp = tempTC.splitZX();
									counter+=3;
								}
								else{
									temp=tempTC.splitZ();
									counter+=1;
								}
							}
							else{
								temp=tempTC.splitX();
								counter+=1;
							}
							AddAgainx.remove(tempTC);
							LinkedList<Point> vs = tempTC.getVertices();
							counter += 3;
							// re-balance
							PriorityQueue<rectCube> rebalanceQ = new PriorityQueue<rectCube>(
									10, new sizeComparatorZ());
							for (int i = 0; i < temp.size(); ++i)
								if (temp.get(i).C0(p))
									removeC0(temp.get(i));
								else {
									rectCube tc1 = temp.get(i);
									for (int k = 0; k < vs.size(); ++k) {
										if (tc1.containPoint(vs.get(k))) {
											Point vp = vs.get(k);
											tc1.getVertices().add(vp);
											if (tc1.belongLeft(vp))
												tc1.getLeftV().add(vp);
											if (tc1.belongRight(vp))
												tc1.getRightV().add(vp);
											if (tc1.belongTop(vp))
												tc1.getTopV().add(vp);
											if (tc1.belongBottom(vp))
												tc1.getBottomV().add(vp);
											if (tc1.belongFront(vp))
												tc1.getFrontV().add(vp);
											if (tc1.belongBack(vp))
												tc1.getBackV().add(vp);
										}
									}
									tc1.addVZ(p);
									tc1.addVX(p);
									Q2.add(tc1);
									AddAgainx.add(tc1);
									rebalanceQ.add(tc1);
								}
							reBalanceAdjust(rebalanceQ, p, Q2, suspend);
						}
					}
					suspend.add(tc);
				}
			} else {
				Iterator<rectCube> iter = suspend.iterator();
				while (iter.hasNext()) {
					rectCube tempI = iter.next();
					tempI.addVZ(p);
					tempI.addVX(p);
					Q3.add(tempI);
				}
				suspend.clear();

				size1 = tc.getSizeZ();
			}
		}

		Iterator<rectCube> iter = suspend.iterator();
		while (iter.hasNext()) {
			rectCube tempI = iter.next();
			tempI.addVZ(p);
			tempI.addVX(p);
			Q3.add(tempI);
		}
		suspend.clear();
		return Q3;
	}

	public void reBalanceAdjust(PriorityQueue<rectCube> tempQ, Poly3 p,
			PriorityQueue<rectCube> Q2, PriorityQueue<rectCube> suspend) {
		PriorityQueue<rectCube> tempQ2 = reBalance(tempQ, p, Q2, suspend);
		PriorityQueue<rectCube> tempQ3 = reAdjust(tempQ2, p, Q2, suspend);
		if (numberofSplit > 0)
			tempQ2 = reBalance(tempQ3, p, Q2, suspend);
		while (numberofSplit > 0) {
			tempQ3 = reAdjust(tempQ2, p, Q2, suspend);
			tempQ2 = reBalance(tempQ3, p, Q2, suspend);
		}
	}

	public PriorityQueue<rectCube> reAdjust(PriorityQueue<rectCube> tempQ,
			Poly3 p, PriorityQueue<rectCube> Q2, PriorityQueue<rectCube> suspend) {
		// PriorityQueue<Cube> tempQ = new PriorityQueue<Cube>(10,new
		// sizeComparator());
		// tempQ.add(c);
		PriorityQueue<rectCube> tempQ2 = new PriorityQueue<rectCube>(10,
				new sizeComparatorXY());

		while (!tempQ.isEmpty()) {
			rectCube tc = tempQ.poll();
			ArrayList<rectCube> tempxp = tc.getxNeighborP();
			ArrayList<rectCube> tempxn = tc.getxNeighborN();
			ArrayList<rectCube> tempyp = tc.getyNeighborP();
			ArrayList<rectCube> tempyn = tc.getyNeighborN();
			ArrayList<rectCube> tempzp = tc.getzNeighborP();
			ArrayList<rectCube> tempzn = tc.getzNeighborN();

			readjustDX(tc, tempxp, tempQ, p, Q2, suspend);
			readjustDX(tc, tempxn, tempQ, p, Q2, suspend);
			readjustDY(tc, tempyp, tempQ, p, Q2, suspend);
			readjustDY(tc, tempyn, tempQ, p, Q2, suspend);
			readjustDZ(tc, tempzp, tempQ, p, Q2, suspend);
			readjustDZ(tc, tempzn, tempQ, p, Q2, suspend);

			tempQ2.add(tc);
		}

		return tempQ2;
	}

	public PriorityQueue<rectCube> reBalance(PriorityQueue<rectCube> tempQ,
			Poly3 p, PriorityQueue<rectCube> Q2, PriorityQueue<rectCube> suspend) {
		// PriorityQueue<Cube> tempQ = new PriorityQueue<Cube>(10,new
		// sizeComparator());
		// tempQ.add(c);
		PriorityQueue<rectCube> tempQ2 = new PriorityQueue<rectCube>(10,
				new sizeComparatorXY());
		this.numberofSplit = 0;
		while (!tempQ.isEmpty()) {
			rectCube tc = tempQ.poll();
			ArrayList<rectCube> tempxp = tc.getxNeighborP();
			ArrayList<rectCube> tempxn = tc.getxNeighborN();
			ArrayList<rectCube> tempyp = tc.getyNeighborP();
			ArrayList<rectCube> tempyn = tc.getyNeighborN();
			ArrayList<rectCube> tempzp = tc.getzNeighborP();
			ArrayList<rectCube> tempzn = tc.getzNeighborN();

			rebalanceDX(tc, tempxp, tempQ, p, Q2, suspend);
			rebalanceDX(tc, tempxn, tempQ, p, Q2, suspend);
			rebalanceDY(tc, tempyp, tempQ, p, Q2, suspend);
			rebalanceDY(tc, tempyn, tempQ, p, Q2, suspend);
			rebalanceDZ(tc, tempzp, tempQ, p, Q2, suspend);
			rebalanceDZ(tc, tempzn, tempQ, p, Q2, suspend);

			tempQ2.add(tc);
		}
		return tempQ2;
	}

	void readjustDX(rectCube tc, ArrayList<rectCube> tempxp,
			PriorityQueue<rectCube> tempQ, Poly3 p, PriorityQueue<rectCube> Q2,
			PriorityQueue<rectCube> suspend) {
		for (int i = 0; i < tempxp.size(); ++i) {
			rectCube tc1 = tempxp.get(i);

			ArrayList<rectCube> temp;
			if (tc1.getSizeY() > tc.getSizeY()
					&& tc1.getSizeZ() < tc.getSizeZ()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitY();
				counter++;
			} else if (tc1.getSizeZ() > tc.getSizeZ()
					&& tc1.getSizeY() < tc.getSizeY()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitZ();
				counter++;
			} else {
				continue;
			}
			LinkedList<Point> vs = tc1.getVertices();
			for (int j = 0; j < temp.size(); ++j)
				if (temp.get(j).C0(p))
					removeC0(temp.get(j));
				else {
					rectCube ttc = temp.get(j);
					// temp.get(j).addV(p);
					tempQ.add(ttc);
					Q2.add(ttc);
					AddAgainx.add(ttc);
					for (int k = 0; k < vs.size(); ++k) {
						if (ttc.containPoint(vs.get(k))) {
							Point vp = vs.get(k);
							ttc.getVertices().add(vp);
							if (ttc.belongLeft(vp))
								ttc.getLeftV().add(vp);
							if (ttc.belongRight(vp))
								ttc.getRightV().add(vp);
							if (ttc.belongTop(vp))
								ttc.getTopV().add(vp);
							if (ttc.belongBottom(vp))
								ttc.getBottomV().add(vp);
							if (ttc.belongFront(vp))
								ttc.getFrontV().add(vp);
							if (ttc.belongBack(vp))
								ttc.getBackV().add(vp);
						}
					}
				}
		}
	}

	void readjustDY(rectCube tc, ArrayList<rectCube> tempxp,
			PriorityQueue<rectCube> tempQ, Poly3 p, PriorityQueue<rectCube> Q2,
			PriorityQueue<rectCube> suspend) {
		for (int i = 0; i < tempxp.size(); ++i) {
			rectCube tc1 = tempxp.get(i);
			ArrayList<rectCube> temp;
			if (tc1.getSizeX() > tc.getSizeX()
					&& tc1.getSizeZ() < tc.getSizeZ()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitX();
				counter++;
			} else if (tc1.getSizeZ() > tc.getSizeZ()
					&& tc1.getSizeX() < tc.getSizeX()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitZ();
				counter++;
			} else {
				continue;
			}
			LinkedList<Point> vs = tc1.getVertices();
			for (int j = 0; j < temp.size(); ++j)
				if (temp.get(j).C0(p))
					removeC0(temp.get(j));
				else {
					rectCube ttc = temp.get(j);
					// temp.get(j).addV(p);
					tempQ.add(ttc);
					Q2.add(ttc);
					AddAgainx.add(ttc);
					for (int k = 0; k < vs.size(); ++k) {
						if (ttc.containPoint(vs.get(k))) {
							Point vp = vs.get(k);
							ttc.getVertices().add(vp);
							if (ttc.belongLeft(vp))
								ttc.getLeftV().add(vp);
							if (ttc.belongRight(vp))
								ttc.getRightV().add(vp);
							if (ttc.belongTop(vp))
								ttc.getTopV().add(vp);
							if (ttc.belongBottom(vp))
								ttc.getBottomV().add(vp);
							if (ttc.belongFront(vp))
								ttc.getFrontV().add(vp);
							if (ttc.belongBack(vp))
								ttc.getBackV().add(vp);
						}
					}
				}
		}
	}

	void readjustDZ(rectCube tc, ArrayList<rectCube> tempxp,
			PriorityQueue<rectCube> tempQ, Poly3 p, PriorityQueue<rectCube> Q2,
			PriorityQueue<rectCube> suspend) {
		for (int i = 0; i < tempxp.size(); ++i) {
			rectCube tc1 = tempxp.get(i);
			ArrayList<rectCube> temp;
			if (tc1.getSizeX() > tc.getSizeX()
					&& tc1.getSizeY() < tc.getSizeY()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitX();
				counter++;
			} else if (tc1.getSizeY() > tc.getSizeY()
					&& tc1.getSizeX() < tc.getSizeX()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitY();
				counter++;
			} else {
				continue;
			}
			LinkedList<Point> vs = tc1.getVertices();
			for (int j = 0; j < temp.size(); ++j)
				if (temp.get(j).C0(p))
					removeC0(temp.get(j));
				else {
					rectCube ttc = temp.get(j);
					// temp.get(j).addV(p);
					tempQ.add(ttc);
					Q2.add(ttc);
					AddAgainx.add(ttc);
					for (int k = 0; k < vs.size(); ++k) {
						if (ttc.containPoint(vs.get(k))) {
							Point vp = vs.get(k);
							ttc.getVertices().add(vp);
							if (ttc.belongLeft(vp))
								ttc.getLeftV().add(vp);
							if (ttc.belongRight(vp))
								ttc.getRightV().add(vp);
							if (ttc.belongTop(vp))
								ttc.getTopV().add(vp);
							if (ttc.belongBottom(vp))
								ttc.getBottomV().add(vp);
							if (ttc.belongFront(vp))
								ttc.getFrontV().add(vp);
							if (ttc.belongBack(vp))
								ttc.getBackV().add(vp);
						}
					}
				}
		}
	}

	void rebalanceDX(rectCube tc, ArrayList<rectCube> tempxp,
			PriorityQueue<rectCube> tempQ, Poly3 p, PriorityQueue<rectCube> Q2,
			PriorityQueue<rectCube> suspend) {
		for (int i = 0; i < tempxp.size(); ++i) {
			rectCube tc1 = tempxp.get(i);
			ArrayList<rectCube> temp;
			if (tempxp.get(i).getSizeY() > 2 * tc.getSizeY()
					&& tempxp.get(i).getSizeZ() > 2 * tc.getSizeZ()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitYZ();
				numberofSplit++;
				counter += 3;
			} else if (tempxp.get(i).getSizeY() > 2 * tc.getSizeY()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitY();
				numberofSplit++;
				counter += 1;
			} else if (tempxp.get(i).getSizeZ() > 2 * tc.getSizeZ()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitZ();
				numberofSplit++;
				counter += 1;
			} else {
				continue;
			}
			LinkedList<Point> vs = tc1.getVertices();
			for (int j = 0; j < temp.size(); ++j)
				if (temp.get(j).C0(p))
					removeC0(temp.get(j));
				else {
					rectCube ttc = temp.get(j);
					// temp.get(j).addV(p);
					tempQ.add(ttc);
					Q2.add(ttc);
					AddAgainx.add(ttc);
					for (int k = 0; k < vs.size(); ++k) {
						if (ttc.containPoint(vs.get(k))) {
							Point vp = vs.get(k);
							ttc.getVertices().add(vp);
							if (ttc.belongLeft(vp))
								ttc.getLeftV().add(vp);
							if (ttc.belongRight(vp))
								ttc.getRightV().add(vp);
							if (ttc.belongTop(vp))
								ttc.getTopV().add(vp);
							if (ttc.belongBottom(vp))
								ttc.getBottomV().add(vp);
							if (ttc.belongFront(vp))
								ttc.getFrontV().add(vp);
							if (ttc.belongBack(vp))
								ttc.getBackV().add(vp);
						}
					}
				}
		}
	}

	void rebalanceDY(rectCube tc, ArrayList<rectCube> tempxp,
			PriorityQueue<rectCube> tempQ, Poly3 p, PriorityQueue<rectCube> Q2,
			PriorityQueue<rectCube> suspend) {
		for (int i = 0; i < tempxp.size(); ++i) {
			rectCube tc1 = tempxp.get(i);
			ArrayList<rectCube> temp;
			if (tempxp.get(i).getSizeX() > 2 * tc.getSizeX()
					&& tempxp.get(i).getSizeZ() > 2 * tc.getSizeZ()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitZX();
				numberofSplit++;
				counter += 3;
			} else if (tempxp.get(i).getSizeX() > 2 * tc.getSizeX()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitX();
				numberofSplit++;
				counter += 1;
			} else if (tempxp.get(i).getSizeZ() > 2 * tc.getSizeZ()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitZ();
				numberofSplit++;
				counter += 1;
			} else {
				continue;
			}
			LinkedList<Point> vs = tc1.getVertices();
			for (int j = 0; j < temp.size(); ++j)
				if (temp.get(j).C0(p))
					removeC0(temp.get(j));
				else {
					rectCube ttc = temp.get(j);
					// temp.get(j).addV(p);
					tempQ.add(ttc);
					Q2.add(ttc);
					AddAgainx.add(ttc);
					for (int k = 0; k < vs.size(); ++k) {
						if (ttc.containPoint(vs.get(k))) {
							Point vp = vs.get(k);
							ttc.getVertices().add(vp);
							if (ttc.belongLeft(vp))
								ttc.getLeftV().add(vp);
							if (ttc.belongRight(vp))
								ttc.getRightV().add(vp);
							if (ttc.belongTop(vp))
								ttc.getTopV().add(vp);
							if (ttc.belongBottom(vp))
								ttc.getBottomV().add(vp);
							if (ttc.belongFront(vp))
								ttc.getFrontV().add(vp);
							if (ttc.belongBack(vp))
								ttc.getBackV().add(vp);
						}
					}
				}
		}
	}

	void rebalanceDZ(rectCube tc, ArrayList<rectCube> tempxp,
			PriorityQueue<rectCube> tempQ, Poly3 p, PriorityQueue<rectCube> Q2,
			PriorityQueue<rectCube> suspend) {
		for (int i = 0; i < tempxp.size(); ++i) {
			rectCube tc1 = tempxp.get(i);
			ArrayList<rectCube> temp;
			if (tempxp.get(i).getSizeX() > 2 * tc.getSizeX()
					&& tempxp.get(i).getSizeY() > 2 * tc.getSizeY()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitXY();
				numberofSplit++;
				counter += 3;
			} else if (tempxp.get(i).getSizeX() > 2 * tc.getSizeX()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitX();
				numberofSplit++;
				counter += 1;
			} else if (tempxp.get(i).getSizeY() > 2 * tc.getSizeY()) {
				Q2.remove(tc1);
				suspend.remove(tc1);
				AddAgainx.remove(tc1);
				temp = tc1.splitY();
				numberofSplit++;
				counter += 1;
			} else {
				continue;
			}
			LinkedList<Point> vs = tc1.getVertices();
			for (int j = 0; j < temp.size(); ++j)
				if (temp.get(j).C0(p))
					removeC0(temp.get(j));
				else {
					rectCube ttc = temp.get(j);
					// temp.get(j).addV(p);
					tempQ.add(ttc);
					Q2.add(ttc);
					AddAgainx.add(ttc);
					for (int k = 0; k < vs.size(); ++k) {
						if (ttc.containPoint(vs.get(k))) {
							Point vp = vs.get(k);
							ttc.getVertices().add(vp);
							if (ttc.belongLeft(vp))
								ttc.getLeftV().add(vp);
							if (ttc.belongRight(vp))
								ttc.getRightV().add(vp);
							if (ttc.belongTop(vp))
								ttc.getTopV().add(vp);
							if (ttc.belongBottom(vp))
								ttc.getBottomV().add(vp);
							if (ttc.belongFront(vp))
								ttc.getFrontV().add(vp);
							if (ttc.belongBack(vp))
								ttc.getBackV().add(vp);
						}
					}
				}
		}
	}

	public void checkCornerVertices(rectCube c) {
		for (int i = 0; i < 8; ++i)
			for (int j = 0; j < c.getVertices().size(); ++j)
				if (c.corners[i].equal(c.getVertices().get(j))) {
					System.out.println("checkCornerVertices false");
					System.exit(0);
				}
	}

	public void outputObj(String filename) {
		BufferedWriter bufferedWriter = null;

		try {

			bufferedWriter = new BufferedWriter(new FileWriter(filename));
			for (int i = 0; i < vertices.length; ++i) {
				bufferedWriter.write("v " + vertices[i][0] + " "
						+ vertices[i][1] + " " + vertices[i][2]);
				bufferedWriter.newLine();
			}

			for (int i = 0; i < faces.length; ++i) {
				bufferedWriter.write("f " + (faces[i][0] + 1) + " "
						+ (faces[i][1] + 1) + " " + (faces[i][2] + 1));
				bufferedWriter.newLine();
			}
			bufferedWriter.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void outputBox(String filename){
		BufferedWriter bufferedWriter = null;
		
		try {
			bufferedWriter = new BufferedWriter(new FileWriter(filename));
			Iterator<rectCube> iter=boxes.iterator();
			int index=1;
			while (iter.hasNext()){
				rectCube c=iter.next();
				Point[] corners=new Point[8];
				corners[0] = c.getA();
				corners[1] = new Point(c.getA().getX(), c.getA().getY(), c.getB().getZ());
				corners[2] = new Point(c.getA().getX(), c.getB().getY(), c.getB().getZ());
				corners[3] = new Point(c.getA().getX(), c.getB().getY(), c.getA().getZ());
				// right face
				corners[4] = new Point(c.getB().getX(), c.getA().getY(), c.getA().getZ());
				corners[5] = new Point(c.getB().getX(), c.getA().getY(), c.getB().getZ());
				corners[6] = c.getB();
				corners[7] = new Point(c.getB().getX(), c.getB().getY(), c.getA().getZ());
				
				for (int i=0; i<8; ++i){
					bufferedWriter.write("v "+corners[i].getX()+" "+corners[i].getY()+" "+corners[i].getZ());
					bufferedWriter.newLine();
				}
				bufferedWriter.write("f "+(index+0)+" "+(index+1)+" "+(index+2));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+2)+" "+(index+3));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+7)+" "+(index+4));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+3)+" "+(index+7));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+4)+" "+(index+6)+" "+(index+5));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+4)+" "+(index+7)+" "+(index+6));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+1)+" "+(index+6)+" "+(index+2));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+1)+" "+(index+5)+" "+(index+6));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+2)+" "+(index+7)+" "+(index+3));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+2)+" "+(index+6)+" "+(index+7));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+5)+" "+(index+1));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+4)+" "+(index+5));
				bufferedWriter.newLine();

//				bufferedWriter.write("c "+"A: "+c.getA().getX()+" "+c.getA().getY()+" "+c.getA().getZ()
//						+" B: "+c.getB().getX()+" "+c.getB().getY()+" "+c.getB().getZ());
//				bufferedWriter.newLine();
				index+=8;
			}
			bufferedWriter.close();
		}catch (IOException e) {
				e.printStackTrace();
		}
	}
	
	
}