
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

import javax.print.PrintException;

import Geometry.Point;
import Geometry.rectCube;
import Polynomial.*;

@SuppressWarnings("serial")
public class ShadingMISApplet extends MISApplet{
	String path="./pv1.txt";
	double xmin=-8;
	double ymin=-8;
	double zmin=-8;
	double xmax=8;
	double ymax=8;
	double zmax=8;
	double xrotate=30;
	double yrotate=30;
	double zrotate=30;
	int sizeFactor=4;
	
	
	Poly3 p=null;
	
	Point A=null;
	Point B=null;
	rectCube rc=null;
	
	SurfaceR sphere;
	static double ratio=2.0;
	
	long time=System.currentTimeMillis();
	// Each light contains 6 values, x,y,z,r,g,b
	double l1[] = new double[]{-1,1,0.5,1,1,1}; //white lights from upper left
	double l2[] = new double[]{1,-1,0.5,1,1,1}; //white lights from bottom right
	//double l3[] = new double[6];
	//double l4[] = new double[6];

	// Camera Matrix
	Matrix3D C = new Matrix3D();

	// Transformation Matrix
	Matrix3D M = new Matrix3D();

	// z-Buffer
	int zSize=480000;
	double zbuffer[] = new double[zSize];              // THE FRAME BUFFER ARRAY

	@SuppressWarnings("deprecation")
	public void init(){
		String a=" ";
		try{
			DataInputStream lit = 
				new DataInputStream(
						new BufferedInputStream(
								new FileInputStream("./para.txt")));
			a=lit.readLine();
			System.out.println(a);	 
		}catch (IOException e) {
			System.err.println("IOException");
		}
		String[] para=new String[0];
		if (a!=null)
			para=a.split(" ");
		if (para.length>0){
			ratio=Double.parseDouble(para[0]);
			if (para.length>1){
				path=para[1];
				if (para.length>2){
					sizeFactor=Integer.parseInt(para[2]);
					if (para.length>8){
						xmin=Double.parseDouble(para[3]);
						ymin=Double.parseDouble(para[4]);
						zmin=Double.parseDouble(para[5]);
						xmax=Double.parseDouble(para[6]);
						ymax=Double.parseDouble(para[7]);
						zmax=Double.parseDouble(para[8]);
						if (para.length>11){
							xrotate=Double.parseDouble(para[9]);
							yrotate=Double.parseDouble(para[10]);
							zrotate=Double.parseDouble(para[11]);
						}
					}
				}
			}
		}
		p=new Poly3(Polynomial.getS(path));
		A=new Point(xmin,ymin,zmin);
		B=new Point(xmax,ymax,zmax);
		rc=new rectCube(A, B);
		
		try {
			sphere = new SurfaceR(p,rc,ratio,sizeFactor);
		} catch (PrintException e) {
			e.printStackTrace();
		}
		
		super.init();
   
		// Initialize camera
		C.identity();
		
		// Initialize matrix transformation
		M.identity();

		// Add material to each object
		sphere.setMaterial(.1,.2,.05,.2,.3,.4,.2,.3,.4,4);
	}

	public void initFrame(){
		// FOR EACH ANIMATION FRAME 
		// clear zBuffer
		clearBuffer();

		// transform Camera Matrix
		C.identity();
		C.translate(0,0,0);	// camera is at the origin
		C.invert(C);

		M.identity();

		M.translate(0,0,-3.8);      // my camera is at the origin looking at negative z's

		M.scale(.6,.6,.6);
		//M.translate(-1.4,-1.4,0);
		xrotate=Math.PI/(180/xrotate);
		yrotate=Math.PI/(180/yrotate);
		zrotate=Math.PI/(180/zrotate);
		M.rotateY(xrotate);
		//M.rotateY(Math.PI/8);
		M.rotateX(yrotate);
		M.rotateZ(zrotate);

		// Apply camera C to transform matrix M (don't want to change camera)
		Matrix3D T = new Matrix3D();
		T.copy(C);
		T.multiply(M);
		T.copy(M);

		sphere.transform(M);

		double triangle[][], newTriangle[][], colors[][], newcolors[][];

		triangle = new double[3][6];    // 3 vertices each with x,y,z,nx,ny,nz
		colors = new double[3][3];      // 3 vertices each with r,g,b

		// for each triangle (face) in the object
		for (int j = 0; j < sphere.numFaces(); j++){
			sphere.getFace(j, triangle);

			// do shading in each vertex to define the [r,g,b] for that vertex, use Phong's algorithm
			for (int c = 0; c < 3; c++){
				Phong_shading(triangle[c],colors[c], sphere.getMaterial());
			}

			// Apply perspective transform to each vertex [x,y,z] -> [-xf/z,-yf/z,-f/z]
			for (int c = 0; c < 3; c++){ 
				// focal length is 3
				triangle[c][0] = -triangle[c][0] * 3.0 / triangle[c][2];
				triangle[c][1] = -triangle[c][1] * 3.0 / triangle[c][2];
				triangle[c][2] = -3.0 / triangle[c][2];
			}

			// Apply viewport transform to each vertex to get px,py,pz
			for (int c = 0; c < 3; c++){
				triangle[c][0] = viewportX(triangle[c][0]);
				triangle[c][1] = viewportY(triangle[c][1]);
			}

			newTriangle = new double[3][6];
			copyTriangle(triangle, newTriangle);
			newcolors = new double[3][3];
			copyColors(colors, newcolors);

			// Vertically split the triangle into two trapezoids
			// if any two vertex have the same y then we don't have to split into two trapezoids
			double t;
			int cut=0;
    
			if (triangle[0][1] == triangle[1][1] || triangle[0][1] == triangle[2][1] || triangle[1][1] == triangle[2][1]){ 
				// don't cut 
				cut = 0;
			}
			else{
				cut = 1;

				// find the side where we need to add new vertex
				double y1 = Math.abs(triangle[0][1] - triangle[1][1]);
				double y2 = Math.abs(triangle[1][1] - triangle[2][1]);
				double y3 = Math.abs(triangle[2][1] - triangle[0][1]);

				double newX;
				double newZ;
				double newr,newg,newb;

				if (y1 > y2){ 
					if (y1 > y3){ 
						// cut between vertex 0 and vertex 1
						if (triangle[0][1] > triangle[1][1]){ 
							t = (triangle[2][1] - triangle[1][1])*1.0 / (triangle[0][1] - triangle[1][1]); 
							newX = (int)lerp(t,triangle[1][0],triangle[0][0]);
							newZ = lerp(t,triangle[1][2],triangle[0][2]);
							newr = lerp(t,colors[1][0],colors[0][0]);
							newg = lerp(t,colors[1][1],colors[0][1]);   
							newb = lerp(t,colors[1][2],colors[0][2]);
						}
						else{ 
							t = (triangle[2][1] - triangle[0][1])*1.0 / (triangle[1][1] - triangle[0][1]); 
							newX = (int)lerp(t,triangle[0][0],triangle[1][0]);
							newZ = lerp(t,triangle[0][2],triangle[1][2]);
							newr = lerp(t,colors[0][0],colors[1][0]);
							newg = lerp(t,colors[0][1],colors[1][1]);   
							newb = lerp(t,colors[0][2],colors[1][2]);
						}

						// new point will have y = triangle[2][1] and we have to compute x with linear interpolation 
						triangle[1][0] = newX;
						triangle[1][1] = triangle[2][1];
						triangle[1][2] = newZ;
						newTriangle[0][0] = newX;
						newTriangle[0][1] = triangle[2][1];
						newTriangle[0][2] = newZ;
						colors[1][0] = newr;
						colors[1][1] = newg;
						colors[1][2] = newb;
						newcolors[0][0] = newr;
						newcolors[0][1] = newg;
						newcolors[0][2] = newb;
					}
					else{
						// cut between vertex 2 and vertex 0
						if (triangle[2][1] > triangle[0][1]){ 
							t = (triangle[1][1] - triangle[0][1])*1.0 / (triangle[2][1] - triangle[0][1]); 
							newX = (int)lerp(t,triangle[0][0],triangle[2][0]);
							newZ = lerp(t,triangle[0][2],triangle[2][2]);
							newr = lerp(t,colors[0][0],colors[2][0]);
							newg = lerp(t,colors[0][1],colors[2][1]);
							newb = lerp(t,colors[0][2],colors[2][2]);
						}
						else{ 
							t = (triangle[1][1] - triangle[2][1])*1.0 / (triangle[0][1] - triangle[2][1]); 
							newX = (int)lerp(t,triangle[2][0],triangle[0][0]);
							newZ = lerp(t,triangle[2][2],triangle[0][2]);
							newr = lerp(t,colors[2][0],colors[0][0]);
							newg = lerp(t,colors[2][1],colors[0][1]);
							newb = lerp(t,colors[2][2],colors[0][2]);
						}

						// new point will have y = triangle[1][1] and we have to compute x with linear interpolation
						triangle[0][0] = newX;
						triangle[0][1] = triangle[1][1];
						triangle[0][2] = newZ;
						newTriangle[2][0] = newX;
						newTriangle[2][1] = newTriangle[1][1];
						newTriangle[2][2] = newZ;
						colors[0][0] = newr;
						colors[0][1] = newg;
						colors[0][2] = newb;
						newcolors[2][0] = newr;
						newcolors[2][1] = newg;
						newcolors[2][2] = newb;
					}
				}
				else{ 
					if (y2 > y3){ 
						// cut between vertex 1 and vertex 2
						if (triangle[1][1] > triangle[2][1]){
							t = (triangle[0][1] - triangle[2][1])*1.0 / (triangle[1][1] - triangle[2][1]); 
							newX = (int)lerp(t,triangle[2][0],triangle[1][0]);
							newZ = lerp(t,triangle[2][2],triangle[1][2]);
							newr = lerp(t,colors[2][0],colors[1][0]);
							newg = lerp(t,colors[2][1],colors[1][1]);
							newb = lerp(t,colors[2][2],colors[1][2]);
						}
						else{
							t = (triangle[0][1] - triangle[1][1])*1.0 / (triangle[2][1] - triangle[1][1]); 
							newX = (int)lerp(t,triangle[1][0],triangle[2][0]);
							newZ = lerp(t,triangle[1][2],triangle[2][2]);
							newr = lerp(t,colors[1][0],colors[2][0]);
							newg = lerp(t,colors[1][1],colors[2][1]);
							newb = lerp(t,colors[1][2],colors[2][2]);
						}

						// new point will have y = triangle[0][1] and we have to compute x with linear interpolation
						triangle[2][0] = newX;
						triangle[2][1] = triangle[0][1];
						triangle[2][2] = newZ;
						colors[2][0] = newr;
						colors[2][1] = newg;
						colors[2][2] = newb;
						newTriangle[1][0] = newX;
						newTriangle[1][1] = triangle[2][1];
						newTriangle[1][2] = newZ;
						newcolors[1][0] = newr;
						newcolors[1][1] = newg;
						newcolors[1][2] = newb;
					}
					else{
						// cut between vertex 2 and vertex 0
						if (triangle[2][1] > triangle[0][1]){
							t = (triangle[1][1] - triangle[0][1])*1.0 / (triangle[2][1] - triangle[0][1]); 
							newX = (int)lerp(t,triangle[0][0],triangle[2][0]);
							newZ = lerp(t,triangle[0][2],triangle[2][2]);
							newr = lerp(t,colors[0][0],colors[2][0]);
							newg = lerp(t,colors[0][1],colors[2][1]);
							newb = lerp(t,colors[0][2],colors[2][2]);
						}
						else{
							t = (triangle[1][1] - triangle[2][1])*1.0 / (triangle[0][1] - triangle[2][1]); 
							newX = (int)lerp(t,triangle[2][0],triangle[0][0]);
							newZ = lerp(t,triangle[2][2],triangle[0][2]);
							newr = lerp(t,colors[2][0],colors[0][0]);
							newg = lerp(t,colors[2][1],colors[0][1]);
							newb = lerp(t,colors[2][2],colors[0][2]);
						}

						// new point will have y = triangle[0][1] and we have to compute x with linear interpolation
						triangle[0][0] = newX;
						triangle[0][1] = triangle[1][1];
						triangle[0][2] = newZ;
						newTriangle[2][0] = newX;
						newTriangle[2][1] = newTriangle[1][1];
						newTriangle[2][2] = newZ;
						colors[0][0] = newr;
						colors[0][1] = newg;
						colors[0][2] = newb;
						newcolors[2][0] = newr;
						newcolors[2][1] = newg;
						newcolors[2][2] = newb;
					}
				}
			}

			if (cut == 0){ // only one trapezoid
				displayTrapezoid(triangle, colors);
			}
			else{// two trapezoids
				displayTrapezoid(triangle, colors);
				displayTrapezoid(newTriangle, newcolors);
			}
		}
		System.out.println("The running time is"+" "+(System.currentTimeMillis()-time));
	}

	public void setPixel(int x, int y, int rgb[]){// SET ONE PIXEL'S COLOR	
		int p = xy2i(x,y);
		
		rgb[0] = unpack(pix[p],0);
		rgb[1] = unpack(pix[p],1);
		rgb[2] = unpack(pix[p],2);
	}

	// Clear Zbuffer
	void clearBuffer(){ 
		for (int i = 0 ; i < W*H ; i++){
			zbuffer[i] = -10000;
		}
	}   

	void print(double triangle[][]){
		for (int i = 0; i < 3; i++){
			for (int j = 0; j < 6; j++){
				System.out.println("triangle["+ i +"]["+ j +"] e' " + triangle[i][j]);
			}
		}
	}

	// Linear interpolation
	double lerp(double t, double a, double b){   
		double result = a + (t * (b - a));
		return result;
	}

	void copyTriangle(double triangle[][], double newTriangle[][]){
		for (int i=0; i < 3; i++)
			for (int j=0; j < 5; j++)
				newTriangle[i][j] = triangle[i][j];
	}

	void copyColors(double colors[][], double newcolors[][]){
		for (int i=0; i < 3; i++)
			for (int j=0; j < 3; j++)
				newcolors[i][j] = colors[i][j];
	}

	// this function uses Phong algorithm to do vertex shading
	// the color values are set in the vector rgb[]
	void Phong_shading (double vertice[], double rgb[], Material m){
		double ambient[]  = m.getAmbient();
		double diffuse[]  = m.getDiffuse();
		double specular[] = m.getSpecular();
		int p = m.getPower();
		
		// since camera is at the origin the Eye is x,y,z
		double E[] = new double[3];
    
		double R1[] = new double[3];
		double R2[] = new double[3];

		// since we are in negative z's the direction must be reverted
		E[0] = -vertice[0];
		E[1] = -vertice[1];
		E[2] = vertice[2];

		normalize(E);

		// array with normals
		double n[] = new double[3];
		n[0] = vertice[3]; 
		n[1] = vertice[4];
		n[2] = vertice[5];

		normalize(n);

		// normalize lights, they must be unit vectors
		normalize(l1);
		normalize(l2);

		getR (n, l1, R1);
		getR (n, l2, R2);

		// Red component
		rgb[0] = ambient[0] + l1[3] * (diffuse[0]*Math.max(0, dot(n,l1))) + l1[3] * (specular[0]*Math.pow(Math.max(0, dot(E,R1)),p)) +
                          l2[3] * (diffuse[0]*Math.max(0, dot(n,l2))) + l2[3] * (specular[0]*Math.pow(Math.max(0, dot(E,R2)),p));
		
		// Green component
		rgb[1] = ambient[1] + l1[4] * (diffuse[1]*Math.max(0, dot(n,l1))) + l1[4] * (specular[1]*Math.pow(Math.max(0, dot(E,R1)),p)) +
                          l2[4] * (diffuse[1]*Math.max(0, dot(n,l2))) + l2[4] * (specular[1]*Math.pow(Math.max(0, dot(E,R2)),p));
		
		// Blue component
		rgb[2] = ambient[2] + l1[5] * (diffuse[2]*Math.max(0, dot(n,l1))) + l1[5] * (specular[2]*Math.pow(Math.max(0, dot(E,R1)),p)) +
                          l2[5] * (diffuse[2]*Math.max(0, dot(n,l2))) + l2[5] * (specular[2]*Math.pow(Math.max(0, dot(E,R2)),p));
	}

	void normalize(double l[]){
		double t = l[0]*l[0] + l[1]*l[1] + l[2]*l[2]; 
		if (t != 0 && t != 1)
			t = (double) (1 / Math.sqrt(t));
		l[0] = l[0] * t;
		l[1] = l[1] * t;
		l[2] = l[2] * t;
	}

	// dot product
	double dot (double a[], double b[]){
		double result;
		result = (a[0]*b[0]) + (a[1]*b[1]) + (a[2]*b[2]);
		return result;
	}

	void getR (double n[], double L[], double R[]){
		double nL = dot(n,L);
		R[0] = 2 * nL * n[0] - L[0];
		R[1] = 2 * nL * n[1] - L[1];
		R[2] = 2 * nL * n[2] - L[2];  
	}

	// Display trapezoid
	void displayTrapezoid(double triangle[][], double colors[][]){
		int ymin = H;
		int ymax = 0;
		int xmin = W;
		int xmax = 0;
		
		// this arrays will keep px, py, pz, r, g, b
		
		double TL[], TR[], BL[], BR[];
		
		TL = new double[6];
		TR = new double[6];
		BL = new double[6];
		BR = new double[6];

		// find top and bottom
		for (int i = 0; i < 3; i++){
			ymin = Math.min(ymin, (int)triangle[i][1]);
			ymax = Math.max(ymax, (int)triangle[i][1]);
		}

		// find xmax and xmin
		for (int i = 0; i < 3; i++){
			xmin = Math.min(xmin, (int)triangle[i][0]);
			xmax = Math.max(xmax, (int)triangle[i][0]);
		}    
   
		TL[1] = ymax;
		TR[1] = ymax;
		BL[1] = ymin;
		BR[1] = ymin;
		TL[0] = -1;
		TR[0] = -1;
		BL[0] = -1;
		BR[0] = -1;

		// find topLeft, topRight, bottomLeft and bottomright
		for (int i = 0; i < 3; i++){
			if (triangle[i][1] == ymin){ 
				// either is bottom left or bottom right or both
				if (triangle[i][0] == xmin){  // is bottom left
					BL[0] = triangle[i][0];
					BL[2] = triangle[i][2];
					BL[3] = colors[i][0];
					BL[4] = colors[i][1];
					BL[5] = colors[i][2];
				}
				else{
					if (triangle[i][0] == xmax){ // is bottom right
						BR[0] = triangle[i][0];
						BR[2] = triangle[i][2];
						BR[3] = colors[i][0];
						BR[4] = colors[i][1];
						BR[5] = colors[i][2];
					}
					else{ 
						if (BL[0] == -1){ 
							BL[0] = triangle[i][0];
							BL[2] = triangle[i][2];
							BL[3] = colors[i][0];
							BL[4] = colors[i][1];
							BL[5] = colors[i][2];
						}

						if (BR[0] == -1){ 
							BR[0] = triangle[i][0];
							BR[2] = triangle[i][2];
							BR[3] = colors[i][0];
							BR[4] = colors[i][1];
							BR[5] = colors[i][2];
						}
					}
				}
			}
			if (triangle[i][1] == ymax){
				// either is top left or top right or both
				if (triangle[i][0] == xmin){  // is top left
					TL[0] = triangle[i][0];
					TL[2] = triangle[i][2];
					TL[3] = colors[i][0];
					TL[4] = colors[i][1];
					TL[5] = colors[i][2];
				}
				else{ 
					if (triangle[i][0] == xmax){ // is top right
						TR[0] = triangle[i][0];
						TR[2] = triangle[i][2];
						TR[3] = colors[i][0];
						TR[4] = colors[i][1];
						TR[5] = colors[i][2];
					}
					else{ 
						if (TL[0] == -1){
							TL[0] = triangle[i][0];
							TL[2] = triangle[i][2];
							TL[3] = colors[i][0];
							TL[4] = colors[i][1];
							TL[5] = colors[i][2];
						}

						if (TR[0] == -1){
							TR[0] = triangle[i][0];
							TR[2] = triangle[i][2]; 
							TR[3] = colors[i][0];
							TR[4] = colors[i][1];
							TR[5] = colors[i][2];
						}
					}
				}
			}
		}

		if (TL[0] == -1) // copy top right to top left
			for (int k = 0; k < 6; k++)
				TL[k] = TR[k]; 

		if (TR[0] == -1) // copy top left to top right
			for (int k = 0; k < 6; k++)
				TR[k] = TL[k]; 
		
		if (BL[0] == -1) // copy bottom right to bottom left
			for (int k = 0; k < 6; k++)
				BL[k] = BR[k];

		if (BR[0] == -1) // copy bottom left to bottom right
			for (int k = 0; k < 6; k++)
				BR[k] = BL[k];
		
		
		double t;
		
		// Loop through all scan lines from bottom to top
		if (ymax != ymin){
			for (int y = ymin; y <= ymax; y++){
				// Interpolate to get [px,r,g,b,pz] at left edge and right edge
				t = (double)(((y - ymin) * 1.0)/((ymax - ymin) * 1.0));
    		
				// interpolate at left edge
				int pxL = (int)lerp(t,BL[0],TL[0]);
				double pzL = lerp(t,BL[2],TL[2]);
				double rL = lerp(t,BL[3],TL[3]);
				double gL = lerp(t,BL[4],TL[4]);
				double bL = lerp(t,BL[5],TL[5]);  

				// interpolate at right edge
				int pxR = (int)lerp(t,BR[0],TR[0]);
				double pzR = lerp(t,BR[2],TR[2]);
				double rR = lerp(t,BR[3],TR[3]);
				double gR = lerp(t,BR[4],TR[4]);
				double bR = lerp(t,BR[5],TR[5]);
    		
				double z;
				// Loop through pixels from PxL to PxR (left to right)
				for (int x = pxL; x <= pxR; x++){
					// convert to pixel
					int i = xy2i(x,y);
					
					// interpolate to get z at this pixel
					z = lerp(t, pzL, pzR);
					
					if (i >= 0 && i<zSize){ // make sure cliping was done correctly       
						if (z > zbuffer[i]){
							// update zbuffer bc this pixel is closer
							zbuffer[i] = z;
							double r,g,b;
							int color;

							// interpolate to get color at this pixel
							r = ((double)(lerp(t, rL, rR)))*255;
							g = ((double)(lerp(t, gL, gR)))*255;
							b = ((double)(lerp(t, bL, bR)))*255;
							
							color = pack((int)r,(int)g,(int)b);	  
							pix[i] = (color);
						}
					}
				}		
			}
		}
	}
  

	// VIEWPORT TRANSFORM
	// CONVERT X COORDINATE TO SCREEN PIXELS
	int viewportX(double x){
		int result = (int)(W/2 + x*W/2);
		return result;
	}
        
	// CONVERT Y COORDINATE TO SCREEN PIXELS
	int viewportY(double y){
		int result = (int)(H/2 - y*W/2);
		return result;
	} 
}
