package Polynomial;
/**
 * This is the parser for polynomials with 2 variables
 * @author Long Lin
 */

import java.util.LinkedList;

public class Poly2 extends Polynomial{
	
	/*
	 * The highest degree of this polynomial respected to 'y'
	 */
	private int deg;

	/*
	 * The coefficient for each term respected to 'y', from degree high to degree low
	 */
	private Poly1[] coeff;
	
	Poly2(){
		super();
		deg=0;
		coeff=new Poly1[0];
	}
	
	@SuppressWarnings("unchecked")
	Poly2(String T){
		super(T,2); //get a list of terms
		
		//get the highest degree
		for (int i=0; i<this.getTerms().size(); i++){
			Monomial m=this.getTerms().get(i);
			if (m.getDeg()[1]>deg)
				deg=m.getDeg()[1];
		}
		
		//initialize each coefficient
		coeff=new Poly1[deg+1];
		
		LinkedList<Monomial>[] temp=(LinkedList<Monomial>[]) new LinkedList[deg+1];
		
		for (int i=0; i<=deg; i++)
			temp[i]=new LinkedList<Monomial>();
		
		for (int i=0; i<this.getTerms().size(); i++){
			Monomial m=this.getTerms().get(i);	
			temp[m.getDeg()[1]].add(m.subMonomial());

			//LinkedList<Monomial> temp=coeff[m.getDeg()[1]].getTerms();
			//temp.add(m.subMonomial());
			//coeff[m.getDeg()[1]].setTerms(temp);
		}
		
		for (int i=0; i<=deg; i++)
			coeff[i]=new Poly1(temp[i]); 
	}
	
	@SuppressWarnings("unchecked")
	Poly2(LinkedList<Monomial> t){
		super.setN(2);
		super.setTerms(t);
		
		deg=0;
		
		for (int i=0; i<t.size(); i++)
			if (t.get(i).getDeg()[1]>deg)
				deg=t.get(i).getDeg()[1];
		
		coeff=new Poly1[deg+1];
		
		LinkedList<Monomial>[] temp=(LinkedList<Monomial>[]) new LinkedList[deg+1]; 
		
		for (int i=0; i<=deg; i++)
			temp[i]=new LinkedList<Monomial>();
		
		for (int i=0; i<t.size(); i++){
			Monomial m=t.get(i);
			temp[m.getDeg()[1]].add(m.subMonomial());
		}
		
		for (int i=0; i<=deg; i++)
			coeff[i]=new Poly1(temp[i]); 
	}
	
	public Poly2 derivative(char c){
		Poly2 p1=new Poly2(super.derivative(c).getTerms());
		return p1;
	}
	
	public Interval value(Interval[] I){
		Interval x=I[0];
		Interval y=I[1];
		
		Interval temp=coeff[deg].value(new Interval[]{x});
		//temp.print();
		Interval temp1=new Interval();
		for (int i=deg-1; i>=0; i--){
			//System.out.println("-----------------------");
			temp1=temp.multiply(temp, y);
			//temp1.print();
			temp=temp.plus(temp1, coeff[i].value(new Interval[]{x}));
			//temp.print();
		}
		return temp;
	}
	
	public void print(){
		System.out.println("Poly2");
		System.out.println("Degree: "+deg);
		System.out.println("Coefficients: ");
		for (int i=0; i<coeff.length; i++){
			System.out.print(i+" ");
			coeff[i].print();
		}
	}
}
