package Geometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Iterator;

import javax.print.PrintException;

import Polynomial.Interval;
import Polynomial.Poly3;

public class rectCube {
	private Point A;
	private Point B;
	public Point[] corners=new Point[8];
	public int [] pc = new int[8]; //sign of corners
	public int para = -1;
	public int linkedFaces = 4;
	public boolean[] linkedFace = new boolean[6]; // left, right, top, bottom,
													// front, back
	private double sizeX;
	private double sizeY;
	private double sizeZ;
	
	private Interval Ix;
	private Interval Iy;
	private Interval Iz;
	
	private ArrayList<rectCube> xNeighborP; //x axis neighbor positive side;
	private ArrayList<rectCube> xNeighborN;
	private ArrayList<rectCube> yNeighborP; //y axis neighbor positive side;
	private ArrayList<rectCube> yNeighborN;
	private ArrayList<rectCube> zNeighborP; //z axis neighbor positive side;
	private ArrayList<rectCube> zNeighborN;
	
	private LinkedList<Point> vertices;
	private ArrayList<Point> topV;
	private ArrayList<Point> bottomV;
	private ArrayList<Point> leftV;
	private ArrayList<Point> rightV;
	private ArrayList<Point> frontV;
	private ArrayList<Point> backV;
	
	ArrayList<ArrayList<Point>> loops;
	
	private ArrayList<Point[]> faces; //store the triangulated face patch
	
	public rectCube(Point a, Point b){
		A=a;
		B=b;
		vertices=new LinkedList<Point>();
		
		if (a.getX()>b.getX() || a.getY()>b.getY() || a.getZ()>b.getZ())
			System.out.println("cube constructor warning: point A is larger than point B");
		
		sizeX=B.getX()-A.getX();
		sizeY=B.getY()-A.getY();
		sizeZ=B.getZ()-A.getZ();
		
		Ix=new Interval(A.getX(), B.getX());
		Iy=new Interval(A.getY(), B.getY());
		Iz=new Interval(A.getZ(), B.getZ());
		
		corners[0]=A;
		corners[1]=new Point(A.getX(), A.getY(), B.getZ());
		corners[2]=new Point(A.getX(), B.getY(), B.getZ());
		corners[3]=new Point(A.getX(), B.getY(), A.getZ());
		//right face
		corners[4]=new Point(B.getX(), A.getY(), A.getZ());
		corners[5]=new Point(B.getX(), A.getY(), B.getZ());
		corners[6]=B;
		corners[7]=new Point(B.getX(), B.getY(), A.getZ());
		
		xNeighborP=new ArrayList<rectCube>();
		xNeighborN=new ArrayList<rectCube>();
		yNeighborP=new ArrayList<rectCube>();
		yNeighborN=new ArrayList<rectCube>();
		zNeighborP=new ArrayList<rectCube>();
		zNeighborN=new ArrayList<rectCube>();
		
		vertices=new LinkedList<Point>();
		topV=new ArrayList<Point>();
		bottomV=new ArrayList<Point>();
		leftV=new ArrayList<Point>();
		rightV=new ArrayList<Point>();
		frontV=new ArrayList<Point>();
		backV=new ArrayList<Point>();
		
		loops=new ArrayList<ArrayList<Point>>();
		faces=new ArrayList<Point[]>();
	}
	
	public ArrayList<rectCube> splitX(){
		ArrayList<rectCube> children=new ArrayList<rectCube>();
		double temp=(A.getX()+B.getX())/2;
		rectCube c1=new rectCube(A, new Point(temp, B.getY(), B.getZ())); //left child
		rectCube c2=new rectCube(new Point(temp, A.getY(), A.getZ()), B); //right child
		c1.para=c2.para=para;
		children.add(c1);
		children.add(c2);

		c1.xNeighborP.add(c2);
		c2.xNeighborN.add(c1);
		
		ArrayList<rectCube> xp=this.getxNeighborP();
		for (int i=0; i<xp.size(); ++i){
			rectCube temp1=xp.get(i);
			temp1.xNeighborN.remove(this);
			c2.addxNeighborP(temp1);
			temp1.addxNeighborN(c2);
		}
		
		ArrayList<rectCube> xn=this.getxNeighborN();
		for (int i=0; i<xn.size(); ++i){
			rectCube temp1=xn.get(i);
			temp1.xNeighborP.remove(this);
			c1.addxNeighborN(temp1);
			temp1.addxNeighborP(c1);
		}
		
		ArrayList<rectCube> yp=this.getyNeighborP();
		ArrayList<rectCube> yn=this.getyNeighborN();
		ArrayList<rectCube> zp=this.getzNeighborP();
		ArrayList<rectCube> zn=this.getzNeighborN();
		Interval[] C1Y=new Interval[]{c1.getIntervalX(), c1.getIntervalZ()};
		Interval[] C1Z=new Interval[]{c1.getIntervalX(), c1.getIntervalY()};
		Interval[] C2Y=new Interval[]{c2.getIntervalX(), c2.getIntervalZ()};
		Interval[] C2Z=new Interval[]{c2.getIntervalX(), c2.getIntervalY()};
		
		for (int i=0; i<yp.size(); ++i){
			rectCube temp1=yp.get(i);
			Interval[] tempY=new Interval[]{temp1.getIntervalX(), temp1.getIntervalZ()};
			temp1.yNeighborN.remove(this);
			if (this.faceOverlap(C1Y, tempY)){
				temp1.addyNeighborN(c1);
				c1.addyNeighborP(temp1);
			}
			if (this.faceOverlap(C2Y, tempY)){
				temp1.addyNeighborN(c2);
				c2.addyNeighborP(temp1);
			}
		}
		
		for (int i=0; i<yn.size(); ++i){
			rectCube temp1=yn.get(i);
			Interval[] tempY=new Interval[]{temp1.getIntervalX(), temp1.getIntervalZ()};
			temp1.yNeighborP.remove(this);
			if (this.faceOverlap(C1Y, tempY)){
				temp1.addyNeighborP(c1);
				c1.addyNeighborN(temp1);
			}
			if (this.faceOverlap(C2Y, tempY)){
				temp1.addyNeighborP(c2);
				c2.addyNeighborN(temp1);
			}
		}
		
		for (int i=0; i<zp.size(); ++i){
			rectCube temp1=zp.get(i);
			Interval[] tempZ=new Interval[]{temp1.getIntervalX(), temp1.getIntervalY()};
			temp1.zNeighborN.remove(this);
			if (this.faceOverlap(C1Z, tempZ)){
				temp1.addzNeighborN(c1);
				c1.addzNeighborP(temp1);
			}
			if (this.faceOverlap(C2Z, tempZ)){
				temp1.addzNeighborN(c2);
				c2.addzNeighborP(temp1);
			}
		}
		
		for (int i=0; i<zn.size(); ++i){
			rectCube temp1=zn.get(i);
			Interval[] tempZ=new Interval[]{temp1.getIntervalX(), temp1.getIntervalY()};
			temp1.zNeighborP.remove(this);
			if (this.faceOverlap(C1Z, tempZ)){
				temp1.addzNeighborP(c1);
				c1.addzNeighborN(temp1);
			}
			if (this.faceOverlap(C2Z, tempZ)){
				temp1.addzNeighborP(c2);
				c2.addzNeighborN(temp1);
			}
		}
		
		return children;
	}
	
	public ArrayList<rectCube> splitY(){
		ArrayList<rectCube> children=new ArrayList<rectCube>();
		double temp=(A.getY()+B.getY())/2;
		rectCube c1=new rectCube(A, new Point(B.getX(), temp, B.getZ())); //bottom child
		rectCube c2=new rectCube(new Point(A.getX(), temp, A.getZ()), B); //top child
		c1.para=c2.para=para;
		children.add(c1);
		children.add(c2);
		
		c1.yNeighborP.add(c2);
		c2.yNeighborN.add(c1);
		
		ArrayList<rectCube> yp=this.getyNeighborP();
		for (int i=0; i<yp.size(); ++i){
			rectCube temp1=yp.get(i);
			temp1.yNeighborN.remove(this);
			c2.addyNeighborP(temp1);
			temp1.addyNeighborN(c2);
		}
		
		ArrayList<rectCube> yn=this.getyNeighborN();
		for (int i=0; i<yn.size(); ++i){
			rectCube temp1=yn.get(i);
			temp1.yNeighborP.remove(this);
			c1.addyNeighborN(temp1);
			temp1.addyNeighborP(c1);
		}
		
		ArrayList<rectCube> xp=this.getxNeighborP();
		ArrayList<rectCube> xn=this.getxNeighborN();
		ArrayList<rectCube> zp=this.getzNeighborP();
		ArrayList<rectCube> zn=this.getzNeighborN();
		Interval[] C1X=new Interval[]{c1.getIntervalY(), c1.getIntervalZ()};
		Interval[] C1Z=new Interval[]{c1.getIntervalX(), c1.getIntervalY()};
		Interval[] C2X=new Interval[]{c2.getIntervalY(), c2.getIntervalZ()};
		Interval[] C2Z=new Interval[]{c2.getIntervalX(), c2.getIntervalY()};
		
		for (int i=0; i<xp.size(); ++i){
			rectCube temp1=xp.get(i);
			Interval[] tempX=new Interval[]{temp1.getIntervalY(), temp1.getIntervalZ()};
			temp1.xNeighborN.remove(this);
			if (this.faceOverlap(C1X, tempX)){
				temp1.addxNeighborN(c1);
				c1.addxNeighborP(temp1);
			}
			if (this.faceOverlap(C2X, tempX)){
				temp1.addxNeighborN(c2);
				c2.addxNeighborP(temp1);
			}
		}
		
		for (int i=0; i<xn.size(); ++i){
			rectCube temp1=xn.get(i);
			Interval[] tempX=new Interval[]{temp1.getIntervalY(), temp1.getIntervalZ()};
			temp1.xNeighborP.remove(this);
			if (this.faceOverlap(C1X, tempX)){
				temp1.addxNeighborP(c1);
				c1.addxNeighborN(temp1);
			}
			if (this.faceOverlap(C2X, tempX)){
				temp1.addxNeighborP(c2);
				c2.addxNeighborN(temp1);
			}
		}
		
		for (int i=0; i<zp.size(); ++i){
			rectCube temp1=zp.get(i);
			Interval[] tempZ=new Interval[]{temp1.getIntervalX(), temp1.getIntervalY()};
			temp1.zNeighborN.remove(this);
			if (this.faceOverlap(C1Z, tempZ)){
				temp1.addzNeighborN(c1);
				c1.addzNeighborP(temp1);
			}
			if (this.faceOverlap(C2Z, tempZ)){
				temp1.addzNeighborN(c2);
				c2.addzNeighborP(temp1);
			}
		}
		
		for (int i=0; i<zn.size(); ++i){
			rectCube temp1=zn.get(i);
			Interval[] tempZ=new Interval[]{temp1.getIntervalX(), temp1.getIntervalY()};
			temp1.zNeighborP.remove(this);
			if (this.faceOverlap(C1Z, tempZ)){
				temp1.addzNeighborP(c1);
				c1.addzNeighborN(temp1);
			}
			if (this.faceOverlap(C2Z, tempZ)){
				temp1.addzNeighborP(c2);
				c2.addzNeighborN(temp1);
			}
		}
		
		return children;
	}
	
	public ArrayList<rectCube> splitZ(){
		ArrayList<rectCube> children=new ArrayList<rectCube>();
		double temp=(A.getZ()+B.getZ())/2;
		rectCube c1=new rectCube(A, new Point(B.getX(), B.getY(), temp)); //front child, N
		rectCube c2=new rectCube(new Point(A.getX(), A.getY(), temp), B); //back child, P
		c1.para=c2.para=para;
		children.add(c1);
		children.add(c2);
		
		c1.zNeighborP.add(c2);
		c2.zNeighborN.add(c1);
		
		ArrayList<rectCube> zp=this.getzNeighborP();
		for (int i=0; i<zp.size(); ++i){
			rectCube temp1=zp.get(i);
			temp1.zNeighborN.remove(this);
			c2.addzNeighborP(temp1);
			temp1.addzNeighborN(c2);
		}
		
		ArrayList<rectCube> zn=this.getzNeighborN();
		for (int i=0; i<zn.size(); ++i){
			rectCube temp1=zn.get(i);
			temp1.zNeighborP.remove(this);
			c1.addzNeighborN(temp1);
			temp1.addzNeighborP(c1);
		}
		
		ArrayList<rectCube> xp=this.getxNeighborP();
		ArrayList<rectCube> xn=this.getxNeighborN();
		ArrayList<rectCube> yp=this.getyNeighborP();
		ArrayList<rectCube> yn=this.getyNeighborN();
		Interval[] C1X=new Interval[]{c1.getIntervalY(), c1.getIntervalZ()};
		Interval[] C1Y=new Interval[]{c1.getIntervalX(), c1.getIntervalZ()};
		Interval[] C2X=new Interval[]{c2.getIntervalY(), c2.getIntervalZ()};
		Interval[] C2Y=new Interval[]{c2.getIntervalX(), c2.getIntervalZ()};
		
		for (int i=0; i<xp.size(); ++i){
			rectCube temp1=xp.get(i);
			Interval[] tempX=new Interval[]{temp1.getIntervalY(), temp1.getIntervalZ()};
			temp1.xNeighborN.remove(this);
			if (this.faceOverlap(C1X, tempX)){
				temp1.addxNeighborN(c1);
				c1.addxNeighborP(temp1);
			}
			if (this.faceOverlap(C2X, tempX)){
				temp1.addxNeighborN(c2);
				c2.addxNeighborP(temp1);
			}
		}
		
		for (int i=0; i<xn.size(); ++i){
			rectCube temp1=xn.get(i);
			Interval[] tempX=new Interval[]{temp1.getIntervalY(), temp1.getIntervalZ()};
			temp1.xNeighborP.remove(this);
			if (this.faceOverlap(C1X, tempX)){
				temp1.addxNeighborP(c1);
				c1.addxNeighborN(temp1);
			}
			if (this.faceOverlap(C2X, tempX)){
				temp1.addxNeighborP(c2);
				c2.addxNeighborN(temp1);
			}
		}
		
		for (int i=0; i<yp.size(); ++i){
			rectCube temp1=yp.get(i);
			Interval[] tempY=new Interval[]{temp1.getIntervalX(), temp1.getIntervalZ()};
			temp1.yNeighborN.remove(this);
			if (this.faceOverlap(C1Y, tempY)){
				temp1.addyNeighborN(c1);
				c1.addyNeighborP(temp1);
			}
			if (this.faceOverlap(C2Y, tempY)){
				temp1.addyNeighborN(c2);
				c2.addyNeighborP(temp1);
			}
		}
		
		for (int i=0; i<yn.size(); ++i){
			rectCube temp1=yn.get(i);
			Interval[] tempY=new Interval[]{temp1.getIntervalX(), temp1.getIntervalZ()};
			temp1.yNeighborP.remove(this);
			if (this.faceOverlap(C1Y, tempY)){
				temp1.addyNeighborP(c1);
				c1.addyNeighborN(temp1);
			}
			if (this.faceOverlap(C2Y, tempY)){
				temp1.addyNeighborP(c2);
				c2.addyNeighborN(temp1);
			}
		}
		
		return children;
	}
	
	
	
	public ArrayList<rectCube> splitXY(){
		ArrayList<rectCube> c=new ArrayList<rectCube>();
		ArrayList<rectCube> temp1=this.splitX();
		for (int i=0; i<temp1.size(); ++i){
			ArrayList<rectCube> temp2=temp1.get(i).splitY();
			for (int j=0; j<temp2.size(); ++j){
				temp2.get(j).para=para;
				c.add(temp2.get(j));
			}
		}
		return c;
	}
	
	public ArrayList<rectCube> splitYZ(){
		ArrayList<rectCube> c=new ArrayList<rectCube>();
		ArrayList<rectCube> temp1=this.splitY();
		for (int i=0; i<temp1.size(); ++i){
			ArrayList<rectCube> temp2=temp1.get(i).splitZ();
			for (int j=0; j<temp2.size(); ++j){
				temp2.get(j).para=para;
				c.add(temp2.get(j));
			}
		}
		return c;
	}
	
	public ArrayList<rectCube> splitZX(){
		ArrayList<rectCube> c=new ArrayList<rectCube>();
		ArrayList<rectCube> temp1=this.splitZ();
		for (int i=0; i<temp1.size(); ++i){
			ArrayList<rectCube> temp2=temp1.get(i).splitX();
			for (int j=0; j<temp2.size(); ++j){
				temp2.get(j).para=para;
				c.add(temp2.get(j));
			}
		}
		return c;
	}
	
	public ArrayList<rectCube> splitXYZ1(){
		ArrayList<rectCube> temp1=this.splitX();
		ArrayList<rectCube> temp2=new ArrayList<rectCube>();
		ArrayList<rectCube> temp3=new ArrayList<rectCube>();
		ArrayList<rectCube> temp;
		for (int i=0; i<temp1.size(); ++i){
			temp=temp1.get(i).splitY();
			for (int j=0; j<temp.size(); ++j)
				temp2.add(temp.get(j));
		}
		for (int i=0; i<temp2.size(); ++i){
			temp=temp2.get(i).splitZ();
			for (int j=0; j<temp.size(); ++j){
				temp.get(j).para=para;
				temp3.add(temp.get(j));
			}
		}
		return temp3;
	}
	
	public ArrayList<rectCube> splitXYZ(){
		ArrayList<rectCube> children=new ArrayList<rectCube>();
		Point A1=new Point(A.getX(), (A.getY()+B.getY())/2, (A.getZ()+B.getZ())/2);
		Point B1=new Point((A.getX()+B.getX())/2, B.getY(), B.getZ());
		Point A2=new Point(A.getX(), (A.getY()+B.getY())/2, A.getZ());
		Point B2=new Point((A.getX()+B.getX())/2, B.getY(), (A.getZ()+B.getZ())/2);
		Point A3=new Point((A.getX()+B.getX())/2, (A.getY()+B.getY())/2, A.getZ());
		Point B3=new Point(B.getX(), B.getY(), (A.getZ()+B.getZ())/2);
		Point A4=new Point((A.getX()+B.getX())/2, (A.getY()+B.getY())/2, (A.getZ()+B.getZ())/2);
		Point B4=B;
		Point A5=new Point(A.getX(), A.getY(), (A.getZ()+B.getZ())/2);
		Point B5=new Point((A.getX()+B.getX())/2, (A.getY()+B.getY())/2, B.getZ());
		Point A6=A;
		Point B6=new Point((A.getX()+B.getX())/2, (A.getY()+B.getY())/2, (A.getZ()+B.getZ())/2);
		Point A7=new Point((A.getX()+B.getX())/2, A.getY(), A.getZ());
		Point B7=new Point(B.getX(), (A.getY()+B.getY())/2, (A.getZ()+B.getZ())/2);
		Point A8=new Point((A.getX()+B.getX())/2, A.getY(), (A.getZ()+B.getZ())/2);
		Point B8=new Point(B.getX(), (A.getY()+B.getY())/2, B.getZ());
		
		rectCube C1=new rectCube(A1, B1);
		rectCube C2=new rectCube(A2, B2);
		rectCube C3=new rectCube(A3, B3);
		rectCube C4=new rectCube(A4, B4);
		rectCube C5=new rectCube(A5, B5);
		rectCube C6=new rectCube(A6, B6);
		rectCube C7=new rectCube(A7, B7);
		rectCube C8=new rectCube(A8, B8);
		
		C1.para = C2.para = C3.para = C4.para = C5.para = C6.para = C7.para = C8.para = para;
		
		children.add(C1);
		children.add(C2);
		children.add(C3);
		children.add(C4);
		children.add(C5);
		children.add(C6);
		children.add(C7);
		children.add(C8);
		
	/////////////////////////////////////	
		C1.zNeighborN.add(C2);
		C2.zNeighborP.add(C1);
		C2.xNeighborP.add(C3);
		C3.xNeighborN.add(C2);
		C3.zNeighborP.add(C4);
		C4.zNeighborN.add(C3);
		C4.xNeighborN.add(C1);
		C1.xNeighborP.add(C4);
		
		C1.yNeighborN.add(C5);
		C5.yNeighborP.add(C1);
		C2.yNeighborN.add(C6);
		C6.yNeighborP.add(C2);
		C3.yNeighborN.add(C7);
		C7.yNeighborP.add(C3);
		C4.yNeighborN.add(C8);
		C8.yNeighborP.add(C4);
		
		C5.zNeighborN.add(C6);
		C6.zNeighborP.add(C5);
		C6.xNeighborP.add(C7);
		C7.xNeighborN.add(C6);
		C7.zNeighborP.add(C8);
		C8.zNeighborN.add(C7);
		C8.xNeighborN.add(C5);
		C5.xNeighborP.add(C8);
		
		Interval[] C1X=new Interval[]{C1.getIntervalY(), C1.getIntervalZ()};
		Interval[] C1Y=new Interval[]{C1.getIntervalX(), C1.getIntervalZ()};
		Interval[] C1Z=new Interval[]{C1.getIntervalX(), C1.getIntervalY()};
		Interval[] C2X=new Interval[]{C2.getIntervalY(), C2.getIntervalZ()};
		Interval[] C2Y=new Interval[]{C2.getIntervalX(), C2.getIntervalZ()};
		Interval[] C2Z=new Interval[]{C2.getIntervalX(), C2.getIntervalY()};
		Interval[] C3X=new Interval[]{C3.getIntervalY(), C3.getIntervalZ()};
		Interval[] C3Y=new Interval[]{C3.getIntervalX(), C3.getIntervalZ()};
		Interval[] C3Z=new Interval[]{C3.getIntervalX(), C3.getIntervalY()};
		Interval[] C4X=new Interval[]{C4.getIntervalY(), C4.getIntervalZ()};
		Interval[] C4Y=new Interval[]{C4.getIntervalX(), C4.getIntervalZ()};
		Interval[] C4Z=new Interval[]{C4.getIntervalX(), C4.getIntervalY()};
		Interval[] C5X=new Interval[]{C5.getIntervalY(), C5.getIntervalZ()};
		Interval[] C5Y=new Interval[]{C5.getIntervalX(), C5.getIntervalZ()};
		Interval[] C5Z=new Interval[]{C5.getIntervalX(), C5.getIntervalY()};
		Interval[] C6X=new Interval[]{C6.getIntervalY(), C6.getIntervalZ()};
		Interval[] C6Y=new Interval[]{C6.getIntervalX(), C6.getIntervalZ()};
		Interval[] C6Z=new Interval[]{C6.getIntervalX(), C6.getIntervalY()};
		Interval[] C7X=new Interval[]{C7.getIntervalY(), C7.getIntervalZ()};
		Interval[] C7Y=new Interval[]{C7.getIntervalX(), C7.getIntervalZ()};
		Interval[] C7Z=new Interval[]{C7.getIntervalX(), C7.getIntervalY()};
		Interval[] C8X=new Interval[]{C8.getIntervalY(), C8.getIntervalZ()};
		Interval[] C8Y=new Interval[]{C8.getIntervalX(), C8.getIntervalZ()};
		Interval[] C8Z=new Interval[]{C8.getIntervalX(), C8.getIntervalY()};
		
		ArrayList<rectCube> xp=this.xNeighborP;
		for (int i=0; i<xp.size(); i++){
			rectCube temp=xp.get(i);
			Interval[] tempX=new Interval[]{temp.getIntervalY(), temp.getIntervalZ()};
			temp.xNeighborN.remove(this);
			if (this.faceOverlap(tempX, C3X)){
				temp.addxNeighborN(C3);
				C3.addxNeighborP(temp);
			}
			if (this.faceOverlap(tempX, C4X)){
				temp.addxNeighborN(C4);
				C4.addxNeighborP(temp);
			}
			if (this.faceOverlap(tempX, C7X)){
				temp.addxNeighborN(C7);
				C7.addxNeighborP(temp);
			}
			if (this.faceOverlap(tempX, C8X)){
				temp.addxNeighborN(C8);
				C8.addxNeighborP(temp);
			}	
		}
		
		ArrayList<rectCube> xn=this.xNeighborN;
		for (int i=0; i<xn.size(); i++){
			rectCube temp=xn.get(i);
			Interval[] tempX=new Interval[]{temp.getIntervalY(), temp.getIntervalZ()};
			temp.xNeighborP.remove(this);
			if (this.faceOverlap(tempX, C1X)){
				temp.addxNeighborP(C1);
				C1.addxNeighborN(temp);
			}
			if (this.faceOverlap(tempX, C2X)){
				temp.addxNeighborP(C2);
				C2.addxNeighborN(temp);
			}
			if (this.faceOverlap(tempX, C5X)){
				temp.addxNeighborP(C5);
				C5.addxNeighborN(temp);
			}
			if (this.faceOverlap(tempX, C6X)){
				temp.addxNeighborP(C6);
				C6.addxNeighborN(temp);
			}	
		}
		
		ArrayList<rectCube> yp=this.yNeighborP;
		for (int i=0; i<yp.size(); i++){
			rectCube temp=yp.get(i);
			Interval[] tempY=new Interval[]{temp.getIntervalX(), temp.getIntervalZ()};
			temp.yNeighborN.remove(this);
			if (this.faceOverlap(tempY, C1Y)){
				temp.addyNeighborN(C1);
				C1.addyNeighborP(temp);
			}
			if (this.faceOverlap(tempY, C2Y)){
				temp.addyNeighborN(C2);
				C2.addyNeighborP(temp);
			}
			if (this.faceOverlap(tempY, C3Y)){
				temp.addyNeighborN(C3);
				C3.addyNeighborP(temp);
			}
			if (this.faceOverlap(tempY, C4Y)){
				temp.addyNeighborN(C4);
				C4.addyNeighborP(temp);
			}	
		}
		
		ArrayList<rectCube> yn=this.yNeighborN;
		for (int i=0; i<yn.size(); i++){
			rectCube temp=yn.get(i);
			Interval[] tempY=new Interval[]{temp.getIntervalX(), temp.getIntervalZ()};
			temp.yNeighborP.remove(this);
			if (this.faceOverlap(tempY, C5Y)){
				temp.addyNeighborP(C5);
				C5.addyNeighborN(temp);
			}
			if (this.faceOverlap(tempY, C6Y)){
				temp.addyNeighborP(C6);
				C6.addyNeighborN(temp);
			}
			if (this.faceOverlap(tempY, C7Y)){
				temp.addyNeighborP(C7);
				C7.addyNeighborN(temp);
			}
			if (this.faceOverlap(tempY, C8Y)){
				temp.addyNeighborP(C8);
				C8.addyNeighborN(temp);
			}	
		}
		
		ArrayList<rectCube> zp=this.zNeighborP;
		for (int i=0; i<zp.size(); i++){
			rectCube temp=zp.get(i);
			Interval[] tempZ=new Interval[]{temp.getIntervalX(), temp.getIntervalY()};
			temp.zNeighborN.remove(this);
			if (this.faceOverlap(tempZ, C1Z)){
				temp.addzNeighborN(C1);
				C1.addzNeighborP(temp);
			}
			if (this.faceOverlap(tempZ, C4Z)){
				temp.addzNeighborN(C4);
				C4.addzNeighborP(temp);
			}
			if (this.faceOverlap(tempZ, C5Z)){
				temp.addzNeighborN(C5);
				C5.addzNeighborP(temp);
			}
			if (this.faceOverlap(tempZ, C8Z)){
				temp.addzNeighborN(C8);
				C8.addzNeighborP(temp);
			}	
		}
		
		ArrayList<rectCube> zn=this.zNeighborN;
//		if (this.equal(testBox2)){
//			System.out.println("in rectCube "+zn.size());
//			for (int i=0; i<zn.size(); ++i)
//				zn.get(i).print();
//			System.out.println("in rectCube ");
//		}
		for (int i=0; i<zn.size(); i++){
			rectCube temp=zn.get(i);
			Interval[] tempZ=new Interval[]{temp.getIntervalX(), temp.getIntervalY()};
			temp.zNeighborP.remove(this);
			if (this.faceOverlap(tempZ, C2Z)){
				temp.addzNeighborP(C2);
				C2.addzNeighborN(temp);
			}
			if (this.faceOverlap(tempZ, C3Z)){
				temp.addzNeighborP(C3);
				C3.addzNeighborN(temp);
			}
			if (this.faceOverlap(tempZ, C6Z)){
				temp.addzNeighborP(C6);
				C6.addzNeighborN(temp);
			}
			if (this.faceOverlap(tempZ, C7Z)){
				temp.addzNeighborP(C7);
				C7.addzNeighborN(temp);
			}	
		}
		
		return children;
	}
	
	public rectCube[] childY(){
		rectCube[] c=new rectCube[2];
		double temp=(A.getY()+B.getY())/2;
		c[0]=new rectCube(A, new Point(B.getX(), temp, B.getZ())); //bottom child
		c[1]=new rectCube(new Point(A.getX(), temp, A.getZ()), B); //top child
		return c;
	}
	
	public rectCube[] childZ(){
		rectCube[] c=new rectCube[2];
		double temp=(A.getZ()+B.getZ())/2;
		c[0]=new rectCube(A, new Point(B.getX(), B.getY(), temp)); //front child, N
		c[1]=new rectCube(new Point(A.getX(), A.getY(), temp), B); //back child, P
		return c;
	}
	
	public rectCube[] childX(){
		rectCube[] c=new rectCube[2];
		double temp=(A.getX()+B.getX())/2;
		c[0]=new rectCube(A, new Point(temp, B.getY(), B.getZ())); //left child
		c[1]=new rectCube(new Point(temp, A.getY(), A.getZ()), B); //right child
		return c;
	}
	
	public rectCube[] childXY(){
		rectCube[] c=new rectCube[4];
		rectCube[] temp=this.childX();
		rectCube[] temp1=temp[0].childY();
		c[0]=temp1[0];
		c[1]=temp1[1];
		temp1=temp[1].childY();
		c[2]=temp1[0];
		c[3]=temp1[1];
		return c;
	}
	
	public rectCube[] childYZ(){
		rectCube[] c=new rectCube[4];
		rectCube[] temp=this.childY();
		rectCube[] temp1=temp[0].childZ();
		c[0]=temp1[0];
		c[1]=temp1[1];
		temp1=temp[1].childZ();
		c[2]=temp1[0];
		c[3]=temp1[1];
		return c;
	}
	
	public rectCube[] childZX(){
		rectCube[] c=new rectCube[4];
		rectCube[] temp=this.childZ();
		rectCube[] temp1=temp[0].childX();
		c[0]=temp1[0];
		c[1]=temp1[1];
		temp1=temp[1].childX();
		c[2]=temp1[0];
		c[3]=temp1[1];
		return c;
	}

/*
	public void addVX(Poly3 p){
		Point p1=new Point(A);
		Point p2=new Point(A.getX(), A.getY(), B.getZ());
		Point p3=new Point(A.getX(), B.getY(), B.getZ());
		Point p4=new Point(A.getX(), B.getY(), A.getZ());
		Point p1b=new Point(B.getX(), A.getY(), A.getZ());
		Point p2b=new Point(B.getX(), A.getY(), B.getZ());
		Point p3b=new Point(B);
		Point p4b=new Point(B.getX(), B.getY(), A.getZ());
		
		//four edges which are parallel to x
		if (p.sign(p1)*p.sign(p1b)==-1){
			if (!this.vertexInLine(p1, p1b)){
				Point m=midPoint(p1,p1b);
				
//				if (m.equal(testPoint1)){
//					System.out.println("hi1");
//					this.print();
//					for (int i=0; i<this.pc.length; ++i)
//						System.out.print(pc[i]+" ");
//				}
				vertices.add(m);
				this.bottomV.add(m);
				this.frontV.add(m);
//				if (m.equal(testPoint1)){
//					System.out.println("this.getyNeighborN().size()"+this.getyNeighborN().size());
//				}
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getY()==m.getY() && temp.getA().getZ()==m.getZ()){
							temp.topV.add(m);
							temp.frontV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getB().getY()==m.getY() && temp1.getB().getZ()==m.getZ()){
								temp1.topV.add(m);
								temp1.backV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getY()==m.getY() && temp.getB().getZ()==m.getZ()){
							temp.bottomV.add(m);
							temp.backV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p2)*p.sign(p2b)==-1){
			if (!this.vertexInLine(p2, p2b)){
				Point m=midPoint(p2,p2b);
				
				vertices.add(m);
				this.backV.add(m);
				this.bottomV.add(m);
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getY()==m.getY() && temp.getB().getZ()==m.getZ()){
							temp.topV.add(m);
							temp.backV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getZ()==m.getZ() && temp1.getB().getY()==m.getY()){
								temp1.frontV.add(m);
								temp1.topV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getY()==m.getY() && temp.getA().getZ()==m.getZ()){
							temp.bottomV.add(m);
							temp.frontV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p3)*p.sign(p3b)==-1){
			if (!this.vertexInLine(p3, p3b)){
				Point m=midPoint(p3,p3b);
				
				vertices.add(m);
				this.topV.add(m);
				this.backV.add(m);
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getY()==m.getY() && temp.getB().getZ()==m.getZ()){
							temp.bottomV.add(m);
							temp.backV.add(m);
							temp.vertices.add(m);
						}
					}
//					if (m.equal(testPoint)){
//						System.out.println();
//						System.out.println("adsfasdf");
//						temp.print();
//					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
//						if (m.equal(testPoint)){
//							temp1.print();
//						}
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getY()==m.getY() && temp1.getA().getZ()==m.getZ()){
								temp1.bottomV.add(m);
								temp1.frontV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getY()==m.getY() && temp.getA().getZ()==m.getZ()){
							temp.topV.add(m);
							temp.frontV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p4)*p.sign(p4b)==-1){
			if (!this.vertexInLine(p4, p4b)){
				Point m=midPoint(p4,p4b);
				
				vertices.add(m);
				this.frontV.add(m);
				this.topV.add(m);
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getY()==m.getY() && temp.getA().getZ()==m.getZ()){
							temp.bottomV.add(m);
							temp.frontV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getY()==m.getY() && temp1.getB().getZ()==m.getZ()){
								temp1.bottomV.add(m);
								temp1.backV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getY()==m.getY() && temp.getB().getZ()==m.getZ()){
							temp.topV.add(m);
							temp.backV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
	}
	
	public void addVY(Poly3 p){
		Point p1=new Point(A);
		Point p2=new Point(A.getX(), A.getY(), B.getZ());
		Point p3=new Point(A.getX(), B.getY(), B.getZ());
		Point p4=new Point(A.getX(), B.getY(), A.getZ());
		Point p1b=new Point(B.getX(), A.getY(), A.getZ());
		Point p2b=new Point(B.getX(), A.getY(), B.getZ());
		Point p3b=new Point(B);
		Point p4b=new Point(B.getX(), B.getY(), A.getZ());
		
		//four edges which are parallel to y
		if (p.sign(p2)*p.sign(p3)==-1){
			if (!this.vertexInLine(p2, p3)){
				Point m=midPoint(p2,p3);
				
				vertices.add(m);
				this.leftV.add(m);
				this.backV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);		
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getZ()==m.getZ() && temp.getB().getX()==m.getX()){
							temp.backV.add(m);
							temp.rightV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){	
							if (temp1.getB().getX()==m.getX() && temp1.getA().getZ()==m.getZ()){
								temp1.rightV.add(m);
								temp1.frontV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getX()==m.getX() && temp.getA().getZ()==m.getZ()){
							temp.leftV.add(m);
							temp.frontV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p4)*p.sign(p1)==-1){
			if (!this.vertexInLine(p4, p1)){
				Point m=midPoint(p4,p1);
				
				vertices.add(m);
				this.leftV.add(m);
				this.frontV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){	
						if (temp.getA().getZ()==m.getZ() && temp.getB().getX()==m.getX()){
							temp.frontV.add(m);
							temp.rightV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getB().getX()==m.getX() && temp1.getB().getZ()==m.getZ()){
								temp1.rightV.add(m);
								temp1.backV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getX()==m.getX() && temp.getB().getZ()==m.getZ()){
							temp.leftV.add(m);
							temp.backV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p2b)*p.sign(p3b)==-1){
			if (!this.vertexInLine(p2b, p3b)){
				Point m=midPoint(p2b,p3b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.backV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getZ()==m.getZ() && temp.getA().getX()==m.getX()){
							temp.backV.add(m);
							temp.leftV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getX()==m.getX() && temp1.getA().getZ()==m.getZ()){
								temp1.leftV.add(m);
								temp1.frontV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getX()==m.getX() && temp.getA().getZ()==m.getZ()){
							temp.rightV.add(m);
							temp.frontV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p4b)*p.sign(p1b)==-1){
			if (!this.vertexInLine(p4b, p1b)){
				Point m=midPoint(p4b,p1b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.frontV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getZ()==m.getZ() && temp.getA().getX()==m.getX()){
							temp.frontV.add(m);
							temp.leftV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getX()==m.getX() && temp1.getB().getZ()==m.getZ()){
								temp1.leftV.add(m);
								temp1.backV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getX()==m.getX() && temp.getB().getZ()==m.getZ()){
							temp.rightV.add(m);
							temp.backV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
	}
	
	public void addVZ(Poly3 p){
		Point p1=new Point(A);
		Point p2=new Point(A.getX(), A.getY(), B.getZ());
		Point p3=new Point(A.getX(), B.getY(), B.getZ());
		Point p4=new Point(A.getX(), B.getY(), A.getZ());
		Point p1b=new Point(B.getX(), A.getY(), A.getZ());
		Point p2b=new Point(B.getX(), A.getY(), B.getZ());
		Point p3b=new Point(B);
		Point p4b=new Point(B.getX(), B.getY(), A.getZ());
		
		//four edges which are parallel to z
		if (p.sign(p1)*p.sign(p2)==-1){
			if (!this.vertexInLine(p1, p2)){
				Point m=midPoint(p1,p2);
				
				vertices.add(m);
				this.leftV.add(m);
				this.bottomV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getY()==m.getY() && temp.getB().getX()==m.getX()){
							temp.bottomV.add(m);
							temp.rightV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getyNeighborN().size(); ++j){
						rectCube temp1=temp.getyNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getB().getX()==m.getX() && temp1.getB().getY()==m.getY()){
								temp1.rightV.add(m);
								temp1.topV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getA().getX()==m.getX() && temp.getB().getY()==m.getY()){
							temp.leftV.add(m);
							temp.topV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p3)*p.sign(p4)==-1){
			if (!this.vertexInLine(p3, p4)){
				Point m=midPoint(p3,p4);
				if (m.equal(testPoint1)){
					System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&");
					this.print();
					System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&");
				}
				if (m.equal(testPoint)){
					System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@");
					this.print();
//					System.out.println(this.getVertices().size());
//					this.getVertices().get(0).print();
					System.out.println(this.yNeighborP.size());
					this.yNeighborP.get(0).print();
					System.out.println(this.xNeighborN.get(0).getVertices().size());
					for (int i=0; i<this.pc.length; ++i)
						System.out.print(pc[i]+" ");
					System.out.println();
					System.out.println(this.getxNeighborN().size());
					for (int i=0; i<this.getxNeighborN().size(); ++i){
						this.getxNeighborN().get(i).print();
						for (int aa=0; aa<this.getxNeighborN().get(i).pc.length; ++aa)
							System.out.print(this.getxNeighborN().get(i).pc[aa]+" ");
						System.out.println();
//						for (int j=0; j<this.getyNeighborN().get(i).getzNeighborN().size(); ++j)
//							this.getyNeighborN().get(i).getzNeighborN().get(j).print();	
//						System.out.println("yN>>>>>>>>>>>>>>>>");
					}
					System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@");
				}
				vertices.add(m);
				this.leftV.add(m);
				this.topV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getY()==m.getY() && temp.getB().getX()==m.getX()){
							temp.topV.add(m);
							temp.rightV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getyNeighborP().size(); ++j){
						rectCube temp1=temp.getyNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){	
							if (temp1.getB().getX()==m.getX() && temp1.getA().getY()==m.getY()){
								temp1.rightV.add(m);
								temp1.bottomV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){			
						if (temp.getA().getX()==m.getX() && temp.getA().getY()==m.getY()){
							temp.leftV.add(m);
							temp.bottomV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p1b)*p.sign(p2b)==-1){
			if (!this.vertexInLine(p1b, p2b)){
				Point m=midPoint(p1b,p2b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.bottomV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){	
						if (temp.getA().getY()==m.getY() && temp.getA().getX()==m.getX()){
							temp.bottomV.add(m);
							temp.leftV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getyNeighborN().size(); ++j){
						rectCube temp1=temp.getyNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getX()==m.getX() && temp1.getB().getY()==m.getY()){
								temp1.leftV.add(m);
								temp1.topV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						if (temp.getB().getX()==m.getX() && temp.getB().getY()==m.getY()){
							temp.rightV.add(m);
							temp.topV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
		
		if (p.sign(p3b)*p.sign(p4b)==-1){
			if (!this.vertexInLine(p3b, p4b)){
				Point m=midPoint(p3b,p4b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.topV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){	
						if (temp.getB().getY()==m.getY() && temp.getA().getX()==m.getX()){
							temp.topV.add(m);
							temp.leftV.add(m);
							temp.vertices.add(m);
						}
					}
					for (int j=0; j<temp.getyNeighborP().size(); ++j){
						rectCube temp1=temp.getyNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m)){
							if (temp1.getA().getX()==m.getX() && temp1.getA().getY()==m.getY()){
								temp1.leftV.add(m);
								temp1.bottomV.add(m);
								temp1.vertices.add(m);
							}
						}
					}
				}
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){		
						if (temp.getB().getX()==m.getX() && temp.getA().getY()==m.getY()){
							temp.rightV.add(m);
							temp.bottomV.add(m);
							temp.vertices.add(m);
						}
					}
				}
			}
		}
	}
*/
	
	public void addVX(Poly3 p){
		Point p1=new Point(A);
		Point p2=new Point(A.getX(), A.getY(), B.getZ());
		Point p3=new Point(A.getX(), B.getY(), B.getZ());
		Point p4=new Point(A.getX(), B.getY(), A.getZ());
		Point p1b=new Point(B.getX(), A.getY(), A.getZ());
		Point p2b=new Point(B.getX(), A.getY(), B.getZ());
		Point p3b=new Point(B);
		Point p4b=new Point(B.getX(), B.getY(), A.getZ());
		
		//four edges which are parallel to x
		if (p.sign(p1)*p.sign(p1b)==-1){
			if (!this.vertexInLine(p1, p1b)){
				Point m=interPoint(p1,p1b, p);
				//Point m=midPoint(p1,p1b);
				
				vertices.add(m);
				this.bottomV.add(m);
				this.frontV.add(m);
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.topV.add(m);
						if (temp.getA().getZ()==m.getZ())
							temp.frontV.add(m);
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getyNeighborN().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getB().getY()==m.getY())
								temp1.topV.add(m);
							temp1.backV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getA().getY()==m.getY())
							temp.bottomV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p2)*p.sign(p2b)==-1){
			if (!this.vertexInLine(p2, p2b)){
				Point m=interPoint(p2,p2b,p);
				//Point m=midPoint(p2,p2b);
//				if (m.equal(point2)){
//					System.out.println("point2");
//					point2=m;
//					this.print();
//					System.exit(0);
//				}
//				if (m.equal(point4)){
//					System.out.println("point4");
//					point4=m;
//					System.exit(0);
//				}
				vertices.add(m);
//				if (this.equal(testBox))
//					System.out.println(this.getVertices().size());
				this.backV.add(m);
				this.bottomV.add(m);
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.topV.add(m);
						if (temp.getB().getZ()==m.getZ())
							temp.backV.add(m);
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getyNeighborN().contains(temp1)){
							temp1.vertices.add(m);
							temp1.frontV.add(m);
							if (temp1.getB().getY()==m.getY())
								temp1.topV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getA().getY()==m.getY())
							temp.bottomV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p3)*p.sign(p3b)==-1){
			if (!this.vertexInLine(p3, p3b)){
				Point m=interPoint(p3,p3b,p);
				//Point m=midPoint(p3,p3b);
				
				vertices.add(m);
				this.topV.add(m);
				this.backV.add(m);
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.bottomV.add(m);
						if (temp.getB().getZ()==m.getZ())
							temp.backV.add(m);
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getyNeighborP().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getA().getY()==m.getY())
								temp1.bottomV.add(m);
							temp1.frontV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getB().getY()==m.getY())
							temp.topV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p4)*p.sign(p4b)==-1){
			if (!this.vertexInLine(p4, p4b)){
				Point m=interPoint(p4,p4b,p);
				//Point m=midPoint(p4,p4b);
//				if (m.equal(point2)){
//					System.out.println("point2");
//					point2=m;
//					this.print();
//					for (int i=0; i<this.getyNeighborP().size(); ++i){
//						System.out.println("asdf"+i);
//						this.getyNeighborP().get(i).print();
//						for (int j=0; j<this.getyNeighborP().get(i).getzNeighborN().size(); ++j)
//							this.getyNeighborP().get(i).getzNeighborN().get(j).print();
//					}
//					System.exit(0);
//				}
//				if (m.equal(point4)){
//					System.out.println("point4");
//					point4=m;
//					System.exit(0);
//				}
				vertices.add(m);
				this.frontV.add(m);
				this.topV.add(m);
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.bottomV.add(m);
						if (temp.getA().getZ()==m.getZ())
							temp.frontV.add(m);
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getyNeighborP().contains(temp1)){
							temp1.vertices.add(m);
							temp1.backV.add(m);
							if (temp1.getA().getY()==m.getY())
								temp1.bottomV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getB().getY()==m.getY())
							temp.topV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
	}
	
	public void addVY(Poly3 p){
		Point p1=new Point(A);
		Point p2=new Point(A.getX(), A.getY(), B.getZ());
		Point p3=new Point(A.getX(), B.getY(), B.getZ());
		Point p4=new Point(A.getX(), B.getY(), A.getZ());
		Point p1b=new Point(B.getX(), A.getY(), A.getZ());
		Point p2b=new Point(B.getX(), A.getY(), B.getZ());
		Point p3b=new Point(B);
		Point p4b=new Point(B.getX(), B.getY(), A.getZ());
		
		//four edges which are parallel to y
		if (p.sign(p2)*p.sign(p3)==-1){
			if (!this.vertexInLine(p2, p3)){
				Point m=interPoint(p2,p3,p);
				//Point m=midPoint(p2,p3);
				
				vertices.add(m);
				this.leftV.add(m);
				this.backV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getB().getZ()==m.getZ())
							temp.backV.add(m);
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborN().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getB().getX()==m.getX())
								temp1.rightV.add(m);
							temp1.frontV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getA().getX()==m.getX())
							temp.leftV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p4)*p.sign(p1)==-1){
//			if (this.equal(testBox)){
//					System.out.println("found it");
//					System.out.println(this.vertexInLine(p4, p1));
//					System.out.println(this.vertices.size());
//					for (int i=0; i<this.vertices.size(); ++i)
//						this.vertices.get(i).print();
//					System.out.println("front");
//					for (int i=0; i<this.frontV.size(); ++i)
//						this.frontV.get(i).print();
//			}
			if (!this.vertexInLine(p4, p1)){
				Point m=interPoint(p4,p1,p);
				//Point m=midPoint(p4,p1);
				
				vertices.add(m);
				this.leftV.add(m);
				this.frontV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getA().getZ()==m.getZ())
							temp.frontV.add(m);
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborN().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getB().getX()==m.getX())
								temp1.rightV.add(m);
							temp1.backV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getA().getX()==m.getX())
							temp.leftV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p2b)*p.sign(p3b)==-1){
			if (!this.vertexInLine(p2b, p3b)){
				Point m=interPoint(p2b,p3b,p);
				//Point m=midPoint(p2b,p3b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.backV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getB().getZ()==m.getZ())
							temp.backV.add(m);
					}
					for (int j=0; j<temp.getzNeighborP().size(); ++j){
						rectCube temp1=temp.getzNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborP().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getA().getX()==m.getX())
								temp1.leftV.add(m);
							temp1.frontV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborP().size(); ++i){
					rectCube temp=this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getB().getX()==m.getX())
							temp.rightV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p4b)*p.sign(p1b)==-1){
			if (!this.vertexInLine(p4b, p1b)){
				Point m=interPoint(p4b,p1b,p);
				//Point m=midPoint(p4b,p1b);
//				if (m.equal(testPoint)){
//					System.out.println("found it 1");
//					this.print();
//					for (int i=0; i<this.getxNeighborP().size(); ++i)
//						this.getxNeighborP().get(i).print();
////					for (int i=0; i<this.getzNeighborN().size(); ++i)
////						this.getzNeighborN().get(i).print();
//				}
				vertices.add(m);
				this.rightV.add(m);
				this.frontV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
//					if (m.equal(testPoint) && temp.equal(testBox)){
//						System.out.println("temp.containPoint(m) "+temp.containPoint(m));
//						System.out.println("temp.getVertices().contains(m) "+temp.getVertices().contains(m));
//						System.out.println("temp.getVertices().size() "+temp.getVertices().size());
//						for (int j=0; j<temp.getVertices().size(); ++j)
//							temp.getVertices().get(j).print();
//						System.out.println(temp.getA().getZ()==m.getZ());
//					}
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getA().getZ()==m.getZ())
							temp.frontV.add(m);
					}
					for (int j=0; j<temp.getzNeighborN().size(); ++j){
						rectCube temp1=temp.getzNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborP().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getA().getX()==m.getX())
								temp1.leftV.add(m);
							temp1.backV.add(m);
						}
					}
				}
				for (int i=0; i<this.getzNeighborN().size(); ++i){
					rectCube temp=this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getB().getX()==m.getX())
							temp.rightV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
	}
	
	public void addVZ(Poly3 p){
		Point p1=new Point(A);
		Point p2=new Point(A.getX(), A.getY(), B.getZ());
		Point p3=new Point(A.getX(), B.getY(), B.getZ());
		Point p4=new Point(A.getX(), B.getY(), A.getZ());
		Point p1b=new Point(B.getX(), A.getY(), A.getZ());
		Point p2b=new Point(B.getX(), A.getY(), B.getZ());
		Point p3b=new Point(B);
		Point p4b=new Point(B.getX(), B.getY(), A.getZ());
		
		//four edges which are parallel to z
		if (p.sign(p1)*p.sign(p2)==-1){
			if (!this.vertexInLine(p1, p2)){
				Point m=interPoint(p1,p2,p);
				//Point m=midPoint(p1,p2);
				
				vertices.add(m);
				this.leftV.add(m);
				this.bottomV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getA().getY()==m.getY())
							temp.bottomV.add(m);
					}
					for (int j=0; j<temp.getyNeighborN().size(); ++j){
						rectCube temp1=temp.getyNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborN().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getB().getX()==m.getX())
								temp1.rightV.add(m);
							temp1.topV.add(m);
						}
					}
				}
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getA().getX()==m.getX())
							temp.leftV.add(m);
						temp.topV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p3)*p.sign(p4)==-1){
			if (!this.vertexInLine(p3, p4)){
				Point m=interPoint(p3,p4,p);
				//Point m=midPoint(p3,p4);
				
				vertices.add(m);
				this.leftV.add(m);
				this.topV.add(m);
				for (int i=0; i<this.getxNeighborN().size(); ++i){
					rectCube temp=this.getxNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getB().getY()==m.getY())
							temp.topV.add(m);
					}
					for (int j=0; j<temp.getyNeighborP().size(); ++j){
						rectCube temp1=temp.getyNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborN().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getB().getX()==m.getX())
								temp1.rightV.add(m);
							temp1.bottomV.add(m);
						}
					}
				}
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getA().getX()==m.getX())
							temp.leftV.add(m);
						temp.bottomV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p1b)*p.sign(p2b)==-1){
			if (!this.vertexInLine(p1b, p2b)){
				Point m=interPoint(p1b,p2b,p);
				//Point m=midPoint(p1b,p2b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.bottomV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getA().getY()==m.getY())
							temp.bottomV.add(m);
					}
					for (int j=0; j<temp.getyNeighborN().size(); ++j){
						rectCube temp1=temp.getyNeighborN().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborP().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getA().getX()==m.getX())
								temp1.leftV.add(m);
							temp1.topV.add(m);
						}
					}
				}
				for (int i=0; i<this.getyNeighborN().size(); ++i){
					rectCube temp=this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getB().getX()==m.getX())
							temp.rightV.add(m);
						temp.topV.add(m);
					}
				}
			}
		}
		
		if (p.sign(p3b)*p.sign(p4b)==-1){
			if (!this.vertexInLine(p3b, p4b)){
				Point m=interPoint(p3b,p4b,p);
				//Point m=midPoint(p3b,p4b);
				
				vertices.add(m);
				this.rightV.add(m);
				this.topV.add(m);
				for (int i=0; i<this.getxNeighborP().size(); ++i){
					rectCube temp=this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getB().getY()==m.getY())
							temp.topV.add(m);
					}
					for (int j=0; j<temp.getyNeighborP().size(); ++j){
						rectCube temp1=temp.getyNeighborP().get(j);
						if (temp1.containPoint(m) && !temp1.vertices.contains(m) && !this.getxNeighborP().contains(temp1)){
							temp1.vertices.add(m);
							if (temp1.getA().getX()==m.getX())
								temp1.leftV.add(m);
							temp1.bottomV.add(m);
						}
					}
				}
				for (int i=0; i<this.getyNeighborP().size(); ++i){
					rectCube temp=this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)){
						temp.vertices.add(m);
						if (temp.getB().getX()==m.getX())
							temp.rightV.add(m);
						temp.bottomV.add(m);
					}
				}
			}
		}
	}

	public void linkCxyz(Poly3 p, Poly3 px, Poly3 py, Poly3 pz)
			throws PrintException {
		if (para == 0) {
			linkedFace[2] = linkedFace[3] = linkedFace[4] = linkedFace[5] = true;
			// top
			if (!this.smallerYP()) {
				linkFacePara(p, px, py, pz, topV);
			}

			// bottom
			if (!this.smallerYN()) {
				linkFacePara(p, px, py, pz, bottomV);
			}

			// front
			if (!this.smallerZN()) {
				linkFacePara(p, px, py, pz, frontV);
			}

			// back
			if (!this.smallerZP()) {
				linkFacePara(p, px, py, pz, backV);
			}

			// ///////////////////////////////////////////////////////////////

			// left
			if ((this.xNeighborN.size() == 0 && leftV.size() < 4)
					|| (this.xNeighborN.size() > 0
							&& (this.xNeighborN.get(0).getSizeY() >= this.getSizeY()
								&& 	this.xNeighborN.get(0).getSizeZ() >= this.getSizeZ()) && (leftV.size() < 4 || this.xNeighborN
							.get(0).para != 0))) {
				linkFacePara(p, px, py, pz, leftV);
				linkedFace[0] = true;
				++linkedFaces;
			} else if (this.smallerXN()) {
				linkedFace[0] = true;
				++linkedFaces;
			}

			// right
			if ((this.xNeighborP.size() == 0 && rightV.size() < 4)
					|| (this.xNeighborP.size() > 0
							&& (this.xNeighborP.get(0).getSizeY() >= this.getSizeY()
								&& 	this.xNeighborP.get(0).getSizeZ() >= this.getSizeZ()) && (rightV.size() < 4 || this.xNeighborP
							.get(0).para != 0))) {
				linkFacePara(p, px, py, pz, rightV);
				linkedFace[1] = true;
				++linkedFaces;
			} else if (this.smallerXP()) {
				linkedFace[1] = true;
				++linkedFaces;
			}
		}

		if (para == 1) {
			linkedFace[0] = linkedFace[1] = linkedFace[4] = linkedFace[5] = true;
			// left
			if (!this.smallerXN()) {
				linkFacePara(p, px, py, pz, leftV);
			}

			// right
			if (!this.smallerXP()) {
				linkFacePara(p, px, py, pz, rightV);
			}

			// front
			if (!this.smallerZN()) {
				linkFacePara(p, px, py, pz, frontV);
			}

			// back
			if (!this.smallerZP()) {
				linkFacePara(p, px, py, pz, backV);
			}

			// ///////////////////////////////////////////////////////////////

			// top
			if ((this.yNeighborP.size() == 0 && topV.size() < 4)
					|| (this.yNeighborP.size() > 0
							&& (this.yNeighborP.get(0).getSizeX() >= this.getSizeX()
									&& 	this.yNeighborP.get(0).getSizeZ() >= this.getSizeZ()) && (topV.size() < 4 || this.yNeighborP
							.get(0).para != 1))) {
				linkFacePara(p, px, py, pz, topV);
				linkedFace[2] = true;
				++linkedFaces;
			} else if (this.smallerYP()) {
				linkedFace[2] = true;
				++linkedFaces;
			}
			// bottom
			if ((this.yNeighborN.size() == 0 && bottomV.size() < 4)
					|| (this.yNeighborN.size() > 0
							&& (this.yNeighborN.get(0).getSizeX() >= this.getSizeX()
									&& 	this.yNeighborN.get(0).getSizeZ() >= this.getSizeZ()) && (bottomV.size() < 4 || this.yNeighborN
							.get(0).para != 1))) {
				linkFacePara(p, px, py, pz, bottomV);
				linkedFace[3] = true;
				++linkedFaces;
			} else if (this.smallerYN()) {
				linkedFace[3] = true;
				++linkedFaces;
			}
		}

		if (para == 2) {
			linkedFace[0] = linkedFace[1] = linkedFace[2] = linkedFace[3] = true;
			// left
			if (!this.smallerXN()) {
				linkFacePara(p, px, py, pz, leftV);
			}

			// right
			if (!this.smallerXP()) {
				linkFacePara(p, px, py, pz, rightV);
			}

			// top
			if (!this.smallerYP()) {
				linkFacePara(p, px, py, pz, topV);
			}

			// bottom
			if (!this.smallerYN()) {
				linkFacePara(p, px, py, pz, bottomV);
			}

			// ///////////////////////////////////////////////////////////////

			// front
			if ((this.zNeighborN.size() == 0 && frontV.size() < 4)
					|| (this.zNeighborN.size() > 0
							&& (this.zNeighborN.get(0).getSizeX() >= this.getSizeX()
									&& 	this.zNeighborN.get(0).getSizeY() >= this.getSizeY()) && (frontV.size() < 4 || this.zNeighborN
							.get(0).para != 2))) {
				linkFacePara(p, px, py, pz, frontV);
				linkedFace[4] = true;
				++linkedFaces;
			} else if (this.smallerZN()) {
				linkedFace[4] = true;
				++linkedFaces;
			}

			// back
			if ((this.zNeighborP.size() == 0 && backV.size() < 4)
					|| (this.zNeighborP.size() > 0
							&& (this.zNeighborP.get(0).getSizeX() >= this.getSizeX()
									&& 	this.zNeighborP.get(0).getSizeY() >= this.getSizeY()) && (backV.size() < 4 || this.zNeighborP
							.get(0).para != 2))) {
				linkFacePara(p, px, py, pz, backV);
				linkedFace[5] = true;
				++linkedFaces;
			} else if (this.smallerZP()) {
				linkedFace[5] = true;
				++linkedFaces;
			}
		}
	}

	public void linkFacePara(Poly3 p, Poly3 px, Poly3 py, Poly3 pz,
			ArrayList<Point> vList) throws PrintException {
		if (vList.size() == 0) {

		} else if (vList.size() == 2) {
			vList.get(0).addLink(vList.get(1));
			vList.get(1).addLink(vList.get(0));
		} else if (vList.size() == 4) {
			Point s1 = new Point();
			Point s2 = new Point();
			Point d1 = new Point();
			Point d2 = new Point();
			for (int i = 0; i < 3; ++i)
				for (int j = i + 1; j < 4; ++j) {
					if (sameLine(vList.get(i), vList.get(j))) {
						s1 = vList.get(i);
						s2 = vList.get(j);
						for (int s = 0; s < 3; ++s) {
							if (s != i && s != j) {
								d1 = vList.get(s);
								for (int t = s + 1; t < 4; ++t) {
									if ((t != i && t != j)) {
										d2 = vList.get(t);
										break;
									}
								}
								break;
							}
						}
					}
				}
			if ((distance(d1, s1) + distance(d2, s2)) > (distance(d1, s2) + distance(
					d2, s1))) {
				d1.addLink(s2);
				s2.addLink(d1);
				d2.addLink(s1);
				s1.addLink(d2);
			} else {
				d1.addLink(s1);
				s1.addLink(d1);
				d2.addLink(s2);
				s2.addLink(d2);
			}
		} else {
			this.printAll();
			System.out.println(this.para);
			throw (new PrintException(
					"error linkFaceCxyz: vertices # != 0, 2, 4"));
		}
	}

	@SuppressWarnings("unchecked")
	public void linkFace5() {
		ArrayList<Point> unlinked;
		if (!linkedFace[0]) {
			linkedFace[0] = true;
			++linkedFaces;
			unlinked = leftV;
			if (this.getxNeighborN().get(0).getSizeY() == this.getSizeY() && 
					this.getxNeighborN().get(0).getSizeZ() == this.getSizeZ())
				if (this.getxNeighborN().get(0).linkedFace[1] == false) {
					this.getxNeighborN().get(0).linkedFace[1] = true;
					++this.getxNeighborN().get(0).linkedFaces;
				}
		} else if (!linkedFace[1]) {
			linkedFace[1] = true;
			++linkedFaces;
			unlinked = rightV;
			if (this.getxNeighborP().get(0).getSizeY() == this.getSizeY() &&
					this.getxNeighborP().get(0).getSizeZ() == this.getSizeZ())
				if (this.getxNeighborP().get(0).linkedFace[0] == false) {
					this.getxNeighborP().get(0).linkedFace[0] = true;
					++this.getxNeighborP().get(0).linkedFaces;
				}
		} else if (!linkedFace[2]) {
			linkedFace[2] = true;
			++linkedFaces;
			unlinked = topV;
			if (this.getyNeighborP().get(0).getSizeX() == this.getSizeX() &&
					this.getyNeighborP().get(0).getSizeZ() == this.getSizeZ())
				if (this.getyNeighborP().get(0).linkedFace[3] == false) {
					this.getyNeighborP().get(0).linkedFace[3] = true;
					++this.getyNeighborP().get(0).linkedFaces;
				}
		} else if (!linkedFace[3]) {
			linkedFace[3] = true;
			++linkedFaces;
			unlinked = bottomV;
			if (this.getyNeighborN().get(0).getSizeX() == this.getSizeX() &&
					this.getyNeighborN().get(0).getSizeZ() == this.getSizeZ())
				if (this.getyNeighborN().get(0).linkedFace[2] == false) {
					this.getyNeighborN().get(0).linkedFace[2] = true;
					++this.getyNeighborN().get(0).linkedFaces;
				}
		} else if (!linkedFace[4]) {
			linkedFace[4] = true;
			++linkedFaces;
			unlinked = frontV;
			if (this.getzNeighborN().get(0).getSizeX() == this.getSizeX() &&
					this.getzNeighborN().get(0).getSizeY() == this.getSizeY())
				if (this.getzNeighborN().get(0).linkedFace[5] == false) {
					this.getzNeighborN().get(0).linkedFace[5] = true;
					++this.getzNeighborN().get(0).linkedFaces;
				}
		} else {
			linkedFace[5] = true;
			++linkedFaces;
			unlinked = backV;
			if (this.getzNeighborP().get(0).getSizeX() == this.getSizeX() &&
					this.getzNeighborP().get(0).getSizeY() == this.getSizeY())
				if (this.getzNeighborP().get(0).linkedFace[4] == false) {
					this.getzNeighborP().get(0).linkedFace[4] = true;
					++this.getzNeighborP().get(0).linkedFaces;
				}
		}
		LinkedList<Point> tempV = (LinkedList<Point>) vertices.clone();
		LinkedList<Point> temp=new LinkedList<Point>();
		for (int i=0; i<unlinked.size(); ++i)
			temp.add(unlinked.get(i));
		while (!temp.isEmpty()) {
			Point p = temp.pop();
			tempV.remove(p);
			Point tempP = p;
			while (!temp.contains(tempP)) {
				for (int i = 0; i < tempV.size(); ++i) {
					if (tempP.getLinks().contains(tempV.get(i))) {
						tempP = tempV.get(i);
						tempV.remove(i);
						break;
					}
				}
			}
			p.addLink(tempP);
			tempP.addLink(p);
			temp.remove(tempP);
		}
	}
	
	public void findLoop(){
//		if (this.equal(testBox)){
//			 for (int i=0; i<this.getVertices().size(); ++i){
//				 System.out.println("vertices: "+(i+1));
//				 this.getVertices().get(i).print();
//				 System.out.println("links<<<<<<<<<<<<<<<<<<<<");
//				 HashSet<Point> ll=this.getVertices().get(i).getLinks();
//				 for (int j=i+1; j<this.getVertices().size(); ++j)
//					 if (ll.contains(this.getVertices().get(j)))
//						 System.out.println(j+1);
//			 }
//		}
		while (vertices.size()>0){
			ArrayList<Point> loop=new ArrayList<Point>(); 
			Point p0=this.vertices.poll();
			Point p=p0;
			loop.add(p);
			for (int i=0; i<vertices.size(); ++i){
				if (p.getLinks().contains(vertices.get(i))){
					p=vertices.get(i);
					vertices.remove(i);
					loop.add(p);
					break;
				}
			}
			for (int i=0; i<vertices.size(); ++i)
				if (p.getLinks().contains(vertices.get(i))){
					p=vertices.get(i);
					vertices.remove(i);
					loop.add(p);
					break;
				}
			
			while (!p.getLinks().contains(p0)){
				for (int i=0; i<vertices.size(); ++i){
					if (p.getLinks().contains(vertices.get(i))){
						p=vertices.get(i);
						vertices.remove(i);
						loop.add(p);
						break;
					}
				}
			}
			loops.add(loop);
//			if (vertices.size()<=2 && vertices.size()>0){
//				System.out.println("22222222222222222222222222222222222222");
//				this.print();
//				System.out.println(this.loops.size());
//				for (int i=0; i<this.loops.get(0).size(); ++i)
//					this.loops.get(0).get(i).print();
//				System.out.println(vertices.size());
//				for (int i=0; i<vertices.size(); ++i)
//					vertices.get(i).print();
//				System.out.println(this.xNeighborP.size());
//				for (int i=0; i<this.xNeighborP.size(); ++i)
//					this.xNeighborP.get(i).print();
//				for (int i=0; i<this.xNeighborP.get(1).getLeftV().size(); ++i)
//					this.xNeighborP.get(1).getLeftV().get(i).print();
//				System.exit(0);
//			}
		}
	}
	
	public void triangulate(HashMap<Point, Integer> v) {
		if (loops.size() == 0) {

		} else {
			for (int i = 0; i < loops.size(); ++i) {
				ArrayList<Point> loop = loops.get(i);
				Point p = this.meanPoint(loop);
				v.put(p, 0);
				if (counterClock(loop)) {
					for (int j = 0; j < loop.size() - 1; ++j) {
						Point[] f = new Point[3];
						f[0] = p;
						f[1] = loop.get(j);
						f[2] = loop.get(j + 1);
						faces.add(f);
					}
					Point[] f = new Point[3];
					f[0] = p;
					f[1] = loop.get(loop.size() - 1);
					f[2] = loop.get(0);
					faces.add(f);
				} else {
					for (int j = loop.size() - 1; j > 0; --j) {
						Point[] f = new Point[3];
						f[0] = p;
						f[1] = loop.get(j);
						f[2] = loop.get(j - 1);
						faces.add(f);
					}
					Point[] f = new Point[3];
					f[0] = p;
					f[1] = loop.get(0);
					f[2] = loop.get(loop.size() - 1);
					faces.add(f);
				}
			}
		}
	}

	public Point meanPoint(ArrayList<Point> loop) {
		double x = 0, y = 0, z = 0;
		Iterator<Point> iter = loop.iterator();
		while (iter.hasNext()) {
			Point temp = iter.next();
			x += temp.getX();
			y += temp.getY();
			z += temp.getZ();
		}
		x /= loop.size();
		y /= loop.size();
		z /= loop.size();
		return new Point(x, y, z);
	}
	
	public void triangulate1(){
		//loop.size() can be 0, 1, 2
		double dis=10000;
		if (loops.size()==0){
			
		}
		else if (loops.size()==1){//loop.size()=1
			ArrayList<Point> loop=loops.get(0);
			if (counterClock(loop))
				for (int j=1; j<loop.size()-1; ++j){
					Point[] f=new Point[3];
					f[0]=loop.get(0);
					f[1]=loop.get(j);
					f[2]=loop.get(j+1);
					faces.add(f);
				}
			else
				for (int j=loop.size()-1; j>1; --j){
					Point[] f=new Point[3];
					f[0]=loop.get(0);
					f[1]=loop.get(j);
					f[2]=loop.get(j-1);
					faces.add(f);
				}
		}
		else if (loops.size()==2){
			if (loops.get(0).size()==4 && inFace(loops.get(0))){
				boolean positive, cc;
				Point p=loops.get(0).get(0);
				if (p.getX()==A.getX() || p.getY()==A.getY() || p.getZ()==A.getZ())
					positive=(pc[0]>0);
				else
					positive=(pc[4]>0);
				
				cc=(positive && sameFaceCounterClock(loops.get(0))) || ((!positive) && (!sameFaceCounterClock(loops.get(0))));
				
				int s=loops.get(1).size();
				int i1=0; 
				int i2=0; 
				for (int i=0; i<4; ++i)
					for (int j=0; j<s; ++j){
						if (dis>distance(loops.get(0).get(i), loops.get(1).get(j))){
							i1=i;
							i2=j;
						}
					}
				if (cc){
					for (int t=0; t<s-3; ++t){ //s-4+1
						Point[] f=new Point[3];
						f[0]=loops.get(0).get(i1);
						f[1]=loops.get(1).get(i2);
						f[2]=loops.get(1).get((i2+1)%s);
						faces.add(f);
						i2=(i2+1)%s;
					}
					for (int i=0; i<4; ++i){
						Point[] f=new Point[3];
						f[0]=loops.get(0).get((i1+i)%4);
						f[1]=loops.get(1).get((i2+i)%s);
						f[2]=loops.get(1).get((i2+i+1)%s);
						faces.add(f);
						Point[] g=new Point[3];
						g[0]=loops.get(0).get((i1+i)%4);
						g[1]=loops.get(1).get((i2+i+1)%s);
						g[2]=loops.get(0).get((i2+i+1)%4);
						faces.add(g);
					}
				}
				else{
					for (int t=0; t<s-3; ++t){ //s-4+1
						Point[] f=new Point[3];
						f[0]=loops.get(0).get(i1);
						f[2]=loops.get(1).get(i2);
						f[1]=loops.get(1).get((i2+1)%s);
						faces.add(f);
						i2=(i2+1)%s;
					}
					for (int i=0; i<4; ++i){
						Point[] f=new Point[3];
						f[0]=loops.get(0).get((i1+i)%4);
						f[2]=loops.get(1).get((i2+i)%4);
						f[1]=loops.get(1).get((i2+i+1)%4);
						faces.add(f);
						Point[] g=new Point[3];
						g[0]=loops.get(0).get((i1+i)%4);
						g[2]=loops.get(1).get((i2+i+1)%4);
						g[1]=loops.get(0).get((i2+i+1)%4);
						faces.add(g);
					}
				}
			}
			else if (loops.get(1).size()==4 && inFace(loops.get(1))){
				boolean positive, cc;
				Point p=loops.get(1).get(0);
				if (p.getX()==A.getX() || p.getY()==A.getY() || p.getZ()==A.getZ())
					positive=(pc[0]>0);
				else
					positive=(pc[4]>0);
				
				cc=(positive && sameFaceCounterClock(loops.get(1))) || ((!positive) && (!sameFaceCounterClock(loops.get(1))));
				
				int s=loops.get(0).size();
				int i1=0; 
				int i2=0; 
				for (int i=0; i<4; ++i)
					for (int j=0; j<s; ++j){
						if (dis>distance(loops.get(1).get(i), loops.get(0).get(j))){
							i1=i;
							i2=j;
						}
					}
				if (cc){
					for (int t=0; t<s-3; ++t){ //s-4+1
						Point[] f=new Point[3];
						f[0]=loops.get(1).get(i1);
						f[1]=loops.get(0).get(i2);
						f[2]=loops.get(0).get((i2+1)%s);
						faces.add(f);
						i2=(i2+1)%s;
					}
					for (int i=0; i<4; ++i){
						Point[] f=new Point[3];
						f[0]=loops.get(1).get((i1+i)%4);
						f[1]=loops.get(0).get((i2+i)%s);
						f[2]=loops.get(0).get((i2+i+1)%s);
						faces.add(f);
						Point[] g=new Point[3];
						g[0]=loops.get(1).get((i1+i)%4);
						g[1]=loops.get(0).get((i2+i+1)%s);
						g[2]=loops.get(1).get((i2+i+1)%4);
						faces.add(g);
					}
				}
				else{
					for (int t=0; t<s-3; ++t){ //s-4+1
						Point[] f=new Point[3];
						f[0]=loops.get(1).get(i1);
						f[2]=loops.get(0).get(i2);
						f[1]=loops.get(0).get((i2+1)%s);
						faces.add(f);
						i2=(i2+1)%s;
					}
					for (int i=0; i<4; ++i){
						Point[] f=new Point[3];
						f[0]=loops.get(1).get((i1+i)%4);
						f[2]=loops.get(0).get((i2+i)%4);
						f[1]=loops.get(0).get((i2+i+1)%4);
						faces.add(f);
						Point[] g=new Point[3];
						g[0]=loops.get(1).get((i1+i)%4);
						g[2]=loops.get(0).get((i2+i+1)%4);
						g[1]=loops.get(1).get((i2+i+1)%4);
						faces.add(g);
					}
				}
			}
			else{
				for (int i=0; i<loops.size(); ++i){
					ArrayList<Point> loop=loops.get(i);
					if (counterClock(loop))
						for (int j=1; j<loop.size()-1; ++j){
							Point[] f=new Point[3];
							f[0]=loop.get(0);
							f[1]=loop.get(j);
							f[2]=loop.get(j+1);
							faces.add(f);
						}
					else
						for (int j=loop.size()-1; j>1; --j){
							Point[] f=new Point[3];
							f[0]=loop.get(0);
							f[1]=loop.get(j);
							f[2]=loop.get(j-1);
							faces.add(f);
						}
				}
			}
		}
		else{
			System.out.println("loop size >2");
		}
	}
	
	public boolean sameFace(ArrayList<Point> loop, Face f) {
		Iterator<Point> iter = loop.iterator();
		if (para == 0) {
			while (iter.hasNext()) {
				Point p = iter.next();
				if (!f.contain(p.getY(), p.getZ()))
					return false;
			}
			return true;
		} else if (para == 1) {
			while (iter.hasNext()) {
				Point p = iter.next();
				if (!f.contain(p.getZ(), p.getX()))
					return false;
			}
			return true;
		} else {
			while (iter.hasNext()) {
				Point p = iter.next();
				if (!f.contain(p.getX(), p.getY()))
					return false;
			}
			return true;
		}
	}
	
	public boolean sameFaceCounterClock(ArrayList<Point> loop){
		boolean cc=true;
		Point p1=loop.get(0);
		Point p2=loop.get(1);
		Point p3=loop.get(2); //p1->p2->p3-->p1 => (p1-p2)x(p3-p2)=out box direction 
		
		double[] a=new double[]{p1.getX()-p2.getX(), p1.getY()-p2.getY(), p1.getZ()-p2.getZ()};
		double[] b=new double[]{p3.getX()-p2.getX(), p3.getY()-p2.getY(), p3.getZ()-p2.getZ()};
		double[] c=crossProduct(a,b);
		
		//left
		if (p1.getX()==A.getX()){
			cc=(c[0]<0 && c[1]==0 && c[2]==0);
		}
		//right
		else if (p1.getX()==B.getX()){
			cc=(c[0]>0 && c[1]==0 && c[2]==0);
		}
		//bottom
		else if (p1.getY()==A.getY()){
			cc=(c[0]==0 && c[1]<0 && c[2]==0);
		}
		//top
		else if (p1.getY()==B.getY()){
			cc=(c[0]==0 && c[1]>0 && c[2]==0);
		}
		//front
		else if (p1.getZ()==A.getZ()){
			cc=(c[0]==0 && c[1]==0 && c[2]<0);
		}
		//back
		else if (p1.getZ()==B.getZ()){
			cc=(c[0]==0 && c[1]==0 && c[2]>0);
		}
		
		return cc;
	}
	
	public boolean counterClock(ArrayList<Point> loop) {
		boolean cc = true;
		int adjust = 1;
		Iterator<Point> iter = loop.iterator();
		Point p1 = null, p2 = null, temp = null;
		while (iter.hasNext()) {
			p1 = iter.next();
			boolean found = false;
			for (int i = 0; i < 8; ++i)
				if (pc[i] < 0 && this.sameLine(corners[i], p1)) {
					if (iter.hasNext())
						p2 = iter.next();
					else
						p2 = loop.get(0);
					temp = corners[i];
					found = true;
					break;
				}
			if (found)
				break;
		}
		if (temp == null) {
			adjust = -1;
			Iterator<Point> iter1 = loop.iterator();
			while (iter1.hasNext()) {
				p1 = iter1.next();
				boolean found = false;
				for (int i = 0; i < 8; ++i)
					if (this.sameLine(corners[i], p1)) {
						if (temp == null) {
							temp = corners[i];
							p2 = iter1.next();
							found = true;
						} else {
							if (distance(temp, p1) > distance(corners[i], p1))
								temp = corners[i];
						}
					}
				if (found)
					break;
			}
			// if (this.equal(new Cube(new Point(5.125, -0.125, -0.125), new
			// Point( 5.3125, 0.0625, 0.0625)))){
			// p1.print();
			// p2.print();
			// temp.print();
			// }
		}
		if (p1==null || p2==null){
			temp=corners[0];
			p1=loop.get(0);
			p2=loop.get(1);
			if (pc[0]==1)
				adjust=-1;
		}
		if ((para==0 && p1.getX()==p2.getX()) || (para==1 && p1.getY()==p2.getY()) || (para==2 && p1.getZ()==p2.getZ())){
			int i=loop.indexOf(p1);
			if (i>0){
				p2=p1;
				p1=loop.get(i-1);
			}
			else{
				p2=p1;
				p1=loop.get(loop.size()-1);
			}
		}
		
		// else{
		if (p1.getX() == p2.getX() && p1.getX() == A.getX()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] * adjust < 0 && c[1] == 0 && c[2] == 0);
		} else if (p1.getX() == p2.getX() && p1.getX() == B.getX()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] * adjust > 0 && c[1] == 0 && c[2] == 0);
		} else if (p1.getY() == p2.getY() && p1.getY() == A.getY()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] * adjust < 0 && c[2] == 0);
		} else if (p1.getY() == p2.getY() && p1.getY() == B.getY()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] * adjust > 0 && c[2] == 0);
		} else if (p1.getZ() == p2.getZ() && p1.getZ() == A.getZ()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] == 0 && c[2] * adjust < 0);
		} else if (p1.getZ() == p2.getZ() && p1.getZ() == B.getZ()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] == 0 && c[2] * adjust > 0);
		} else {
			System.out.println("error!!!!!");
		}
		// }
		return cc;
	}
	
	public void getSign(Poly3 p){
		for (int i=0; i<8; ++i)
			pc[i]=p.sign(corners[i]);
	}
	
	public double[] crossProduct(double[] a, double[] b){
		return new double[]{a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]};
	}
	
	//return true if the points of a loop is inside a face
	public boolean inFace(ArrayList<Point> loop){
		if (loop.size()==4){
			Point p1=loop.get(0);
			Point p2=loop.get(1);
			Point p3=loop.get(2);
			Point p4=loop.get(3);
			Face xy=new Face(new Interval(A.getX(), B.getX()), new Interval(A.getY(), B.getY()));
			Face yz=new Face(new Interval(A.getY(), B.getY()), new Interval(A.getZ(), B.getZ()));
			Face zx=new Face(new Interval(A.getZ(), B.getZ()), new Interval(A.getX(), B.getX()));
			if ((p1.getX()==A.getX() && p2.getX()==A.getX() && 
					p3.getX()==A.getX() && p4.getX()==A.getX() && 
					yz.contain(p1.getY(), p1.getZ()) && yz.contain(p2.getY(), p2.getZ()) &&
					yz.contain(p3.getY(), p3.getZ()) && yz.contain(p4.getY(), p4.getZ())) ||
					(p1.getX()==B.getX() && p2.getX()==B.getX() && 
					p3.getX()==B.getX() && p4.getX()==B.getX() &&
					yz.contain(p1.getY(), p1.getZ()) && yz.contain(p2.getY(), p2.getZ()) &&
					yz.contain(p3.getY(), p3.getZ()) && yz.contain(p4.getY(), p4.getZ())) ||
					(p1.getY()==A.getY() && p2.getY()==A.getY() && 
					p3.getY()==A.getY() && p4.getY()==A.getY() && 
					zx.contain(p1.getZ(), p1.getX()) && zx.contain(p2.getZ(), p2.getX()) &&
					zx.contain(p3.getZ(), p3.getX()) && zx.contain(p4.getZ(), p4.getX())) ||
					(p1.getY()==B.getY() && p2.getY()==B.getY() && 
					p3.getY()==B.getY() && p4.getY()==B.getY() && 
					zx.contain(p1.getZ(), p1.getX()) && zx.contain(p2.getZ(), p2.getX()) &&
					zx.contain(p3.getZ(), p3.getX()) && zx.contain(p4.getZ(), p4.getX())) ||
					(p1.getZ()==A.getZ() && p2.getZ()==A.getZ() && 
					p3.getZ()==A.getZ() && p4.getZ()==A.getZ() && 
					xy.contain(p1.getX(), p1.getY()) && xy.contain(p2.getX(), p2.getY()) &&
					xy.contain(p3.getX(), p3.getY()) && xy.contain(p4.getX(), p4.getY())) ||
					(p1.getZ()==B.getZ() && p2.getZ()==B.getZ() && 
					p3.getZ()==B.getZ() && p4.getZ()==B.getZ() && 
					xy.contain(p1.getX(), p1.getY()) && xy.contain(p2.getX(), p2.getY()) &&
					xy.contain(p3.getX(), p3.getY()) && xy.contain(p4.getX(), p4.getY())))
				return true;
		}
		return false;
	}
	
	//return the distance between two points a and b.
	public double distance(Point a, Point b){
		return Math.sqrt((Math.pow((a.getX()-b.getX()),2)+Math.pow((a.getY()-b.getY()),2)+Math.pow((a.getZ()-b.getZ()),2)));
	}
	
	//return true if two points a and b are on the same line.
	public boolean sameLine(Point a, Point b){
		return ((a.getX()==b.getX() && a.getY()==b.getY()) ||
			    (a.getY()==b.getY() && a.getZ()==b.getZ()) ||
			    (a.getZ()==b.getZ() && a.getX()==b.getX())); 
	}
	
	//return true if there already exists a vertices on line(a,b)
	public boolean vertexInLine(Point a, Point b){
		for (int i=0; i<this.vertices.size(); ++i){
			Point p=vertices.get(i);
			if (p.contain(a, b)){
				return true;
			}
		}
		return false;
	}
	
	//return true if p is contained inside the cube
	public boolean containPoint(Point p){
		return ((p.getX()>=A.getX() && p.getX()<=B.getX()) &&
				(p.getY()>=A.getY() && p.getY()<=B.getY()) &&
				(p.getZ()>=A.getZ() && p.getZ()<=B.getZ()));
	}
	
	public boolean sameSign(Poly3 p){
		return ((pc[0]==pc[1]) &&
			    (pc[1]==pc[2]) &&
			    (pc[2]==pc[3]) &&
			    (pc[3]==pc[4]) &&
			    (pc[4]==pc[5]) &&
			    (pc[5]==pc[6]) &&
			    (pc[6]==pc[7]));
	}
	
	public boolean ambiguous(Poly3 p){
		if (para == 0) {
			Face f = new Face(new Interval(A.getY(), B.getY()), new Interval(A
					.getZ(), B.getZ()));
			if ((leftV.size() == 4 && sameFace(leftV, f))
					|| (rightV.size() == 4 && sameFace(rightV, f))) {
				System.out.println("xambiguous!!!!!!!!!!!!!!!!");
				return true;
			}
		} else if (para == 1) {
			Face f = new Face(new Interval(A.getZ(), B.getZ()), new Interval(A
					.getX(), B.getX()));
			if ((topV.size() == 4 && sameFace(topV, f))
					|| (bottomV.size() == 4 && sameFace(bottomV, f))) {
				System.out.println("yambiguous!!!!!!!!!!!!!!!!");
				return true;
			}
		} else {
			Face f = new Face(new Interval(A.getX(), B.getX()), new Interval(A
					.getY(), B.getY()));
			if ((frontV.size() == 4 && sameFace(frontV, f))
					|| (backV.size() == 4 && sameFace(backV, f))) {
				System.out.println("zambiguous!!!!!!!!!!!!!!!!");
				return true;
			}
		}

		return false;
	}
	
	public String ambiguous1(Poly3 p) {
			if (leftV.size() == 2) {
				String temp=sameBoxLineX(leftV.get(0), leftV.get(1));
				if (temp.length()>0)
					return temp;
			}
			if (rightV.size() == 2) {
				String temp=sameBoxLineX(rightV.get(0), rightV.get(1));
				if (temp.length()>0)
					return temp;
			}
			if (topV.size() == 2) {
				String temp=sameBoxLineY(topV.get(0), topV.get(1));
				if (temp.length()>0)
					return temp;
			}
			if (bottomV.size() == 2) {
				String temp=sameBoxLineY(bottomV.get(0), bottomV.get(1));
				if (temp.length()>0)
					return temp;
			}
			if (frontV.size() == 2) {
				String temp=sameBoxLineZ(frontV.get(0), frontV.get(1));
				if (temp.length()>0)
					return temp;
			}
			if (backV.size() == 2) {
				String temp=sameBoxLineZ(backV.get(0), backV.get(1));
				if (temp.length()>0)
					return temp;
			}
		return ""; //not ambiguous
	}
	
	public rectCube ambiguous2(Poly3 p) {
		if (para == 0) {
			if (pc[0] == pc[2] && pc[1] == pc[3] && pc[0] != pc[1])
				if (xNeighborN.size() == 1 && (xNeighborN.get(0).sizeY > sizeY || xNeighborN.get(0).sizeZ > sizeZ))
					return xNeighborN.get(0);
			if (pc[4] == pc[6] && pc[5] == pc[7] && pc[4] != pc[5])
				if (xNeighborP.size() == 1 && (xNeighborP.get(0).sizeY > sizeY || xNeighborP.get(0).sizeZ > sizeZ))
					return xNeighborP.get(0);
		}
		if (para == 1) {
			if (pc[0] == pc[5] && pc[1] == pc[4] && pc[0] != pc[1])
				if (yNeighborN.size() == 1 && (yNeighborN.get(0).sizeX > sizeX || yNeighborN.get(0).sizeZ > sizeZ))
					return yNeighborN.get(0);
			if (pc[3] == pc[6] && pc[2] == pc[7] && pc[2] != pc[3])
				if (yNeighborP.size() == 1 && (yNeighborP.get(0).sizeX > sizeX || yNeighborP.get(0).sizeZ > sizeZ))
					return yNeighborP.get(0);
		}
		if (para == 2) {
			if (pc[0] == pc[7] && pc[3] == pc[4] && pc[0] != pc[3])
				if (zNeighborN.size() == 1 && (zNeighborN.get(0).sizeX > sizeX || zNeighborN.get(0).sizeY > sizeY))
					return zNeighborN.get(0);
			if (pc[1] == pc[6] && pc[2] == pc[5] && pc[2] != pc[1])
				if (zNeighborP.size() == 1 && (zNeighborP.get(0).sizeX > sizeX || zNeighborP.get(0).sizeY > sizeY))
					return zNeighborP.get(0);
		}
		return null;
	}
	
	String sameBoxLineY(Point p1, Point p2) {
		double cax = A.getX();
		double caz = A.getZ();
		double cbx = B.getX();
		double cbz = B.getZ();
		if (p1.getX() == p2.getX() && (p1.getX() == cax || p1.getX() == cbx))
			return "z";
		if (p1.getZ() == p2.getZ() && (p1.getZ() == caz || p1.getZ() == cbz))
			return "x";
		return "";
	}

	String sameBoxLineX(Point p1, Point p2) {
		double cay = A.getY();
		double caz = A.getZ();
		double cby = B.getY();
		double cbz = B.getZ();
		if (p1.getY() == p2.getY() && (p1.getY() == cay || p1.getY() == cby))
			return "z";
		if (p1.getZ() == p2.getZ() && (p1.getZ() == caz || p1.getZ() == cbz))
			return "y";
		return "";
//		return ((p1.getY() == p2.getY() && (p1.getY() == cay || p1.getY() == cby)) || (p1
//				.getZ() == p2.getZ() && (p1.getZ() == caz || p1.getZ() == cbz)));
	}

	String sameBoxLineZ(Point p1, Point p2) {
		double cax = A.getX();
		double cay = A.getY();
		double cbx = B.getX();
		double cby = B.getY();
		if (p1.getX() == p2.getX() && (p1.getX() == cax || p1.getX() == cbx))
			return "y";
		if (p1.getY() == p2.getY() && (p1.getY() == cay || p1.getY() == cby))
			return "x";
		return "";
//		return ((p1.getX() == p2.getX() && (p1.getX() == cax || p1.getX() == cbx)) || (p1
//				.getY() == p2.getY() && (p1.getY() == cay || p1.getY() == cby)));
	}
	
	public boolean belongLeft(Point p){
		return (p.getX()==this.getA().getX());
	}
	
	public boolean belongRight(Point p){
		return (p.getX()==this.getB().getX());
	}
	
	public boolean belongTop(Point p){
		return (p.getY()==this.getB().getY());
	}
	
	public boolean belongBottom(Point p){
		return (p.getY()==this.getA().getY());
	}
	
	public boolean belongBack(Point p){
		return (p.getZ()==this.getB().getZ());
	}
	
	public boolean belongFront(Point p){
		return (p.getZ()==this.getA().getZ());
	}
	
	public boolean C0(Poly3 p){
		return (!p.value(new Interval[]{this.getIntervalX(), this.getIntervalY(), this.getIntervalZ()}).zero());
	}
	
	public boolean C1(Poly3 p, Poly3 px, Poly3 py, Poly3 pz){		
		Interval[] I=new Interval[]{this.getIntervalX(), this.getIntervalY(), this.getIntervalZ()};		
		Interval temp=new Interval();		
		Interval Ix=temp.multiply(px.value(I), px.value(I));
		Interval Iy=temp.multiply(py.value(I), py.value(I));
		Interval Iz=temp.multiply(pz.value(I), pz.value(I));		
		return (!temp.plus(temp.plus(Ix, Iy), Iz).zero());
	}
	
	public boolean Cx(Poly3 p, Poly3 px){		
		Interval[] I=new Interval[]{this.getIntervalX(), this.getIntervalY(), this.getIntervalZ()};
		if (!px.value(I).zero()){
			para=0;
			return true;
		}else{
			return false;
		}
	}
	
	public boolean Cy(Poly3 p, Poly3 py){
		Interval[] I=new Interval[]{this.getIntervalX(), this.getIntervalY(), this.getIntervalZ()};
		if (!py.value(I).zero()){
			para=1;
			return true;
		}else{
			return false;
		}
	}
	
	public boolean Cz(Poly3 p, Poly3 pz){	
		Interval[] I=new Interval[]{this.getIntervalX(), this.getIntervalY(), this.getIntervalZ()};
		if (!pz.value(I).zero()){
			para=2;
			return true;
		}else{
			return false;
		}
	}
	
	
	public boolean Cxyz(Poly3 p, Poly3 px, Poly3 py, Poly3 pz){
		return (this.Cx(p, px) || this.Cy(p, py) || this.Cz(p, pz));
	}
	
	/*
	 * return true if the the projections of cubes to y-z plane overlap
	 */
	public boolean xOverlap(rectCube a, rectCube b){
		Interval[] fa=new Interval[]{a.getIntervalY(), a.getIntervalZ()};
		Interval[] fb=new Interval[]{b.getIntervalY(), b.getIntervalZ()};
		return faceOverlap(fa,fb);
	}
	
	/*
	 * return true if the the projections of cubes to x-z plane overlap
	 */
	public boolean yOverlap(rectCube a, rectCube b){
		Interval[] fa=new Interval[]{a.getIntervalX(), a.getIntervalZ()};
		Interval[] fb=new Interval[]{b.getIntervalX(), b.getIntervalZ()};
		return faceOverlap(fa,fb);
	}
	
	/*
	 * return true if the the projections of cubes to x-y plane overlap
	 */
	public boolean zOverlap(rectCube a, rectCube b){
		Interval[] fa=new Interval[]{a.getIntervalX(), a.getIntervalY()};
		Interval[] fb=new Interval[]{b.getIntervalX(), b.getIntervalY()};
		return faceOverlap(fa,fb);
	}
	
	/*
	 * return true if two planar faces f1 f2 overlap
	 */
	public boolean faceOverlap1(Interval[] f1, Interval[] f2){ //f1[0] x interval, f1[1] y interval
		double m1x=(f1[0].getA()+f1[0].getB())/2; 
		double m1y=(f1[1].getA()+f1[1].getB())/2;
		double m2x=(f2[0].getA()+f2[0].getB())/2;
		double m2y=(f2[1].getA()+f2[1].getB())/2;
		
		if ((f2[0].getA()<=m1x && m1x<=f2[0].getB() && f2[1].getA()<=m1y && m1y<=f2[1].getB()) || 
			(f1[0].getA()<=m2x && m2x<=f1[0].getB() && f1[1].getA()<=m2y && m2y<=f1[1].getB()))
			return true;
		else
			return false;
	}
	
	public boolean faceOverlap(Interval[] f1, Interval[] f2){ //f1[0] x interval, f1[1] y interval
		return !(f1[0].getA()>=f2[0].getB() || f2[0].getA()>=f1[0].getB() 
				|| f1[1].getA()>=f2[1].getB() || f2[1].getA()>=f1[1].getB());
	}
	
	public boolean equal(rectCube c){
		return (this.A.equal(c.A) && this.B.equal(c.B));
	}
	
//	public Point midPoint(Point a, Point b){
//		return new Point((a.getX()+b.getX())/2, (a.getY()+b.getY())/2, (a.getZ()+b.getZ())/2);
//	}
	
	public Point interPoint(Point a, Point b, Poly3 p){
		double v2=p.value(b);
		double v1=p.value(a);
		double t=Math.abs(v1/(v2-v1));
//		if ((v1 == 0) || (v2 == 0))
//			t = 0.5;
		 if (v1 == 0)
		 t = 0.01;
		 if (v2 == 0)
		 t = 0.99;
		double x, y, z;
		if (a.getX()==b.getX())
			x=a.getX();
		else x=a.getX()+(b.getX()-a.getX())*t;
		if (a.getY()==b.getY())
			y=a.getY();
		else y=a.getY()+(b.getY()-a.getY())*t;
		if (a.getZ()==b.getZ())
			z=a.getZ();
		else z=a.getZ()+(b.getZ()-a.getZ())*t;
		return new Point(x, y, z);
	}
	
	public boolean smallerXN(){
		if (this.getxNeighborN().size()==0)
			return false;
		else{
			rectCube temp=this.getxNeighborN().get(0);
			return (temp.sizeY<this.sizeY || temp.sizeZ<this.sizeZ);
		}
	}
	
	public boolean smallerXP(){
		if (this.getxNeighborP().size()==0)
			return false;
		else{
			rectCube temp=this.getxNeighborP().get(0);
			return (temp.sizeY<this.sizeY || temp.sizeZ<this.sizeZ);
		}
	}
	
	public boolean smallerYN(){
		if (this.getyNeighborN().size()==0)
			return false;
		else{
			rectCube temp=this.getyNeighborN().get(0);
			return (temp.sizeX<this.sizeX || temp.sizeZ<this.sizeZ);
		}
	}
	
	public boolean smallerYP(){
		if (this.getyNeighborP().size()==0)
			return false;
		else{
			rectCube temp=this.getyNeighborP().get(0);
			return (temp.sizeX<this.sizeX || temp.sizeZ<this.sizeZ);
		}
	}
	
	public boolean smallerZN(){
		if (this.getzNeighborN().size()==0)
			return false;
		else{
			rectCube temp=this.getzNeighborN().get(0);
			return (temp.sizeX<this.sizeX || temp.sizeY<this.sizeY);
		}
	}
	
	public boolean smallerZP(){
		if (this.getzNeighborP().size()==0)
			return false;
		else{
			rectCube temp=this.getzNeighborP().get(0);
			return (temp.sizeX<this.sizeX || temp.sizeY<this.sizeY);
		}
	}
	
	public void removeVetex(Point p){
		vertices.remove(p);
		leftV.remove(p);
		rightV.remove(p);
		topV.remove(p);
		bottomV.remove(p);
		frontV.remove(p);
		backV.remove(p);
	}
	
	public HashSet<rectCube> allNeighbors(){
		HashSet<rectCube> n=new HashSet<rectCube>();
		n.addAll(xNeighborN);
		for (int i=0; i<xNeighborN.size(); ++i){
			n.addAll(xNeighborN.get(i).yNeighborN);
			n.addAll(xNeighborN.get(i).yNeighborP);
			n.addAll(xNeighborN.get(i).zNeighborN);
			n.addAll(xNeighborN.get(i).zNeighborP);
		}
		n.addAll(xNeighborP);
		for (int i=0; i<xNeighborP.size(); ++i){
			n.addAll(xNeighborP.get(i).yNeighborN);
			n.addAll(xNeighborP.get(i).yNeighborP);
			n.addAll(xNeighborP.get(i).zNeighborN);
			n.addAll(xNeighborP.get(i).zNeighborP);
		}
		n.addAll(yNeighborN);
		n.addAll(yNeighborP);
		n.addAll(zNeighborN);
		n.addAll(zNeighborP);
		return n;
	}
	
	public double ratioX(){
		return Math.max(sizeY, sizeZ)/sizeX;
	}
	
	public double ratioY(){
		return Math.max(sizeX, sizeZ)/sizeY;
	}
	
	public double ratioZ(){
		return Math.max(sizeX, sizeY)/sizeZ;
	}
	
	public double ratioXY(){
		return sizeZ/Math.min(sizeX, sizeY);
	}
	
	public double ratioYZ(){
		return sizeX/Math.min(sizeY, sizeZ);
	}
	
	public double ratioZX(){
		return sizeY/Math.min(sizeZ, sizeX);
	}
	
	/*
	 * return true if two cubes overlap
	 */
	static public boolean cubeOverlap(rectCube c1, rectCube c2) {
		return (!(c1.getA().getX() > c2.getB().getX()
				|| c2.getA().getX() > c1.getB().getX()
				|| c1.getA().getY() > c2.getB().getY()
				|| c2.getA().getY() > c1.getB().getY()
				|| c1.getA().getZ() > c2.getB().getZ() || c2.getA().getZ() > c1
				.getB().getZ()))
				&& // only intersect with a corner
				(!((c1.getA().getX() == c2.getB().getX() || c2.getA().getX() == c1
						.getB().getX())
						&& (c1.getA().getY() > c2.getB().getY() || c2.getA()
								.getY() > c1.getB().getY()) && (c1.getA()
						.getZ() > c2.getB().getZ() || c2.getA().getZ() > c1
						.getB().getZ())));
	}

	public void print(){
		System.out.println("rectCube:");
		A.print();
		B.print();
	}
	
	public void printVertices(){
		System.out.println("vertices:");
		for (int i=0; i<vertices.size(); ++i)
			vertices.get(i).print();
	}
	
	public void printLinks(){
		for (int i=0; i<this.getVertices().size(); ++i){
			System.out.println("vertices: "+(i+1));
			this.getVertices().get(i).print();
			System.out.println("links<<<<<<<<<<<<<<<<<<<<");
			HashSet<Point> ll=this.getVertices().get(i).getLinks();
			for (int j=i+1; j<this.getVertices().size(); ++j)
				if (ll.contains(this.getVertices().get(j)))
					System.out.println(j+1);
		}
	}
	
	public void printSign(){
		for (int i=0; i<8; ++i)
			System.out.print(pc[i]+" ");
		System.out.println();
	}
	
	public void printAll(){
		this.print();
		this.printSign();
		this.printVertices();
		this.printLinks();
	}
	
	public ArrayList<ArrayList<Point>> getLoops(){
		return loops;
	}
	
	public Point getA(){
		return A;
	}
	
	public Point getB(){
		return B;
	}
	
	public Interval getIntervalX(){
		return Ix;
	}
	
	public Interval getIntervalY(){
		return Iy;
	}
	
	public Interval getIntervalZ(){
		return Iz;
	}
	
	public double getSizeX(){
		return sizeX;
	}
	
	public double getSizeY(){
		return sizeY;
	}
	
	public double getSizeZ(){
		return sizeZ;
	}
	
	public ArrayList<rectCube> getxNeighborP(){
		return xNeighborP;
	}
	
	public ArrayList<rectCube> getxNeighborN(){
		return xNeighborN;
	}
	
	public ArrayList<rectCube> getyNeighborP(){
		return yNeighborP;
	}
	
	public ArrayList<rectCube> getyNeighborN(){
		return yNeighborN;
	}
	
	public ArrayList<rectCube> getzNeighborP(){
		return zNeighborP;
	}
	
	public ArrayList<rectCube> getzNeighborN(){
		return zNeighborN;
	}
	
	public LinkedList<Point> getVertices(){
		return vertices;
	}
	
	public ArrayList<Point> getTopV(){
		return topV;
	}
	
	public ArrayList<Point> getBottomV(){
		return bottomV;
	}
	
	public ArrayList<Point> getLeftV(){
		return leftV;
	}
	
	public ArrayList<Point> getRightV(){
		return rightV;
	}
	
	public ArrayList<Point> getFrontV(){
		return frontV;
	}
	
	public ArrayList<Point> getBackV(){
		return backV;
	}
	
	public ArrayList<Point[]> getFaces(){
		return this.faces;
	}
	
	public void addxNeighborP(rectCube c){
		xNeighborP.add(c);
	}
	
	public void addxNeighborN(rectCube c){
		xNeighborN.add(c);
	}
	
	public void addyNeighborP(rectCube c){
		yNeighborP.add(c);
	}
	
	public void addyNeighborN(rectCube c){
		yNeighborN.add(c);
	}
	
	public void addzNeighborP(rectCube c){
		zNeighborP.add(c);
	}
	
	public void addzNeighborN(rectCube c){
		zNeighborN.add(c);
	}
}
