package Geometry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;

import javax.print.PrintException;

import Polynomial.Interval;
import Polynomial.Poly3;

public class Cube {
	private Point A;
	private Point B;
	public Point[] corners = new Point[8];
	public int[] pc = new int[8]; // sign of corners
	public int para = -1;
	public int linkedFaces = 4;
	public boolean[] linkedFace = new boolean[6]; // left, right, top, bottom,
													// front, back
	private double size;

	private LinkedList<Cube> xNeighborP; // x axis neighbor positive side;
	private LinkedList<Cube> xNeighborN;
	private LinkedList<Cube> yNeighborP; // y axis neighbor positive side;
	private LinkedList<Cube> yNeighborN;
	private LinkedList<Cube> zNeighborP; // z axis neighbor positive side;
	private LinkedList<Cube> zNeighborN;

	private LinkedList<Point> vertices;
	private LinkedList<Point> topV;
	private LinkedList<Point> bottomV;
	private LinkedList<Point> leftV;
	private LinkedList<Point> rightV;
	private LinkedList<Point> frontV;
	private LinkedList<Point> backV;

	LinkedList<LinkedList<Point>> loops;

	private LinkedList<Point[]> faces = new LinkedList<Point[]>();

	public Cube() {
		A = new Point();
		B = new Point();

		size = 0;
		// children=new LinkedList<Cube>();
		// neighbor=new LinkedList<Cube>();
		xNeighborP = new LinkedList<Cube>();
		xNeighborN = new LinkedList<Cube>();
		yNeighborP = new LinkedList<Cube>();
		yNeighborN = new LinkedList<Cube>();
		zNeighborP = new LinkedList<Cube>();
		zNeighborN = new LinkedList<Cube>();

		vertices = new LinkedList<Point>();
		topV = new LinkedList<Point>();
		bottomV = new LinkedList<Point>();
		leftV = new LinkedList<Point>();
		rightV = new LinkedList<Point>();
		frontV = new LinkedList<Point>();
		backV = new LinkedList<Point>();

		loops = new LinkedList<LinkedList<Point>>();
	}

	public Cube(Point a, Point b) {
		A = new Point(a);
		B = new Point(b);
		vertices = new LinkedList<Point>();

		if (a.getX() > b.getX() || a.getY() > b.getY() || a.getZ() > b.getZ())
			System.out
					.println("cube constructor warning: point A is larger than point B");

		size = B.getX() - A.getX();
		// children=new LinkedList<Cube>();
		// neighbor=new LinkedList<Cube>();
		xNeighborP = new LinkedList<Cube>();
		xNeighborN = new LinkedList<Cube>();
		yNeighborP = new LinkedList<Cube>();
		yNeighborN = new LinkedList<Cube>();
		zNeighborP = new LinkedList<Cube>();
		zNeighborN = new LinkedList<Cube>();

		vertices = new LinkedList<Point>();
		topV = new LinkedList<Point>();
		bottomV = new LinkedList<Point>();
		leftV = new LinkedList<Point>();
		rightV = new LinkedList<Point>();
		frontV = new LinkedList<Point>();
		backV = new LinkedList<Point>();

		loops = new LinkedList<LinkedList<Point>>();
	}

	public LinkedList<Cube> split() {
		LinkedList<Cube> children = new LinkedList<Cube>();
		Point A1 = new Point(A.getX(), (A.getY() + B.getY()) / 2, (A.getZ() + B
				.getZ()) / 2);
		Point B1 = new Point((A.getX() + B.getX()) / 2, B.getY(), B.getZ());
		Point A2 = new Point(A.getX(), (A.getY() + B.getY()) / 2, A.getZ());
		Point B2 = new Point((A.getX() + B.getX()) / 2, B.getY(), (A.getZ() + B
				.getZ()) / 2);
		Point A3 = new Point((A.getX() + B.getX()) / 2,
				(A.getY() + B.getY()) / 2, A.getZ());
		Point B3 = new Point(B.getX(), B.getY(), (A.getZ() + B.getZ()) / 2);
		Point A4 = new Point((A.getX() + B.getX()) / 2,
				(A.getY() + B.getY()) / 2, (A.getZ() + B.getZ()) / 2);
		Point B4 = B;
		Point A5 = new Point(A.getX(), A.getY(), (A.getZ() + B.getZ()) / 2);
		Point B5 = new Point((A.getX() + B.getX()) / 2,
				(A.getY() + B.getY()) / 2, B.getZ());
		Point A6 = A;
		Point B6 = new Point((A.getX() + B.getX()) / 2,
				(A.getY() + B.getY()) / 2, (A.getZ() + B.getZ()) / 2);
		Point A7 = new Point((A.getX() + B.getX()) / 2, A.getY(), A.getZ());
		Point B7 = new Point(B.getX(), (A.getY() + B.getY()) / 2, (A.getZ() + B
				.getZ()) / 2);
		Point A8 = new Point((A.getX() + B.getX()) / 2, A.getY(), (A.getZ() + B
				.getZ()) / 2);
		Point B8 = new Point(B.getX(), (A.getY() + B.getY()) / 2, B.getZ());

		Cube C1 = new Cube(A1, B1);
		Cube C2 = new Cube(A2, B2);
		Cube C3 = new Cube(A3, B3);
		Cube C4 = new Cube(A4, B4);
		Cube C5 = new Cube(A5, B5);
		Cube C6 = new Cube(A6, B6);
		Cube C7 = new Cube(A7, B7);
		Cube C8 = new Cube(A8, B8);

		C1.para = C2.para = C3.para = C4.para = C5.para = C6.para = C7.para = C8.para = para;

		children.add(C1);
		children.add(C2);
		children.add(C3);
		children.add(C4);
		children.add(C5);
		children.add(C6);
		children.add(C7);
		children.add(C8);

		// ///////////////////////////////////
		C1.zNeighborN.add(C2);
		C2.zNeighborP.add(C1);
		C2.xNeighborP.add(C3);
		C3.xNeighborN.add(C2);
		C3.zNeighborP.add(C4);
		C4.zNeighborN.add(C3);
		C4.xNeighborN.add(C1);
		C1.xNeighborP.add(C4);

		C1.yNeighborN.add(C5);
		C5.yNeighborP.add(C1);
		C2.yNeighborN.add(C6);
		C6.yNeighborP.add(C2);
		C3.yNeighborN.add(C7);
		C7.yNeighborP.add(C3);
		C4.yNeighborN.add(C8);
		C8.yNeighborP.add(C4);

		C5.zNeighborN.add(C6);
		C6.zNeighborP.add(C5);
		C6.xNeighborP.add(C7);
		C7.xNeighborN.add(C6);
		C7.zNeighborP.add(C8);
		C8.zNeighborN.add(C7);
		C8.xNeighborN.add(C5);
		C5.xNeighborP.add(C8);

		Interval[] C1X = new Interval[] { C1.getIntervalY(), C1.getIntervalZ() };
		Interval[] C1Y = new Interval[] { C1.getIntervalX(), C1.getIntervalZ() };
		Interval[] C1Z = new Interval[] { C1.getIntervalX(), C1.getIntervalY() };
		Interval[] C2X = new Interval[] { C2.getIntervalY(), C2.getIntervalZ() };
		Interval[] C2Y = new Interval[] { C2.getIntervalX(), C2.getIntervalZ() };
		Interval[] C2Z = new Interval[] { C2.getIntervalX(), C2.getIntervalY() };
		Interval[] C3X = new Interval[] { C3.getIntervalY(), C3.getIntervalZ() };
		Interval[] C3Y = new Interval[] { C3.getIntervalX(), C3.getIntervalZ() };
		Interval[] C3Z = new Interval[] { C3.getIntervalX(), C3.getIntervalY() };
		Interval[] C4X = new Interval[] { C4.getIntervalY(), C4.getIntervalZ() };
		Interval[] C4Y = new Interval[] { C4.getIntervalX(), C4.getIntervalZ() };
		Interval[] C4Z = new Interval[] { C4.getIntervalX(), C4.getIntervalY() };
		Interval[] C5X = new Interval[] { C5.getIntervalY(), C5.getIntervalZ() };
		Interval[] C5Y = new Interval[] { C5.getIntervalX(), C5.getIntervalZ() };
		Interval[] C5Z = new Interval[] { C5.getIntervalX(), C5.getIntervalY() };
		Interval[] C6X = new Interval[] { C6.getIntervalY(), C6.getIntervalZ() };
		Interval[] C6Y = new Interval[] { C6.getIntervalX(), C6.getIntervalZ() };
		Interval[] C6Z = new Interval[] { C6.getIntervalX(), C6.getIntervalY() };
		Interval[] C7X = new Interval[] { C7.getIntervalY(), C7.getIntervalZ() };
		Interval[] C7Y = new Interval[] { C7.getIntervalX(), C7.getIntervalZ() };
		Interval[] C7Z = new Interval[] { C7.getIntervalX(), C7.getIntervalY() };
		Interval[] C8X = new Interval[] { C8.getIntervalY(), C8.getIntervalZ() };
		Interval[] C8Y = new Interval[] { C8.getIntervalX(), C8.getIntervalZ() };
		Interval[] C8Z = new Interval[] { C8.getIntervalX(), C8.getIntervalY() };

		LinkedList<Cube> xp = this.xNeighborP;
		for (int i = 0; i < xp.size(); i++) {
			Cube temp = xp.get(i);
			Interval[] tempX = new Interval[] { temp.getIntervalY(),
					temp.getIntervalZ() };
			temp.xNeighborN.remove(this);
			if (this.faceOverlap(tempX, C3X)) {
				temp.addxNeighborN(C3);
				C3.addxNeighborP(temp);
			}
			if (this.faceOverlap(tempX, C4X)) {
				temp.addxNeighborN(C4);
				C4.addxNeighborP(temp);
			}
			if (this.faceOverlap(tempX, C7X)) {
				temp.addxNeighborN(C7);
				C7.addxNeighborP(temp);
			}
			if (this.faceOverlap(tempX, C8X)) {
				temp.addxNeighborN(C8);
				C8.addxNeighborP(temp);
			}
		}

		LinkedList<Cube> xn = this.xNeighborN;
		for (int i = 0; i < xn.size(); i++) {
			Cube temp = xn.get(i);
			Interval[] tempX = new Interval[] { temp.getIntervalY(),
					temp.getIntervalZ() };
			temp.xNeighborP.remove(this);
			if (this.faceOverlap(tempX, C1X)) {
				temp.addxNeighborP(C1);
				C1.addxNeighborN(temp);
			}
			if (this.faceOverlap(tempX, C2X)) {
				temp.addxNeighborP(C2);
				C2.addxNeighborN(temp);
			}
			if (this.faceOverlap(tempX, C5X)) {
				temp.addxNeighborP(C5);
				C5.addxNeighborN(temp);
			}
			if (this.faceOverlap(tempX, C6X)) {
				temp.addxNeighborP(C6);
				C6.addxNeighborN(temp);
			}
		}

		LinkedList<Cube> yp = this.yNeighborP;
		for (int i = 0; i < yp.size(); i++) {
			Cube temp = yp.get(i);
			Interval[] tempY = new Interval[] { temp.getIntervalX(),
					temp.getIntervalZ() };
			temp.yNeighborN.remove(this);
			if (this.faceOverlap(tempY, C1Y)) {
				temp.addyNeighborN(C1);
				C1.addyNeighborP(temp);
			}
			if (this.faceOverlap(tempY, C2Y)) {
				temp.addyNeighborN(C2);
				C2.addyNeighborP(temp);
			}
			if (this.faceOverlap(tempY, C3Y)) {
				temp.addyNeighborN(C3);
				C3.addyNeighborP(temp);
			}
			if (this.faceOverlap(tempY, C4Y)) {
				temp.addyNeighborN(C4);
				C4.addyNeighborP(temp);
			}
		}

		LinkedList<Cube> yn = this.yNeighborN;
		for (int i = 0; i < yn.size(); i++) {
			Cube temp = yn.get(i);
			Interval[] tempY = new Interval[] { temp.getIntervalX(),
					temp.getIntervalZ() };
			temp.yNeighborP.remove(this);
			if (this.faceOverlap(tempY, C5Y)) {
				temp.addyNeighborP(C5);
				C5.addyNeighborN(temp);
			}
			if (this.faceOverlap(tempY, C6Y)) {
				temp.addyNeighborP(C6);
				C6.addyNeighborN(temp);
			}
			if (this.faceOverlap(tempY, C7Y)) {
				temp.addyNeighborP(C7);
				C7.addyNeighborN(temp);
			}
			if (this.faceOverlap(tempY, C8Y)) {
				temp.addyNeighborP(C8);
				C8.addyNeighborN(temp);
			}
		}

		LinkedList<Cube> zp = this.zNeighborP;
		for (int i = 0; i < zp.size(); i++) {
			Cube temp = zp.get(i);
			Interval[] tempZ = new Interval[] { temp.getIntervalX(),
					temp.getIntervalY() };
			temp.zNeighborN.remove(this);
			if (this.faceOverlap(tempZ, C1Z)) {
				temp.addzNeighborN(C1);
				C1.addzNeighborP(temp);
			}
			if (this.faceOverlap(tempZ, C4Z)) {
				temp.addzNeighborN(C4);
				C4.addzNeighborP(temp);
			}
			if (this.faceOverlap(tempZ, C5Z)) {
				temp.addzNeighborN(C5);
				C5.addzNeighborP(temp);
			}
			if (this.faceOverlap(tempZ, C8Z)) {
				temp.addzNeighborN(C8);
				C8.addzNeighborP(temp);
			}
		}

		LinkedList<Cube> zn = this.zNeighborN;
		for (int i = 0; i < zn.size(); i++) {
			Cube temp = zn.get(i);
			Interval[] tempZ = new Interval[] { temp.getIntervalX(),
					temp.getIntervalY() };
			temp.zNeighborP.remove(this);
			if (this.faceOverlap(tempZ, C2Z)) {
				temp.addzNeighborP(C2);
				C2.addzNeighborN(temp);
			}
			if (this.faceOverlap(tempZ, C3Z)) {
				temp.addzNeighborP(C3);
				C3.addzNeighborN(temp);
			}
			if (this.faceOverlap(tempZ, C6Z)) {
				temp.addzNeighborP(C6);
				C6.addzNeighborN(temp);
			}
			if (this.faceOverlap(tempZ, C7Z)) {
				temp.addzNeighborP(C7);
				C7.addzNeighborN(temp);
			}
		}

		return children;
	}

	public void addV(Poly3 p) {
		getSign(p);
		// left face
		Point p1 = new Point(A);
		Point p2 = new Point(A.getX(), A.getY(), B.getZ());
		Point p3 = new Point(A.getX(), B.getY(), B.getZ());
		Point p4 = new Point(A.getX(), B.getY(), A.getZ());
		if (p.sign(p1) * p.sign(p2) == -1) {
			if (!this.vertexInLine(p1, p2)) {
				Point m = interPoint(p1, p2, p);
				// Point m=midPoint(p1,p2);
				vertices.add(m);
				this.leftV.add(m);
				this.bottomV.add(m);
				for (int i = 0; i < this.getxNeighborN().size(); ++i) {
					Cube temp = this.getxNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getA().getY() == m.getY())
							temp.bottomV.add(m);
					}
					for (int j = 0; j < temp.getyNeighborN().size(); ++j) {
						Cube temp1 = temp.getyNeighborN().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getB().getX() == m.getX())
								temp1.rightV.add(m);
							temp1.topV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getyNeighborN().size(); ++i) {
					Cube temp = this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getA().getX() == m.getX())
							temp.leftV.add(m);
						temp.topV.add(m);
					}
				}
			}
		}
		if (p.sign(p2) * p.sign(p3) == -1) {
			if (!this.vertexInLine(p2, p3)) {
				Point m = interPoint(p2, p3, p);
				// Point m=midPoint(p2,p3);
				vertices.add(m);
				this.leftV.add(m);
				this.backV.add(m);
				for (int i = 0; i < this.getxNeighborN().size(); ++i) {
					Cube temp = this.getxNeighborN().get(i);

					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getB().getZ() == m.getZ())
							temp.backV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborP().size(); ++j) {
						Cube temp1 = temp.getzNeighborP().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getB().getX() == m.getX())
								temp1.rightV.add(m);
							temp1.frontV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborP().size(); ++i) {
					Cube temp = this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getA().getX() == m.getX())
							temp.leftV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		if (p.sign(p3) * p.sign(p4) == -1) {
			if (!this.vertexInLine(p3, p4)) {
				Point m = interPoint(p3, p4, p);
				// Point m=midPoint(p3,p4);
				vertices.add(m);
				this.leftV.add(m);
				this.topV.add(m);
				for (int i = 0; i < this.getxNeighborN().size(); ++i) {
					Cube temp = this.getxNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getB().getY() == m.getY())
							temp.topV.add(m);
					}
					for (int j = 0; j < temp.getyNeighborP().size(); ++j) {
						Cube temp1 = temp.getyNeighborP().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getB().getX() == m.getX())
								temp1.rightV.add(m);
							temp1.bottomV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getyNeighborP().size(); ++i) {
					Cube temp = this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getA().getX() == m.getX())
							temp.leftV.add(m);
						temp.bottomV.add(m);
					}
				}
			}
		}
		if (p.sign(p4) * p.sign(p1) == -1) {
			if (!this.vertexInLine(p4, p1)) {
				Point m = interPoint(p4, p1, p);
				// Point m=midPoint(p4,p1);

				vertices.add(m);
				this.leftV.add(m);
				this.frontV.add(m);
				for (int i = 0; i < this.getxNeighborN().size(); ++i) {
					Cube temp = this.getxNeighborN().get(i);

					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.rightV.add(m);
						if (temp.getA().getZ() == m.getZ())
							temp.frontV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborN().size(); ++j) {
						Cube temp1 = temp.getzNeighborN().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getB().getX() == m.getX())
								temp1.rightV.add(m);
							temp1.backV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborN().size(); ++i) {
					Cube temp = this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getA().getX() == m.getX())
							temp.leftV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
		// right face
		Point p1b = new Point(B.getX(), A.getY(), A.getZ());
		Point p2b = new Point(B.getX(), A.getY(), B.getZ());
		Point p3b = new Point(B);
		Point p4b = new Point(B.getX(), B.getY(), A.getZ());
		if (p.sign(p1b) * p.sign(p2b) == -1) {
			if (!this.vertexInLine(p1b, p2b)) {
				Point m = interPoint(p1b, p2b, p);
				// Point m=midPoint(p1b,p2b);
				vertices.add(m);
				this.rightV.add(m);
				this.bottomV.add(m);
				for (int i = 0; i < this.getxNeighborP().size(); ++i) {
					Cube temp = this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getA().getY() == m.getY())
							temp.bottomV.add(m);
					}
					for (int j = 0; j < temp.getyNeighborN().size(); ++j) {
						Cube temp1 = temp.getyNeighborN().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getA().getX() == m.getX())
								temp1.leftV.add(m);
							temp1.topV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getyNeighborN().size(); ++i) {
					Cube temp = this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getB().getX() == m.getX())
							temp.rightV.add(m);
						temp.topV.add(m);
					}
				}
			}
		}
		if (p.sign(p2b) * p.sign(p3b) == -1) {
			if (!this.vertexInLine(p2b, p3b)) {
				Point m = interPoint(p2b, p3b, p);
				// Point m=midPoint(p2b,p3b);
				vertices.add(m);
				this.rightV.add(m);
				this.backV.add(m);
				for (int i = 0; i < this.getxNeighborP().size(); ++i) {
					Cube temp = this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getB().getZ() == m.getZ())
							temp.backV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborP().size(); ++j) {
						Cube temp1 = temp.getzNeighborP().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getA().getX() == m.getX())
								temp1.leftV.add(m);
							temp1.frontV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborP().size(); ++i) {
					Cube temp = this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getB().getX() == m.getX())
							temp.rightV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		if (p.sign(p3b) * p.sign(p4b) == -1) {
			if (!this.vertexInLine(p3b, p4b)) {
				Point m = interPoint(p3b, p4b, p);
				// Point m=midPoint(p3b,p4b);
				// if (m.getX()==-0.78125 && m.getY()==1.5625 &&
				// m.getZ()==1.953125){
				// this.print();
				// this.printVertices();
				// }
				vertices.add(m);
				this.rightV.add(m);
				this.topV.add(m);
				for (int i = 0; i < this.getxNeighborP().size(); ++i) {
					Cube temp = this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getB().getY() == m.getY())
							temp.topV.add(m);
					}
					for (int j = 0; j < temp.getyNeighborP().size(); ++j) {
						Cube temp1 = temp.getyNeighborP().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getA().getX() == m.getX())
								temp1.leftV.add(m);
							temp1.bottomV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getyNeighborP().size(); ++i) {
					Cube temp = this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getB().getX() == m.getX())
							temp.rightV.add(m);
						temp.bottomV.add(m);
					}
				}
			}
		}
		if (p.sign(p4b) * p.sign(p1b) == -1) {
			if (!this.vertexInLine(p4b, p1b)) {
				Point m = interPoint(p4b, p1b, p);
				// Point m=midPoint(p4b,p1b);
				vertices.add(m);
				this.rightV.add(m);
				this.frontV.add(m);
				for (int i = 0; i < this.getxNeighborP().size(); ++i) {
					Cube temp = this.getxNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.leftV.add(m);
						if (temp.getA().getZ() == m.getZ())
							temp.frontV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborN().size(); ++j) {
						Cube temp1 = temp.getzNeighborN().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getA().getX() == m.getX())
								temp1.leftV.add(m);
							temp1.backV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborN().size(); ++i) {
					Cube temp = this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getB().getX() == m.getX())
							temp.rightV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
		// central four edges
		if (p.sign(p1) * p.sign(p1b) == -1) {
			if (!this.vertexInLine(p1, p1b)) {
				Point m = interPoint(p1, p1b, p);
				// Point m=midPoint(p1,p1b);
				// if (m.equal(point2)){
				// System.out.println("point2");
				// point2=m;
				// }
				// if (m.equal(point4)){
				// System.out.println("point4");
				// point4=m;
				// }

				vertices.add(m);
				this.bottomV.add(m);
				this.frontV.add(m);
				for (int i = 0; i < this.getyNeighborN().size(); ++i) {
					Cube temp = this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.topV.add(m);
						if (temp.getA().getZ() == m.getZ())
							temp.frontV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborN().size(); ++j) {
						Cube temp1 = temp.getzNeighborN().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getB().getY() == m.getY())
								temp1.topV.add(m);
							temp1.backV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborN().size(); ++i) {
					Cube temp = this.getzNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getA().getY() == m.getY())
							temp.bottomV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
		if (p.sign(p2) * p.sign(p2b) == -1) {
			if (!this.vertexInLine(p2, p2b)) {
				Point m = interPoint(p2, p2b, p);
				// Point m=midPoint(p2,p2b);
				vertices.add(m);
				this.backV.add(m);
				this.bottomV.add(m);
				for (int i = 0; i < this.getyNeighborN().size(); ++i) {
					Cube temp = this.getyNeighborN().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.topV.add(m);
						if (temp.getB().getZ() == m.getZ())
							temp.backV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborP().size(); ++j) {
						Cube temp1 = temp.getzNeighborP().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							temp1.frontV.add(m);
							if (temp1.getB().getY() == m.getY())
								temp1.topV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborP().size(); ++i) {
					Cube temp = this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getA().getY() == m.getY())
							temp.bottomV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		if (p.sign(p3) * p.sign(p3b) == -1) {
			if (!this.vertexInLine(p3, p3b)) {
				Point m = interPoint(p3, p3b, p);
				// Point m=midPoint(p3,p3b);
				vertices.add(m);
				this.topV.add(m);
				this.backV.add(m);
				for (int i = 0; i < this.getyNeighborP().size(); ++i) {
					Cube temp = this.getyNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.bottomV.add(m);
						if (temp.getB().getZ() == m.getZ())
							temp.backV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborP().size(); ++j) {
						Cube temp1 = temp.getzNeighborP().get(j);
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							if (temp1.getA().getY() == m.getY())
								temp1.bottomV.add(m);
							temp1.frontV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborP().size(); ++i) {
					Cube temp = this.getzNeighborP().get(i);
					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getB().getY() == m.getY())
							temp.topV.add(m);
						temp.frontV.add(m);
					}
				}
			}
		}
		if (p.sign(p4) * p.sign(p4b) == -1) {
			if (!this.vertexInLine(p4, p4b)) {
				Point m = interPoint(p4, p4b, p);
				// Point m=midPoint(p4,p4b);
				vertices.add(m);
				this.frontV.add(m);
				this.topV.add(m);
				for (int i = 0; i < this.getyNeighborP().size(); ++i) {
					Cube temp = this.getyNeighborP().get(i);

					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						temp.bottomV.add(m);
						if (temp.getA().getZ() == m.getZ())
							temp.frontV.add(m);
					}
					for (int j = 0; j < temp.getzNeighborN().size(); ++j) {
						Cube temp1 = temp.getzNeighborN().get(j);
						// if (temp1.getA().equal(new Point(-2.34375, -1.5625,
						// -1.5625))){
						// System.out.println("***************************************");
						// temp.print();
						// temp1.print();
						// System.out.println("***************************************");
						// }
						if (temp1.containPoint(m)
								&& !temp1.vertices.contains(m)) {
							temp1.vertices.add(m);
							temp1.backV.add(m);
							if (temp1.getA().getY() == m.getY())
								temp1.bottomV.add(m);
						}
					}
				}
				for (int i = 0; i < this.getzNeighborN().size(); ++i) {
					Cube temp = this.getzNeighborN().get(i);

					if (temp.containPoint(m) && !temp.vertices.contains(m)) {
						temp.vertices.add(m);
						if (temp.getB().getY() == m.getY())
							temp.topV.add(m);
						temp.backV.add(m);
					}
				}
			}
		}
	}

	public void linkCxyz(Poly3 p, Poly3 px, Poly3 py, Poly3 pz)
			throws PrintException {
		if (para == 0) {
			linkedFace[2] = linkedFace[3] = linkedFace[4] = linkedFace[5] = true;
			// top
			if (this.yNeighborP.size() == 0
					|| this.yNeighborP.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, topV);
			}

			// bottom
			if (this.yNeighborN.size() == 0
					|| this.yNeighborN.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, bottomV);
			}

			// front
			if (this.zNeighborN.size() == 0
					|| this.zNeighborN.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, frontV);
			}

			// back
			if (this.zNeighborP.size() == 0
					|| this.zNeighborP.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, backV);
			}

			// ///////////////////////////////////////////////////////////////

			// left
			if ((this.xNeighborN.size() == 0 && leftV.size() < 4)
					|| (this.xNeighborN.size() > 0
							&& this.xNeighborN.get(0).getSize() >= this
									.getSize() && (leftV.size() < 4 || this.xNeighborN
							.get(0).para != 0))) {
				linkFacePara(p, px, py, pz, leftV);
				linkedFace[0] = true;
				++linkedFaces;
			} else if (this.xNeighborN.size() > 0
					&& this.xNeighborN.get(0).getSize() < this.getSize()) {
				linkedFace[0] = true;
				++linkedFaces;
			}

			// right
			if ((this.xNeighborP.size() == 0 && rightV.size() < 4)
					|| (this.xNeighborP.size() > 0
							&& this.xNeighborP.get(0).getSize() >= this
									.getSize() && (rightV.size() < 4 || this.xNeighborP
							.get(0).para != 0))) {
				linkFacePara(p, px, py, pz, rightV);
				linkedFace[1] = true;
				++linkedFaces;
			} else if (this.xNeighborP.size() > 0
					&& this.xNeighborP.get(0).getSize() < this.getSize()) {
				linkedFace[1] = true;
				++linkedFaces;
			}
		}

		if (para == 1) {
			linkedFace[0] = linkedFace[1] = linkedFace[4] = linkedFace[5] = true;
			// left
			if (this.xNeighborN.size() == 0
					|| this.xNeighborN.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, leftV);
			}

			// right
			if (this.xNeighborP.size() == 0
					|| this.xNeighborP.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, rightV);
			}

			// front
			if (this.zNeighborN.size() == 0
					|| this.zNeighborN.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, frontV);
			}

			// back
			if (this.zNeighborP.size() == 0
					|| this.zNeighborP.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, backV);
			}

			// ///////////////////////////////////////////////////////////////

			// top
			if ((this.yNeighborP.size() == 0 && topV.size() < 4)
					|| (this.yNeighborP.size() > 0
							&& this.yNeighborP.get(0).getSize() >= this
									.getSize() && (topV.size() < 4 || this.yNeighborP
							.get(0).para != 1))) {
				linkFacePara(p, px, py, pz, topV);
				linkedFace[2] = true;
				++linkedFaces;
			} else if (this.yNeighborP.size() > 0
					&& this.yNeighborP.get(0).getSize() < this.getSize()) {
				linkedFace[2] = true;
				++linkedFaces;
			}
			// bottom
			if ((this.yNeighborN.size() == 0 && bottomV.size() < 4)
					|| (this.yNeighborN.size() > 0
							&& this.yNeighborN.get(0).getSize() >= this
									.getSize() && (bottomV.size() < 4 || this.yNeighborN
							.get(0).para != 1))) {
				linkFacePara(p, px, py, pz, bottomV);
				linkedFace[3] = true;
				++linkedFaces;
			} else if (this.yNeighborN.size() > 0
					&& this.yNeighborN.get(0).getSize() < this.getSize()) {
				linkedFace[3] = true;
				++linkedFaces;
			}
		}

		if (para == 2) {
			linkedFace[0] = linkedFace[1] = linkedFace[2] = linkedFace[3] = true;
			// left
			if (this.xNeighborN.size() == 0
					|| this.xNeighborN.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, leftV);
			}

			// right
			if (this.xNeighborP.size() == 0
					|| this.xNeighborP.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, rightV);
			}

			// top
			if (this.yNeighborP.size() == 0
					|| this.yNeighborP.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, topV);
			}

			// bottom
			if (this.yNeighborN.size() == 0
					|| this.yNeighborN.get(0).getSize() >= this.getSize()) {
				linkFacePara(p, px, py, pz, bottomV);
			}

			// ///////////////////////////////////////////////////////////////

			// front
			if ((this.zNeighborN.size() == 0 && frontV.size() < 4)
					|| (this.zNeighborN.size() > 0
							&& this.zNeighborN.get(0).getSize() >= this
									.getSize() && (frontV.size() < 4 || this.zNeighborN
							.get(0).para != 2))) {
				linkFacePara(p, px, py, pz, frontV);
				linkedFace[4] = true;
				++linkedFaces;
			} else if (this.zNeighborN.size() > 0
					&& this.zNeighborN.get(0).getSize() < this.getSize()) {
				linkedFace[4] = true;
				++linkedFaces;
			}

			// back
			if ((this.zNeighborP.size() == 0 && backV.size() < 4)
					|| (this.zNeighborP.size() > 0
							&& this.zNeighborP.get(0).getSize() >= this
									.getSize() && (backV.size() < 4 || this.zNeighborP
							.get(0).para != 2))) {
				linkFacePara(p, px, py, pz, backV);
				linkedFace[5] = true;
				++linkedFaces;
			} else if (this.zNeighborP.size() > 0
					&& this.zNeighborP.get(0).getSize() < this.getSize()) {
				linkedFace[5] = true;
				++linkedFaces;
			}
		}
	}

	public void linkFacePara(Poly3 p, Poly3 px, Poly3 py, Poly3 pz,
			LinkedList<Point> vList) throws PrintException {
		if (vList.size() == 0) {

		} else if (vList.size() == 2) {
			vList.get(0).addLink(vList.get(1));
			vList.get(1).addLink(vList.get(0));
		} else if (vList.size() == 4) {
			Point s1 = new Point();
			Point s2 = new Point();
			Point d1 = new Point();
			Point d2 = new Point();
			for (int i = 0; i < 3; ++i)
				for (int j = i + 1; j < 4; ++j) {
					if (sameLine(vList.get(i), vList.get(j))) {
						s1 = vList.get(i);
						s2 = vList.get(j);
						for (int s = 0; s < 3; ++s) {
							if (s != i && s != j) {
								d1 = vList.get(s);
								for (int t = s + 1; t < 4; ++t) {
									if ((t != i && t != j)) {
										d2 = vList.get(t);
										break;
									}
								}
								break;
							}
						}
					}
				}
			if ((distance(d1, s1) + distance(d2, s2)) > (distance(d1, s2) + distance(
					d2, s1))) {
				d1.addLink(s2);
				s2.addLink(d1);
				d2.addLink(s1);
				s1.addLink(d2);
			} else {
				d1.addLink(s1);
				s1.addLink(d1);
				d2.addLink(s2);
				s2.addLink(d2);
			}
		} else {
			throw (new PrintException(
					"error linkFaceCxyz: vertices # != 0, 2, 4"));
		}
	}

	public void link(Poly3 p, Poly3 px, Poly3 py, Poly3 pz) {
		// left
		// if (this.xNeighborN.size()>0)
		if (this.xNeighborN.size() == 0
				|| this.xNeighborN.get(0).getSize() >= this.getSize()) {
			linkFace(p, px, py, pz, leftV);
		}

		// right
		// if (this.xNeighborP.size()>0)
		if (this.xNeighborP.size() == 0
				|| this.xNeighborP.get(0).getSize() >= this.getSize()) {
			linkFace(p, px, py, pz, rightV);
		}

		// top
		// if (this.yNeighborP.size()>0)
		if (this.yNeighborP.size() == 0
				|| this.yNeighborP.get(0).getSize() >= this.getSize()) {
			linkFace(p, px, py, pz, topV);
		}

		// bottom
		// if (this.yNeighborN.size()>0)
		if (this.yNeighborN.size() == 0
				|| this.yNeighborN.get(0).getSize() >= this.getSize()) {
			linkFace(p, px, py, pz, bottomV);
		}

		// front
		// if (this.zNeighborN.size()>0)
		if (this.zNeighborN.size() == 0
				|| this.zNeighborN.get(0).getSize() >= this.getSize()) {
			linkFace(p, px, py, pz, frontV);
		}

		// back
		// if (this.zNeighborP.size()>0)
		if (this.zNeighborP.size() == 0
				|| this.zNeighborP.get(0).getSize() >= this.getSize()) {
			linkFace(p, px, py, pz, backV);
		}
	}

	public void linkFace(Poly3 p, Poly3 px, Poly3 py, Poly3 pz,
			LinkedList<Point> vList) {
		if (vList.size() == 0) {

		} else if (vList.size() == 2) {
			vList.get(0).addLink(vList.get(1));
			vList.get(1).addLink(vList.get(0));
		} else if ((vList.size() == 4)
				&& (new Cube(A, new Point(A.getX(), B.getY(), B.getZ())).Cy(p,
						py) || new Cube(A, new Point(A.getX(), B.getY(), B
						.getZ())).Cz(p, pz))) {
			Point s1 = new Point();
			Point s2 = new Point();
			Point d1 = new Point();
			Point d2 = new Point();
			for (int i = 0; i < 3; ++i)
				for (int j = i + 1; j < 4; ++j) {
					if (sameLine(vList.get(i), vList.get(j))) {
						s1 = vList.get(i);
						s2 = vList.get(j);
						for (int s = 0; s < 3; ++s) {
							if (s != i && s != j) {
								d1 = vList.get(s);
								for (int t = s + 1; t < 4; ++t) {
									if ((t != i && t != j)) {
										d2 = vList.get(t);
										break;
									}
								}
								break;
							}
						}
					}
				}
			if ((distance(d1, s1) + distance(d2, s2)) > (distance(d1, s2) + distance(
					d2, s1))) {
				d1.addLink(s2);
				s2.addLink(d1);
				d2.addLink(s1);
				s1.addLink(d2);
			} else {
				d1.addLink(s1);
				s1.addLink(d1);
				d2.addLink(s2);
				s2.addLink(d2);
			}
		} else {
			if (vList.size() % 2 != 0)
				System.out.println("left with wrong number of vertices.");
			else {
				PriorityQueue<Point> Q = new PriorityQueue<Point>(12,
						new verticesComparator());
				for (int i = 0; i < vList.size(); ++i)
					Q.add(vList.get(i));
				while (!Q.isEmpty()) {
					Point p1 = Q.poll();
					Point p2 = Q.poll();
					p1.addLink(p2);
					p2.addLink(p1);

				}
			}
		}
	}

	@SuppressWarnings("unchecked")
	public void linkFace5() {
		LinkedList<Point> unlinked;
		if (!linkedFace[0]) {
			linkedFace[0] = true;
			++linkedFaces;
			unlinked = leftV;
			if (this.getxNeighborN().get(0).getSize() == this.getSize())
				if (this.getxNeighborN().get(0).linkedFace[1] == false) {
					this.getxNeighborN().get(0).linkedFace[1] = true;
					++this.getxNeighborN().get(0).linkedFaces;
				}
		} else if (!linkedFace[1]) {
			linkedFace[1] = true;
			++linkedFaces;
			unlinked = rightV;
			if (this.getxNeighborP().get(0).getSize() == this.getSize())
				if (this.getxNeighborP().get(0).linkedFace[0] == false) {
					this.getxNeighborP().get(0).linkedFace[0] = true;
					++this.getxNeighborP().get(0).linkedFaces;
				}
		} else if (!linkedFace[2]) {
			linkedFace[2] = true;
			++linkedFaces;
			unlinked = topV;
			if (this.getyNeighborP().get(0).getSize() == this.getSize())
				if (this.getyNeighborP().get(0).linkedFace[3] == false) {
					this.getyNeighborP().get(0).linkedFace[3] = true;
					++this.getyNeighborP().get(0).linkedFaces;
				}
		} else if (!linkedFace[3]) {
			linkedFace[3] = true;
			++linkedFaces;
			unlinked = bottomV;
			if (this.getyNeighborN().get(0).getSize() == this.getSize())
				if (this.getyNeighborN().get(0).linkedFace[2] == false) {
					this.getyNeighborN().get(0).linkedFace[2] = true;
					++this.getyNeighborN().get(0).linkedFaces;
				}
		} else if (!linkedFace[4]) {
			linkedFace[4] = true;
			++linkedFaces;
			unlinked = frontV;
			if (this.getzNeighborN().get(0).getSize() == this.getSize())
				if (this.getzNeighborN().get(0).linkedFace[5] == false) {
					this.getzNeighborN().get(0).linkedFace[5] = true;
					++this.getzNeighborN().get(0).linkedFaces;
				}
		} else {
			linkedFace[5] = true;
			++linkedFaces;
			unlinked = backV;
			if (this.getzNeighborP().get(0).getSize() == this.getSize())
				if (this.getzNeighborP().get(0).linkedFace[4] == false) {
					this.getzNeighborP().get(0).linkedFace[4] = true;
					++this.getzNeighborP().get(0).linkedFaces;
				}
		}
		LinkedList<Point> tempV = (LinkedList<Point>) vertices.clone();
		while (!unlinked.isEmpty()) {
			Point p = unlinked.pop();
			tempV.remove(p);
			Point tempP = p;
			while (!unlinked.contains(tempP)) {
				for (int i = 0; i < tempV.size(); ++i) {
					if (tempP.getLinks().contains(tempV.get(i))) {
						tempP = tempV.get(i);
						tempV.remove(i);
						break;
					}
				}
			}
			p.addLink(tempP);
			tempP.addLink(p);
			unlinked.remove(tempP);
		}
	}

	public void findLoop() {
		while (vertices.size() > 0) {
			LinkedList<Point> loop = new LinkedList<Point>();
			Point p0 = this.vertices.poll();
			Point p = p0;
			loop.add(p);
			for (int i = 0; i < vertices.size(); ++i) {
				if (p.getLinks().contains(vertices.get(i))) {
					p = vertices.get(i);
					vertices.remove(i);
					loop.add(p);
					break;
				}
			}
			for (int i = 0; i < vertices.size(); ++i)
				if (p.getLinks().contains(vertices.get(i))) {
					p = vertices.get(i);
					vertices.remove(i);
					loop.add(p);
					break;
				}

			while (!p.getLinks().contains(p0)) {
				for (int i = 0; i < vertices.size(); ++i) {
					if (p.getLinks().contains(vertices.get(i))) {
						p = vertices.get(i);
						vertices.remove(i);
						loop.add(p);
						break;
					}
				}
			}
			loops.add(loop);
		}
	}

	public void triangulate(HashMap<Point, Integer> v) {
		if (loops.size() == 0) {

		} else {
			for (int i = 0; i < loops.size(); ++i) {
				LinkedList<Point> loop = loops.get(i);
				Point p = this.meanPoint(loop);
				v.put(p, 0);
				if (counterClock(loop)) {
					for (int j = 0; j < loop.size() - 1; ++j) {
						Point[] f = new Point[3];
						f[0] = p;
						f[1] = loop.get(j);
						f[2] = loop.get(j + 1);
						faces.add(f);
					}
					Point[] f = new Point[3];
					f[0] = p;
					f[1] = loop.get(loop.size() - 1);
					f[2] = loop.get(0);
					faces.add(f);
				} else {
					for (int j = loop.size() - 1; j > 0; --j) {
						Point[] f = new Point[3];
						f[0] = p;
						f[1] = loop.get(j);
						f[2] = loop.get(j - 1);
						faces.add(f);
					}
					Point[] f = new Point[3];
					f[0] = p;
					f[1] = loop.get(0);
					f[2] = loop.get(loop.size() - 1);
					faces.add(f);
				}
			}
		}
	}

	public Point meanPoint(LinkedList<Point> loop) {
		double x = 0, y = 0, z = 0;
		Iterator<Point> iter = loop.iterator();
		while (iter.hasNext()) {
			Point temp = iter.next();
			x += temp.getX();
			y += temp.getY();
			z += temp.getZ();
		}
		x /= loop.size();
		y /= loop.size();
		z /= loop.size();
		return new Point(x, y, z);
	}

	public void triangulate1() {
		// loop.size() can be 0, 1, 2
		double dis = 10000;
		if (loops.size() == 0) {

		} else if (loops.size() == 1) {// loop.size()=1
			LinkedList<Point> loop = loops.get(0);
			if (counterClock(loop))
				for (int j = 1; j < loop.size() - 1; ++j) {
					Point[] f = new Point[3];
					f[0] = loop.get(0);
					f[1] = loop.get(j);
					f[2] = loop.get(j + 1);
					faces.add(f);
				}
			else
				for (int j = loop.size() - 1; j > 1; --j) {
					Point[] f = new Point[3];
					f[0] = loop.get(0);
					f[1] = loop.get(j);
					f[2] = loop.get(j - 1);
					faces.add(f);
				}
		} else if (loops.size() == 2) {
			if (loops.get(0).size() == 4 && inFace(loops.get(0))) {
				boolean positive, cc;
				Point p = loops.get(0).get(0);
				if (p.getX() == A.getX() || p.getY() == A.getY()
						|| p.getZ() == A.getZ())
					positive = (pc[0] > 0);
				else
					positive = (pc[4] > 0);

				cc = (positive && sameFaceCounterClock(loops.get(0)))
						|| ((!positive) && (!sameFaceCounterClock(loops.get(0))));

				int s = loops.get(1).size();
				int i1 = 0;
				int i2 = 0;
				for (int i = 0; i < 4; ++i)
					for (int j = 0; j < s; ++j) {
						if (dis > distance(loops.get(0).get(i), loops.get(1)
								.get(j))) {
							i1 = i;
							i2 = j;
						}
					}
				if (cc) {
					for (int t = 0; t < s - 3; ++t) { // s-4+1
						Point[] f = new Point[3];
						f[0] = loops.get(0).get(i1);
						f[1] = loops.get(1).get(i2);
						f[2] = loops.get(1).get((i2 + 1) % s);
						faces.add(f);
						i2 = (i2 + 1) % s;
					}
					for (int i = 0; i < 4; ++i) {
						Point[] f = new Point[3];
						f[0] = loops.get(0).get((i1 + i) % 4);
						f[1] = loops.get(1).get((i2 + i) % s);
						f[2] = loops.get(1).get((i2 + i + 1) % s);
						faces.add(f);
						Point[] g = new Point[3];
						g[0] = loops.get(0).get((i1 + i) % 4);
						g[1] = loops.get(1).get((i2 + i + 1) % s);
						g[2] = loops.get(0).get((i2 + i + 1) % 4);
						faces.add(g);
					}
				} else {
					for (int t = 0; t < s - 3; ++t) { // s-4+1
						Point[] f = new Point[3];
						f[0] = loops.get(0).get(i1);
						f[2] = loops.get(1).get(i2);
						f[1] = loops.get(1).get((i2 + 1) % s);
						faces.add(f);
						i2 = (i2 + 1) % s;
					}
					for (int i = 0; i < 4; ++i) {
						Point[] f = new Point[3];
						f[0] = loops.get(0).get((i1 + i) % 4);
						f[2] = loops.get(1).get((i2 + i) % 4);
						f[1] = loops.get(1).get((i2 + i + 1) % 4);
						faces.add(f);
						Point[] g = new Point[3];
						g[0] = loops.get(0).get((i1 + i) % 4);
						g[2] = loops.get(1).get((i2 + i + 1) % 4);
						g[1] = loops.get(0).get((i2 + i + 1) % 4);
						faces.add(g);
					}
				}
			} else if (loops.get(1).size() == 4 && inFace(loops.get(1))) {
				boolean positive, cc;
				Point p = loops.get(1).get(0);
				if (p.getX() == A.getX() || p.getY() == A.getY()
						|| p.getZ() == A.getZ())
					positive = (pc[0] > 0);
				else
					positive = (pc[4] > 0);

				cc = (positive && sameFaceCounterClock(loops.get(1)))
						|| ((!positive) && (!sameFaceCounterClock(loops.get(1))));

				int s = loops.get(0).size();
				int i1 = 0;
				int i2 = 0;
				for (int i = 0; i < 4; ++i)
					for (int j = 0; j < s; ++j) {
						if (dis > distance(loops.get(1).get(i), loops.get(0)
								.get(j))) {
							i1 = i;
							i2 = j;
						}
					}
				if (cc) {
					for (int t = 0; t < s - 3; ++t) { // s-4+1
						Point[] f = new Point[3];
						f[0] = loops.get(1).get(i1);
						f[1] = loops.get(0).get(i2);
						f[2] = loops.get(0).get((i2 + 1) % s);
						faces.add(f);
						i2 = (i2 + 1) % s;
					}
					for (int i = 0; i < 4; ++i) {
						Point[] f = new Point[3];
						f[0] = loops.get(1).get((i1 + i) % 4);
						f[1] = loops.get(0).get((i2 + i) % s);
						f[2] = loops.get(0).get((i2 + i + 1) % s);
						faces.add(f);
						Point[] g = new Point[3];
						g[0] = loops.get(1).get((i1 + i) % 4);
						g[1] = loops.get(0).get((i2 + i + 1) % s);
						g[2] = loops.get(1).get((i2 + i + 1) % 4);
						faces.add(g);
					}
				} else {
					for (int t = 0; t < s - 3; ++t) { // s-4+1
						Point[] f = new Point[3];
						f[0] = loops.get(1).get(i1);
						f[2] = loops.get(0).get(i2);
						f[1] = loops.get(0).get((i2 + 1) % s);
						faces.add(f);
						i2 = (i2 + 1) % s;
					}
					for (int i = 0; i < 4; ++i) {
						Point[] f = new Point[3];
						f[0] = loops.get(1).get((i1 + i) % 4);
						f[2] = loops.get(0).get((i2 + i) % 4);
						f[1] = loops.get(0).get((i2 + i + 1) % 4);
						faces.add(f);
						Point[] g = new Point[3];
						g[0] = loops.get(1).get((i1 + i) % 4);
						g[2] = loops.get(0).get((i2 + i + 1) % 4);
						g[1] = loops.get(1).get((i2 + i + 1) % 4);
						faces.add(g);
					}
				}
			} else {
				for (int i = 0; i < loops.size(); ++i) {
					LinkedList<Point> loop = loops.get(i);
					if (counterClock(loop))
						for (int j = 1; j < loop.size() - 1; ++j) {
							Point[] f = new Point[3];
							f[0] = loop.get(0);
							f[1] = loop.get(j);
							f[2] = loop.get(j + 1);
							faces.add(f);
						}
					else
						for (int j = loop.size() - 1; j > 1; --j) {
							Point[] f = new Point[3];
							f[0] = loop.get(0);
							f[1] = loop.get(j);
							f[2] = loop.get(j - 1);
							faces.add(f);
						}
				}
			}
		} else {
			System.out.println("loop size >2");
		}

	}

	public boolean sameFaceCounterClock(LinkedList<Point> loop) {
		boolean cc = true;
		Point p1 = loop.get(0);
		Point p2 = loop.get(1);
		Point p3 = loop.get(2); // p1->p2->p3-->p1 => (p1-p2)x(p3-p2)=out box
		// direction

		double[] a = new double[] { p1.getX() - p2.getX(),
				p1.getY() - p2.getY(), p1.getZ() - p2.getZ() };
		double[] b = new double[] { p3.getX() - p2.getX(),
				p3.getY() - p2.getY(), p3.getZ() - p2.getZ() };
		double[] c = crossProduct(a, b);

		// left
		if (p1.getX() == A.getX()) {
			cc = (c[0] < 0 && c[1] == 0 && c[2] == 0);
		}
		// right
		else if (p1.getX() == B.getX()) {
			cc = (c[0] > 0 && c[1] == 0 && c[2] == 0);
		}
		// bottom
		else if (p1.getY() == A.getY()) {
			cc = (c[0] == 0 && c[1] < 0 && c[2] == 0);
		}
		// top
		else if (p1.getY() == B.getY()) {
			cc = (c[0] == 0 && c[1] > 0 && c[2] == 0);
		}
		// front
		else if (p1.getZ() == A.getZ()) {
			cc = (c[0] == 0 && c[1] == 0 && c[2] < 0);
		}
		// back
		else if (p1.getZ() == B.getZ()) {
			cc = (c[0] == 0 && c[1] == 0 && c[2] > 0);
		}

		return cc;
	}

	public boolean counterClock(LinkedList<Point> loop) {
		boolean cc = true;
		int adjust = 1;
		Iterator<Point> iter = loop.iterator();
		Point p1 = null, p2 = null, temp = null;
		while (iter.hasNext()) {
			p1 = iter.next();
			boolean found = false;
			for (int i = 0; i < 8; ++i)
				if (pc[i] < 0 && this.sameLine(corners[i], p1)) {
					if (iter.hasNext())
						p2 = iter.next();
					else
						p2 = loop.getFirst();
					temp = corners[i];
					found = true;
					break;
				}
			if (found)
				break;
		}
		if (temp == null) {
			adjust = -1;
			Iterator<Point> iter1 = loop.iterator();
			while (iter1.hasNext()) {
				p1 = iter1.next();
				boolean found = false;
				for (int i = 0; i < 8; ++i)
					if (this.sameLine(corners[i], p1)) {
						if (temp == null) {
							temp = corners[i];
							p2 = iter1.next();
							found = true;
						} else {
							if (distance(temp, p1) > distance(corners[i], p1))
								temp = corners[i];
						}
					}
				if (found)
					break;
			}
			// if (this.equal(new Cube(new Point(5.125, -0.125, -0.125), new
			// Point( 5.3125, 0.0625, 0.0625)))){
			// p1.print();
			// p2.print();
			// temp.print();
			// }
		}
		
		if ((para==0 && p1.getX()==p2.getX()) || (para==1 && p1.getY()==p2.getY()) || (para==2 && p1.getZ()==p2.getZ())){
			int i=loop.indexOf(p1);
			if (i>0){
				p2=p1;
				p1=loop.get(i-1);
			}
			else{
				p2=p1;
				p1=loop.getLast();
			}
		}
		
		// else{
		if (p1.getX() == p2.getX() && p1.getX() == A.getX()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] * adjust < 0 && c[1] == 0 && c[2] == 0);
		} else if (p1.getX() == p2.getX() && p1.getX() == B.getX()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] * adjust > 0 && c[1] == 0 && c[2] == 0);
		} else if (p1.getY() == p2.getY() && p1.getY() == A.getY()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] * adjust < 0 && c[2] == 0);
		} else if (p1.getY() == p2.getY() && p1.getY() == B.getY()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] * adjust > 0 && c[2] == 0);
		} else if (p1.getZ() == p2.getZ() && p1.getZ() == A.getZ()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] == 0 && c[2] * adjust < 0);
		} else if (p1.getZ() == p2.getZ() && p1.getZ() == B.getZ()) {
			double[] a = new double[] { p2.getX() - temp.getX(),
					p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
			double[] b = new double[] { p1.getX() - temp.getX(),
					p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
			double[] c = crossProduct(a, b);
			cc = (c[0] == 0 && c[1] == 0 && c[2] * adjust > 0);
		} else {
			System.out.println("error!!!!!");
		}
		// }
		return cc;
	}

	// public boolean counterClock(LinkedList<Point> loop) {
	// boolean cc = true;
	// Point p1 = loop.get(0);
	// Point p2 = loop.get(1);
	// Point temp = null;
	// // left
	// if (p1.getX() == p2.getX() && p1.getX() == A.getX()) {
	// for (int i = 0; i < 4; ++i) {
	// if (pc[i] < 0) {
	// temp = corners[i]; // p1->p2->temp->p1 =>
	// // (p2-temp)x(p1-temp)=(-1,0,0)
	// break;
	// }
	// }
	// if (temp == null)
	// System.out.println("temp=null error");
	// else {
	// double[] a = new double[] { p2.getX() - temp.getX(),
	// p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
	// double[] b = new double[] { p1.getX() - temp.getX(),
	// p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
	// double[] c = crossProduct(a, b);
	// cc = (c[0] < 0 && c[1] == 0 && c[2] == 0);
	// }
	// }
	// // right
	// else if (p1.getX() == p2.getX() && p1.getX() == B.getX()) {
	// for (int i = 4; i < 8; ++i) {
	// if (pc[i] < 0) {
	// temp = corners[i]; // p1->p2->temp->p1 =>
	// // (p1-temp)x(temp-p2)=(-1,0,0)
	// break;
	// }
	// }
	// if (temp == null)
	// System.out.println("temp=null error");
	// else {
	// double[] a = new double[] { p2.getX() - temp.getX(),
	// p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
	// double[] b = new double[] { p1.getX() - temp.getX(),
	// p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
	// double[] c = crossProduct(a, b);
	// cc = (c[0] > 0 && c[1] == 0 && c[2] == 0);
	// }
	// }
	// // bottom
	// else if (p1.getY() == p2.getY() && p1.getY() == A.getY()) {
	// int[] index = new int[] { 0, 1, 4, 5 };
	// for (int i = 0; i < 4; ++i) {
	// if (pc[index[i]] < 0) {
	// temp = corners[index[i]]; // p1->p2->temp->p1 =>
	// // (p1-temp)x(temp-p2)=(-1,0,0)
	// break;
	// }
	// }
	// if (temp == null)
	// System.out.println("temp=null error");
	// else {
	// double[] a = new double[] { p2.getX() - temp.getX(),
	// p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
	// double[] b = new double[] { p1.getX() - temp.getX(),
	// p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
	// double[] c = crossProduct(a, b);
	// cc = (c[0] == 0 && c[1] < 0 && c[2] == 0);
	// }
	// }
	// // top
	// else if (p1.getY() == p2.getY() && p1.getY() == B.getY()) {
	// int[] index = new int[] { 2, 3, 6, 7 };
	// for (int i = 0; i < 4; ++i) {
	// if (pc[index[i]] < 0) {
	// temp = corners[index[i]]; // p1->p2->temp->p1 =>
	// // (p1-temp)x(temp-p2)=(-1,0,0)
	// break;
	// }
	// }
	// if (temp == null)
	// System.out.println("temp=null error");
	// else {
	// double[] a = new double[] { p2.getX() - temp.getX(),
	// p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
	// double[] b = new double[] { p1.getX() - temp.getX(),
	// p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
	// double[] c = crossProduct(a, b);
	// cc = (c[0] == 0 && c[1] > 0 && c[2] == 0);
	// }
	// }
	// // front
	// else if (p1.getZ() == p2.getZ() && p1.getZ() == A.getZ()) {
	// int[] index = new int[] { 0, 3, 4, 7 };
	// for (int i = 0; i < 4; ++i) {
	// if (pc[index[i]] < 0) {
	// temp = corners[index[i]]; // p1->p2->temp->p1 =>
	// // (p1-temp)x(temp-p2)=(-1,0,0)
	// break;
	// }
	// }
	// if (temp == null)
	// System.out.println("temp=null error");
	// else {
	// double[] a = new double[] { p2.getX() - temp.getX(),
	// p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
	// double[] b = new double[] { p1.getX() - temp.getX(),
	// p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
	// double[] c = crossProduct(a, b);
	// cc = (c[0] == 0 && c[1] == 0 && c[2] < 0);
	// }
	// }
	// // back
	// else if (p1.getZ() == p2.getZ() && p1.getZ() == B.getZ()) {
	// int[] index = new int[] { 1, 2, 5, 6 };
	// for (int i = 0; i < 4; ++i) {
	// if (pc[index[i]] < 0) {
	// temp = corners[index[i]]; // p1->p2->temp->p1 =>
	// // (p1-temp)x(temp-p2)=(-1,0,0)
	// break;
	// }
	// }
	// if (temp == null)
	// System.out.println("temp=null error");
	// else {
	// double[] a = new double[] { p2.getX() - temp.getX(),
	// p2.getY() - temp.getY(), p2.getZ() - temp.getZ() };
	// double[] b = new double[] { p1.getX() - temp.getX(),
	// p1.getY() - temp.getY(), p1.getZ() - temp.getZ() };
	// double[] c = crossProduct(a, b);
	// cc = (c[0] == 0 && c[1] == 0 && c[2] > 0);
	// }
	// }
	// return cc;
	// }

	public void getSign(Poly3 p) {
		// left face
		corners[0] = A;
		corners[1] = new Point(A.getX(), A.getY(), B.getZ());
		corners[2] = new Point(A.getX(), B.getY(), B.getZ());
		corners[3] = new Point(A.getX(), B.getY(), A.getZ());
		// right face
		corners[4] = new Point(B.getX(), A.getY(), A.getZ());
		corners[5] = new Point(B.getX(), A.getY(), B.getZ());
		corners[6] = B;
		corners[7] = new Point(B.getX(), B.getY(), A.getZ());
		for (int i = 0; i < 8; ++i)
			pc[i] = p.sign(corners[i]);
	}

	public double[] crossProduct(double[] a, double[] b) {
		return new double[] { a[1] * b[2] - a[2] * b[1],
				a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0] };
	}

	public boolean sameFace(LinkedList<Point> loop, Face f) {
		Iterator<Point> iter = loop.iterator();
		if (para == 0) {
			while (iter.hasNext()) {
				Point p = iter.next();
				if (!f.contain(p.getY(), p.getZ()))
					return false;
			}
			return true;
		} else if (para == 1) {
			while (iter.hasNext()) {
				Point p = iter.next();
				if (!f.contain(p.getZ(), p.getX()))
					return false;
			}
			return true;
		} else {
			while (iter.hasNext()) {
				Point p = iter.next();
				if (!f.contain(p.getX(), p.getY()))
					return false;
			}
			return true;
		}
	}

	// return true if the points of a loop is inside a face
	public boolean inFace(LinkedList<Point> loop) {
		if (loop.size() == 4) {
			Point p1 = loop.get(0);
			Point p2 = loop.get(1);
			Point p3 = loop.get(2);
			Point p4 = loop.get(3);
			Face xy = new Face(new Interval(A.getX(), B.getX()), new Interval(A
					.getY(), B.getY()));
			Face yz = new Face(new Interval(A.getY(), B.getY()), new Interval(A
					.getZ(), B.getZ()));
			Face zx = new Face(new Interval(A.getZ(), B.getZ()), new Interval(A
					.getX(), B.getX()));
			if ((p1.getX() == A.getX() && p2.getX() == A.getX()
					&& p3.getX() == A.getX() && p4.getX() == A.getX()
					&& yz.contain(p1.getY(), p1.getZ())
					&& yz.contain(p2.getY(), p2.getZ())
					&& yz.contain(p3.getY(), p3.getZ()) && yz.contain(
					p4.getY(), p4.getZ()))
					|| (p1.getX() == B.getX() && p2.getX() == B.getX()
							&& p3.getX() == B.getX() && p4.getX() == B.getX()
							&& yz.contain(p1.getY(), p1.getZ())
							&& yz.contain(p2.getY(), p2.getZ())
							&& yz.contain(p3.getY(), p3.getZ()) && yz.contain(
							p4.getY(), p4.getZ()))
					|| (p1.getY() == A.getY() && p2.getY() == A.getY()
							&& p3.getY() == A.getY() && p4.getY() == A.getY()
							&& zx.contain(p1.getZ(), p1.getX())
							&& zx.contain(p2.getZ(), p2.getX())
							&& zx.contain(p3.getZ(), p3.getX()) && zx.contain(
							p4.getZ(), p4.getX()))
					|| (p1.getY() == B.getY() && p2.getY() == B.getY()
							&& p3.getY() == B.getY() && p4.getY() == B.getY()
							&& zx.contain(p1.getZ(), p1.getX())
							&& zx.contain(p2.getZ(), p2.getX())
							&& zx.contain(p3.getZ(), p3.getX()) && zx.contain(
							p4.getZ(), p4.getX()))
					|| (p1.getZ() == A.getZ() && p2.getZ() == A.getZ()
							&& p3.getZ() == A.getZ() && p4.getZ() == A.getZ()
							&& xy.contain(p1.getX(), p1.getY())
							&& xy.contain(p2.getX(), p2.getY())
							&& xy.contain(p3.getX(), p3.getY()) && xy.contain(
							p4.getX(), p4.getY()))
					|| (p1.getZ() == B.getZ() && p2.getZ() == B.getZ()
							&& p3.getZ() == B.getZ() && p4.getZ() == B.getZ()
							&& xy.contain(p1.getX(), p1.getY())
							&& xy.contain(p2.getX(), p2.getY())
							&& xy.contain(p3.getX(), p3.getY()) && xy.contain(
							p4.getX(), p4.getY())))
				return true;
		}
		return false;
	}

	// return the distance between two points a and b.
	public double distance(Point a, Point b) {
		return Math.sqrt((Math.pow((a.getX() - b.getX()), 2)
				+ Math.pow((a.getY() - b.getY()), 2) + Math.pow((a.getZ() - b
				.getZ()), 2)));
	}

	// return true if two points a and b are on the same line.
	public boolean sameLine(Point a, Point b) {
		return ((a.getX() == b.getX() && a.getY() == b.getY())
				|| (a.getY() == b.getY() && a.getZ() == b.getZ()) || (a.getZ() == b
				.getZ() && a.getX() == b.getX()));
	}

	// return true if there already exists a vertices on line(a,b)
	public boolean vertexInLine(Point a, Point b) {
		for (int i = 0; i < this.vertices.size(); ++i) {
			Point p = vertices.get(i);
			if (p.contain(a, b)) {
				return true;
			}
		}
		return false;
	}

	// return true if p is contained inside the cube
	public boolean containPoint(Point p) {
		return ((p.getX() >= A.getX() && p.getX() <= B.getX())
				&& (p.getY() >= A.getY() && p.getY() <= B.getY()) && (p.getZ() >= A
				.getZ() && p.getZ() <= B.getZ()));
	}

	public boolean sameSign(Poly3 p) {
		Point p1 = new Point(A);
		Point p2 = new Point(A.getX(), A.getY(), B.getZ());
		Point p3 = new Point(A.getX(), B.getY(), B.getZ());
		Point p4 = new Point(A.getX(), B.getY(), A.getZ());
		Point p5 = new Point(B);
		Point p6 = new Point(B.getX(), A.getY(), B.getZ());
		Point p7 = new Point(B.getX(), A.getY(), A.getZ());
		Point p8 = new Point(B.getX(), B.getY(), A.getZ());

		return ((p.sign(p1) == p.sign(p2)) && (p.sign(p2) == p.sign(p3))
				&& (p.sign(p3) == p.sign(p4)) && (p.sign(p4) == p.sign(p5))
				&& (p.sign(p5) == p.sign(p6)) && (p.sign(p6) == p.sign(p7)) && (p
				.sign(p7) == p.sign(p8)));
	}

	public boolean ambiguous(Poly3 p) {
		if (para == 0) {
			Face f = new Face(new Interval(A.getY(), B.getY()), new Interval(A
					.getZ(), B.getZ()));
			if ((leftV.size() == 4 && sameFace(leftV, f))
					|| (rightV.size() == 4 && sameFace(rightV, f))) {
				System.out.println("xambiguous!!!!!!!!!!!!!!!!");
				return true;
			}
		} else if (para == 1) {
			Face f = new Face(new Interval(A.getZ(), B.getZ()), new Interval(A
					.getX(), B.getX()));
			if ((topV.size() == 4 && sameFace(topV, f))
					|| (bottomV.size() == 4 && sameFace(bottomV, f))) {
				System.out.println("yambiguous!!!!!!!!!!!!!!!!");
				return true;
			}
		} else {
			Face f = new Face(new Interval(A.getX(), B.getX()), new Interval(A
					.getY(), B.getY()));
			if ((frontV.size() == 4 && sameFace(frontV, f))
					|| (backV.size() == 4 && sameFace(backV, f))) {
				System.out.println("zambiguous!!!!!!!!!!!!!!!!");
				return true;
			}
		}

		return false;
	}

	public boolean ambiguous1(Poly3 p) {
		if (leftV.size() == 2) {
			if (sameBoxLineX(leftV.get(0), leftV.get(1)))
				return true;
		}
		if (rightV.size() == 2) {
			if (sameBoxLineX(rightV.get(0), rightV.get(1)))
				return true;
		}
		if (topV.size() == 2) {
			if (sameBoxLineY(topV.get(0), topV.get(1)))
				return true;
		}
		if (bottomV.size() == 2) {
			if (sameBoxLineY(bottomV.get(0), bottomV.get(1)))
				return true;
		}
		if (frontV.size() == 2) {
			if (sameBoxLineZ(frontV.get(0), frontV.get(1)))
				return true;
		}
		if (backV.size() == 2) {
			if (sameBoxLineZ(backV.get(0), backV.get(1)))
				return true;
		}
		return false;
	}

	public Cube ambiguous2(Poly3 p) {
		if (para == 0) {
			if (pc[0] == pc[2] && pc[1] == pc[3] && pc[0] != pc[1])
				if (xNeighborN.size() == 1 && xNeighborN.get(0).size > size)
					return xNeighborN.get(0);
			if (pc[4] == pc[6] && pc[5] == pc[7] && pc[4] != pc[5])
				if (xNeighborP.size() == 1 && xNeighborP.get(0).size > size)
					return xNeighborP.get(0);
		}
		if (para == 1) {
			if (pc[0] == pc[5] && pc[1] == pc[4] && pc[0] != pc[1])
				if (yNeighborN.size() == 1 && yNeighborN.get(0).size > size)
					return yNeighborN.get(0);
			if (pc[3] == pc[6] && pc[2] == pc[7] && pc[2] != pc[3])
				if (yNeighborP.size() == 1 && yNeighborP.get(0).size > size)
					return yNeighborP.get(0);
		}
		if (para == 2) {
			if (pc[0] == pc[7] && pc[3] == pc[4] && pc[0] != pc[3])
				if (zNeighborN.size() == 1 && zNeighborN.get(0).size > size)
					return zNeighborN.get(0);
			if (pc[1] == pc[6] && pc[2] == pc[5] && pc[2] != pc[1])
				if (zNeighborP.size() == 1 && zNeighborP.get(0).size > size)
					return zNeighborP.get(0);
		}
		return null;
	}

	boolean sameBoxLineY(Point p1, Point p2) {
		double cax = A.getX();
		double caz = A.getZ();
		double cbx = B.getX();
		double cbz = B.getZ();
		return ((p1.getX() == p2.getX() && (p1.getX() == cax || p1.getX() == cbx)) || (p1
				.getZ() == p2.getZ() && (p1.getZ() == caz || p1.getZ() == cbz)));
	}

	boolean sameBoxLineX(Point p1, Point p2) {
		double cay = A.getY();
		double caz = A.getZ();
		double cby = B.getY();
		double cbz = B.getZ();
		return ((p1.getY() == p2.getY() && (p1.getY() == cay || p1.getY() == cby)) || (p1
				.getZ() == p2.getZ() && (p1.getZ() == caz || p1.getZ() == cbz)));
	}

	boolean sameBoxLineZ(Point p1, Point p2) {
		double cax = A.getX();
		double cay = A.getY();
		double cbx = B.getX();
		double cby = B.getY();
		return ((p1.getX() == p2.getX() && (p1.getX() == cax || p1.getX() == cbx)) || (p1
				.getY() == p2.getY() && (p1.getY() == cay || p1.getY() == cby)));
	}

	public boolean C0(Poly3 p) {
		return (!p.value(
				new Interval[] { this.getIntervalX(), this.getIntervalY(),
						this.getIntervalZ() }).zero());
	}

	public boolean C1(Poly3 p, Poly3 px, Poly3 py, Poly3 pz) {

		Interval[] I = new Interval[] { this.getIntervalX(),
				this.getIntervalY(), this.getIntervalZ() };

		Interval temp = new Interval();

		Interval Ix = temp.multiply(px.value(I), px.value(I));
		Interval Iy = temp.multiply(py.value(I), py.value(I));
		Interval Iz = temp.multiply(pz.value(I), pz.value(I));

		return (!temp.plus(temp.plus(Ix, Iy), Iz).zero());
	}

	public boolean Cx(Poly3 p, Poly3 px) {

		Interval[] I = new Interval[] { this.getIntervalX(),
				this.getIntervalY(), this.getIntervalZ() };
		if (!px.value(I).zero()) {
			para = 0;
			return true;
		} else
			return false;
	}

	public boolean Cy(Poly3 p, Poly3 py) {

		Interval[] I = new Interval[] { this.getIntervalX(),
				this.getIntervalY(), this.getIntervalZ() };

		if (!py.value(I).zero()) {
			para = 1;
			return true;
		} else
			return false;
	}

	public boolean Cxyz(Poly3 p, Poly3 px, Poly3 py, Poly3 pz) {
		return (this.Cx(p, px) || this.Cy(p, py) || this.Cz(p, pz));
	}

	public boolean Cz(Poly3 p, Poly3 pz) {

		Interval[] I = new Interval[] { this.getIntervalX(),
				this.getIntervalY(), this.getIntervalZ() };

		if (!pz.value(I).zero()) {
			para = 2;
			return true;
		} else
			return false;
	}

	public LinkedList<LinkedList<Point>> getLoops() {
		return loops;
	}

	public Point getA() {
		return A;
	}

	public Point getB() {
		return B;
	}

	public Interval getIntervalX() {
		return new Interval(A.getX(), B.getX());
	}

	public Interval getIntervalY() {
		return new Interval(A.getY(), B.getY());
	}

	public Interval getIntervalZ() {
		return new Interval(A.getZ(), B.getZ());
	}

	public double getSize() {
		return size;
	}

	public LinkedList<Cube> getxNeighborP() {
		return xNeighborP;
	}

	public LinkedList<Cube> getxNeighborN() {
		return xNeighborN;
	}

	public LinkedList<Cube> getyNeighborP() {
		return yNeighborP;
	}

	public LinkedList<Cube> getyNeighborN() {
		return yNeighborN;
	}

	public LinkedList<Cube> getzNeighborP() {
		return zNeighborP;
	}

	public LinkedList<Cube> getzNeighborN() {
		return zNeighborN;
	}

	public LinkedList<Point> getVertices() {
		return vertices;
	}

	public LinkedList<Point> getTopV() {
		return topV;
	}

	public LinkedList<Point> getBottomV() {
		return bottomV;
	}

	public LinkedList<Point> getLeftV() {
		return leftV;
	}

	public LinkedList<Point> getRightV() {
		return rightV;
	}

	public LinkedList<Point> getFrontV() {
		return frontV;
	}

	public LinkedList<Point> getBackV() {
		return backV;
	}

	public LinkedList<Point[]> getFaces() {
		return this.faces;
	}

	public void setA(Point a) {
		A.copy(a);
	}

	public void setB(Point b) {
		B.copy(b);
	}

	public void addxNeighborP(Cube c) {
		xNeighborP.add(c);
	}

	public void addxNeighborN(Cube c) {
		xNeighborN.add(c);
	}

	public void addyNeighborP(Cube c) {
		yNeighborP.add(c);
	}

	public void addyNeighborN(Cube c) {
		yNeighborN.add(c);
	}

	public void addzNeighborP(Cube c) {
		zNeighborP.add(c);
	}

	public void addzNeighborN(Cube c) {
		zNeighborN.add(c);
	}

	public void setVertices(LinkedList<Point> v) {
		vertices = v;
	}

	/*
	 * return true if the the projections of cubes to y-z plane overlap
	 */
	public boolean xOverlap(Cube a, Cube b) {
		Interval[] fa = new Interval[] { a.getIntervalY(), a.getIntervalZ() };
		Interval[] fb = new Interval[] { b.getIntervalY(), b.getIntervalZ() };
		return faceOverlap(fa, fb);
	}

	/*
	 * return true if the the projections of cubes to x-z plane overlap
	 */
	public boolean yOverlap(Cube a, Cube b) {
		Interval[] fa = new Interval[] { a.getIntervalX(), a.getIntervalZ() };
		Interval[] fb = new Interval[] { b.getIntervalX(), b.getIntervalZ() };
		return faceOverlap(fa, fb);
	}

	/*
	 * return true if the the projections of cubes to x-y plane overlap
	 */
	public boolean zOverlap(Cube a, Cube b) {
		Interval[] fa = new Interval[] { a.getIntervalX(), a.getIntervalY() };
		Interval[] fb = new Interval[] { b.getIntervalX(), b.getIntervalY() };
		return faceOverlap(fa, fb);
	}

	/*
	 * return true if two planar faces (defined by ((a1x, a1y), (b1x, b1y)) and
	 * ((a2x, a2y), (b2x, b2y))) overlap
	 */
	public boolean faceOverlap(Interval[] f1, Interval[] f2) { // f1[0] x
		// interval,
		// f1[1] y
		// interval
		return !(f1[0].getA() >= f2[0].getB() || f2[0].getA() >= f1[0].getB()
				|| f1[1].getA() >= f2[1].getB() || f2[1].getA() >= f1[1].getB());
	}

	/*
	 * return true if two cubes overlap
	 */
	static public boolean cubeOverlap(Cube c1, Cube c2) {
		return (!(c1.getA().getX() > c2.getB().getX()
				|| c2.getA().getX() > c1.getB().getX()
				|| c1.getA().getY() > c2.getB().getY()
				|| c2.getA().getY() > c1.getB().getY()
				|| c1.getA().getZ() > c2.getB().getZ() || c2.getA().getZ() > c1
				.getB().getZ()))
				&& // only intersect with a corner
				(!((c1.getA().getX() == c2.getB().getX() || c2.getA().getX() == c1
						.getB().getX())
						&& (c1.getA().getY() > c2.getB().getY() || c2.getA()
								.getY() > c1.getB().getY()) && (c1.getA()
						.getZ() > c2.getB().getZ() || c2.getA().getZ() > c1
						.getB().getZ())));
	}

	// public boolean faceOverlap(Face f1, Face f2){
	// double m1x=f1.midX();
	// double m1y=f1.midY();
	// double m2x=f2.midX();
	// double m2y=f2.midY();
	//		
	// if ((f2.getX().getA()<m1x && m1x<f2.getX().getB() && f2.getY().getA()<m1y
	// && m1y<f2.getY().getB()) ||
	// (f1.getX().getA()<m2x && m2x<f1.getX().getB() && f1.getY().getA()<m2y &&
	// m2y<f1.getY().getB()))
	// return true;
	// else
	// return false;
	// }

	// public boolean faceOverlap1(Interval[] f1, Interval[] f2){
	// double m1x=(f1[0].getA()+f1[0].getB())/2;
	// double m1y=(f1[1].getA()+f1[1].getB())/2;
	// double m2x=(f2[0].getA()+f2[0].getB())/2;
	// double m2y=(f2[1].getA()+f2[1].getB())/2;
	//		
	// if ((f2[0].getA()<m1x && m1x<f2[0].getB() && f2[1].getA()<m1y &&
	// m1y<f2[1].getB()) ||
	// (f1[0].getA()<m2x && m2x<f1[0].getB() && f1[1].getA()<m2y &&
	// m2y<f1[1].getB()))
	// return true;
	// else
	// return false;
	// }
	//	
	// public boolean faceOverlap(double[][] f1, double[][] f2){//f1[0]:
	// intervalX, f1[0][0]: intervalX.A
	// double m1x=(f1[0][0]+f1[0][1])/2;
	// double m1y=(f1[1][0]+f1[1][1])/2;
	// double m2x=(f2[0][0]+f2[0][1])/2;
	// double m2y=(f2[1][0]+f2[1][1])/2;
	//		
	// if ((f2[0][0]<m1x && m1x<f2[0][1] && f2[1][0]<m1y && m1y<f2[1][1]) ||
	// (f1[0][0]<m2x && m2x<f1[0][1] && f1[1][0]<m2y && m2y<f1[1][1]))
	// return true;
	// else
	// return false;
	// }

	// public Point interPoint(Point a, Point b, Poly3 p){
	// return new Point((a.getX()+b.getX())/2, (a.getY()+b.getY())/2,
	// (a.getZ()+b.getZ())/2);
	// }

	public Point interPoint(Point a, Point b, Poly3 p) {
		double v2 = p.value(b);
		double v1 = p.value(a);
		double t = Math.abs(v1 / (v2 - v1));

		if ((v1 == 0) || (v2 == 0))
			t = 0.5;
		// if (v1 == 0)
		// t = 0.01;
		// if (v2 == 0)
		// t = 0.99;
		double x, y, z;
		if (a.getX() == b.getX())
			x = a.getX();
		else
			x = a.getX() + (b.getX() - a.getX()) * t;
		if (a.getY() == b.getY())
			y = a.getY();
		else
			y = a.getY() + (b.getY() - a.getY()) * t;
		if (a.getZ() == b.getZ())
			z = a.getZ();
		else
			z = a.getZ() + (b.getZ() - a.getZ()) * t;
		return new Point(x, y, z);
	}

	public boolean smallerXN() {
		if (this.getxNeighborN().size() == 0)
			return false;
		else {
			Cube temp = this.getxNeighborN().get(0);
			return (temp.getSize() < this.getSize());
		}
	}

	public boolean smallerXP() {
		if (this.getxNeighborP().size() == 0)
			return false;
		else {
			Cube temp = this.getxNeighborP().get(0);
			return (temp.getSize() < this.getSize());
		}
	}

	public boolean smallerYN() {
		if (this.getyNeighborN().size() == 0)
			return false;
		else {
			Cube temp = this.getyNeighborN().get(0);
			return (temp.getSize() < this.getSize());
		}
	}

	public boolean smallerYP() {
		if (this.getyNeighborP().size() == 0)
			return false;
		else {
			Cube temp = this.getyNeighborP().get(0);
			return (temp.getSize() < this.getSize());
		}
	}

	public boolean smallerZN() {
		if (this.getzNeighborN().size() == 0)
			return false;
		else {
			Cube temp = this.getzNeighborN().get(0);
			return (temp.getSize() < this.getSize());
		}
	}

	public boolean smallerZP() {
		if (this.getzNeighborP().size() == 0)
			return false;
		else {
			Cube temp = this.getzNeighborP().get(0);
			return (temp.getSize() < this.getSize());
		}
	}

	public void removeVetex(Point p) {
		vertices.remove(p);
		leftV.remove(p);
		rightV.remove(p);
		topV.remove(p);
		bottomV.remove(p);
		frontV.remove(p);
		backV.remove(p);
	}

	public boolean belongLeft(Point p) {
		return (p.getX() == this.getA().getX());
	}

	public boolean belongRight(Point p) {
		return (p.getX() == this.getB().getX());
	}

	public boolean belongTop(Point p) {
		return (p.getY() == this.getB().getY());
	}

	public boolean belongBottom(Point p) {
		return (p.getY() == this.getA().getY());
	}

	public boolean belongBack(Point p) {
		return (p.getZ() == this.getB().getZ());
	}

	public boolean belongFront(Point p) {
		return (p.getZ() == this.getA().getZ());
	}

	public boolean equal(Cube c) {
		return (this.A.equal(c.A) && this.B.equal(c.B));
	}

	public void print() {
		System.out.println("cube:");
		A.print();
		B.print();
	}

	public void printVertices() {
		System.out.println("vertices:");
		for (int i = 0; i < vertices.size(); ++i)
			vertices.get(i).print();
	}
}
