import java.io.File;
import java.io.IOException;
import java.util.Scanner;

import javax.print.PrintException;

import Geometry.Cube;
import Geometry.Point;
import Polynomial.*;

public class outputObj{
	public static void main(String[] args){
	String path="./testcases/pv1.txt";
	double xmin=-8;
	double ymin=-8;
	double zmin=-8;
	double xmax=8;
	double ymax=8;
	double zmax=8;
	double sizeFactor=4.0;
	String algorithm="cxyz";
	
	long time=System.currentTimeMillis();;
	Poly3 p;
	
	Point A;
	Point B;
	Cube c;
	
	Shape3D sphere = null;

	
		String a=" ";
		try{
			Scanner scan=new Scanner(new File("./para.txt"));
			a=scan.nextLine();
			System.out.println(a);	 
		}catch (IOException e) {
			System.err.println("IOException");
		}
		String[] para=a.split(" ");
		if (para.length>0){
			algorithm=para[0];
			if (para.length>1){
				path=para[1];
				if (para.length>2){
					sizeFactor=Double.parseDouble(para[2]);
					if (para.length>8){
						xmin=Double.parseDouble(para[3]);
						ymin=Double.parseDouble(para[4]);
						zmin=Double.parseDouble(para[5]);
						xmax=Double.parseDouble(para[6]);
						ymax=Double.parseDouble(para[7]);
						zmax=Double.parseDouble(para[8]);
					}
				}
			}
		}
		System.out.println(path);
		
		p=new Poly3(Polynomial.getS(path));
		A=new Point(xmin,ymin,zmin);
		B=new Point(xmax,ymax,zmax);
		c=new Cube(A, B);
		if (algorithm.equals("cxyz"))
			try {
				sphere = new SurfaceCxyz(p,c,sizeFactor);
			} catch (PrintException e) {
				e.printStackTrace();
			}
		else if (algorithm.equals("pv"))
			sphere = new SurfacePV(p,c,sizeFactor);
		else if (algorithm.equals("cxyze"))
			sphere = new SurfaceCxyzE(p,c,sizeFactor);
		else{
			System.err.println("no such method");
			System.exit(0);
		}
		String[] eg=path.split("/");
		((Surface)sphere).outputObj("./output/"+algorithm+"_"+eg[eg.length-1]+".obj");
		//((Surface)sphere).outputBox("./output/"+"boxes_"+algorithm+"_"+eg[eg.length-1]+".obj");
		System.out.println(System.currentTimeMillis()-time);
	}
}