//cxyze algorithm
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;

import Geometry.*;
import Polynomial.*;

public class SurfaceCxyzE extends Surface {
	final double epsilon = 0.25;

	// double sizeFactor=8;
	// LinkedList<Cube> C0=new LinkedList<Cube>(); //C0 cubes

	public SurfaceCxyzE(Poly3 p, Cube c, double sizeFactor) {
		Poly3 px = p.derivative('x');
		Poly3 py = p.derivative('y');
		Poly3 pz = p.derivative('z');
		HashMap<Point, Integer> v = new HashMap<Point, Integer>();
		PriorityQueue<Cube> Q1 = new PriorityQueue<Cube>(100000,
				new sizeComparator()); // Cxyz cubes
		PriorityQueue<Cube> Q2 = new PriorityQueue<Cube>(100000,
				new sizeComparator()); // Balanced Cxyz Cubes
		PriorityQueue<Cube> Q3 = new PriorityQueue<Cube>(100000,
				new sizeComparator());
		LinkedList<Cube> Q0 = new LinkedList<Cube>();
		ArrayList<Point[]> f = new ArrayList<Point[]>();

		Q0.add(c);
		/****************************
		 *subdivision criteria
		 ****************************/
		while (!Q0.isEmpty()) {
			Cube t1 = Q0.poll();
			if (t1.C0(p)) {
				removeC0(t1);
			} else if (t1.Cxyz(p, px, py, pz)) {
				Q1.add(t1);
			} else {
				LinkedList<Cube> tempQ = t1.split();
				counter += 7;
				for (int i = 0; i < tempQ.size(); i++)
					Q0.add(tempQ.get(i));
			}
		}
		System.out.println("subdivision criteria");
		System.out.println("number of boxes=" + counter);
		System.out.println();

		/****************************
		 *balance
		 ****************************/
		Q2 = balance(Q1, p);
		System.out.println("balance");
		System.out.println("number of boxes=" + counter);
		System.out.println();

		/****************************
		 *epsilon refinement
		 ****************************/
		while (!Q2.isEmpty()) {
			Cube tempT = Q2.poll();
			if (tempT.C1(p, px, py, pz))
				Q1.add(tempT); // now Q1 is empty and act as a temp queue
			else {
				LinkedList<Cube> temp = tempT.split();
				counter += 7;
				for (int i = 0; i < temp.size(); ++i) {
					Cube tempI = temp.get(i);
					if (tempI.C0(p)) {
						// C0.add(tempI);
					} else {
						Q2.add(tempI);
					}
				}
			}
		}

		while (!Q1.isEmpty()) {
			Cube tc = Q1.poll();
			if (tc.getSize() <= epsilon)
				Q3.add(tc);
			else {
				LinkedList<Cube> temp = tc.split();
				counter += 7;
				for (int i = 0; i < temp.size(); ++i) {
					Cube tempI = temp.get(i);
					if (tempI.C0(p)) {
						// C0.add(tempI);
					} else {
						Q1.add(tempI);
					}
				}
			}
		}

		System.out.println("refinement");
		System.out.println("number of boxes=" + counter);
		System.out.println();

		/****************************
		 *construction
		 ****************************/
//		checkDuplication(Q3);
//		checkInclusion(Q3);
		while (!Q3.isEmpty()) {
			Cube tc = Q3.poll();
			tc.addV(p);
			Iterator<Point> iter = tc.getVertices().iterator();
			while (iter.hasNext())
				v.put(iter.next(), 0);
			tc.link(p, px, py, pz);
			tc.findLoop();
			tc.triangulate(v);
			for (int i = 0; i < tc.getFaces().size(); ++i)
				f.add(tc.getFaces().get(i));
			boxes.add(tc);
		}

		setFaces(v, f, px, py, pz, sizeFactor);
	}	
}
