//cxyz algorithm
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Stack;

import javax.print.PrintException;

import Geometry.*;
import Polynomial.*;

public class SurfaceCxyz extends Surface {
	int locate = 0;
	int rightv = 0;
	int balanceT = 1;
	// double sizeFactor=8;
	// LinkedList<Cube> C0=new LinkedList<Cube>(); //C0 cubes
//	Cube testcube=new Cube(new Point(5.125, -0.125, -0.125), new Point( 5.3125, 0.0625, 0.0625));
	public SurfaceCxyz() {

	}

	public SurfaceCxyz(Poly3 p, Cube c, double sizeFactor)
			throws PrintException {
		Poly3 px = p.derivative('x');
		Poly3 py = p.derivative('y');
		Poly3 pz = p.derivative('z');
//		getPositivePoint(p);
		HashMap<Point, Integer> v = new HashMap<Point, Integer>();
		PriorityQueue<Cube> Q1 = new PriorityQueue<Cube>(10,
				new sizeComparator()); // Cxyz cubes
		PriorityQueue<Cube> Q2 = new PriorityQueue<Cube>(10,
				new sizeComparator()); // Balanced Cxyz Cubes
		PriorityQueue<Cube> Q3 = new PriorityQueue<Cube>(10,
				new sizeComparator());
		LinkedList<Cube> Q0 = new LinkedList<Cube>();
		ArrayList<Point[]> f = new ArrayList<Point[]>();

		Q0.add(c);
		/****************************
		 *subdivision criteria
		 ****************************/
		while (!Q0.isEmpty()) {
			Cube t1 = Q0.poll();
			if (t1.C0(p)) {
				removeC0(t1);
			} else if (t1.Cxyz(p, px, py, pz)) {
				Q1.add(t1);
			} else {
				LinkedList<Cube> tempQ = t1.split();
				counter += 7;
				for (int i = 0; i < tempQ.size(); i++)
					Q0.add(tempQ.get(i));
			}
		}
		System.out.println("subdivision criteria");
		System.out.println("number of boxes=" + counter);
		System.out.println();

		/****************************
		 *balance
		 ****************************/
		Q2 = balance(Q1, p);
		System.out.println("balance");
		System.out.println("number of boxes=" + counter);
		System.out.println();

		/****************************
		 *disambiguation
		 ****************************/
		Q3 = this.disambiguous(Q2, p);
		System.out.println("disambiguation");
		System.out.println("number of boxes=" + counter);
		System.out.println("balanced times=" + balanceT);
		System.out.println();

		/****************************
		 *construction
		 ****************************/
//		Iterator<Cube> iter=Q3.iterator();
//		Cube ccc=null;
//		while (iter.hasNext()){
//			ccc=iter.next();
//			if (ccc.equal(testcube)){
//				testcube=ccc;
//				break;
//			}
//		}
//		testcube.print();
//		System.out.println(testcube.linkedFaces);

//		for (int i=0; i<testcube.getVertices().size(); ++i){
//			System.out.println("<<<<<<<<<<<<<<<<<<<<<<");
//			testcube.getVertices().get(i).print();
//			System.out.println();
//			for (int j=i+1; j<testcube.getVertices().size(); ++j){
//				if (testcube.getVertices().get(i).getLinks().contains(testcube.getVertices().get(j)))
//					testcube.getVertices().get(j).print();
//			}
//			System.out.println(">>>>>>>>>>>>>>>>>>>>>>");
//		}
//		int def=testcube.linkedFaces;
			
//		int abc=0;
//		checkDuplication(Q3);
//		checkInclusion(Q3);
//		System.out.println(Q3.size());
		while (!Q3.isEmpty()) {
//			if (testcube.linkedFaces>def){
//				System.out.println(1+" "+abc+" "+testcube.linkedFaces);
//				def=testcube.linkedFaces;
//				for (int i=0; i<testcube.linkedFace.length; ++i)
//					System.out.print(testcube.linkedFace[i]+" ");
//				testcube.printVertices();
//				for (int i=0; i<testcube.getVertices().size(); ++i){
//					System.out.println("<<<<<<<<<<<<<<<<<<<<<<");
//					System.out.println(i);
//					System.out.println();
//					for (int j=i+1; j<testcube.getVertices().size(); ++j){
//						if (testcube.getVertices().get(i).getLinks().contains(testcube.getVertices().get(j)))
//							System.out.println(j);
//					}
//					System.out.println(">>>>>>>>>>>>>>>>>>>>>>");
//				}
//			}
			Cube tc = Q3.poll();
//			abc++;
//			System.out.println(abc);
			
			for (int i = 0; i < tc.getVertices().size(); ++i)
				v.put(tc.getVertices().get(i), 0);
//			if (tc==testcube){
//				System.out.println(2+" "+abc+" "+testcube.linkedFaces);
//				tc.print();
//				System.out.println("tc=========="+tc.linkedFaces);
//				for (int i=0; i<tc.linkedFace.length; ++i)
//					System.out.print(tc.linkedFace[i]+" ");
//				for (int i=0; i<tc.getVertices().size(); ++i){
//					System.out.println("<<<<<<<<<<<<<<<<<<<<<<");
//					System.out.println(i);
//					System.out.println();
//					for (int j=i+1; j<tc.getVertices().size(); ++j){
//						if (tc.getVertices().get(i).getLinks().contains(tc.getVertices().get(j)))
//							System.out.println(j);
//					}
//					System.out.println(">>>>>>>>>>>>>>>>>>>>>>");
//				}
//			}
			tc.linkCxyz(p, px, py, pz);
//			if (tc.equal(testcube))
//				System.out.println("tc=========="+tc.linkedFaces);
			if (tc.linkedFaces < 6) {
				if (tc.linkedFaces == 5) {
					// linked based on the other face;
					tc.linkFace5();
				} else { //tc.linkedFaces == 4
					if (tc.para==0){
						Stack<Cube> stack=new Stack<Cube>();
						stack.push(tc);
						Cube tempTC=tc.getxNeighborN().get(0);
						tempTC.linkCxyz(p, px, py, pz);
						
						while(tempTC.linkedFaces==4){
//							if (tempTC.getSize()!=tc.getSize())
//								System.out.println("error in different size and 4");
							stack.push(tempTC);
							tempTC=tempTC.getxNeighborN().get(0);
							tempTC.linkCxyz(p, px, py, pz);
							
						}
//						if (tempTC.linkedFaces==6){
//							tempTC=stack.pop();
//							++tempTC.linkedFaces;
//							tempTC.linkedFace[0]=true;
//						}
						tempTC.linkFace5();
						while (!stack.isEmpty()){
							tempTC=stack.pop();
							tempTC.linkFace5();
						}
					} else if(tc.para==1){
						Stack<Cube> stack=new Stack<Cube>();
						stack.push(tc);
						Cube tempTC=tc.getyNeighborN().get(0);
						tempTC.linkCxyz(p, px, py, pz);
						
						while(tempTC.linkedFaces==4){
							stack.push(tempTC);
							tempTC=tempTC.getyNeighborN().get(0);
							tempTC.linkCxyz(p, px, py, pz);
							
						}

						tempTC.linkFace5();
						while (!stack.isEmpty()){
							tempTC=stack.pop();
							tempTC.linkFace5();
						}
					} else{
						Stack<Cube> stack=new Stack<Cube>();
						stack.push(tc);
						Cube tempTC=tc.getzNeighborN().get(0);
						tempTC.linkCxyz(p, px, py, pz);
						
						while(tempTC.linkedFaces==4){
							stack.push(tempTC);
							tempTC=tempTC.getzNeighborN().get(0);
							tempTC.linkCxyz(p, px, py, pz);
							
						}

						tempTC.linkFace5();
						
						while (!stack.isEmpty()){
							tempTC=stack.pop();
							tempTC.linkFace5();
						}
					}
				}
			}
			
//			if (abc==40127){
//				tc.print();
//				tc.printVertices();
//				System.out.println(tc.para);
//				for (int i=0; i<8; ++i)
//					System.out.print(tc.pc[i]+" ");
//				System.out.println(3+" "+abc+" "+tc.linkedFaces);
//				for (int i=0; i<tc.linkedFace.length; ++i)
//					System.out.print(tc.linkedFace[i]+" ");
//				System.out.println(tc.getLoops().size());
//				for (int i=0; i<tc.getVertices().size(); ++i){
//					System.out.println("<<<<<<<<<<<<<<<<<<<<<<");
//					System.out.println(i);
//					System.out.println();
//					for (int j=i+1; j<tc.getVertices().size(); ++j){
//						if (tc.getVertices().get(i).getLinks().contains(tc.getVertices().get(j)))
//							System.out.println(j);
//					}
//					System.out.println(">>>>>>>>>>>>>>>>>>>>>>");
//				}
//			}
			
			tc.findLoop();
			
			tc.triangulate(v);
			
//			if (abc==43223)
			for (int i = 0; i < tc.getFaces().size(); ++i)
				f.add(tc.getFaces().get(i));
			boxes.add(tc);
		}

		System.out.println("construction");

		setFaces(v, f, px, py, pz, sizeFactor);
	}

	public PriorityQueue<Cube> disambiguous(PriorityQueue<Cube> Q2, Poly3 p) {
		PriorityQueue<Cube> Q3 = new PriorityQueue<Cube>(10,
				new sizeComparator());
		double size = Q2.peek().getSize();
		double size1 = Q2.peek().getSize();
		while (size1 == size && !Q2.isEmpty()) {
			Cube tc = Q2.poll();
			tc.addV(p);
			Q3.add(tc);
			if (!Q2.isEmpty())
				size1 = Q2.peek().getSize();
		}// finish dealing with the smallest size
		PriorityQueue<Cube> suspend = new PriorityQueue<Cube>(10,
				new sizeComparator());
		while (!Q2.isEmpty()) {
			Cube tc = Q2.peek();
			if (tc.getSize() <= size1) {// deal with small size
				tc = Q2.poll();
				if (tc.ambiguous(p) || tc.ambiguous1(p)) {// ambiguous
					LinkedList<Cube> temp = tc.split();
					LinkedList<Point> vs = tc.getVertices();
					counter += 7;
					// re-balance
					PriorityQueue<Cube> rebalanceQ = new PriorityQueue<Cube>(
							10, new sizeComparator());
					for (int i = 0; i < temp.size(); ++i)
						if (temp.get(i).C0(p))
							removeC0(temp.get(i));
						else {
							Cube tc1 = temp.get(i);
							for (int k = 0; k < vs.size(); ++k) {
								if (tc1.containPoint(vs.get(k))) {
									Point vp = vs.get(k);
									tc1.getVertices().add(vp);
									if (tc1.belongLeft(vp))
										tc1.getLeftV().add(vp);
									if (tc1.belongRight(vp))
										tc1.getRightV().add(vp);
									if (tc1.belongTop(vp))
										tc1.getTopV().add(vp);
									if (tc1.belongBottom(vp))
										tc1.getBottomV().add(vp);
									if (tc1.belongFront(vp))
										tc1.getFrontV().add(vp);
									if (tc1.belongBack(vp))
										tc1.getBackV().add(vp);
								}
							}
							tc1.addV(p);
							Q3.add(tc1);
							rebalanceQ.add(tc1);
						}
					reBalance(rebalanceQ, p, Q2);
					Q2.addAll(suspend);
					suspend.clear();
				} else {
					Cube tempTC=tc.ambiguous2(p);
					if (tempTC!=null){
						Q2.remove(tempTC);
						LinkedList<Cube> temp = tempTC.split();
						LinkedList<Point> vs = tempTC.getVertices();
						counter += 7;
						// re-balance
						PriorityQueue<Cube> rebalanceQ = new PriorityQueue<Cube>(
								10, new sizeComparator());
						for (int i = 0; i < temp.size(); ++i)
							if (temp.get(i).C0(p))
								removeC0(temp.get(i));
							else {
								Cube tc1 = temp.get(i);
								for (int k = 0; k < vs.size(); ++k) {
									if (tc1.containPoint(vs.get(k))) {
										Point vp = vs.get(k);
										tc1.getVertices().add(vp);
										if (tc1.belongLeft(vp))
											tc1.getLeftV().add(vp);
										if (tc1.belongRight(vp))
											tc1.getRightV().add(vp);
										if (tc1.belongTop(vp))
											tc1.getTopV().add(vp);
										if (tc1.belongBottom(vp))
											tc1.getBottomV().add(vp);
										if (tc1.belongFront(vp))
											tc1.getFrontV().add(vp);
										if (tc1.belongBack(vp))
											tc1.getBackV().add(vp);
									}
								} //this is for vertices added by smaller neighboring boxes
								tc1.addV(p); //this is for update with larger neighboring boxes
								Q2.add(tc1);
								rebalanceQ.add(tc1);
							}
						reBalance(rebalanceQ, p, Q2);
					}

					suspend.add(tc);
				}
			} else {
				Iterator<Cube> iter = suspend.iterator();
				while (iter.hasNext()) {
					Cube tempI = iter.next();
//					if (tempI.C0(p)) {
//						System.out.println("exit c0 box");
//					} else {
						tempI.addV(p);
						Q3.add(tempI);
//					}
				}
				suspend.clear();
				size1 = tc.getSize();
			}
		}

		Iterator<Cube> iter = suspend.iterator();
		while (iter.hasNext()) {
			Cube tempI = iter.next();
			if (tempI.C0(p)) {
				System.out.println("exit c0 box");
			} else {
				tempI.addV(p);
				Q3.add(tempI);
			}
		}
		suspend.clear();
		return Q3;
	}

	public void reBalance(PriorityQueue<Cube> tempQ, Poly3 p,
			PriorityQueue<Cube> Q2) {
		// PriorityQueue<Cube> tempQ = new PriorityQueue<Cube>(10,new
		// sizeComparator());
		// tempQ.add(c);
		while (!tempQ.isEmpty()) {
			Cube tc = tempQ.poll();
			LinkedList<Cube> tempxp = tc.getxNeighborP();
			LinkedList<Cube> tempxn = tc.getxNeighborN();
			LinkedList<Cube> tempyp = tc.getyNeighborP();
			LinkedList<Cube> tempyn = tc.getyNeighborN();
			LinkedList<Cube> tempzp = tc.getzNeighborP();
			LinkedList<Cube> tempzn = tc.getzNeighborN();

			rebalanceD(tc, tempxp, tempQ, p, Q2);
			rebalanceD(tc, tempxn, tempQ, p, Q2);
			rebalanceD(tc, tempyp, tempQ, p, Q2);
			rebalanceD(tc, tempyn, tempQ, p, Q2);
			rebalanceD(tc, tempzp, tempQ, p, Q2);
			rebalanceD(tc, tempzn, tempQ, p, Q2);
			
			Iterator<Cube> iter=tempxp.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCyp = tempC.getyNeighborP();
				LinkedList<Cube> tempCyn = tempC.getyNeighborN();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				rebalanceEdgeD(tc, tempCyp, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCyn, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCzp, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCzn, tempQ, p, Q2);
			}
			
			iter=tempxn.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCyp = tempC.getyNeighborP();
				LinkedList<Cube> tempCyn = tempC.getyNeighborN();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				rebalanceEdgeD(tc, tempCyp, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCyn, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCzp, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCzn, tempQ, p, Q2);
			}
			
			iter=tempyp.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				rebalanceEdgeD(tc, tempCzp, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCzn, tempQ, p, Q2);
			}
			
			iter=tempyn.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				rebalanceEdgeD(tc, tempCzp, tempQ, p, Q2);
				rebalanceEdgeD(tc, tempCzn, tempQ, p, Q2);
			}
		}
	}

	void rebalanceD(Cube tc, LinkedList<Cube> tempxp,
			PriorityQueue<Cube> tempQ, Poly3 p, PriorityQueue<Cube> Q2) {
		for (int i = 0; i < tempxp.size(); ++i) {
			if (tempxp.get(i).getSize() > 2 * tc.getSize()) {
				Cube tc1 = tempxp.get(i);
				Q2.remove(tc1);
				LinkedList<Cube> temp = tc1.split();
				LinkedList<Point> vs = tc1.getVertices();
				counter += 7;

				for (int j = 0; j < temp.size(); ++j)
					if (temp.get(j).C0(p))
						removeC0(temp.get(j));
					else {
						Cube ttc = temp.get(j);
						for (int k = 0; k < vs.size(); ++k) {
							if (ttc.containPoint(vs.get(k))) {
								Point vp = vs.get(k);
								ttc.getVertices().add(vp);
								if (ttc.belongLeft(vp))
									ttc.getLeftV().add(vp);
								if (ttc.belongRight(vp))
									ttc.getRightV().add(vp);
								if (ttc.belongTop(vp))
									ttc.getTopV().add(vp);
								if (ttc.belongBottom(vp))
									ttc.getBottomV().add(vp);
								if (ttc.belongFront(vp))
									ttc.getFrontV().add(vp);
								if (ttc.belongBack(vp))
									ttc.getBackV().add(vp);
							}
						}
						ttc.addV(p);
						tempQ.add(ttc);
						Q2.add(ttc);
					}
			}
		}
	}
	
	void rebalanceEdgeD(Cube tc, LinkedList<Cube> tempxp,
			PriorityQueue<Cube> tempQ, Poly3 p, PriorityQueue<Cube> Q2) {
		for (int i = 0; i < tempxp.size(); ++i) {
			Cube tc1=tempxp.get(i);
			if (Cube.cubeOverlap(tc1, tc))
			if (tc1.getSize() > 2 * tc.getSize()) {
				Q2.remove(tc1);
				LinkedList<Cube> temp = tc1.split();
				LinkedList<Point> vs = tc1.getVertices();
				counter += 7;

				for (int j = 0; j < temp.size(); ++j)
					if (temp.get(j).C0(p))
						removeC0(temp.get(j));
					else {
						Cube ttc = temp.get(j);
						for (int k = 0; k < vs.size(); ++k) {
							if (ttc.containPoint(vs.get(k))) {
								Point vp = vs.get(k);
								ttc.getVertices().add(vp);
								if (ttc.belongLeft(vp))
									ttc.getLeftV().add(vp);
								if (ttc.belongRight(vp))
									ttc.getRightV().add(vp);
								if (ttc.belongTop(vp))
									ttc.getTopV().add(vp);
								if (ttc.belongBottom(vp))
									ttc.getBottomV().add(vp);
								if (ttc.belongFront(vp))
									ttc.getFrontV().add(vp);
								if (ttc.belongBack(vp))
									ttc.getBackV().add(vp);
							}
						}
						ttc.addV(p);
						tempQ.add(ttc);
						Q2.add(ttc);
					}
			}
		}
	}
}
