import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;

import Geometry.Cube;
import Geometry.Point;
import Polynomial.Poly3;

class Surface extends Shape3D {
//	public static Point positiveP=new Point(0,0,0);
	int counter = 1;
	double vertices[][];
	double temp_vertices[][];
	int faces[][];
	LinkedList<Cube> boxes=new LinkedList<Cube>();
	Matrix3D mTrans = new Matrix3D(); // Transformation Matrix
	Material material = new Material();

//	public void getPositivePoint(Poly3 p){
//		while(p.value(positiveP)<=0){
//			Random r=new Random();
//			positiveP.setX(r.nextDouble());
//		}
//	}
	
	public int numFaces() {
		return faces.length;
	}

	public void getFace(int j, double triangle[][]) {
		for (int i = 0; i < 6; i++) {
			triangle[0][i] = temp_vertices[faces[j][0]][i]; // first vertice
			triangle[1][i] = temp_vertices[faces[j][1]][i]; // second vertice
			triangle[2][i] = temp_vertices[faces[j][2]][i]; // third vertice
		}
	}

	// Set Sphere's material to be used in Phong's algorithm
	public void setMaterial(double ar, double ag, double ab, double dr,
			double dg, double db, double sr, double sg, double sb, int sp) {
		material.setAmbient(ar, ag, ab);
		material.setDiffuse(dr, dg, db);
		material.setSpecular(sr, sg, sb, sp);
	}

	public Material getMaterial() {
		return material;
	}

	public void transform() {
		for (int i = 0; i < faces.length; i++)
			for (int j = 0; j < 3; j++) // transform all 3 vertices
			{
				mTrans.transform(vertices[faces[i][j]],
						temp_vertices[faces[i][j]]); // transform x,y,z
			}
	}

	public void transformPerspective() {
		for (int i = 0; i < faces.length - 1; i++)
			for (int j = 0; j < 3; j++) // transform all 3 vertices
			{
				mTrans.transformPerspective(vertices[faces[i][j]],
						temp_vertices[faces[i][j]]); // transform x,y,z
			}
	}

	public void transform(Matrix3D m) {
		mTrans.copy(m);
		transform();
	}

	public void transformPerspective(Matrix3D m) {
		mTrans.copy(m);
		transformPerspective();
	}

	public Matrix3D getMatrix() {
		return mTrans;
	}

	public void clearMatrix() {
		mTrans.identity();
	}

	public void rotateX(double theta) {
		mTrans.rotateX(theta);
	}

	public void rotateY(double theta) {
		mTrans.rotateY(theta);
	}

	public void rotateZ(double theta) {
		mTrans.rotateZ(theta);
	}

	public void translate(double x, double y, double z) {
		mTrans.translate(x, y, z);
	}

	public void scale(double x, double y, double z) {
		mTrans.scale(x, y, z);
	}

	// This function draws the sphere in the graphic
	public void render(Graphics g, int w, int h) {
		// draw one polygon per face
		for (int i = 0; i < faces.length - 1; i++)
			drawFace(g, i, w, h);
	};

	public void drawFace(Graphics g, int index, int w, int h) {
		int x1, y1, x2, y2;

		// Each face is a polygon with 3 vertices, so we have to draw 3 lines
		for (int j = 0; j < 3; j++) {
			x1 = x(temp_vertices[faces[index][j]][0], w);
			y1 = y(temp_vertices[faces[index][j]][1], w, h);
			if (j + 1 < 3) {
				x2 = x(temp_vertices[faces[index][j + 1]][0], w);
				y2 = y(temp_vertices[faces[index][j + 1]][1], w, h);
			} else // x1,y1 is the last point and has to be connected to the
					// first point
			{
				x2 = x(temp_vertices[faces[index][0]][0], w);
				y2 = y(temp_vertices[faces[index][0]][1], w, h);
			}
			g.drawLine(x1, y1, x2, y2);
		}
	}

	// CONVERT X COORDINATE TO SCREEN PIXELS
	private int x(double x, int w) {
		return (int) (w / 2 + x * w / 2);
	}

	// CONVERT Y COORDINATE TO SCREEN PIXELS
	private int y(double y, int w, int h) {
		return (int) (h / 2 - y * w / 2);
	}
	
	void normalize(double l[]) {
		double t = l[0] * l[0] + l[1] * l[1] + l[2] * l[2];
		if (t != 0 && t != 1) {
			t = (double) (1 / Math.sqrt(t));
		}
		l[0] = l[0] * t;
		l[1] = l[1] * t;
		l[2] = l[2] * t;
	}

//	protected PriorityQueue<Cube> balance(PriorityQueue<Cube> Q, Poly3 p) {
//		PriorityQueue<Cube> B = new PriorityQueue<Cube>(100000,
//				new sizeComparator());
//
//		while (!Q.isEmpty()) {
//			Cube temp = Q.peek();
//			boolean done = true;
//
//			LinkedList<Cube> tempxp = temp.getxNeighborP();
//			LinkedList<Cube> tempxn = temp.getxNeighborN();
//			LinkedList<Cube> tempyp = temp.getyNeighborP();
//			LinkedList<Cube> tempyn = temp.getyNeighborN();
//			LinkedList<Cube> tempzp = temp.getzNeighborP();
//			LinkedList<Cube> tempzn = temp.getzNeighborN();
//
//			for (int i = 0; i < tempxp.size(); ++i) {
//				if (tempxp.get(i).getSize() > 2 * temp.getSize()) {
//					done = false;
//					Q.remove(tempxp.get(i));
//					LinkedList<Cube> tempL = tempxp.get(i).split();
//					counter += 7;
//					for (int j = 0; j < tempL.size(); ++j) {
//						if (tempL.get(j).C0(p)) {
//							Cube t1 = tempL.get(j);
//							removeC0(t1);
//						} else
//							Q.add(tempL.get(j));
//					}
//				}
//			}
//
//			for (int i = 0; i < tempxn.size(); ++i) {
//				if (tempxn.get(i).getSize() > 2 * temp.getSize()) {
//					done = false;
//					Q.remove(tempxn.get(i));
//					LinkedList<Cube> tempL = tempxn.get(i).split();
//					counter += 7;
//					for (int j = 0; j < tempL.size(); ++j) {
//						if (tempL.get(j).C0(p)) {
//							Cube t1 = tempL.get(j);
//							removeC0(t1);
//						} else
//							Q.add(tempL.get(j));
//					}
//				}
//			}
//
//			for (int i = 0; i < tempyp.size(); ++i) {
//				if (tempyp.get(i).getSize() > 2 * temp.getSize()) {
//					done = false;
//					Q.remove(tempyp.get(i));
//					LinkedList<Cube> tempL = tempyp.get(i).split();
//					counter += 7;
//					for (int j = 0; j < tempL.size(); ++j) {
//						if (tempL.get(j).C0(p)) {
//							Cube t1 = tempL.get(j);
//							removeC0(t1);
//						} else
//							Q.add(tempL.get(j));
//					}
//				}
//			}
//
//			for (int i = 0; i < tempyn.size(); ++i) {
//				if (tempyn.get(i).getSize() > 2 * temp.getSize()) {
//					done = false;
//					Q.remove(tempyn.get(i));
//					LinkedList<Cube> tempL = tempyn.get(i).split();
//					counter += 7;
//					for (int j = 0; j < tempL.size(); ++j) {
//						if (tempL.get(j).C0(p)) {
//							Cube t1 = tempL.get(j);
//							removeC0(t1);
//						} else
//							Q.add(tempL.get(j));
//					}
//				}
//			}
//
//			for (int i = 0; i < tempzp.size(); ++i) {
//				if (tempzp.get(i).getSize() > 2 * temp.getSize()) {
//					done = false;
//					Q.remove(tempzp.get(i));
//					LinkedList<Cube> tempL = tempzp.get(i).split();
//					counter += 7;
//					for (int j = 0; j < tempL.size(); ++j) {
//						if (tempL.get(j).C0(p)) {
//							Cube t1 = tempL.get(j);
//							removeC0(t1);
//						} else
//							Q.add(tempL.get(j));
//					}
//				}
//			}
//
//			for (int i = 0; i < tempzn.size(); ++i) {
//				if (tempzn.get(i).getSize() > 2 * temp.getSize()) {
//					done = false;
//					Q.remove(tempzn.get(i));
//					LinkedList<Cube> tempL = tempzn.get(i).split();
//					counter += 7;
//					for (int j = 0; j < tempL.size(); ++j) {
//						if (tempL.get(j).C0(p)) {
//							Cube t1 = tempL.get(j);
//							removeC0(t1);
//						} else
//							Q.add(tempL.get(j));
//					}
//				}
//			}
//
//			if (done) {
//				B.add(temp);
//				Q.remove(temp);
//			}
//		}
//		return B;
//	}
	
	protected PriorityQueue<Cube> balance(PriorityQueue<Cube> Q, Poly3 p) {
		PriorityQueue<Cube> B = new PriorityQueue<Cube>(100000,
				new sizeComparator());

		while (!Q.isEmpty()) {
			Cube temp = Q.peek();
			boolean done = true;

			LinkedList<Cube> tempxp = temp.getxNeighborP();
			LinkedList<Cube> tempxn = temp.getxNeighborN();
			LinkedList<Cube> tempyp = temp.getyNeighborP();
			LinkedList<Cube> tempyn = temp.getyNeighborN();
			LinkedList<Cube> tempzp = temp.getzNeighborP();
			LinkedList<Cube> tempzn = temp.getzNeighborN();
			
			if (!balanceList(Q, p, tempxp, temp))
				done=false;
			if (!balanceList(Q, p, tempxn, temp))
				done=false;
			if (!balanceList(Q, p, tempyp, temp))
				done=false;
			if (!balanceList(Q, p, tempyn, temp))
				done=false;
			if (!balanceList(Q, p, tempzp, temp))
				done=false;
			if (!balanceList(Q, p, tempzn, temp))
				done=false;
			
			Iterator<Cube> iter=tempxp.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCyp = tempC.getyNeighborP();
				LinkedList<Cube> tempCyn = tempC.getyNeighborN();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				if (!balanceEdgeList(Q, p, tempCyp, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCyn, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCzp, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCzn, temp))
					done=false;
			}
			
			iter=tempxn.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCyp = tempC.getyNeighborP();
				LinkedList<Cube> tempCyn = tempC.getyNeighborN();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				if (!balanceEdgeList(Q, p, tempCyp, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCyn, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCzp, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCzn, temp))
					done=false;
			}
			
			iter=tempyp.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				if (!balanceEdgeList(Q, p, tempCzp, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCzn, temp))
					done=false;
			}
			
			iter=tempyn.iterator();
			while (iter.hasNext()){
				Cube tempC=iter.next();
				LinkedList<Cube> tempCzp = tempC.getzNeighborP();
				LinkedList<Cube> tempCzn = tempC.getzNeighborN();
				
				if (!balanceEdgeList(Q, p, tempCzp, temp))
					done=false;
				if (!balanceEdgeList(Q, p, tempCzn, temp))
					done=false;
			}
			
			if (done) {
				B.add(temp);
				Q.remove(temp);
			}
		}
		return B;
	}
	
	public boolean balanceList(PriorityQueue<Cube> Q, Poly3 p, LinkedList<Cube> list, Cube c){
		boolean done=true;
		for (int i = 0; i < list.size(); ++i) {
			Cube tempC=list.get(i);
			if (tempC.getSize() > 2 * c.getSize()) {
				done = false;
				Q.remove(tempC);
				LinkedList<Cube> tempL = tempC.split();
				counter += 7;
				for (int j = 0; j < tempL.size(); ++j) {
					if (tempL.get(j).C0(p)) {
						Cube t1 = tempL.get(j);
						removeC0(t1);
					} else
						Q.add(tempL.get(j));
				}
			}
		}
		return done;
	}
	
	public boolean balanceEdgeList(PriorityQueue<Cube> Q, Poly3 p, LinkedList<Cube> list, Cube c){
		boolean done=true;
		for (int i = 0; i < list.size(); ++i) {
			Cube tempC=list.get(i);
			if (Cube.cubeOverlap(tempC, c))
			if (tempC.getSize() > 2 * c.getSize()) {
				done = false;
				Q.remove(tempC);
				LinkedList<Cube> tempL = tempC.split();
				counter += 7;
				for (int j = 0; j < tempL.size(); ++j) {
					if (tempL.get(j).C0(p)) {
						Cube t1 = tempL.get(j);
						removeC0(t1);
					} else
						Q.add(tempL.get(j));
				}
			}
		}
		return done;
	}

	public void removeC0(Cube t1) {
		for (int g = 0; g < t1.getxNeighborN().size(); ++g)
			t1.getxNeighborN().get(g).getxNeighborP().remove(t1);
		for (int g = 0; g < t1.getxNeighborP().size(); ++g)
			t1.getxNeighborP().get(g).getxNeighborN().remove(t1);
		for (int g = 0; g < t1.getyNeighborN().size(); ++g)
			t1.getyNeighborN().get(g).getyNeighborP().remove(t1);
		for (int g = 0; g < t1.getyNeighborP().size(); ++g)
			t1.getyNeighborP().get(g).getyNeighborN().remove(t1);
		for (int g = 0; g < t1.getzNeighborN().size(); ++g)
			t1.getzNeighborN().get(g).getzNeighborP().remove(t1);
		for (int g = 0; g < t1.getzNeighborP().size(); ++g)
			t1.getzNeighborP().get(g).getzNeighborN().remove(t1);
	}

	public void setFaces(HashMap<Point, Integer> v, ArrayList<Point[]> f,
			Poly3 px, Poly3 py, Poly3 pz, double sizeFactor) {
		vertices = new double[v.size()][6];
		temp_vertices = new double[v.size()][6];
		faces = new int[f.size()][3];
		int t = 0;
		Iterator<Map.Entry<Point, Integer>> iter = v.entrySet().iterator();
		Point[] temp = new Point[v.size()];
		while (iter.hasNext()) {
			Map.Entry<Point, Integer> e = iter.next();
			Point pp = e.getKey();
			temp_vertices[t][0] = vertices[t][0] = pp.getX() / sizeFactor;
			temp_vertices[t][1] = vertices[t][1] = pp.getY() / sizeFactor;
			temp_vertices[t][2] = vertices[t][2] = pp.getZ() / sizeFactor;
			temp_vertices[t][3] = vertices[t][3] = px.value(pp) / sizeFactor;
			temp_vertices[t][4] = vertices[t][4] = py.value(pp) / sizeFactor;
			temp_vertices[t][5] = vertices[t][5] = pz.value(pp) / sizeFactor;
			// normalize(vertices[t]);
			// normalize(temp_vertices[t]);
			temp[t] = pp;
			++t;
		}

		for (int s = 0; s < temp.length; ++s)
			v.put(temp[s], s);

		for (int u = 0; u < faces.length; ++u) {
			Point[] pf = f.get(u);
			faces[u][0] = v.get(pf[0]);
			faces[u][1] = v.get(pf[1]);
			faces[u][2] = v.get(pf[2]);
		}
	}
	
	void checkDuplication(PriorityQueue<Cube> Q) {
		Cube[] abc = Q.toArray(new Cube[0]);
		for (int i = 0; i < abc.length; ++i)
			for (int j = i + 1; j < abc.length; ++j)
				if (abc[i].equal(abc[j]))
					System.out.println("duplicate!!!!!!!!!!!!!");
	}
	
	void checkInclusion(PriorityQueue<Cube> Q) {
		Cube[] abc = Q.toArray(new Cube[0]);
		for (int i = 0; i < abc.length; ++i)
			for (int j = i + 1; j < abc.length; ++j)
				if (include(abc[i], abc[j]) || include(abc[j], abc[i]))
					System.out.println("include!!!!!!!!!!!!!");
	}

	boolean include(Cube a, Cube b) {
		Point a1 = a.getA();
		Point a2 = a.getB();
		Point b1 = b.getA();
		Point b2 = b.getB();
		return (a1.getX() <= b1.getX() && a1.getY() <= b1.getY()
				&& a1.getZ() <= b1.getZ() && a2.getX() >= b2.getX()
				&& a2.getY() >= b2.getY() && a2.getZ() >= b2.getZ());
	}
	
	public void outputObj(String filename){
		BufferedWriter bufferedWriter = null;
		
		try {
			
			bufferedWriter = new BufferedWriter(new FileWriter(filename));
			for (int i=0; i<vertices.length; ++i){
				bufferedWriter.write("v "+vertices[i][0]+" "+vertices[i][1]+" "+vertices[i][2]);
				bufferedWriter.newLine();
			}

			for (int i=0; i<faces.length; ++i){
				bufferedWriter.write("f "+(faces[i][0]+1)+" "+(faces[i][1]+1)+" "+(faces[i][2]+1));
				bufferedWriter.newLine();
			}
			bufferedWriter.close();
		}catch (IOException e) {
				e.printStackTrace();
		}
	}
	
	public void outputBox(String filename){
		BufferedWriter bufferedWriter = null;
		
		try {
			bufferedWriter = new BufferedWriter(new FileWriter(filename));
			Iterator<Cube> iter=boxes.iterator();
			int index=1;
			while (iter.hasNext()){
				Cube c=iter.next();
				Point[] corners=new Point[8];
				corners[0] = c.getA();
				corners[1] = new Point(c.getA().getX(), c.getA().getY(), c.getB().getZ());
				corners[2] = new Point(c.getA().getX(), c.getB().getY(), c.getB().getZ());
				corners[3] = new Point(c.getA().getX(), c.getB().getY(), c.getA().getZ());
				// right face
				corners[4] = new Point(c.getB().getX(), c.getA().getY(), c.getA().getZ());
				corners[5] = new Point(c.getB().getX(), c.getA().getY(), c.getB().getZ());
				corners[6] = c.getB();
				corners[7] = new Point(c.getB().getX(), c.getB().getY(), c.getA().getZ());
				
				for (int i=0; i<8; ++i){
					bufferedWriter.write("v "+corners[i].getX()+" "+corners[i].getY()+" "+corners[i].getZ());
					bufferedWriter.newLine();
				}
				bufferedWriter.write("f "+(index+0)+" "+(index+1)+" "+(index+2));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+2)+" "+(index+3));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+7)+" "+(index+4));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+3)+" "+(index+7));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+4)+" "+(index+6)+" "+(index+5));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+4)+" "+(index+7)+" "+(index+6));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+1)+" "+(index+6)+" "+(index+2));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+1)+" "+(index+5)+" "+(index+6));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+2)+" "+(index+7)+" "+(index+3));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+2)+" "+(index+6)+" "+(index+7));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+5)+" "+(index+1));
				bufferedWriter.newLine();
				bufferedWriter.write("f "+(index+0)+" "+(index+4)+" "+(index+5));
				bufferedWriter.newLine();

//				bufferedWriter.write("c "+"A: "+c.getA().getX()+" "+c.getA().getY()+" "+c.getA().getZ()
//						+" B: "+c.getB().getX()+" "+c.getB().getY()+" "+c.getB().getZ());
//				bufferedWriter.newLine();
				index+=8;
			}
			bufferedWriter.close();
		}catch (IOException e) {
				e.printStackTrace();
		}
	}

}
