package Polynomial;
/**
 * This is a parser for polynomial
 * @input A string
 * @return A numerical expression of the polynomial
 * @author Long Lin
 *
 */

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Scanner;

import Geometry.Point;

public class Polynomial{
	
	/**
	 * Number of variables
	 */
	private int N;
	
	/**
	 * List of monomials
	 */
	private LinkedList<Monomial> terms;
	
	Polynomial(){
		N=0;
		terms=new LinkedList<Monomial>();
	}
	
	Polynomial(String T, int n){
		N=n;
		terms=new LinkedList<Monomial>();
		while (T.substring(1).contains("+") || T.substring(1).contains("-")){
			int i=1;

			while ((T.charAt(i)!='+') && (T.charAt(i)!='-'))
				++i;

			String sub=T.substring(0, i);

			terms.add(new Monomial(sub, n));
			T=T.substring(i);
		}
		terms.add(new Monomial(T, n));
	}
	
	public int getN(){
		return N;
	}
	
	public void setN(int n){
		N=n;
	}
	
	public LinkedList<Monomial> getTerms(){
		return terms; 
	}
	
	@SuppressWarnings("unchecked")
	public void setTerms(LinkedList<Monomial> t){
		terms=(LinkedList<Monomial>)t.clone();
	}
	
	public double value(double[] p){
		double v=0;
		for (int i=0; i<terms.size(); i++){
			v+=terms.get(i).value(p);
		}
		return v;
	}
	
	public double value(Point p){
		return value(new double[]{p.getX(), p.getY(), p.getZ()});
	}
	
	public int sign(Point p){
		double v=value(p);
		if (v<0)
			return -1;
		else
			return 1;
	}
	
	public Polynomial derivative(char c){
		Polynomial p1=new Polynomial();

		LinkedList<Monomial> t1=new LinkedList<Monomial>();
		for (int i=0; i<terms.size(); i++)
			t1.add(terms.get(i).derivative(c));
		
		p1.setN(N);
		p1.setTerms(t1);
		return p1;
	}
	
	public void print(){
		System.out.println("This polynomials has "+terms.size()+" terms:");
		for (int i=0; i<terms.size(); ++i)
			terms.get(i).print();
	}
	
	void error(String T){
		System.out.println("Wrong format:"+T);
	}
	
	public static String getS(String p){
		String a=" ";
		try{
			Scanner scan=new Scanner(new File(p));
			a=scan.nextLine();
			System.out.println(a);	 
			
		}catch (IOException e) {
			System.err.println("IOException");
		}
		return a;
	}
}
