package Polynomial;
/**
 * This is the parser for polynomials with 2 variables
 * @author Long Lin
 */

import java.util.LinkedList;

public class Poly3 extends Polynomial{
	
	/*
	 * The highest degree of this polynomial respected to 'y'
	 */
	private int deg;

	/*
	 * The coefficient for each term respected to 'y', from degree high to degree low
	 */
	private Poly2[] coeff;
	
	public Poly3(){
		super();
		deg=0;
		coeff=new Poly2[0];
	}
	
	@SuppressWarnings("unchecked")
	public
	Poly3(String T){
		super(T,3);
		
		//get the highest degree
		for (int i=0; i<this.getTerms().size(); i++){
			Monomial m=this.getTerms().get(i);
			if (m.getDeg()[2]>deg)
				deg=m.getDeg()[2];
		}
		
		//initialize each coefficient
		coeff=new Poly2[deg+1];
		
		LinkedList<Monomial>[] temp=(LinkedList<Monomial>[]) new LinkedList[deg+1];
		
		for (int i=0; i<=deg; i++)
			temp[i]=new LinkedList<Monomial>();
		
		for (int i=0; i<this.getTerms().size(); i++){
			Monomial m=this.getTerms().get(i);	
			temp[m.getDeg()[2]].add(m.subMonomial());
		}

		
		for (int i=0; i<=deg; i++){
			//System.out.println("i="+i+" size="+temp[i].size());
			coeff[i]=new Poly2(temp[i]);
		}
		
	}
	
	@SuppressWarnings("unchecked")
	Poly3(LinkedList<Monomial> t){
		super.setN(3);
		super.setTerms(t);
		
		deg=0;
		
		for (int i=0; i<t.size(); i++)
			if (t.get(i).getDeg()[2]>deg)
				deg=t.get(i).getDeg()[2];
		
		coeff=new Poly2[deg+1];
		
		LinkedList<Monomial>[] temp=(LinkedList<Monomial>[]) new LinkedList[deg+1]; 
		
		for (int i=0; i<=deg; i++)
			temp[i]=new LinkedList<Monomial>();
		
		for (int i=0; i<t.size(); i++){
			Monomial m=t.get(i);	
			temp[m.getDeg()[2]].add(m.subMonomial());
		}

		
		for (int i=0; i<=deg; i++){
			//System.out.println("i="+i+" size="+temp[i].size());
			coeff[i]=new Poly2(temp[i]);
		}
		
	}
	
	public Poly3 derivative(char c){
		Poly3 p1=new Poly3(super.derivative(c).getTerms());
		return p1;
	}
	
	public Interval value(Interval[] I){
		Interval x=I[0];
		Interval y=I[1];
		Interval z=I[2];
		
		Interval temp=coeff[deg].value(new Interval[]{x,y});
		//temp.print();
		Interval temp1=new Interval();
		for (int i=deg-1; i>=0; i--){
			//System.out.println("-----------------------");
			temp1=temp.multiply(temp, z);
			//temp1.print();
			temp=temp.plus(temp1, coeff[i].value(new Interval[]{x,y}));
			//temp.print();
		}
		return temp;
	}
	
	public boolean containZero(Interval[] I){
		return (value(I).zero());
	}
	
	public void print(){
		System.out.println("Poly3");
		System.out.println("Degree: "+deg);
		System.out.println("Coefficients: ");
		for (int i=0; i<coeff.length; i++){
			System.out.print(i+" ");
			coeff[i].print();
		}
	}
}
