package Polynomial;
import java.util.LinkedList;


/**
 * This is the parser for polynomials with 1 variable
 * @author Long Lin
 */

public class Poly1 extends Polynomial{
	
	/*
	 * The highest degree of this polynomial
	 */
	private int deg;
	
	/*
	 * The coefficient for each term, from degree high to degree low
	 */
	private double[] coeff;
	
	Poly1(){
		super();
		deg=0;
		coeff=new double[0];
	}
	
	Poly1(String T){
		super(T,1);
		//get the highest degree of the polynomial
		for (int i=0; i<this.getTerms().size(); i++){
			Monomial m=this.getTerms().get(i);
			if (m.getDeg()[0]>deg)
				deg=m.getDeg()[0];
		}
		
		coeff=new double[deg+1];
		
		for (int i=0; i<this.getTerms().size(); i++){
			Monomial m=this.getTerms().get(i);
			coeff[m.getDeg()[0]]=m.getCoeff();
		}
	}
	
	Poly1(LinkedList<Monomial> t){
		super.setN(1);
		super.setTerms(t);
		
		deg=0;
		
		for (int i=0; i<t.size(); i++)
			if (t.get(i).getDeg()[0]>deg)
				deg=t.get(i).getDeg()[0];
		
		coeff=new double[deg+1];
		
		for (int i=0; i<t.size(); i++)
			coeff[t.get(i).getDeg()[0]]=t.get(i).getCoeff();
	}
	
	public int getDeg(){
		return this.deg;
	}
	
	public double[] getCoeff(){
		return this.coeff;
	}
	
	public void setDeg(int d){
		deg=d;
	}
	
	public void setCoeff(double[] c){
		coeff=c.clone();
	}
	
	public Poly1 derivative(char c){
		Poly1 p1=new Poly1(super.derivative(c).getTerms());
		return p1;
	}
	
	public Interval value(Interval[] I){
		Interval x=I[0];
		
		Interval temp=new Interval(coeff[deg], coeff[deg]);
		Interval temp1=new Interval();
		for (int i=deg-1; i>=0; i--){		
			double c=coeff[i];
			temp1=temp.multiply(temp, x);
			//temp1.print();
			temp=temp.plus(temp1, new Interval(c, c));
			//temp.print();
		}
		return temp;
	}
	
	public void print(){
		System.out.println("Poly1");
		System.out.println("Degree: "+deg);
		System.out.print("Coefficients: ");
		for (int i=0; i<coeff.length; i++)
			System.out.print(coeff[i]+" ");
		System.out.println();
	}

}
