package Polynomial;
/**
 * This is a parser for monomial
 * @input A string
 * @return A numerical expression of the monomial
 * @author Long Lin
 *
 */

public class Monomial {
	
	/**
	 * Number of variables, maximum 3
	 */
	private int N;
	
	/**
	 * A list of degrees of variables
	 */
	private int[] deg;
	
	/**
	 * Coefficient of this monomial, which is always positive
	 */
	private double coeff;
	
	Monomial(){
		N=0;
		deg=new int[N];
		coeff=0;
	}
	
	Monomial(int n, int[] d, double c){
		N=n;
		deg=d;
		coeff=c;
	}
	
	Monomial(String T, int n){
		N=n;
		deg=new int[N];
		coeff=0;
		if (T.isEmpty())
			System.out.println("Error: empty term");
		else if (T.charAt(0)=='x' || T.charAt(0)=='y' || T.charAt(0)=='z') 
			coeff=1;
		else if (!T.contains("*")){
			if ((T.charAt(0)=='+')&&(T.charAt(1)=='x' || T.charAt(1)=='y' || T.charAt(1)=='z'))
				coeff=1;
			else if ((T.charAt(0)=='-')&&(T.charAt(1)=='x' || T.charAt(1)=='y' || T.charAt(1)=='z'))
				coeff=-1;
			else
				coeff=Double.parseDouble(T);
		}
		else{
			int i=0;
			while (T.charAt(i)!='*'){
				++i;
			}
			String sub=T.subSequence(0, i).toString();
			coeff=Double.parseDouble(sub);
			T=T.substring(i+1);
		}
		
		
		while (T.contains("*")){
			int i=0;
			while (T.charAt(i)!='*'){
				//System.out.println(i+" "+T.charAt(i));
				i++;
			}
			//System.out.println(i);
			String sub=T.subSequence(0, i).toString();
			//System.out.println(sub);
			if (sub.contains("x")){
				if (!sub.contains("^"))
					deg[0]=1;
				else
					deg[0]=Integer.parseInt(sub.substring(sub.indexOf('^')+1));
			}
			else if (sub.contains("y")){
				if (!sub.contains("^"))
					deg[1]=1;
				else
					deg[1]=Integer.parseInt(sub.substring(sub.indexOf('^')+1));
			}
			else{
				if (!sub.contains("^"))
					deg[2]=1;
				else
					deg[2]=Integer.parseInt(sub.substring(sub.indexOf('^')+1));
			}
			
				T=T.substring(i+1);
			}
			if (T.contains("x")){
				if (!T.contains("^"))
					deg[0]=1;
				else
					deg[0]=Integer.parseInt(T.substring(T.indexOf('^')+1));
			}
			else if (T.contains("y")){
				if (!T.contains("^"))
					deg[1]=1;
				else
					deg[1]=Integer.parseInt(T.substring(T.indexOf('^')+1));
			}
			else if (T.contains("z")){
				if (!T.contains("^"))
					deg[2]=1;
				else
					deg[2]=Integer.parseInt(T.substring(T.indexOf('^')+1));
			}
			
		}
	
	public int getN(){
		return N;
	}
	
	public int[] getDeg(){
		return deg;
	}
	
	public double getCoeff(){
		return coeff;
	}
	
	public void setN(int n){
		N=n;
	}
	
	public void setDeg(int[] d){
		deg=d.clone();
	}
	
	public void setCoeff(double c){
		coeff=c;
	}
	
	public Monomial subMonomial(){
		int[] deg1=new int[deg.length-1];
		for (int i=0; i<deg.length-1; i++)
			deg1[i]=deg[i];
		return new Monomial(N-1, deg1, coeff);
	}
	
	public double value(double[] p){
		double v=this.coeff;
		if (p.length < N)
			System.out.println("input value inadequete");
		for (int i=0; i<N; i++)
			v*=Math.pow(p[i], deg[i]);
		return v;
	}

	public Monomial derivative(char c){
		if (c=='x'){
			if (deg[0]==0)
				return new Monomial(N, new int[N], 0);
			else{
				double coeff1=coeff*deg[0];
				int[] deg1=deg.clone();
				deg1[0]=deg[0]-1;
				return new Monomial(N, deg1, coeff1);
			}
		}
		else if (c=='y'){
			if (deg[1]==0)
				return new Monomial(N, new int[N], 0);
			else{
				double coeff1=coeff*deg[1];
				int[] deg1=deg.clone();
				deg1[1]=deg[1]-1;
				return new Monomial(N, deg1, coeff1);
			}
		}
		else if (c=='z'){
			if (deg[2]==0)
				return new Monomial(N, new int[N], 0);
			else{
				double coeff1=coeff*deg[2];
				int[] deg1=deg.clone();
				deg1[2]=deg[2]-1;
				return new Monomial(N, deg1, coeff1);
			}
		}
		else{
			System.out.println("no such variable");
			return this;
		}
	}
	
	void print(){
		System.out.println("# of variables: "+N+" coefficient: "+coeff);
		System.out.print("degrees: ");
		for (int i=0; i<deg.length; ++i)
			  System.out.print(deg[i]+" ");
		System.out.println();
	}
	
	void error(String T){
		System.out.println("Wrong format:"+T);
	}
}
