package Polynomial;
/**
 * Class of Interval Arithmetic
 * @author Long Lin
 *
 */

public class Interval {
	private double a;
	private double b;
	
	public Interval(){
		this.a=0;
		this.b=0;
	}
	
	public Interval(double a, double b){
		if (a<=b){
			this.a=a;
			this.b=b;
		}
		else{
			this.a=b;
			this.b=a;
		}
	}
	
	public void copy(Interval I){
		this.a=I.a;
		this.b=I.b;
	}
	
	public double[] getInterval(){
		return new double[]{this.a, this.b};
	}
	
	public double getA(){
		return this.a;
	}
	
	public double getB(){
		return this.b;
	}
	
	public void setA(double a){
		this.a=a;
	}
	
	public void setB(double b){
		this.b=b;
	}
	
	public boolean zero(){
		return (this.a<=0)&&(this.b>=0);
	}
	
	public Interval multiply(Interval s, Interval t){
		Interval I=new Interval(
		Math.min(Math.min(s.a*t.a, s.a*t.b),Math.min(s.b*t.a, s.b*t.b)),
		Math.max(Math.max(s.a*t.a, s.a*t.b),Math.max(s.b*t.a, s.b*t.b)));
		return I;
	}
	
	public Interval plus(Interval s, Interval t){
		Interval I=new Interval(
		s.a+t.a,
		s.b+t.b);
		return I;
	}
	
	public Interval minus(Interval s, Interval t){
		Interval I=new Interval(
		s.a-t.b,
		s.b-t.a);
		return I;
	}
	
	public Interval divide(Interval s, Interval t){
		Interval I=new Interval();
		if (t.zero())
			System.out.println("Error: Enominator includes zero.");
		else{
			I.setA(Math.min(Math.min(s.a/t.a, s.a/t.b),Math.min(s.b/t.a, s.b/t.b)));
			I.setB(Math.max(Math.max(s.a/t.a, s.a/t.b),Math.max(s.b/t.a, s.b/t.b)));
		}
		return I;
	}
	
	public void print(){
		System.out.println(this.a+" "+this.b);
	}
	
	public boolean overlap(Interval s, Interval t){
		return (!((s.b<=t.a)||(s.a>=t.b)));
	}
	
	public boolean contain(double d){
		return (d>a && d<b);
	}
	
	public double length(){
		return b-a;
	}
	
}
