public class Matrix3D 
{
   // Matrix data
   double data[][] = new double[4][4];

   // set the value to M(i,j) 
   public void set(int i, int j, double value) { data[i][j] = value;}

   // get the value of M(i,j)
   public double get(int i, int j) {return data[i][j];}
   
   // ------------------------------------------------------------------------------
   // primitive methods to create identity, rotation, translation and scale Matrices
   // ------------------------------------------------------------------------------

   // matrix copy
   public void copy(Matrix3D M)
   {
      for (int i = 0; i < 4; i++) // run through all the rows
      for (int j = 0; j < 4; j++) // run through all the columns
	  set(i, j, M.get(i,j));
   }
  
   public double[][] getData()
   { return this.data; }

   // build 4 by 4 identity matrix
   public void identity() 
   {
       int ii, jj;
       for(ii=0; ii<4; ++ii)
           for(jj=0; jj<4; ++jj)
           {
                if(ii == jj) 
                    data[ii][jj] = 1;
                else
                    data[ii][jj] = 0;
           }
   };

   // build translation matrix for x,y,z 
   public void translationMatrix(double x, double y, double z) 
   {
      identity();
      data[0][3] = x;
      data[1][3] = y;
      data[2][3] = z;
   }

   // build theta x rotation matrix
   public void xRotationMatrix(double theta)
   {
      identity();
      data[1][1] = Math.cos(theta);
      data[1][2] = -Math.sin(theta);
      data[2][1] = Math.sin(theta);
      data[2][2] = Math.cos(theta);
   }

   // build theta y rotation matrix
   public void yRotationMatrix(double theta)
   {
      identity();
      data[0][0] = Math.cos(theta);
      data[0][2] = Math.sin(theta);
      data[2][0] = -Math.sin(theta);
      data[2][2] = Math.cos(theta);
   }

   // build theta y rotation matrix
   public void yRotationMatrix_new(double theta)
   {  
      identity();
      data[0][0] = Math.cos(theta); 
      data[0][2] = Math.sin(theta);
      data[2][0] = -Math.sin(theta);
      data[2][2] = Math.cos(theta);
   }
  

   // build theta z rotation matrix
   public void zRotationMatrix(double theta)
   {
      identity();
      data[0][0] = Math.cos(theta);
      data[0][1] = -Math.sin(theta);
      data[1][0] = Math.sin(theta);
      data[1][1] = Math.cos(theta);
   }

   // build perspective matrix
   public void perspectiveMatrix(double f)
   {
      identity(); 
      // ???
   }

   // build scale matrix for x,y,z
   public void scaleMatrix(double x, double y, double z)
   {
      identity();
      data[0][0] = x;
      data[1][1] = y;
      data[2][2] = z;
   }

   // ------------------------------------------
   // methods to transform one matrix by another
   // ------------------------------------------
   
   // matrix multiplication
   public void multiply(Matrix3D M)
   {  Matrix3D temp = new Matrix3D();
      temp.copy(this);      // FIRST COPY MY ORIGINAL DATA TO A TEMPORARY MATRIX
      for (int i = 0 ; i < 4 ; i++)
      for (int j = 0 ; j < 4 ; j++) {
         double sum = 0;
         for (int k = 0 ; k < 4 ; k++)
         sum += temp.get(i,k) * M.get(k,j);
         data[i][j] = sum;  // THEN COMPUTE NEW DATA VALUES FOR ME
      }
   }

   public void invert(Matrix3D srcMatrix) 
   {
      double src[][] = srcMatrix.getData();
      double dst[][] = this.data;

      // COMPUTE ADJOINT COFACTOR MATRIX FOR THE ROTATION+SCALE 3x3

      for (int i = 0; i < 3; i++)
         for (int j = 0; j < 3; j++) {
            int i0 = (i + 1) % 3, i1 = (i + 2) % 3;
            int j0 = (j + 1) % 3, j1 = (j + 2) % 3;
            dst[j][i] = src[i0][j0] * src[i1][j1] -
                        src[i0][j1] * src[i1][j0];
         }

      // RENORMALIZE BY DETERMINANT TO GET ROTATION+SCALE 3x3 INVERSE

      double determinant = src[0][0] * dst[0][0] +
                           src[1][0] * dst[0][1] +
                           src[2][0] * dst[0][2];

      for (int i = 0; i < 3; i++)
         for (int j = 0; j < 3; j++)
            dst[i][j] /= determinant;

      // COMPUTE INVERSE TRANSLATION

      for (int i = 0; i < 3; i++)
         dst[i][3] = - dst[i][0] * src[0][3] -
                       dst[i][1] * src[1][3] -
                       dst[i][2] * src[2][3];

      dst[3][3] = 1.0;
   }

   // matrix translation
   public void translate(double a, double b, double c)
   {  Matrix3D temp = new Matrix3D();
      temp.translationMatrix(a, b, c);	
      this.multiply(temp);	
   }

   // matrix rotation in X
   public void rotateX(double theta)
   {  Matrix3D temp = new Matrix3D(); 
      temp.xRotationMatrix(theta);
      this.multiply(temp);
   }

   // matrix rotation in Y
   public void rotateY(double theta)
   {  Matrix3D temp = new Matrix3D(); 
      temp.yRotationMatrix(theta);
      this.multiply(temp);
   }

   // matrix rotation in Z
   public void rotateZ(double theta)
   {  Matrix3D temp = new Matrix3D(); 
      temp.zRotationMatrix(theta);
      this.multiply(temp);
   }

   // matrix perspective
   public void perspective(double f)
   { Matrix3D temp = new Matrix3D();
     temp.perspectiveMatrix(f);
     this.multiply(temp);
   }   

   // matrix scaling
   public void scale(double a, double b, double c)
   {  Matrix3D temp = new Matrix3D();
      temp.scaleMatrix(a, b, c);
      this.multiply(temp);
   }

   // matrix transpose to be used when tranforming normals
   public void transpose() 
   {  Matrix3D temp = new Matrix3D();
      temp.copy(this); 			// FIRST COPY TO A TEMPORARY MATRIX
      for (int i=0; i < 4; i++)
      {  for (int j=0; j < 4; j++)
         { data[i][j] = temp.get(j,i); }
      }
   }

   // transform vertices using the Matrix
   public void transform(double src[], double dst[])
   {  Matrix3D temp1 = new Matrix3D();
      Matrix3D temp2 = new Matrix3D();
      temp1.copy(this);

      // transform x, y, z
      for (int i = 0; i < 3; i++)
         dst[i] = data[i][0] * src[0] + data[i][1] * src[1] + data[i][2] * src[2] + data[i][3];
   
      // transform normals nx, ny, nz
      temp2.invert(temp1);
      temp2.transpose();

      dst[3] = temp2.data[0][0] * src[3] + temp2.data[0][1] * src[4] + temp2.data[0][2] * src[5];
      dst[4] = temp2.data[1][0] * src[3] + temp2.data[1][1] * src[4] + temp2.data[1][2] * src[5]; 
      dst[5] = temp2.data[2][0] * src[3] + temp2.data[2][1] * src[4] + temp2.data[2][2] * src[5];    
   }

   // perpective transform
   public void transformPerspective(double src[], double dst[])
   {  
      for (int i = 0; i < 3; i++)
      { dst[i] = data[i][0] * src[0] + data[i][1] * src[1] + data[i][2] * src[2] + data[i][3];} 
      
      // focal length is -3  
      dst[0] =  -3.0 * dst[0] / dst[2]; // x -> -f * x/z where f is 3
      dst[1] =  -3.0 * dst[1] / dst[2]; // y -> -f * y/z where f is 3
      dst[2] =  -3.0 / dst[2];         
   }

}
