package Geometry;

import java.util.LinkedList;
import Polynomial.Interval;

public class Point {
	private double X;
	private double Y;
	private double Z;
	
	LinkedList<Point> linkedPoints;
	
	public Point(){
		X=0;
		Y=0;
		Z=0;
		linkedPoints=new LinkedList<Point>();
	}
	
	public Point(double x, double y, double z){
		X=x;
		Y=y;
		Z=z;
		linkedPoints=new LinkedList<Point>();
	}
	
	public Point(Point p){
		X=p.getX();
		Y=p.getY();
		Z=p.getZ();
		linkedPoints=new LinkedList<Point>();
	}
	
	@SuppressWarnings("unchecked")
	public void copy(Point p){
		X=p.getX();
		Y=p.getY();
		Z=p.getZ();
		linkedPoints=(LinkedList<Point>)p.getLinks().clone();
	}
	
	public void addLink(Point p){
		if (!exist(p))
			linkedPoints.add(p);
		//if (linkedPoints.size()>2)
		//	System.err.println("linking points greater than two.");
	}
	
	public boolean exist(Point p){
		for (int i=0; i<linkedPoints.size(); ++i)
			if (linkedPoints.get(i).equal(p))
				return true;
		return false;
	}
	
	public LinkedList<Point> getLinks(){
		return linkedPoints;
	}
	
	public double getX(){
		return X;
	}
	
	public double getY(){
		return Y;
	}
	
	public double getZ(){
		return Z;
	}
	
	public void setX(double x){
		X=x;
	}
	
	public void setY(double y){
		Y=y;
	}
	
	public void setZ(double z){
		Z=z;
	}
	
	public boolean equal(Point p){
		return (X==p.getX() && Y==p.getY() && Z==p.getZ());
	}
	
	public boolean contain(Point a, Point b){
		if (a.X==b.X){
			if (a.Y==b.Y)
				return (this.Y==a.Y && this.X==a.X && (new Interval(a.Z, b.Z)).contain(this.Z));
			else if (a.Z==b.Z)
				return (this.X==a.X && this.Z==a.Z && (new Interval(a.Y, b.Y)).contain(this.Y));
			else{
				System.err.println("point a and b are not on the same line.");
				return false;
			}
		}
		if (a.Y==b.Y && a.Z==b.Z){
			return (this.Y==a.Y && this.Z==a.Z && (new Interval(a.X, b.X)).contain(this.X));
		}
		else{
			System.err.println("point a and b are not on the same line.");
			return false;
		}
	}
	
	public void print(){
		System.out.println("point: "+X+" "+Y+" "+Z);
	}
	
	public void printLink(){
		System.out.println("this point");
		this.print();
		System.out.println("linked points:");
		for (int i=0; i<linkedPoints.size(); ++i)
			linkedPoints.get(i).print();
	}
}
