
public class Point {
	private double x;
	private double y;
	
	Point(){
		this.x=0;
		this.y=0;
	}
	
	Point(double x, double y){
		this.x=x;
		this.y=y;
	}
	
	public void copy(Point p){
		this.x=p.x;
		this.y=p.y;
	}
	
	public double[] getPoint(){
		return new double[]{this.x, this.y};
	}
	
	public double getX(){
		return this.x;
	}
	
	public double getY(){
		return this.y;
	}
	
	public void setX(double x){
		this.x=x;
	}
	
	public void setY(double y){
		this.y=y;
	}
	
	public int sign(){
		double value=new ImplicitCurve().value(x, y);
		if (value<0)
			return -1;
		if (value>0)
			return 1;
		else
			return 1;
	}
	
	public void print(){
		System.out.println(this.x+" "+this.y);
	}
	
	//return true if this point contains in the edge (a,b).
	public boolean contain(Point a, Point b){
		boolean e=false;
		if ((x==a.getX())&&(x==b.getX())){
			if (((a.getY()<y)&&(y<b.getY()))||((a.getY()>y)&&(y>b.getY())))
				e=true;
		}
		if ((y==a.getY())&&(y==b.getY())){
			if (((a.getX()<x)&&(x<b.getX()))||((a.getX()>x)&&(x>b.getX())))
				e=true;
		}
		return e;
	}
}
