//import java.math.*;

public class Interval {
	private double a;
	private double b;
	
	Interval(){
		this.a=0;
		this.b=0;
	}
	
	Interval(double a, double b){
		this.a=a;
		this.b=b;
	}
	
	public void copy(Interval I){
		this.a=I.a;
		this.b=I.b;
	}
	
	public double[] getInterval(){
		return new double[]{this.a, this.b};
	}
	
	public double getA(){
		return this.a;
	}
	
	public double getB(){
		return this.b;
	}
	
	public void setA(double a){
		this.a=a;
	}
	
	public void setB(double b){
		this.b=b;
	}
	
	public boolean zero(){
		return (this.a<=0)&&(this.b>=0);
	}
	
	public Interval multiply(Interval s, Interval t){
		this.a=Math.min(Math.min(s.a*t.a, s.a*t.b),Math.min(s.b*t.a, s.b*t.b));
		this.b=Math.max(Math.max(s.a*t.a, s.a*t.b),Math.max(s.b*t.a, s.b*t.b));
		return this;
	}
	
	public Interval plus(Interval s, Interval t){
		this.a=s.a+t.a;
		this.b=s.b+t.b;
		return this;
	}
	
	public Interval minus(Interval s, Interval t){
		this.a=s.a-t.b;
		this.b=s.b-t.a;
		return this;
	}
	
	public Interval divide(Interval s, Interval t){
		if (t.zero())
			System.out.println("Error: Enominator includes zero.");
		else{
			this.a=Math.min(Math.min(s.a/t.a, s.a/t.b),Math.min(s.b/t.a, s.b/t.b));
			this.b=Math.max(Math.max(s.a/t.a, s.a/t.b),Math.max(s.b/t.a, s.b/t.b));
		}
		return this;
	}
	
	public void print(){
		System.out.println(this.a+" "+this.b);
	}
	
	public boolean overlap(Interval s, Interval t){
		return (!((s.b<=t.a)||(s.a>=t.b)));
	}
	
	public double length(){
		return Math.abs(b-a);
	}
	
}
