import java.util.*;

public class box{
	private Interval x;
	private Interval y;
	
	private LinkedList<Point> p;
	//private Point tl; p(0)
	//private Point bl; p(1)
	//private Point br; p(2)
	//private Point tr; p(3)
	
	private double size;
	
	private box parent;
	
	private LinkedList<box> children;
	
	private LinkedList<box> neighbor;
	
	private LinkedList<Point> vertices;
	
	public boolean mark;
	
	//private Point[] tEdge;
	//private Point[] bEdge;
	//private Point[] lEdge;
	//private Point[] rEdge;
	//private box c2;
	//private box c3;
	//private box c4;
	
	//private boolean ambiguous;
	//private boolean suspicious;
	//private 
	
	box(){
		x=new Interval();
		y=new Interval();
		p=new LinkedList<Point>();
		size=0;
		
		parent=null;
		
		children=new LinkedList<box>();
		
		neighbor=new LinkedList<box>();
		
		vertices=new LinkedList<Point>();
		
		mark=false;
		
		//tEdge=new Point[2];
		//bEdge=new Point[2];
		//lEdge=new Point[2];
		//rEdge=new Point[2];
		
		
		//ambiguous=false;
		//suspicious=false;
	}
	
	box(Point a, Point b){
		p=new LinkedList<Point>();
		p.add(new Point(a.getX(), b.getY()));
		p.add(new Point(a.getX(), a.getY()));
		p.add(new Point(b.getX(), a.getY()));
		p.add(new Point(b.getX(), b.getY()));
		
		x=new Interval(a.getX(), b.getX());
		y=new Interval(a.getY(), b.getY());
		
		size=Math.abs(b.getX()-a.getX());
		
		parent=null;
		
		children=new LinkedList<box>();
		
		neighbor=new LinkedList<box>();
		
		vertices=new LinkedList<Point>();
		
		mark=false;
		
		//ambiguous=false;
		//suspicious=false;
	}
	
	public LinkedList<box> split(){
		LinkedList<box> n=this.neighbor;
		box c1=new box(this.m(p.get(0), p.get(1)), this.m(p.get(0), p.get(3)));
		c1.parent=this;
		box c2=new box(p.get(1), this.m(p.get(1), p.get(3)));
		c2.parent=this;
		box c3=new box(this.m(p.get(1), p.get(2)), this.m(p.get(2), p.get(3)));
		c3.parent=this;
		box c4=new box(this.m(p.get(1), p.get(3)), p.get(3));
		c4.parent=this;
		
		c1.neighbor.add(c2);
		c1.neighbor.add(c4);
		c2.neighbor.add(c1);
		c2.neighbor.add(c3);
		c3.neighbor.add(c2);
		c3.neighbor.add(c4);
		c4.neighbor.add(c3);
		c4.neighbor.add(c1);
		
		for (int i=0; i<n.size(); i++){
			box nt=n.get(i);
			nt.neighbor.remove(this);
			LinkedList<Point> pt=nt.getPoint();
			
			//neighbors on the up side
			if (pt.get(1).getY()==this.getPoint().get(0).getY()){
				if (nt.getX().overlap(nt.getX(), c1.getX())){
					c1.neighbor.add(nt);
					nt.neighbor.add(c1);
				}
				if (nt.getX().overlap(nt.getX(), c4.getX())){
					c4.neighbor.add(nt);
					nt.neighbor.add(c4);
				}
			}
			//neighbors on the left side
			if (pt.get(2).getX()==this.getPoint().get(1).getX()){
				if (nt.getY().overlap(nt.getY(), c1.getY())){
					c1.neighbor.add(nt);
					nt.neighbor.add(c1);
				}
				if (nt.getY().overlap(nt.getY(), c2.getY())){
					c2.neighbor.add(nt);
					nt.neighbor.add(c2);
				}
			}
			//neighbors on the bottom side
			if (pt.get(3).getY()==this.getPoint().get(2).getY()){
				if (nt.getX().overlap(nt.getX(), c2.getX())){
					c2.neighbor.add(nt);
					nt.neighbor.add(c2);
				}
				if (nt.getX().overlap(nt.getX(), c3.getX())){
					c3.neighbor.add(nt);
					nt.neighbor.add(c3);
				}
			}
			//neighbors on the right side
			if (pt.get(0).getX()==this.getPoint().get(3).getX()){
				if (nt.getY().overlap(nt.getY(), c3.getY())){
					c3.neighbor.add(nt);
					nt.neighbor.add(c3);
				}
				if (nt.getY().overlap(nt.getY(), c4.getY())){
					c4.neighbor.add(nt);
					nt.neighbor.add(c4);
				}
			}
		}
		children.add(c1);
		children.add(c2);
		children.add(c3);
		children.add(c4);
		//children.add(new box(this.m(tl, bl), this.m(tl, tr)));
		//children.add(new box(bl, this.m(bl, tr)));
		//children.add(new box(this.m(bl, br), this.m(br, tr)));
		return children;
	}
	
	public Point m(Point a, Point b){
		return new Point((a.getX()+b.getX())/2, (a.getY()+b.getY())/2);
	}
	
	public Interval getX(){
		return x;
	}
	
	public Interval getY(){
		return y;
	}
	
	public LinkedList<Point> getPoint(){
		return this.p;
	}
	
	public LinkedList<box> getChildren(){
		return this.children;
	}
	
	public box getParent(){
		return this.parent;
	}
	
	public LinkedList<box> getNeighbor(){
		return this.neighbor;
	}
	
	public LinkedList<Point> getVertices(){
		return this.vertices;
	}
	
	public double getSize(){
		return this.size;
	}
	
	public boolean getMark(){
		return this.mark;
	}
	
	//box is suspicious if its four corners have the same sign.
	public boolean suspicious(){
		return (p.get(0).sign()==p.get(1).sign() && p.get(1).sign()==p.get(2).sign() && p.get(2).sign()==p.get(3).sign());
	}
	
	//box is ambiguous if its four corners have the same sign, plus it has 2 vertices.
	public boolean ambiguous(){
		if (!this.suspicious())
			return false;
		else{ 
			if (this.vertices.size()==2)
				return true;
			else
				return false;
		}
	}
	
	//c0 if for box with interval x & y, 0 not \in f(x,y).
	public boolean c0(){
		//new ImplicitCurve().value(x, y).print();
		return (!new ImplicitCurve().value(x, y).zero());
	}
	
	//c1 if for box with interval x & y, 0 not \in <f'(x,y), f'(x,y)>.
	public boolean c1(){
		//return (ImplicitCurve().dValue(x, y)[0]);
		ImplicitCurve ic= new ImplicitCurve();
		Interval I= new Interval();
		Interval temp= new Interval();
		Interval temp1= new Interval();
		temp.multiply(ic.dValue(x, y)[0], ic.dValue(x, y)[0]);
		temp1.multiply(ic.dValue(x, y)[1], ic.dValue(x, y)[1]);
		I.plus(temp, temp1);
		//I.print();
		
		return (!I.zero());
	}
	
	//cxy if for box with interval x & y, 0 not \in fx(x,y) or fy(x,y).
	public boolean cxy(){
		ImplicitCurve ic= new ImplicitCurve();
		return ((!ic.dValue(x, y)[0].zero())||(!ic.dValue(x, y)[1].zero()));
	}
	
	public void print(){
		for (int i=0; i<p.size(); i++)
			p.get(i).print();
	}
	
	public void addV(){
		for (int i=0; i<p.size(); i++){
			if (p.get(i).sign()!=p.get((i+1)%4).sign()){
				if (!existV(p.get(i), p.get((i+1)%4))){
					Point v=m(p.get(i),p.get((i+1)%4));
					this.vertices.add(v);
					for (int j=0; j<this.neighbor.size(); j++){
						box b=this.neighbor.get(j);
						if (b.containP(v)&&(!b.existV(v))){	
							b.getVertices().add(v);/*
							if (b.getPoint().get(0).getX()==-0.55 && b.getPoint().get(0).getY()==0.012499999999999956){
								System.out.println(b.getVertices().size());
								for (int t=0; t<b.getVertices().size(); t++)
									b.getVertices().get(t).print();
								v.print();
							}*/
						}
						//if (b.getPoint().get(1).getY()==0.5&&b.getPoint().get(1).getX()==-1){
						//	this.print();
						//	System.out.println(b.getNeighbor().size());
						//}
					}
				}
			}
		}
		
	}
	
	//return true if the edge (a,b) already exists vertices.
	public boolean existV(Point a, Point b){
		boolean e=false;
		for (int i=0; i<this.vertices.size(); i++){
			Point v=this.vertices.get(i);
			if ((((v.getX()==a.getX())&&(v.getX()==b.getX())))||(((v.getY()==a.getY())&&(v.getY()==b.getY()))))
				e=true;
		}
		return e;
	}
	
	//return true if this box contains point a.
	public boolean containP(Point a){
		boolean e=false;
		for (int i=0; i<p.size(); i++){
			if (a.contain(p.get(i), p.get((i+1)%4)))
				e=true;
		}
		return e;
	}
	
	public boolean existV(Point a){
		boolean e=false;
		for (int i=0; i<this.getVertices().size(); i++){
			Point v=this.getVertices().get(i);
			if (v.getX()==a.getX() && v.getY()==a.getY())
				e=true;
		}
		return e;
	}
	
}
