/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;

public class VPanel
extends Panel {
    public double[] Scores;
    public double[] Times;
    public int NumPlayers;
    public int NumTurns;
    public TurnChecker tc = new TurnChecker();
    public GameStartChecker gs = new GameStartChecker();
    public ReadyChecker rc;
    public int Winner;
    public int StartTurns = 7;
    public int PlayerTimeLimit = 0;
    public int HumanPlayers = 0;
    private Voronize v;
    private boolean singlePoly;
    private int showPoly;
    private Color[] colors = new Color[]{Color.red, Color.blue};
    private Dimension pref;

    public VPanel(Voronize voronize) {
        this.v = voronize;
        this.pref = new Dimension(400, 400);
        this.singlePoly = false;
        this.showPoly = 0;
        class VPanelKey
        extends KeyAdapter {
            private VPanel vp;

            public VPanelKey(VPanel vPanel2) {
                this.vp = vPanel2;
            }

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyChar()) {
                    case 'l': {
                        this.vp.setSinglePoly(!this.vp.getSinglePoly());
                        break;
                    }
                    case 'j': {
                        this.vp.setShowPoly(this.vp.getShowPoly() - 1);
                        break;
                    }
                    case 'k': {
                        this.vp.setShowPoly(this.vp.getShowPoly() + 1);
                    }
                }
            }
        }
        this.addKeyListener(new VPanelKey(this));
        class VPanelMouse
        extends MouseAdapter {
            private VPanel vp;
            private Voronize vo;

            public VPanelMouse(VPanel vPanel2, Voronize voronize) {
                this.vp = vPanel2;
                this.vo = voronize;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    int n = VPanel.this.tc.whosTurn();
                    try {
                        String string = point.x + " " + point.y + " " + n + "\n";
                        for (int i = 0; i < VPanel.this.NumPlayers; ++i) {
                            System.out.println("Sending move to player " + (i + 1));
                            if (i == n - 1) continue;
                            try {
                                OutputStream outputStream = Voronize.ns.PlayerSockets[i].getOutputStream();
                                outputStream.write(string.getBytes());
                                continue;
                            }
                            catch (Exception exception) {
                                System.out.println("Error writing socket");
                                System.out.println(exception);
                            }
                        }
                        VPanel.this.makeMove(point, this.vo, this.vp);
                    }
                    catch (Exception exception) {
                        System.out.println("Invalid move?");
                        System.out.println(exception);
                    }
                } else if ((mouseEvent.getModifiers() & 4) != 0) {
                    Vector vector = this.vo.getPPolys();
                    for (int i = 0; i < vector.size(); ++i) {
                        PolarPoly polarPoly = (PolarPoly)vector.elementAt(i);
                        if (!polarPoly.getPolygon().contains(point)) continue;
                        System.out.println("poly: " + i + ", area: " + polarPoly.area());
                        break;
                    }
                    PolarPoly polarPoly = this.vo.testPoint(point);
                    System.out.println("area: " + polarPoly.area());
                } else if ((mouseEvent.getModifiers() & 8) != 0) {
                    Vector vector = this.vo.getPoints();
                    for (int i = 0; i < vector.size(); ++i) {
                        Point point2 = (Point)vector.elementAt(i);
                        System.out.println(point2.x + " " + point2.y);
                    }
                }
            }
        }
        this.addMouseListener(new VPanelMouse(this, voronize));
    }

    public void clear() {
        this.resetGame();
        this.v.clear();
        this.repaint();
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Object object;
        int n;
        Vector vector = this.v.getPoints();
        Vector vector2 = this.v.getPPolys();
        graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(this.getForeground());
        if (this.showPoly >= vector2.size()) {
            this.showPoly -= vector2.size();
        } else if (this.showPoly < 0) {
            this.showPoly += vector2.size();
        }
        if (this.singlePoly) {
            System.out.println("displaying: " + this.showPoly);
        }
        for (n = 0; n < this.NumPlayers; ++n) {
            this.Scores[n] = 0.0;
        }
        n = this.singlePoly ? this.showPoly : 0;
        int n2 = this.singlePoly ? this.showPoly + 1 : vector2.size();
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            System.out.println("Updating poly " + i);
            Point point = (Point)vector.elementAt(i);
            System.out.println("Point " + point.x + " " + point.y);
            object = (PolarPoly)vector2.elementAt(i);
            d += ((PolarPoly)object).area();
            Polygon polygon = ((PolarPoly)object).getPolygon();
            Rectangle rectangle = polygon.getBounds();
            System.out.println("x:" + rectangle.x + " y:" + rectangle.y + " w:" + rectangle.width + " h:" + rectangle.height);
            graphics.setColor(this.colors[i % this.NumPlayers]);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.fillOval(point.x - 3, point.y - 3, 7, 7);
            int n3 = i % this.NumPlayers;
            this.Scores[n3] = this.Scores[n3] + ((PolarPoly)object).area();
        }
        System.out.println("plys left: " + this.NumTurns);
        double d2 = 0.0;
        object = new DecimalFormat("###.###");
        for (int i = 0; i < this.NumPlayers; ++i) {
            Voronize.ScoreLabels[i].setText("Player " + (i + 1) + ":  " + ((NumberFormat)object).format(this.Scores[i]));
            Voronize.TimeLabels[i].setText("TIME:  " + ((NumberFormat)object).format(this.Times[i]));
            System.out.println("player " + (i + 1) + ": " + this.Scores[i]);
            if (!(this.Scores[i] > d2)) continue;
            d2 = this.Scores[i];
            this.Winner = i + 1;
        }
        System.out.println();
        if (this.NumTurns == 0) {
            System.out.println("player " + this.Winner + " wins");
        }
    }

    public Dimension getPreferredSize() {
        return this.pref;
    }

    public void setPreferredSize(Dimension dimension) {
        this.pref = dimension;
    }

    public boolean getSinglePoly() {
        return this.singlePoly;
    }

    public void setSinglePoly(boolean bl) {
        this.singlePoly = bl;
        this.repaint();
    }

    public int getShowPoly() {
        return this.showPoly;
    }

    public void setShowPoly(int n) {
        this.showPoly = n;
        this.repaint();
    }

    public void resetGame() {
        int n;
        Voronize.ns.NextPlayerNumber = 1;
        this.tc.changeTurn(0);
        for (n = 0; n < this.NumPlayers; ++n) {
            try {
                if (Voronize.ns.PlayerSockets[n] == null) continue;
                Voronize.ns.PlayerSockets[n].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.Scores = new double[Voronize.MaxPlayers];
        this.Times = new double[Voronize.MaxPlayers];
        n = 0;
        while (true) {
            if (n >= Voronize.MaxPlayers) break;
            this.Scores[n] = 0.0;
            this.Times[n] = this.PlayerTimeLimit;
            ++n;
        }
        this.setNumPlayers(0);
        this.Winner = 0;
        this.gs.update(false);
    }

    public void setNumPlayers(int n) {
        this.NumPlayers = n;
        this.NumTurns = this.StartTurns * this.NumPlayers;
    }

    public void makeMove(Point point, Voronize voronize, VPanel vPanel) {
        boolean bl = false;
        int n = this.tc.whosTurn();
        if (this.NumTurns != 0) {
            --this.NumTurns;
            if (point.x >= 0 && point.x < voronize.W && point.y >= 0 && point.y < voronize.H) {
                Vector vector = voronize.getPoints();
                System.out.println("makeMove p.x:" + point.x + " p.y:" + point.y);
                ++point.x;
                ++point.y;
                if (!vector.contains(point)) {
                    int n2;
                    voronize.points.addElement(point);
                    voronize.ppolys = new Vector();
                    for (n2 = 0; n2 < voronize.points.size(); ++n2) {
                        voronize.ppolys.addElement(new PolarPoly());
                    }
                    for (n2 = 0; n2 < voronize.points.size(); ++n2) {
                        VLine[] vLineArray = voronize.getBisectors((Point)voronize.points.elementAt(n2));
                        voronize.addPoint(n2, vLineArray, false);
                    }
                    vPanel.repaint();
                } else {
                    System.out.println("Player " + n + " made a duplicate move! " + --point.x + " " + --point.y);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.tc.changeTurn(0);
        } else {
            n = n < this.NumPlayers ? ++n : 1;
            this.tc.changeTurn(n);
        }
    }
}

