/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Polygon;
import java.util.Vector;

public class PolarPoly {
    private Vector points = new Vector();

    public void addPoint(PointDouble pointDouble) {
        this.addPoint(pointDouble.x, pointDouble.y);
    }

    public void addPoint(double d, double d2) {
        this.points.addElement(new PointDouble(d, d2));
        this.sort(this.points);
    }

    public int getSize() {
        return this.points.size();
    }

    public PointDouble getPoint(int n) {
        return (PointDouble)this.points.elementAt(n);
    }

    public void removePoint(int n) {
        this.points.removeElementAt(n);
    }

    public Polygon getPolygon() {
        Polygon polygon = new Polygon();
        for (int i = 0; i < this.points.size(); ++i) {
            PointDouble pointDouble = (PointDouble)this.points.elementAt(i);
            polygon.addPoint((int)Math.round(pointDouble.x), (int)Math.round(pointDouble.y));
        }
        return polygon;
    }

    public double area() {
        double d = 0.0;
        for (int i = 2; i < this.points.size(); ++i) {
            d += this.triarea((PointDouble)this.points.elementAt(0), (PointDouble)this.points.elementAt(i - 1), (PointDouble)this.points.elementAt(i));
        }
        return d;
    }

    public String toString() {
        String string = "(" + this.points.size() + "/" + this.area() + "):";
        for (int i = 0; i < this.points.size(); ++i) {
            string = string + " " + (PointDouble)this.points.elementAt(i);
        }
        return string;
    }

    private double triarea(PointDouble pointDouble, PointDouble pointDouble2, PointDouble pointDouble3) {
        double d = pointDouble2.x - pointDouble.x;
        double d2 = pointDouble2.y - pointDouble.y;
        double d3 = pointDouble3.x - pointDouble.x;
        double d4 = pointDouble3.y - pointDouble.y;
        return Math.abs(d * d4 - d2 * d3) / 2.0;
    }

    private void sort(Vector vector) {
        int n;
        int n2 = vector.size();
        Vector<Double> vector2 = new Vector<Double>();
        PointDouble[] pointDoubleArray = new PointDouble[n2];
        PointDouble pointDouble = this.getCenter();
        for (n = 0; n < n2; ++n) {
            vector2.addElement(new Double(this.getTheta((PointDouble)vector.elementAt(n), pointDouble)));
        }
        for (n = 0; n < n2; ++n) {
            double d = Math.PI * 2;
            int n3 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                double d2 = (Double)vector2.elementAt(i);
                if (!(d2 < d)) continue;
                d = d2;
                n3 = i;
            }
            pointDoubleArray[n] = (PointDouble)vector.elementAt(n3);
            vector.removeElementAt(n3);
            vector2.removeElementAt(n3);
        }
        for (n = 0; n < n2; ++n) {
            vector.addElement(pointDoubleArray[n]);
        }
    }

    private PointDouble getCenter() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.points.size(); ++i) {
            d += ((PointDouble)this.points.elementAt((int)i)).x;
            d2 += ((PointDouble)this.points.elementAt((int)i)).y;
        }
        return new PointDouble(d / (double)this.points.size(), d2 / (double)this.points.size());
    }

    private double getTheta(PointDouble pointDouble, PointDouble pointDouble2) {
        double d = pointDouble.x - pointDouble2.x;
        double d2 = pointDouble.y - pointDouble2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Math.acos(d / d3);
        return d2 < 0.0 ? Math.PI * 2 - d4 : d4;
    }
}

