package superply;

import java.io.IOException;

import superply.math.HintChecker;

import heurgame.PlayerProxy;
import heurgame.logging.LogBox;

/**
 * @author David Kaplin and Chris Quackenbush
 */
public class SuperPlyPlayerProxy extends PlayerProxy {
	private HintChecker hintChecker;
	
	SuperPlyPlayerProxy(HintChecker hc){
		hintChecker = hc;
	}
	
	
    /** 
     * @see heurgame.PlayerProxy#getMove(java.lang.String)
     */
    public String getMove(String queryInfo) {
        this.toPlayer.println("STATUS "+queryInfo);
        this.toPlayer.flush();
        makeNormal("MOVE",queryInfo,"hinting");
		this.toPlayer.println("HINT "+hintChecker.getHint());
		this.toPlayer.flush();
		makeNormal("HINT",queryInfo,"waiting");
        try {
            String ans = fromPlayer.readLine();
            makeNormal("MOVE",queryInfo,"got "+ ans);
            return ans;
        } catch (IOException e) {
            debugging.addUrgentEntry("MOVE "+queryInfo,e.getLocalizedMessage(),1);
        } 
        return null;
    }

    /** 
     * @see heurgame.PlayerProxy#sendDisqualify(java.lang.String)
     */
    public void sendDisqualify(String why) {
        this.toPlayer.println("TIMEOUT ");
        this.toPlayer.flush();
        makeNormal("Disqualification ","TIMEOUT",why);
        this.toPlayer.close();
        try {
            this.fromPlayer.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    /** 
     * @see heurgame.PlayerProxy#sendInitialStatus(java.lang.String)
     */
    public void sendInitialStatus(String initStatus) {
        this.toPlayer.println("INIT "+initStatus);
        this.toPlayer.flush();
		makeNormal("INIT",initStatus,"");
		this.toPlayer.println("X "+hintChecker.getColumnLabels()
							+" Y "+hintChecker.getRowLabels());
		this.toPlayer.flush();
		makeNormal("INIT","Labels","X "+hintChecker.getColumnLabels()
								  +" Y "+hintChecker.getRowLabels());
    }

    /** 
     * @see heurgame.PlayerProxy#sendFinalStatus(java.lang.String)
     */
    public void sendFinalStatus(String finStatus) {
        this.toPlayer.println("FINAL "+finStatus);
        this.toPlayer.flush();
        makeNormal("EndGame",finStatus,"");
        toPlayer.close();
        try {
            fromPlayer.close();
        } catch (IOException e) {
            debugging.addUrgentEntry("FINAL "+finStatus,e.getLocalizedMessage(),1);
        }
    }

    /** 
     * @see heurgame.PlayerProxy#sendStatus(java.lang.String)
     */
    public void sendStatus(String status) {
        this.toPlayer.println("STATUS "+status);
        this.toPlayer.flush();
        makeNormal("Status",status,"");
    }

    /** 
     * @see heurgame.PlayerProxy#sendInvalidMove(java.lang.String)
     */
    public String sendInvalidMove(String why) {
        makeNormal("Invalid",why,"ERROR!");
        return null;
    }
    public void makeNormal(String command, String info, String status){
        debugging.addEntry(command +": "+info,status);
    }
    /** 
     * @see heurgame.PlayerProxy#setupLogging(heurgame.logging.AbstractLog, heurgame.logging.LogReader)
     */
    public void setupLogging(LogBox prepackaged) {
        debugging = prepackaged;
    }

    /** 
     * @see heurgame.PlayerProxy#sendIncrementalStatus(java.lang.String)
     */
    public void sendIncrementalStatus(String status) {
        this.toPlayer.println("STATUS "+status);
        this.toPlayer.flush();
        makeNormal("Incremental Status",status,"");
    }

    /** 
     * @see heurgame.PlayerProxy#sendWarning(java.lang.String)
     */
    public void sendWarning(String information) {
        this.toPlayer.println("WARNING "+information);
        this.toPlayer.flush();
        makeNormal("WARNING",information,"");
    }

}
