package superply.math;


/*
 * Created on Nov 21, 2004
 */

/**
 * @author Chris Quackenbush
 */
public class HintCheckerAlgebra extends HintChecker{
//game definition
	int BOARD_SIZE = 8;
	int LARGEST_TEXT_ELEMENT = 60;
	String rowLabels = "2x+2 8x+6 2x-4 6x-6 6x 8x-2 2x+8 2x-2";
	String colLabels = "6 4x-6 4x+2 -18 4x+6 4x+10 4x-2 4x-10";
	String symbol = "find x";
	String[] hints = {
		"contains 1",
		"contains 2",
		"contains 3",
		"contains 4",
		"contains 5",
		"contains 6",
		"contains 7",
		"contains 8",
		"contains 9",
		"contains 0"
	};
	int[] cell = {
		2, 	 4,		0,		-10, 	-2,	 	-4, 	2, 		6,
	   0, 	-3, 	-1, 	-3, 	0,		1, 		-2, 	-4,
	   5, 	1, 		-3, 	-6, 	-5, 	-7, 	-1, 	3,
	   2, 	0,		4, 		-2, 	6,	 	8,	 	2, 		-2,
	   1, 	-3, 	1, 		-3, 	3, 		5, 		-1, 	-5,
	   1, 	-1, 	1, 		-2, 	2, 		3, 		0, 		-2,
	   -1,	7,		3,	 	-13, 	1,	 	-1, 	5,	 	9,
	   4, 	2,	 	-2, 	-7, 	-4, 	-6, 	0,	 	4
	};
	
	public String getLabelAt(int r, int c) {
		return String.valueOf( cell[r*BOARD_SIZE+c] );
	}
	
	public boolean isValidHint(int r, int c, int h) {
		if( r < 0 || r >= BOARD_SIZE || c < 0 || c >= BOARD_SIZE)
			return false;
		String[] hint = hints[h].split(" ");
		if(
		 (hint[0].equals("contains") && getLabelAt(r,c).indexOf(hint[1]) >= 0)
		){
			return true;
		}
		return false;
	}	
//end game definition
	
	public HintCheckerAlgebra(String hintType) {
		super(hintType);
		clear();
	}
	
	public String[] getHints() {
		return hints;
	}

	public int getBoardSize() {
		return BOARD_SIZE;
	}

	public String getColumnLabels() {
		return colLabels;
	}

	public String getRowLabels() {
		return rowLabels;
	}

	public String getOperation() {
		return symbol;
	}

	public int getCellSize() {
		return LARGEST_TEXT_ELEMENT;
	}
}
