package superply.math;

/*
 * Created on Nov 21, 2004
 */

import java.awt.Point;
import java.util.Vector;

import heurgame.PlayerToken;

/**
 * @author Chris Quackenbush
 *
 */
public class HintChecker {
	int BOARD_SIZE = 8;
	String labels = "2 3 4 5 6 7 8 9";
	String symbol = "X";
	
	public Vector playOrder;
	String hintStyle = "random";
	private PlayerToken[] boardModel = new PlayerToken[BOARD_SIZE*BOARD_SIZE];
	HintChooser hintChooser;
	Vector[] hintCells;
	public int winner = 2;
	
	/**
	 * @param hintType "random" or "deterministic"
	 */
	public HintChecker(String hintType) {
		if(hintType.equals("deterministic"))
			hintStyle = hintType;
		clear();
	}
	
	/**
	 * resets the HintChecker
	 */
	public void clear() {
		winner = 2;
		hintChooser = new HintChooser(hintStyle,this);
		for(int i=0; i <BOARD_SIZE*BOARD_SIZE;i++)
			boardModel[i] = null;
		hintCells = new Vector[hintChooser.hints.length];
		for(int i = 0; i < hintCells.length; i++){
		 hintCells[i] = new Vector();
		 for(int j = 0; j < BOARD_SIZE; j++){
		  for(int k = j; k < BOARD_SIZE; k++){
			String[] hint = hintChooser.hints[i].split(" ");
			int cellVal = (2+k)*(2+j);
			if(
			 (hint[0].equals("odd") && cellVal%2 == 1) ||
			 (hint[0].equals("even") && cellVal%2 == 0) ||
			 (hint[0].equals("contains") && getLabelAt(k,j).indexOf(hint[1]) >= 0) ||
			 (hint[0].equals("between") && cellVal >= Integer.parseInt(hint[1]) && cellVal <= Integer.parseInt(hint[2]))
			){
				hintCells[i].add(new Point(k,j));
				if(j != k) hintCells[i].add(new Point(j,k));
			}
		  }
		 }
		}
	}

	public PlayerToken winner(){
		if(playOrder.size() > 1){
			boolean[] tried = new boolean[BOARD_SIZE*BOARD_SIZE];
			PlayerToken p = (PlayerToken)playOrder.get(0);
			//try to get from left to right
			for(int i=0; i <BOARD_SIZE*BOARD_SIZE;i++)
				tried[i] = false;
			for(int r = 0; r < BOARD_SIZE; r++)
				if(searchLR(p,r,0,tried)){
					winner = 0;
					return p;
				}
				
			p = (PlayerToken)playOrder.get(1);
			//try to get from top to bottom
			for(int i=0; i <BOARD_SIZE*BOARD_SIZE;i++)
				tried[i] = false;
			for(int c = 0; c < BOARD_SIZE; c++)
				if(searchTB(p,0,c,tried)){
					winner = 1;
					return p;
				}
		}
		return null;
	}

	/**
	 * @return true if there is a path belonging to p from TOP to BOTTOM starting at
	 * (row,col)
	 */
	private boolean searchTB(PlayerToken p, int row, int col, boolean[] marks) {
		marks[row*BOARD_SIZE+col] = true;
		if(!p.equals(boardModel[row*BOARD_SIZE+col]))
			return false;
		if(row == BOARD_SIZE-1)
			return true;
			
		int nr,nc;
		for(int dRow = -1; dRow < 2; dRow++)
		 for(int dCol = -1; dCol < 2; dCol++){
		 	nr = row+dRow; nc = col+dCol;
			if(nr >= 0 && nc >= 0 && nr < BOARD_SIZE && nc < BOARD_SIZE &&
			   !marks[nr*BOARD_SIZE+nc] && (nr != row || nc != col)){
				if(searchTB(p,nr,nc,marks))
					return true;	
		 	}
		 }
		return false;
	}

	/**
	 * @return true if there is a path belonging to p from LEFT to RIGHT starting at
	 * (row,col)
	 */
	private boolean searchLR(PlayerToken p, int row, int col, boolean[] marks) {
		marks[row*BOARD_SIZE+col] = true;
		if(!p.equals(boardModel[row*BOARD_SIZE+col]))
			return false;
		if(col == BOARD_SIZE-1)
			return true;
			
		int nr,nc;
		for(int dRow = -1; dRow < 2; dRow++)
		 for(int dCol = -1; dCol < 2; dCol++){
			nr = row+dRow; nc = col+dCol;
			if(nr >= 0 && nc >= 0 && nr < BOARD_SIZE && nc < BOARD_SIZE &&
			   !marks[nr*BOARD_SIZE+nc] && (nr != row || nc != col)){
				if(searchLR(p,nr,nc,marks))
					return true;	
			}
		 }	
		return false;
	}

	/**
	 * @param pt the PlayerToken of the player whose moves you want
	 * @return a vector of points corresponding to that players moves
	 */
	public Vector getMoves(PlayerToken pt) {
		Vector answer = new Vector();
		for(int i=0; i < BOARD_SIZE*BOARD_SIZE;i++){
			if( boardModel[i] != null && boardModel[i].equals(pt) )
				answer.add(new Point(i/BOARD_SIZE,i%BOARD_SIZE));
		}
		return answer;
	}

	/**
	 * @param who player who wants to move into this spot
	 * @param p p.x is the row we are moving to p.y is the column
	 * @return
	 */
	public boolean add(PlayerToken who, Point p) {
		int index = p.x*BOARD_SIZE+p.y;
		if(boardModel[index] != null){
			hintChooser.next();
			return false; //occupied
		}else if(hintCells[ hintChooser.counter ].contains(p)){
			boardModel[index] = who;
			for(int i = 0; i < hintCells.length; i++){
				hintCells[i].remove(p);
			}
			hintChooser.next();
			return true;
		}
		hintChooser.next();
		return false; //invalid for hint
	}

	/**
	 * @return the dimention of the board (it is square)
	 */
	public int getBoardSize() {
		return BOARD_SIZE;
	}

	/**
	 * @return random or deterministic
	 */
	public String getHintMethod() {
		return hintStyle;
	}
	
	/**
		 * @return the current hint
		 */
		public String getHint() {
		return hintChooser.get();
	}

	/**
	 * @return the space seperated values along the top edge
	 */
	public String getColumnLabels() {
		return labels;
	}

	/**
	 * @return the space seperated values along the left edge
	 */
	public String getRowLabels() {
		return labels;
	}

	/**
	 * 
	 */
	public String getOperation() {
		return symbol;		
	}

	/**
	 * @param r row
	 * @param c column
	 * @return the PlayerToken of the player who controls (r,c)
	 */
	public PlayerToken getPlayerAt(int r, int c) {
		return boardModel[r*BOARD_SIZE+c];
	}

	/**
	 * @param r row
	 * @param c column
	 * @return the label for the cell (r,c)
	 */
	public String getLabelAt(int r, int c) {
		return String.valueOf( (2+r)*(2+c) );
	}

}
