package heurgame.event.turn;

import heurgame.PlayerToken;

import java.util.Vector;

/*
 * Created on Oct 15, 2004
 */

/**
 * @author David Kaplin
 *
 * This Iterface may need to change.  
 * The actions defined are common to TokenBased Iterators, this
 * does allow some code reuse between RoundRobinIterator and
 * the SecondChanceRRIterator.  It is quite possible there
 * will be some other iterators it can help as well. 
 */
public interface TokenBased {
    /**
     * Called after construction by the Game itself, to initialize
     * the TokenBased Iterator
     * 
     * @param totalRounds The number of desired rounds for the Iterator
     * @param pTokens The Tokens of the players
     */
    abstract public void setup(int totalRounds, Vector pTokens);
    /**
     * Events specific to a game may occur that would force
     * the active tokens to change for the next round.  This 
     * method allows this change.
     * 
     * @param newTokens Exact order of tokens for the next round.
     */
    abstract public void updateActiveTokens(Vector newTokens);
    /**
     * @return The player token of the current turn's player
     */
    abstract public PlayerToken getCurrentToken();
}
