package mallProject1;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;

public class AnalyzeData {

  public static void main(String[] args) {

    //analyzeEntireData();
    analyzeAndValidateData();
  }

  //function to analyze and validate income based recommendations
  private static void analyzeAndValidateData() {
    String mallIncomeDataFile = "C:/Users/Rishabh/Desktop/capstone project/dataStuff/latlongdata/meanNormalizedscoreMallAndStores_withScores.txt";
    //"C:/Users/Rishabh/Desktop/capstone project/dataStuff/latlongdata/joinedFileFilteredmeanAndStores.txt";

    int validationPercent = 10;
    List<String> storeList = new ArrayList<String>();
    storeList = readDataAsList(mallIncomeDataFile, validationPercent);

    long seed = System.nanoTime();
    Collections.shuffle(storeList, new Random(seed));

    List<String> trainList = new ArrayList<String>();
    int trainSize = ((100 - validationPercent) * storeList.size()) / 100;
    System.out.println("train size: " + trainSize);

    for (int i = 0; i < trainSize; i++) {
      trainList.add(storeList.get(i));
    }
    //  trainList = storeList.subList(0, trainSize);
    storeList.removeAll(trainList);
    //System.out.println(trainList);
    List<String> valList = storeList;
    //System.out.println(valList);

    double acceptedError = 15.0;

    System.out.println("train list: " + trainList.size() + " val list size: " + valList.size());

    Map<String, List<Float>> storeIncomeMap = generateStoreIncomeMap(trainList);
    Map<String, List<Float>> validationStoreIncomeMap = generateStoreIncomeMap(valList);
    Map<String, Float> storeScoreMap = aggregateScores(storeIncomeMap);

    Float percentAccuracy = calculateAccuracy(storeScoreMap, validationStoreIncomeMap,
        acceptedError);
    System.out.println("final accuracy: " + percentAccuracy);
  }

  //to calculate accuracy for test results 
  private static Float calculateAccuracy(Map<String, Float> storeScoreMap,
      Map<String, List<Float>> validationStoreIncomeMap, double acceptedError) {

    int correct = 0;
    int incorrect = 0;
    for (String name : validationStoreIncomeMap.keySet()) {

      //String key = name;
      //String value = storeIncomeMap.get(name).toString();
      //System.out.println(key + " $" + value);

      List<Float> scores = validationStoreIncomeMap.get(name);
      if (storeScoreMap.containsKey(name)) {
        Float actualScore = storeScoreMap.get(name);
        for (Float score : scores) {
          double error = (Math.abs(score - actualScore) * 100.00) / score;
          if (error < acceptedError) {
            correct++;
          } else {
            incorrect++;
          }
        }
      }

    }
    System.out.println("total checked: " + (incorrect + correct));
    return (float) correct / (float) (incorrect + correct);
  }
  
  //function to calculate aggregate scores for each store
  private static Map<String, Float> aggregateScores(Map<String, List<Float>> storeIncomeMap) {
    Map<String, Float> storeScoreMap = new HashMap<String, Float>();
    for (String name : storeIncomeMap.keySet()) {

      //String key = name;
      //String value = storeIncomeMap.get(name).toString();
      //System.out.println(key + " $" + value);

      List<Float> scores = storeIncomeMap.get(name);
      Double sum = 0.0;
      if (scores.size() > 2) {
        for (Float score : scores) {
          sum = sum + score;
        }
        storeScoreMap.put(name, (float) (sum / (float) scores.size()));
      }
    }
    System.out.println("train store size: "+storeScoreMap.size());
    return storeScoreMap;
  }

  //fucntion to generate a map for each stoe and a list of incomes from various regions
  private static Map<String, List<Float>> generateStoreIncomeMap(List<String> trainList) {
    Map<String, List<Float>> storeIncomeMap = new HashMap<String, List<Float>>();

    for (String storeData : trainList) {
      String line = storeData.replaceAll("\"", "");
      String[] content = line.split("\t");
      //System.out.println(content[0]);
      //System.out.println(content[1]);
      String stores[] = content[2].split("\\|");
      for (String store : stores) {
        store = store.trim();
        //System.out.println(store);
        //System.out.println(store);
        if (storeIncomeMap.containsKey(store)) {
          ArrayList<Float> incomeList = (ArrayList<Float>) storeIncomeMap.get(store);
          incomeList.add(new Float(content[0].trim()));
          //System.out.println(incomeList);
        } else {
          ArrayList<Float> incomeList = new ArrayList<Float>();
          incomeList.add(new Float(content[0].trim()));
          storeIncomeMap.put(store, incomeList);
          //System.out.println(incomeList);
        }
      }
    }
    return storeIncomeMap;
  }

  private static List<String> readDataAsList(String mallIncomeDataFile, int validationPercent) {
    List<String> storeScoreList = new ArrayList<String>();
    Scanner in = null;
    try {
      in = new Scanner(new File(mallIncomeDataFile));

      in.nextLine();
      while (in.hasNext()) {

        String line = in.nextLine();
        //line = line.replaceAll("\"", "");
        storeScoreList.add(line);

      }
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } finally {
      in.close();
    }
    return storeScoreList;
  }

  private static void analyzeEntireData() {
    String mallIncomeDataFile = "C:/Users/Rishabh/Desktop/capstone project/dataStuff/latlongdata/meannormalizedscoreAndStores.txt";
    //"C:/Users/Rishabh/Desktop/capstone project/dataStuff/latlongdata/joinedFileFilteredmeanAndStores.txt";
    int threshold1 = -1;
    int threshold2 = -1;
    double mean = 33439.7;
    double dev = 11462.97;

    ArrayList<String> highEnd = new ArrayList<String>();
    ArrayList<String> medOrDistributed = new ArrayList<String>();
    ArrayList<String> lowEnd = new ArrayList<String>();

    Map<String, List<Float>> storeIncomeMap = processMallIncomeData(mallIncomeDataFile, threshold1,
        threshold2);

    for (String name : storeIncomeMap.keySet()) {

      String key = name;
      String value = storeIncomeMap.get(name).toString();
      System.out.println(key + " $" + value);
      int countPlus = 0;
      int countLow = 0;
      List<Float> incomes = storeIncomeMap.get(name);
      if (incomes.size() > 2) {
        for (Float val : incomes) {
          if (val > 0.75) {
            countPlus++;
          }
          if (val < -0.5) {
            countLow++;
          }
        }
        if (countLow / incomes.size() > 0.7) {
          lowEnd.add(name);
        } else if (countPlus / incomes.size() > 0.7) {
          highEnd.add(name);
        } else {
          medOrDistributed.add(name);
        }

      }
    }

    System.out.println("High end stores: " + highEnd);
    System.out.println("Low end stores: " + lowEnd);
    System.out.println("Medium Range or range independent stores: " + medOrDistributed);
  }

  private static Map<String, List<Float>> processMallIncomeData(String mallIncomeDataFile,
      int threshold1, int threshold2) {
    Map<String, List<Float>> storeIncomeMap = new HashMap<String, List<Float>>();
    Scanner in = null;
    try {
      in = new Scanner(new File(mallIncomeDataFile));

      in.nextLine();
      while (in.hasNext()) {
        String line = in.nextLine();
        line = line.replaceAll("\"", "");
        String[] content = line.split("\t");
        //System.out.println(content[0]);
        //System.out.println(content[1]);
        String stores[] = content[2].split("\\|");
        for (String store : stores) {
          store = store.trim();
          //System.out.println(store);
          //System.out.println(store);
          if (storeIncomeMap.containsKey(store)) {
            ArrayList<Float> incomeList = (ArrayList<Float>) storeIncomeMap.get(store);
            incomeList.add(new Float(content[1].trim()));
            //System.out.println(incomeList);
          } else {
            ArrayList<Float> incomeList = new ArrayList<Float>();
            incomeList.add(new Float(content[1].trim()));
            storeIncomeMap.put(store, incomeList);
            //System.out.println(incomeList);
          }
        }
      }
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } finally {
      in.close();
    }
    return storeIncomeMap;
  }
}
