from flask import Flask, render_template, request, redirect, url_for
from flask.helpers import send_from_directory
app = Flask(__name__)
import association_analysis

import numpy as np

#OLD HOME PAGE
@app.route("/")
def main():
	print 'started'
	return render_template('index.html')

#HOME PAGE	
@app.route("/home")
def home():
	print 'started'
	#store_income_score_file="data/store_wise_cat_avg_score_filtered2.txt"
	store_income_score_file="data/store_wise_cat_avg_score_filtered2_sorted.txt"
	store_income_score = np.genfromtxt(store_income_score_file, dtype=None, names=True, delimiter='\t')
	list_stores=[]
	for item in store_income_score:
		print item[0],item[1]
		l=[]
		strng=unicode(item[0],errors='ignore')
		l.append(strng)
		l.append(item[1])
		list_stores.append(l)
	print list_stores


	cat_file="data/catlist8.txt"
        store_income_score = np.genfromtxt(cat_file, dtype=None, names=True, delimiter='\t')
        list_cat=[]
        for item in store_income_score:
                #strng=unicode(item,errors='ignore')
                list_cat.append(item)
        print list_cat

	return render_template('index2.html',list_stores=list_stores,list_cat=list_cat)


#NOT USED ONLY FOR TESTING
@app.route('/dataset')
def generateDataset():
	print 'data done'
	dataset=association_analysis.load_dataset('store')
	
	return str(dataset)	

# OLD RECCOMENATION BASED ONLY ON particular CATEGORY INPUT	
@app.route('/getReco', methods=['POST'])
def generate_recommendation():
	print 'data done'
	storeType=request.form['category']
	stores=request.form['stores']
	stores=stores.lower()
	print storeType
	print stores
	dataset=association_analysis.load_dataset(storeType)
	frequency=0.04
	if(storeType=='clothing_store' or storeType=='shoe_store'):
		frequency=0.2
	listOfFreqItems,support_data=association_analysis.apriori(dataset,frequency)
	result= association_analysis.find_suggestions(stores.strip(),listOfFreqItems,support_data) 
        incomeBased=request.form['income']
	resultString=''
	list_suggestion=''
	if(incomeBased=='True' and stores.strip()!=''):
		list_suggestion= association_analysis.getStoresBasedOnIncomeScores(stores,10)
    
		#for i in range(0,list_suggestion.shape[0]):
        	#	resultString=resultString+'\n'+ list_suggestion[i][0]+","+ list_suggestion[i][1]
	resultString=str(result)+'\n Suggestion from Income Data: \n' +resultString;
	#print list_suggestion[0]
	#return str(resultString)	
	return render_template("results.html", resultStr=result,list_suggestion=list_suggestion,category=storeType,storeName=stores)


	# CURRENT FUNCTION TO GENERATE RECO
@app.route('/getCatStoreReco', methods=['POST'])
def generate_recommendation_from_cat():
	print 'data done'
	
	storeTypes=request.form.getlist('categories')
	storeTypes2=request.form.getlist('categories2')
	print "htmlinput",storeTypes,storeTypes2
	
	catList=[]
	for item in storeTypes:
		#print item
		if(item.strip()!=['']):
		
			catList2=[x.replace('"[','').replace(']"','').replace('[','').replace(']','').strip().lower() for x in (item.split(","))]
			for cat in catList2:
				if(cat.strip()!='' and cat not in catList):
					catList.append(cat)
	print catList
        for item in storeTypes2:
                #print item
                if(item.strip()!=['']):

                        catList2=[x.replace('"[','').replace(']"','').replace('[','').replace(']','').strip().lower() for x in (item.split(","))]
                        for cat in catList2:
                                if(cat.strip()!='' and cat not in catList):
                                        catList.append(cat)
        print "totalCatList",catList

	print str(catList)
	dataset=association_analysis.load_dataset("mallwisecategory")
	frequency=0.5
	
	# function call to generate frequnt category data set for use in next function call
	listOfFreqCats,support_data=association_analysis.apriori(dataset,frequency)
	
	# FUNCTION CALL TO GET STIRE SGGESTIONS
	result=association_analysis.generate_store_suggestions(catList,listOfFreqCats,support_data)
			
	return render_template("results2.html", resultStr=result,category=str(catList))


# older funtion for income analysis
@app.route('/getIncomeReco', methods=['POST'])
def generate_recommendation2():
        print 'data done'
        incomeBased=request.form['income']
        stores=request.form['stores']
        stores=stores.lower()
        print storeType
        print stores
        result= association_analysis.getStoresBasedOnIncomeScores(stores)
        return str(result)
	
if __name__ == "__main__":
    app.run(host='0.0.0.0', port=47152,debug=True)
	
