package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;

import java.awt.*;
import java.awt.geom.Point2D;

public class QPath extends PPath implements QElement {
  private static final Color PATH_COLOR = new Color(33, 33, 119);
  private final static float dash[] = {10.0f};
  private static final PFixedWidthStroke eStroke = new PFixedWidthStroke(2, PFixedWidthStroke.CAP_BUTT, PFixedWidthStroke.JOIN_MITER, 10.0f, dash, 0.0f);
  private QNode source, target;
  private String attr = "?>0";
  private String id;
  private int valence = 0;

  public QPath(String id) {
    setStroke(eStroke);
    setStrokePaint(PATH_COLOR);
    this.id = id;
  }

  public QPath(QNode s, QNode t, String id) {
    source = s;
    target = t;
    setStroke(eStroke);
    setStrokePaint(PATH_COLOR);
    this.id = id;
    update();
  }

  public void delete(PLayer nodeLayer, PLayer edgeLayer) {
    if(getSource() != null)
      getSource().removePath(this);
    if(getTarget() != null)
      getTarget().removePath(this);
    edgeLayer.removeChild(this);
  }

  public String getInfo() {
    return "Path\n" + "Id: " + id + "\n" + "Attribute: " + attr + "\n" + "Source Id: " + getSource().getId() + "\n" + "Target Id: " + getTarget().getId() + "\n";
  }

  public String getId() {
    return id;
  }

  public void update() {
    QNode first = source;
    QNode second = target;
    float shift = 20 * (float)Math.floor((valence + 1) / 2);
    float sign = +1;
    if(valence % 2 == 0)
      sign = -1;
    if(target.getId().compareTo(source.getId()) < 0) {
      first = target;
      second = source;
    }
    Point2D start = first.getFullBoundsReference().getCenter2D();
    Point2D end = second.getFullBoundsReference().getCenter2D();
    reset();
    moveTo((float)start.getX(), (float)start.getY());
    // multi-edge
    if(valence > 0) {
      Point2D.Float point = new Point2D.Float((float)start.getX() + (float)(end.getX() - start.getX()) / 2, (float)start.getY() + (float)(end.getY() - start.getY()) / 2);
      double angle = Math.atan((end.getY() - start.getY()) / (end.getX() - start.getX()));
      if(end.getX() >= start.getX())
        point.setLocation(point.getX() + sign * shift * Math.sin(angle), point.getY() - sign * shift * Math.cos(angle));
      else
        point.setLocation(point.getX() - sign * shift * Math.sin(angle), point.getY() + sign * shift * Math.cos(angle));
      lineTo((float)point.getX(), (float)point.getY());
    }
    lineTo((float)end.getX(), (float)end.getY());
  }

  void drawTo(Point2D end) {
    if(source == null)
      return;
    Point2D start = source.getFullBoundsReference().getCenter2D();
    reset();
    moveTo((float)start.getX(), (float)start.getY());
    lineTo((float)end.getX(), (float)end.getY());
  }

  public void setAttr(String attr) {
    this.attr = attr;
  }

  public String getAttr() {
    return attr;
  }

  public QNode getSource() {
    return source;
  }

  public void setSource(QNode s) {
    source = s;
  }

  public QNode getTarget() {
    return target;
  }

  public void setTarget(QNode t) {
    target = t;
  }

  public void setValence(int newValence) {
    valence = newValence;
  }

  public int getValence() {
    return valence;
  }

}
