package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

import java.awt.geom.Point2D;

public class QCreateNodeHandler extends PBasicInputEventHandler {

  private QToolFrame frame;

  public QCreateNodeHandler(QToolFrame frame) {
    this.frame = frame;
  }

  public void mouseClicked(PInputEvent event) {
    // only by left mouse-button click
    if(!event.isLeftMouseButton())
      return;

    // create new node as composition of ellipse and text
    PLayer nodeLayer = ((PCanvas)(event.getComponent())).getCamera().getLayer(1);
    Point2D pressPoint = event.getPosition();
    QNode node = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
    node.addToLayer(nodeLayer);
    frame.isModif = true;
    frame.setTitleModif();
    Network.nCount++;
    frame.updateStatus();
  }

}
