package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PPanEventHandler;

import javax.swing.*;
import java.awt.*;

public class QCanvas extends PCanvas {

  final static Color BACKGROUND_COLOR = new Color(204, 204, 255);

  private final Cursor cursorHand = new Cursor(Cursor.HAND_CURSOR);
  private final Cursor cursorDefault = new Cursor(Cursor.DEFAULT_CURSOR);

  private final QCreateNodeHandler createNodeHandler;
  private final QCreateEdgeHandler createEdgeHandler;
  private final QCreateLoopHandler createLoopHandler;
  private QCreatePathHandler createPathHandler;
  private QCreateStructure createStructure;
  private final PPanEventHandler panHandler = new PPanEventHandler();
  //private final PZoomEventHandler zoomHandler        = new PZoomEventHandler();
  private QSelectHandler selectHandler;
  private int setup = -1;


  private PLayer nodeLayer;
  private PLayer edgeLayer;

  public QCanvas(QToolFrame frame, JTextArea info) {
    getCamera().setPaint(BACKGROUND_COLOR);

    createPathHandler = new QCreatePathHandler(frame);
    createNodeHandler = new QCreateNodeHandler(frame);
    createEdgeHandler = new QCreateEdgeHandler(frame);
    createLoopHandler = new QCreateLoopHandler(frame);
    createStructure = new QCreateStructure(frame);
    // set up two layers (0-edges and loops,1-nodes)
    nodeLayer = getLayer();
    edgeLayer = new PLayer();
    getRoot().addChild(edgeLayer);
    getCamera().addLayer(0, edgeLayer);
    getCamera().addLayer(1, nodeLayer);

    //TODO: check this:
    edgeLayer.moveToFront(); // why??

    //TODO: refactor it:
    selectHandler = new QSelectHandler(nodeLayer, nodeLayer, info, frame);
    //setFullScreenMode(true); // nice :)

    // select
    setupSelectorMode();

  }

  public PLayer getNodeLayerReference() {
    return nodeLayer;
  }

  public PLayer getEdgeLayerReference() {
    return edgeLayer;
  }

  public void setupPathCreatorMode() {
    setCursor(cursorDefault);
    selectHandler.unselectAll();
    removeInputEventListener(createEdgeHandler);
    removeInputEventListener(createLoopHandler);
    removeInputEventListener(selectHandler);
    removeInputEventListener(createNodeHandler);
    removeInputEventListener(createStructure);
    removeInputEventListener(createPathHandler);
    addInputEventListener(createPathHandler);
    setPanEventHandler(null);
    //setZoomEventHandler(null);
  }

  public void setupNodeCreatorMode() {
    setCursor(cursorDefault);
    selectHandler.unselectAll();
    removeInputEventListener(createEdgeHandler);
    removeInputEventListener(createLoopHandler);
    removeInputEventListener(selectHandler);
    removeInputEventListener(createPathHandler);
    removeInputEventListener(createStructure);
    removeInputEventListener(createNodeHandler);
    addInputEventListener(createNodeHandler);
    setPanEventHandler(null);
    //setZoomEventHandler(null);
  }

  public void setupEdgeCreatorMode() {
    setCursor(cursorDefault);
    selectHandler.unselectAll();
    removeInputEventListener(createLoopHandler);
    removeInputEventListener(createNodeHandler);
    removeInputEventListener(selectHandler);
    removeInputEventListener(createPathHandler);
    removeInputEventListener(createStructure);
    removeInputEventListener(createEdgeHandler);
    addInputEventListener(createEdgeHandler);
    setPanEventHandler(null);
    //setZoomEventHandler(null);
  }

  public void setupLoopCreatorMode() {
    setCursor(cursorDefault);
    selectHandler.unselectAll();
    removeInputEventListener(createNodeHandler);
    removeInputEventListener(selectHandler);
    removeInputEventListener(createEdgeHandler);
    removeInputEventListener(createPathHandler);
    removeInputEventListener(createStructure);
    removeInputEventListener(createLoopHandler);
    addInputEventListener(createLoopHandler);
    setPanEventHandler(null);
    //setZoomEventHandler(null);
  }

  public void setupSelectorMode() {
    setCursor(cursorDefault);
    removeInputEventListener(createEdgeHandler);
    removeInputEventListener(createLoopHandler);
    removeInputEventListener(createNodeHandler);
    removeInputEventListener(createPathHandler);
    removeInputEventListener(createStructure);
    removeInputEventListener(selectHandler);
    addInputEventListener(selectHandler);
    setPanEventHandler(null);
    //setZoomEventHandler(null);
  }

  public void setupMoveMode() {
    setCursor(cursorHand);
    selectHandler.unselectAll();
    removeInputEventListener(selectHandler);
    removeInputEventListener(createNodeHandler);
    removeInputEventListener(createLoopHandler);
    removeInputEventListener(createEdgeHandler);
    removeInputEventListener(createPathHandler);
    removeInputEventListener(createStructure);
    removeInputEventListener(panHandler);
    setPanEventHandler(panHandler);
  }

  public void setupStructure(int i) {
    setCursor(cursorDefault);
    selectHandler.unselectAll();
    removeInputEventListener(createEdgeHandler);
    removeInputEventListener(createLoopHandler);
    removeInputEventListener(selectHandler);
    removeInputEventListener(createPathHandler);
    removeInputEventListener(createNodeHandler);
    removeInputEventListener(createStructure);
    createStructure.setStructure(i);
    addInputEventListener(createStructure);
    setPanEventHandler(null);
  }
}
