package netmatch.wizard;

import cytoscape.Cytoscape;
import cytoscape.CyNetwork;

import javax.swing.*;
import java.util.Set;
import java.util.Iterator;

public class WizardPanel1 extends JPanel {
  private JComboBox targetCombo;
  private Set s;

  public WizardPanel1() {
    initComponents();
    acquireTargets();
  }

  public void acquireTargets() {
    s = Cytoscape.getNetworkSet();
    targetCombo.removeAllItems();
    for(Iterator it = s.iterator();it.hasNext();) {
      CyNetwork n = (CyNetwork)it.next();
      targetCombo.addItem(n.getIdentifier() + "-" + n.getTitle());
    }
    if(!s.isEmpty())
      targetCombo.setSelectedIndex(0);
  }

  public boolean validateAndSave() {
    return !s.isEmpty();
  }

  private void initComponents() {
    JLabel jLabel1 = new javax.swing.JLabel();
    targetCombo = new javax.swing.JComboBox();
    JLabel jLabel2 = new javax.swing.JLabel();

    setName("targetComboBox");
    jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
    jLabel1.setText("Please select the target network from following list: ");
    targetCombo.setModel(new javax.swing.DefaultComboBoxModel());
    jLabel2.setText("Network loaded in Cytoscape workspace:");
    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .add(19, 19, 19)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel2)
                    .add(targetCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 344, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
            .addContainerGap(37, Short.MAX_VALUE)));
    layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(jLabel1)
            .add(19, 19, 19)
            .add(jLabel2)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(targetCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addContainerGap(180, Short.MAX_VALUE)));
  }

  public String getValue() {
    return (String)targetCombo.getSelectedItem();
  }
}
