// IMPORTED FROM PICCOLOX

package netmatch.piccolox;

import edu.umd.cs.piccolo.util.PBounds;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;

public class PScrollPaneLayout extends ScrollPaneLayout {
  public static class UIResource extends PScrollPaneLayout
      implements javax.swing.plaf.UIResource {

    public UIResource() {
    }
  }


  public PScrollPaneLayout() {
  }

  public void layoutContainer(Container container) {
    JScrollPane jscrollpane = (JScrollPane) container;
    vsbPolicy = jscrollpane.getVerticalScrollBarPolicy();
    hsbPolicy = jscrollpane.getHorizontalScrollBarPolicy();
    Rectangle rectangle = jscrollpane.getBounds();
    rectangle.x = rectangle.y = 0;
    Insets insets = container.getInsets();
    rectangle.x = insets.left;
    rectangle.y = insets.top;
    rectangle.width -= insets.left + insets.right;
    rectangle.height -= insets.top + insets.bottom;
    boolean flag = jscrollpane.getComponentOrientation().isLeftToRight();
    Rectangle rectangle1 = new Rectangle(0, rectangle.y, 0, 0);
    if(colHead != null && colHead.isVisible()) {
      int i = colHead.getPreferredSize().height;
      rectangle1.height = i;
      rectangle.y += i;
      rectangle.height -= i;
    }
    Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
    if(rowHead != null && rowHead.isVisible()) {
      int j = rowHead.getPreferredSize().width;
      rectangle2.width = j;
      rectangle.width -= j;
      if(flag) {
        rectangle2.x = rectangle.x;
        rectangle.x += j;
      }
      else {
        rectangle2.x = rectangle.x + rectangle.width;
      }
    }
    Border border = jscrollpane.getViewportBorder();
    Insets insets1;
    if(border != null) {
      insets1 = border.getBorderInsets(container);
      rectangle.x += insets1.left;
      rectangle.y += insets1.top;
      rectangle.width -= insets1.left + insets1.right;
      rectangle.height -= insets1.top + insets1.bottom;
    }
    else {
      insets1 = new Insets(0, 0, 0, 0);
    }
    Dimension dimension = viewport == null ? new Dimension(0, 0) : viewport.toViewCoordinates(rectangle.getSize());
    PBounds pbounds = new PBounds(0.0D, 0.0D, dimension.getWidth(), dimension.getHeight());
    Dimension dimension2 = viewport == null ? new Dimension(0, 0) : ((PViewport) viewport).getViewSize(pbounds);
    Rectangle rectangle3 = new Rectangle(0, rectangle.y - insets1.top, 0, 0);
    boolean flag1;
    flag1 = vsbPolicy == 22 || vsbPolicy != 21 && dimension2.height > dimension.height;
    if(vsb != null && flag1) {
      adjustForVSB(true, rectangle, rectangle3, insets1, flag);
      dimension = viewport.toViewCoordinates(rectangle.getSize());
      pbounds.setRect(0.0D, 0.0D, dimension.getWidth(), dimension.getHeight());
      dimension2 = ((PViewport) viewport).getViewSize(pbounds);
    }
    Rectangle rectangle4 = new Rectangle(rectangle.x - insets1.left, 0, 0, 0);
    boolean flag2;
    flag2 = hsbPolicy == 32 || hsbPolicy != 31 && dimension2.width > dimension.width;
    if(hsb != null && flag2) {
      adjustForHSB(true, rectangle, rectangle4, insets1);
      if(vsb != null && !flag1 && vsbPolicy != 21) {
        Dimension dimension1 = viewport.toViewCoordinates(rectangle.getSize());
        pbounds.setRect(0.0D, 0.0D, dimension1.getWidth(), dimension1.getHeight());
        Dimension dimension3 = ((PViewport) viewport).getViewSize(pbounds);
        flag1 = dimension3.height > dimension1.height;
        if(flag1)
          adjustForVSB(true, rectangle, rectangle3, insets1, flag);
      }
    }
    if(viewport != null)
      viewport.setBounds(rectangle);
    rectangle3.height = rectangle.height + insets1.top + insets1.bottom;
    rectangle4.width = rectangle.width + insets1.left + insets1.right;
    rectangle2.height = rectangle.height + insets1.top + insets1.bottom;
    rectangle2.y = rectangle.y - insets1.top;
    rectangle1.width = rectangle.width + insets1.left + insets1.right;
    rectangle1.x = rectangle.x - insets1.left;
    if(rowHead != null)
      rowHead.setBounds(rectangle2);
    if(colHead != null)
      colHead.setBounds(rectangle1);
    if(vsb != null)
      if(flag1) {
        vsb.setVisible(true);
        vsb.setBounds(rectangle3);
      }
      else {
        vsb.setVisible(false);
      }
    if(hsb != null)
      if(flag2) {
        hsb.setVisible(true);
        hsb.setBounds(rectangle4);
      }
      else {
        hsb.setVisible(false);
      }
    if(lowerLeft != null)
      lowerLeft.setBounds(flag ? rectangle2.x : rectangle3.x, rectangle4.y, flag ? rectangle2.width : rectangle3.width, rectangle4.height);
    if(lowerRight != null)
      lowerRight.setBounds(flag ? rectangle3.x : rectangle2.x, rectangle4.y, flag ? rectangle3.width : rectangle2.width, rectangle4.height);
    if(upperLeft != null)
      upperLeft.setBounds(flag ? rectangle2.x : rectangle3.x, rectangle1.y, flag ? rectangle2.width : rectangle3.width, rectangle1.height);
    if(upperRight != null)
      upperRight.setBounds(flag ? rectangle3.x : rectangle2.x, rectangle1.y, flag ? rectangle3.width : rectangle2.width, rectangle1.height);
  }

  protected void adjustForVSB(boolean flag, Rectangle rectangle, Rectangle rectangle1, Insets insets, boolean flag1) {
    int i = vsb.getPreferredSize().width;
    if(flag) {
      rectangle.width -= i;
      rectangle1.width = i;
      if(flag1) {
        rectangle1.x = rectangle.x + rectangle.width + insets.right;
      }
      else {
        rectangle1.x = rectangle.x - insets.left;
        rectangle.x += i;
      }
    }
    else {
      rectangle.width += i;
    }
  }

  protected void adjustForHSB(boolean flag, Rectangle rectangle, Rectangle rectangle1, Insets insets) {
    int i = hsb.getPreferredSize().height;
    if(flag) {
      rectangle.height -= i;
      rectangle1.y = rectangle.y + rectangle.height + insets.bottom;
      rectangle1.height = i;
    }
    else {
      rectangle.height += i;
    }
  }
}