// IMPORTED FROM PICCOLOX

package netmatch.piccolox;

import java.awt.*;
import java.awt.event.ActionEvent;
import javax.swing.*;
import javax.swing.plaf.ScrollPaneUI;

public class PScrollPane extends JScrollPane {
  protected static class PNullAction extends AbstractAction {

    public void actionPerformed(ActionEvent actionevent) {
    }

    protected PNullAction() {
    }
  }

  protected static class PScrollEndAction extends AbstractAction {

    public void actionPerformed(ActionEvent actionevent) {
      JScrollPane jscrollpane = (JScrollPane) actionevent.getSource();
      if(jscrollpane.getVerticalScrollBar().isShowing() || jscrollpane.getHorizontalScrollBar().isShowing()) {
        JViewport jviewport = jscrollpane.getViewport();
        if(jviewport != null && jviewport.getView() != null) {
          Rectangle rectangle = jviewport.getViewRect();
          Dimension dimension = jviewport.getViewSize();
          jviewport.setViewPosition(new Point(dimension.width - rectangle.width, dimension.height - rectangle.height));
        }
      }
    }

    protected PScrollEndAction(String s) {
      super(s);
    }
  }

  private static class PScrollHomeAction extends AbstractAction {

    public void actionPerformed(ActionEvent actionevent) {
      JScrollPane jscrollpane = (JScrollPane) actionevent.getSource();
      if(jscrollpane.getVerticalScrollBar().isShowing() || jscrollpane.getHorizontalScrollBar().isShowing()) {
        JViewport jviewport = jscrollpane.getViewport();
        if(jviewport != null && jviewport.getView() != null)
          jviewport.setViewPosition(new Point(0, 0));
      }
    }

    protected PScrollHomeAction(String s) {
      super(s);
    }
  }

  protected static class PScrollAction extends AbstractAction {

    protected int orientation;
    protected int direction;
    private boolean block;

    public void actionPerformed(ActionEvent actionevent) {
      JScrollPane jscrollpane = (JScrollPane) actionevent.getSource();
      if(orientation == 1 && jscrollpane.getVerticalScrollBar().isShowing() || orientation == 0 && jscrollpane.getHorizontalScrollBar().isShowing()) {
        JViewport jviewport = jscrollpane.getViewport();
        Component component;
        if(jviewport != null && (component = jviewport.getView()) != null) {
          Rectangle rectangle = jviewport.getViewRect();
          Dimension dimension = jviewport.getViewSize();
          int i;
          if(component instanceof Scrollable) {
            if(block)
              i = ((Scrollable) component).getScrollableBlockIncrement(rectangle, orientation, direction);
            else
              i = ((Scrollable) component).getScrollableUnitIncrement(rectangle, orientation, direction);
          }
          else if(block) {
            if(orientation == 1)
              i = rectangle.height;
            else
              i = rectangle.width;
          }
          else {
            i = 10;
          }
          if(orientation == 1) {
            rectangle.y += i * direction;
            if(rectangle.y + rectangle.height > dimension.height)
              rectangle.y = Math.max(0, dimension.height - rectangle.height);
            else if(rectangle.y < 0)
              rectangle.y = 0;
          }
          else {
            rectangle.x += i * direction;
            if(rectangle.x + rectangle.width > dimension.width)
              rectangle.x = Math.max(0, dimension.width - rectangle.width);
            else if(rectangle.x < 0)
              rectangle.x = 0;
          }
          jviewport.setViewPosition(rectangle.getLocation());
        }
      }
    }

    protected PScrollAction(String s, int i, int j, boolean flag) {
      super(s);
      orientation = i;
      direction = j;
      block = flag;
    }
  }


  protected PNullAction nullAction;
  protected boolean disableKeyActions;

  public PScrollPane(Component component, int i, int j) {
    super(component, i, j);
    nullAction = null;
    disableKeyActions = false;
    PScrollPaneLayout.UIResource uiresource = new PScrollPaneLayout.UIResource();
    setLayout(uiresource);
    uiresource.syncWithScrollPane(this);
  }

  public PScrollPane(Component component) {
    this(component, 20, 30);
  }

  public PScrollPane(int i, int j) {
    this(null, i, j);
  }

  public PScrollPane() {
    this(null, 20, 30);
  }

  public void setKeyActionsDisabled(boolean flag) {
    if(flag && disableKeyActions != flag) {
      disableKeyActions = flag;
      disableKeyActions();
    }
    else if(!flag && disableKeyActions != flag) {
      disableKeyActions = flag;
      installCustomKeyActions();
    }
  }

  public void setUI(ScrollPaneUI scrollpaneui) {
    super.setUI(scrollpaneui);
    if(!disableKeyActions)
      installCustomKeyActions();
    else
      disableKeyActions();
  }

  protected void installCustomKeyActions() {
    ActionMap actionmap = getActionMap();
    actionmap.put("scrollUp", new PScrollAction("scrollUp", 1, -1, true));
    actionmap.put("scrollDown", new PScrollAction("scrollDown", 1, 1, true));
    actionmap.put("scrollLeft", new PScrollAction("scrollLeft", 0, -1, true));
    actionmap.put("scrollRight", new PScrollAction("ScrollRight", 0, 1, true));
    actionmap.put("unitScrollRight", new PScrollAction("UnitScrollRight", 0, 1, false));
    actionmap.put("unitScrollLeft", new PScrollAction("UnitScrollLeft", 0, -1, false));
    actionmap.put("unitScrollUp", new PScrollAction("UnitScrollUp", 1, -1, false));
    actionmap.put("unitScrollDown", new PScrollAction("UnitScrollDown", 1, 1, false));
    actionmap.put("scrollEnd", new PScrollEndAction("ScrollEnd"));
    actionmap.put("scrollHome", new PScrollHomeAction("ScrollHome"));
  }

  protected void disableKeyActions() {
    ActionMap actionmap = getActionMap();
    if(nullAction == null)
      nullAction = new PNullAction();
    actionmap.put("scrollUp", nullAction);
    actionmap.put("scrollDown", nullAction);
    actionmap.put("scrollLeft", nullAction);
    actionmap.put("scrollRight", nullAction);
    actionmap.put("unitScrollRight", nullAction);
    actionmap.put("unitScrollLeft", nullAction);
    actionmap.put("unitScrollUp", nullAction);
    actionmap.put("unitScrollDown", nullAction);
    actionmap.put("scrollEnd", nullAction);
    actionmap.put("scrollHome", nullAction);
  }

  protected JViewport createViewport() {
    return new PViewport();
  }
}