/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import netmatch.algorithm.Edge;
import netmatch.algorithm.Node;

public class GraphLoader {
    private int count = 0;
    private Node nodes = null;
    private Node lastNode = null;
    private Edge lastEdge = null;
    private JFrame frame;

    public GraphLoader(JFrame frame) {
        this.frame = frame;
    }

    public int NodeCount() {
        return this.count;
    }

    public Object GetNodeAttr(int id) {
        Node n = this.nodes;
        if (this.lastNode != null && this.lastNode.id <= id) {
            n = this.lastNode;
        }
        while (n != null && n.id != id) {
            n = n.next;
        }
        if (n == null) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "NetMatch Error. Inconsistent data!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error. Inconsistent data!");
            }
            return null;
        }
        return n.attr;
    }

    public int getCyNetworkID(int id) {
        Node n = this.nodes;
        if (this.lastNode != null && this.lastNode.id <= id) {
            n = this.lastNode;
        }
        while (n != null && n.id != id) {
            n = n.next;
        }
        if (n == null) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "**NetMatch Error. Inconsistent data!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error. Inconsistent data!");
            }
            return -1;
        }
        return n.networkIndex;
    }

    public int OutEdgeCount(int id) {
        Node n = this.nodes;
        if (this.lastNode != null && this.lastNode.id <= id) {
            n = this.lastNode;
        }
        while (n != null && n.id != id) {
            n = n.next;
        }
        if (n == null) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "NetMatch Error. Inconsistent data!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error. Inconsistent data!");
            }
            return -1;
        }
        return n.count;
    }

    public int GetOutEdge(int id, int i, Object[][] pattr) {
        Node n = this.nodes;
        if (this.lastNode != null && this.lastNode.id <= id) {
            n = this.lastNode;
        }
        while (n != null && n.id != id) {
            n = n.next;
        }
        if (n == null) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "NetMatch Error. Inconsistent data!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error. Inconsistent data!");
            }
            return -1;
        }
        Edge e = n.edges;
        int pos = 0;
        if (this.lastEdge != null && this.lastEdge.from == id && this.lastEdge.pos >= 0 && this.lastEdge.pos <= i) {
            e = this.lastEdge;
            pos = e.pos;
        }
        while (e != null && pos < i) {
            e.pos = pos++;
            e = e.next;
        }
        if (e == null) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "NetMatch Error. Inconsistent data!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error. Inconsistent data!");
            }
            return -1;
        }
        if (pattr != null) {
            pattr[id][i] = e.attr;
        }
        this.lastNode = n;
        this.lastEdge = e;
        return e.to;
    }

    public void toBiDirected() {
        int nc = this.NodeCount();
        Object[][] ea = new Object[nc][nc];
        for (int from = 0; from < nc; ++from) {
            for (int count = 0; count < this.OutEdgeCount(from); ++count) {
                int to = this.GetOutEdge(from, count, ea);
                this.InsertEdge(to, from, ea[from][count]);
            }
        }
    }

    public int InsertNode(Object attr) {
        Node n = new Node();
        n.id = this.count++;
        int id = n.id;
        n.attr = attr;
        n.edges = null;
        n.count = 0;
        Node p = this.nodes;
        Node p0 = null;
        if (this.lastNode != null && this.lastNode.id < id) {
            p0 = this.lastNode;
            p = this.lastNode.next;
        }
        while (p != null && p.id < id) {
            p0 = p;
            p = p.next;
        }
        if (p0 == null) {
            n.next = this.nodes;
            this.nodes = n;
        } else {
            n.next = p0.next;
            p0.next = n;
        }
        this.lastNode = n;
        return n.id;
    }

    public int InsertNode(Object attr, int networkIndex) {
        Node n = new Node();
        n.id = this.count++;
        int id = n.id;
        n.attr = attr;
        n.edges = null;
        n.count = 0;
        n.networkIndex = networkIndex;
        Node p = this.nodes;
        Node p0 = null;
        if (this.lastNode != null && this.lastNode.id < id) {
            p0 = this.lastNode;
            p = this.lastNode.next;
        }
        while (p != null && p.id < id) {
            p0 = p;
            p = p.next;
        }
        if (p0 == null) {
            n.next = this.nodes;
            this.nodes = n;
        } else {
            n.next = p0.next;
            p0.next = n;
        }
        this.lastNode = n;
        return n.id;
    }

    public void InsertEdge(int id1, int id2, Object attr) {
        Node pn = this.nodes;
        if (this.lastNode != null && this.lastNode.id <= id1) {
            pn = this.lastNode;
        }
        while (pn != null && pn.id < id1) {
            pn = pn.next;
        }
        if (pn == null || pn.id != id1) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "NetMatch Warning. Bad param 1 in GraphLoader - InsertEdge: " + id1 + " " + id2, "NetMatch Warning", 2);
            } else {
                System.err.println("NetMatch Warning. Bad param 1 in GraphLoader - InsertEdge: " + id1 + " " + id2);
            }
        } else {
            Edge p = pn.edges;
            Edge p0 = null;
            if (this.lastEdge != null && this.lastEdge.from == id1 && this.lastEdge.to < id2) {
                p0 = this.lastEdge;
                p = this.lastEdge.next;
            }
            while (p != null && p.to < id2) {
                p0 = p;
                p = p.next;
            }
            if (p != null && p.to == id2) {
                p.update(attr);
            } else {
                Edge e = new Edge(id1, id2, attr);
                if (p0 == null) {
                    e.next = pn.edges;
                    pn.edges = e;
                } else {
                    e.next = p0.next;
                    p0.next = e;
                }
                ++pn.count;
                this.lastNode = pn;
                this.lastEdge = e;
            }
        }
    }
}

