package nanomunchers;

import java.util.Vector;

import heurgame.DefaultReferee;
import heurgame.PlayerProxy;
import heurgame.PlayerToken;
import heurgame.TimeKeeper;
import heurgame.analysis.MoveAnalyzer;
import heurgame.analysis.SystemAnalyzer;
import heurgame.event.GameEvent;
/*
 * Created on Oct 21, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoRef extends DefaultReferee {
    private NanoGame myGame;
    private String state = new String("SETUP");
    
    /** 
     * @see heurgame.event.GameListener#gameSetup(heurgame.event.GameEvent)
     */
    public void gameSetup(GameEvent e) {
        super.setup(e);
        this.myGame = (NanoGame)e.context;
        state = e.currentState;
    }

    /** 
     * @see heurgame.event.GameListener#gameStarted(heurgame.event.GameEvent)
     */
    public void gameStarted(GameEvent e) {
        state = e.currentState;
        if (state.equals("SETUP")){
            Vector threadCollection = new Vector();
            for(int i=0;i<this.playerProxies.size();i++){
                final PlayerProxy proxy = (PlayerProxy) this.playerProxies.get(i);
                debugging.addEntry("INIT Thread dispatching",proxy.getToken().getName()+" of "+proxy.getToken().getOrigin());
                Thread t = new Thread(){
                    public void run(){
                        proxy.sendInitialStatus(myGame.getGreeting());
                    }
                };
                debugging.addEntry("INIT Thread dispatched",proxy.getToken().getName()+" of "+proxy.getToken().getOrigin());
                t.start();
                threadCollection.add(t);
            }
            for(int i=0;i<threadCollection.size();i++){
                Thread a = (Thread) threadCollection.get(i);
                try {
                    a.join();
                } catch (InterruptedException e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                }
            }
        }else if (state.equals("MOVE")){
            Vector threadCollection = new Vector();
            final String gameState = game.getState();
            final NanoSystemAnalyzer finalJudge = (NanoSystemAnalyzer) myGame.getSystemAnalyzer();
            final NanoMoveAnalyzer moveJudge = (NanoMoveAnalyzer) myGame.getSystemAnalyzer().getMoveAnalyzer();

            for(int i=0;i<this.playerProxies.size();i++){
                final NanoPlayerProxy proxy = (NanoPlayerProxy) this.playerProxies.get(i);
                Thread t = new Thread(){
                    public void run(){
                        PlayerToken t = (PlayerToken)proxy.getToken();
                        TimeKeeper watchdog = (TimeKeeper)NanoRef.this.timeMap.get(t);
                        debugging.addEntry("Thread 1",proxy.getToken().getName()+" of "+proxy.getToken().getOrigin());
                        watchdog.unPause();
                        String playerAnswer = proxy.getMove(gameState);
                        watchdog.pause();
                        String validity = moveJudge.evaluateMove(playerAnswer, t, 0);
                        String information = validity.substring(validity.indexOf(' ')+1,validity.length());
                        String action = validity.substring(0,validity.indexOf(' '));
                        boolean keepAsking = true;
                        debugging.addEntry("Thread 2",proxy.getToken().getName()+" of "+proxy.getToken().getOrigin());
                        while(keepAsking){
                            debugging.addEntry("Thread Asking",proxy.getToken().getName()+"action|"+action+"|validity|"+ validity+"|information|"+information+"|");
                            if (validity.startsWith(MoveAnalyzer.MOVE_INVALID)){
                                watchdog.unPause();
                                playerAnswer = proxy.sendInvalidMove(information); 
                                watchdog.pause();
                                keepAsking = true;
                            }else if (validity.startsWith(MoveAnalyzer.MOVE_VALID)){
                                keepAsking = information.equals("NEXT");
                                if (keepAsking){
                                    watchdog.unPause();
                                    playerAnswer = proxy.sendNext(); 
                                    watchdog.pause();
                                    keepAsking = true;
                                }else{
                                    proxy.sendDone();
                                    keepAsking = false;
                                }
                            }else if (action.equals(MoveAnalyzer.MOVE_DISQUALIFIED)){
                                NanoRef.this.disqualifyPlayer(t,information);
                                keepAsking = false;
                                break;
                                
                            }
                            
                            validity = moveJudge.evaluateMove(playerAnswer, t, 0);
                            information = validity.substring(validity.indexOf(' ')+1,validity.length());
                            action = validity.substring(0,validity.indexOf(' '));
                            
                        }
                    }	
                };
                debugging.addEntry("Thread dispatched",proxy.getToken().getName()+" of "+proxy.getToken().getOrigin());
                t.start();
                threadCollection.add(t);
            }
            for(int i=0;i<threadCollection.size();i++){
                Thread a = (Thread) threadCollection.get(i);
                try {
                    a.join();
                } catch (InterruptedException e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                }
            }
        }
    }

    /** 
     * @see heurgame.event.GameListener#gameEnded(heurgame.event.GameEvent)
     */
    public void gameEnded(GameEvent e) {
        String goodString = "TIE";
        String badString= "LOSE";
        Vector loosers = new Vector();
        loosers.addAll(playerProxies);
        SystemAnalyzer finalJudge = myGame.getSystemAnalyzer();
        if (finalJudge.isDecisive()){
            goodString = "WIN";
            PlayerToken winToken = finalJudge.getWinningPlayer();
            PlayerProxy winner = (PlayerProxy)playerMap.get(winToken);
            winner.sendFinalStatus(goodString);
            debugging.addEntry("WINNER ANNOUNCED",winToken.getName()+" of "+winToken.getOrigin());
            loosers.remove(winner);//Remove the Proxy not the token!
        }else{
            PlayerToken[] pts = finalJudge.getWinningPlayers();
            for(int i=0;i<pts.length;i++){
                PlayerToken tieToken = pts[i];
                PlayerProxy tied = (PlayerProxy)playerMap.get(tieToken);
                tied.sendFinalStatus(goodString);
                debugging.addEntry("TIE ANNOUNCED",tieToken.getName()+" of "+tieToken.getOrigin());
                loosers.remove(tied);//Remove the Proxy, not the token!
            }
        }
        for(int i=0;i<loosers.size();i++){
            PlayerProxy lost = (PlayerProxy)loosers.get(i);
            lost.sendFinalStatus(badString);
            debugging.addEntry("Loser ANNOUNCED",lost.getToken().getName()+" of "+lost.getToken().getOrigin());
        }

    }

}
