package nanomunchers.ui;

import heurgame.PlayerToken;
import heurgame.ui.PlayerColors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
//import java.awt.Point;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;

import nanomunchers.bot.KNanoBot;
import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;
//import nanomunchers.graph.KGraphFactory;
import nanomunchers.graph.KNode;
/*
 * Created on Oct 27, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoSimulation extends Canvas {
    private KGraph graph;
    Graphics bufferGraphics;
	Image offscreen;
	int hoffset,woffset;
	int lastWidth=-1;
	int lastHeight = -1;
	private PlayerColors playerColors;
	private PlayerToken[] eaten;
	private Vector nodeLookup;
	private Vector currentFrame;
	private Vector allFrames;
	private Hashtable nanoLookup;
	private Hashtable playerLookup;
	double interpolation = .1;
	double currentPosition = 0;
	private Hashtable nanoPlacesStart;
	private Hashtable nanoPlacesEnd;
	
	public void setup(KGraph graph){
	    this.graph = graph;
	    eaten = new PlayerToken[graph.getNodes().length];
	    nodeLookup = new Vector();
	    for(int i=0;i<graph.getNodes().length;i++){
	        nodeLookup.add(graph.getNodes()[i]);
	    }
	    nanoLookup = new Hashtable();
	    playerLookup = new Hashtable();
	    nanoPlacesStart = new Hashtable();
	    nanoPlacesEnd = new Hashtable();
	    currentFrame = new Vector();
	    allFrames = new Vector();
	}
	public Integer register(PlayerToken owner, KNanoBot nb){
	    Integer id = new Integer(nanoLookup.size());
	    nanoLookup.put(id,nb);
	    playerLookup.put(id,owner);
	    return id;
	}
	public void nextMove(Integer nanoId, KNode place,boolean dead){
	    NanoBit bit = new NanoBit();
	    bit.id = nanoId;
	    bit.spot = place;
	    bit.dead = dead;
	    graph = place.getGraph();
	    currentFrame.add(bit);
	}
	public void nextFrame(){
	    System.out.println("Next Frame called "+ allFrames.size());
	    allFrames.add(currentFrame);
	    currentFrame = new Vector();
	}
	public void play(){
	    graph.clear();
	    for(int i=0;i<nanoLookup.size();i++){
	        KNanoBot bot = (KNanoBot)nanoLookup.get(new Integer(i));
	        bot.clear();
	    }
	    System.out.println("Bots cleared");
	    for(int i=0;i<(allFrames.size());i++){
	        System.out.println("Frame "+ i);
	        Vector thisFrame = (Vector)allFrames.get(i);
	        synchronized (nanoLookup){
	            nanoPlacesStart.clear();
	            for(int j=0;j<thisFrame.size();j++){
	                NanoBit bit = (NanoBit)thisFrame.get(j);
	                KNanoBot bot = (KNanoBot)nanoLookup.get(bit.id);
	                nanoPlacesStart.put(bit.id,bit.spot);
	                int spotIndex = nodeLookup.indexOf(bit.spot);
	                eaten[spotIndex] = (PlayerToken)playerLookup.get(bit.id);
	                if (bit.dead==true){
	                    bot.kill();
	                    nanoPlacesEnd.put(bit.id,bit.spot);
	                }else{
	                    KNode next = bot.nextMove();
	                    bot.move();
	                    nanoPlacesEnd.put(bit.id,next);
	                }
	            }
		        while(currentPosition < 1.0){
		            try {
		               // repaint();
		                Thread.sleep(100);
		                currentPosition += interpolation;
		            } catch (InterruptedException e){
		            
		            }
		        }
	        }
	        //Report scores here.
	        currentPosition = 0;

	        
	    }
	}
    public NanoSimulation(PlayerColors pc){
        playerColors = pc;
        Thread paintThread = new Thread(){
            public void run(){
                while(true){
                try {
                    Thread.sleep(50);
                }catch (InterruptedException e){
                    
                }
                repaint();
                }
            }
        };
        paintThread.start();
    }
    public void update(Graphics g){
        if (graph==null){
            return;
        }
        int width = getWidth();
        int height = getHeight();
        if (offscreen == null || (width != lastWidth) || (height != lastHeight)) {
			offscreen = createImage(width, height);
			bufferGraphics = offscreen.getGraphics();
		}
        lastWidth = width;
        lastHeight = height;
        bufferGraphics.setColor(Color.white); //getBackground());
		bufferGraphics.fillRect(0, 0, width, height);
        
        //g.translate(0,-1);
        woffset = width/(graph.getWidth()+1);
        hoffset = height/(graph.getHeight()+1);
        bufferGraphics.setColor(new Color(0,0,0));
        if (((width+1) > graph.getWidth()) && ((height+1) > graph.getHeight())){
            KEdge[] edges = graph.getUniqueEdges();
            int sx,sy,dx,dy;
            for(int i=0;i<edges.length;i++){
                boolean a = edges[i].getNodes()[0].isMarked();
                boolean b = edges[i].getNodes()[1].isMarked();
                if (!a && !b){
                    bufferGraphics.setColor(new Color(0,0,0));
                }else{
                    int aindex = nodeLookup.indexOf(edges[i].getNodes()[0]);
                    int bindex = nodeLookup.indexOf(edges[i].getNodes()[1]);
                    if (eaten[aindex]==eaten[bindex]){
                        bufferGraphics.setColor(playerColors.getColor(eaten[aindex]));
                    }else{
                        bufferGraphics.setColor(new Color(254,100,250));
                    }
                }
                    sx = woffset + woffset*edges[i].getNodes()[0].getX();
                    dx = woffset + woffset*edges[i].getNodes()[1].getX();
                    sy = hoffset + hoffset*edges[i].getNodes()[0].getY();
                    dy = hoffset + hoffset*edges[i].getNodes()[1].getY();
                    
                    bufferGraphics.drawLine(sx,sy,dx,dy);
                    
                    if (!a && !b){
                        bufferGraphics.drawLine(sx,sy+1,dx,dy+1);
                        bufferGraphics.drawLine(sx+1,sy,dx+1,dy);
                        bufferGraphics.drawLine(sx,sy-1,dx,dy-1);
                        bufferGraphics.drawLine(sx-1,sy,dx-1,dy);
                    
                        bufferGraphics.drawOval(sx-5,sy-5,10,10);
                        bufferGraphics.drawOval(dx-5,dy-5,10,10);
                    }
                    
                
            }
            //draw the bots
            for(int i=0;i<nanoPlacesStart.size();i++){
                Integer id = new Integer(i);
                KNode start = (KNode)nanoPlacesStart.get(id);
                KNode end =   (KNode)nanoPlacesEnd.get(id);
                if (start==null){
                    continue;
                }
                sx = woffset + woffset*start.getX();
                dx = woffset + woffset*end.getX();
                sy = hoffset + hoffset*start.getY();
                dy = hoffset + hoffset*end.getY();
                
                int ix = (int)((double)sx + ((double)(dx - sx))*currentPosition);
                int iy = (int)((double)sy + ((double)(dy - sy))*currentPosition);
                bufferGraphics.setColor(playerColors.getColor((PlayerToken)playerLookup.get(id)));
                KNanoBot bot = (KNanoBot)nanoLookup.get(id);
                if (bot.isAlive()){
                    bufferGraphics.fill3DRect(ix-10,iy-10,20,20,true);
                }else{
                    bufferGraphics.fillRect(ix-10,iy-10,20,20);
                }
            }
        }
        //g.translate(0,1);
        g.drawImage(offscreen, 0, 0, this);
    }
    public static void main(String args[]){
        final Frame f = new Frame("NanoSimulation");
        f.setLayout(new java.awt.BorderLayout());
        GraphEditPanel gep = new GraphEditPanel();
        gep.setSize(500,350);
        f.add(gep);
        
        f.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                f.dispose();
                System.exit(1);
            }
        });
        f.pack();
        f.show();
    }
    
    class NanoBit{
        public Integer id;
        public KNode spot;
        public boolean dead;
    }
}
