package heurgame.ui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import heurgame.logging.LogItem;
import heurgame.logging.LogReader;
/*
 * Created on Oct 16, 2004
 */

/**
 * @author David Kaplin
 *
 * A common interface for getting messages that are logged
 */
public class GraphicalLogInterface implements LogReader {
    private static List log = new List();
    private static Frame logWindow = new Frame("Log");
    /** 
     * @see heurgame.logging.LogReader#readLog(java.lang.String, int, heurgame.logging.LogItem)
     */
    public void readLog(String who, int priority, LogItem information) {
        log.add(
          information.getTime() + " " + information.getWho() +": "      
          + information.shortDescription + " -- " + information.longDescription
        );
    }
    public static Frame getLogWindow(){
        logWindow.setLayout(new BorderLayout());
        logWindow.add(log);
        Toolkit tk = logWindow.getToolkit();
        logWindow.setSize((tk.getScreenSize().width*3)/4,(tk.getScreenSize().height*3)/4);
        logWindow.setLocation((tk.getScreenSize().width)/8,(tk.getScreenSize().height)/8);
        Button close = new Button("Close");
        logWindow.add(close,BorderLayout.SOUTH);
        final Runnable r = new Runnable(){
            public void run(){
                logWindow.hide();
            }
        };
        close.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                r.run();
            }
        });
        logWindow.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                r.run();
            }
        });
        return logWindow;
    }
    /** 
     * @see heurgame.logging.LogReader#clearLog()
     */
    public void clearLog() {
        log.removeAll();
    }

}
