package nanomunchers.graph;
import java.util.*;
import java.awt.*;

import nanomunchers.bot.NanoBot;
/*
 * Created on Oct 25, 2003
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */

/**
 * @author john doe
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Node {

	/**
	 * 
	 */

	public static final int BOARD_H = 10;  //used to flip the board vertically

	int id, x, y;
	Point p = null;

	Vector v = new Vector(); // edges will be converted to array for efficency

	NodeSet set = null;
	Node[] edges = null;

	boolean marked = false;
	boolean isleaf = false;
	private NanoBot bot = null;

	public Node(int id, int x, int y) {
		this.id = id;
		this.x = x;
		this.y = y;
		p = new Point(x, y);
	}

	public int getX() {
		return BOARD_H - x;
	}
	public Point getRawPoint(){
	    return p;
	}
	public void setBot(NanoBot b) {
		this.bot = b;
	}

	public NanoBot getBot() {
		return bot;
	}

	public NodeSet getSet() {
		return set;
	}

	public void setSet(NodeSet set) {
		this.set = set;
	}

	public void setLeaf(boolean b) {
		isleaf = b;
	}

	public boolean isLeaf() {
		return isleaf;
	}
	public boolean isMarked(){
	    return marked;
	}
	public void unMark() {
		marked = false;
		bot = null;
	}

	public void mark(NanoBot bot) {
		
		marked = true;
		this.bot = bot;
	}

    // converts the edges vector into an array for faster running
	public void init() {
		edges = new Node[4];
		for (int i = 0; i < v.size(); i++) {

			Node n = (Node) v.elementAt(i);
			Point edgeP = n.p;

			if (edgeP.x < p.x) {
				edges[NanoBot.LEFT] = n;
			} else if (edgeP.x > p.x) {
				edges[NanoBot.RIGHT] = n;
			} else if (edgeP.y > p.y) {
				edges[NanoBot.UP] = n;

			} else if (edgeP.y < p.y) {
				edges[NanoBot.DOWN] = n;
			}
		}

	}

	public Point getLoc() {
		return new Point(p.x, BOARD_H - y);
	}

	public void addEdge(Node node) {
		v.addElement(node);
	}

	public String toString() {

		return id + "," + p.x + "," + p.y ;
	}

	public Node getEdge(int i) {
		return edges[i];
	}
	public int getId(){
	    return id;
	}
	public static void main(String[] args) {
	}
}
