package heurgame.logging;

import java.util.List;
/**
 * @author David Kaplin
 * Log writers report information to the logs.
 * In this system the Log writers are passive.
 * Over time the log that they registered with will
 * check it for updates.
 */
public interface LogWriter {
    /**
     * Usually a particular LogWriter is going to send more than one message
     * to the log during the life of a program.  To avoid constantly sending
     * the sender's name during updates a LogWriter should identify itself
     * through this message.
     * 
     * @return Descriptive name of the reporting component.
     */
    public abstract String getLogName();
    
    /**
     * This is the normal method for adding information to the log.
     * 
     */
    public abstract List getEntries();
    
    /**
     * Normally logs are stored in a FIFO manner.  Using this method will give your
     * message the opportunity to reach the highest point in the log.
     *
     * @return A List of urgent entires for the log
     */ 
     
    public abstract List urgentEntries();
}
