package heurgame;
/*
 * Created on Oct 12, 2004
 */


/**
 * @author David Kaplin
 *
 *Identifies each player to the system.  Allows easier debugging and
 *better abstraction from the origin of the players.
 */
public class PlayerToken{
    private String name;
    private String origin;
    /**
     * This should only be called in the PlayerProxy Class.
     * No other classes should create PlayerTokens.
     * 
     * @param parent The connection to the player's input, insures you have 
     * access to a PlayerProxy for construction.
     * @param origin Describing the source of the input, usually a network
     * address.
     * @param name Name of the player.
     */
    protected PlayerToken(PlayerProxy parent,String origin, String name){
        this.name = name;
        this.origin = origin;
    }
    /**
     * @return Name given to the player by the player.
     */
    public String getName(){return name;}
    
    /**
     * To adapt for whitespace intolerant protocols.
     * @return Name where all whitespace is removed and 
     * replaced with underscores.
     */
    public String getWhitespaceSafeName(){
        return name.replace(' ','_');
    }
    /**
     * @return Origin of the input from the player, usually a network
     * address, might be something more exotic.
     */
    public String getOrigin(){return origin;}
}