#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"
#include "cfortran.h"
#include "hbook.h"
#include <time.h>

int grb_finder(int Data, EVENT_DATA *eventData, char *filename) {

  char reason[10][50] = {" ",
                         "last Event",
                         "Event Buffer Full",
                         "Buffer evaluation time reached",
                         "run changed",
                         "time reversal",
                         "time gap ",
			 "checkEvent error"};
  static int    firstevent=1,firstcall=1; 
  static int    nFit_event,nHit_event,irun,subirun,passed,nBuff,i,j,k,dha,ddec,itotal,   
                irunlast,iha,idec,ira,itime,evaluate,nhabins,xha,xdec,signal,
                nHead,nTail,nTailBack,nBack,nBuffBack,nBuffBackOld;
  static unsigned int  julDate,datelast;
  short int     timeErr;
  int           eventERR,bad;
  static double time,duration[NDUR],x,y,timediff,previoustime,timedifftot,
                nValid,ntimediff,delT,sum_time,start_time,end_time,cpuT,
                localRA,localDec,sidTime,localDec2000,timelast,lastCalcTime=-999.,
                timemin,sidmin,time_lastEvent,backint,backduration;
  static float  ra_event,dec_event,theta_event,phi_event,chi_event,gby_event,
                ha_event,xcore_event,ycore_event,x2_event,fracfit_event,
                ramin,ramax,decmin,decmax,hamin,hamax,event_rate,backnorm,total,
                temp,back;
  char          chfield[100],str[300];
  FILE          *fp;

  static EVENT evbuffer[EVBUFFSIZE];
  static TIME_DIST timebin[4000];
  static MAP maps;
  static PROB prob;

  /* initialize at first call */
  if (firstcall) { 

    firstcall=0;
    ramin =  -0.005;
    ramax = 359.995;
    hamin =  -0.005;
    hamax = 359.995;
    decmin= -59.995;
    decmax=  90.005;
    grb_finder_init(&maps,duration,&prob);
  } /* close if (firstcall) */
   
  if (Data) {
    dec_event   = eventData->recEvent.reconInfo.angleFit.decF;
    time        = eventData->recEvent.reconInfo.clockData.eventTime;
    timeErr     = eventData->recEvent.reconInfo.clockData.timeErr;
    nFit_event  = eventData->recEvent.reconInfo.angleFit.nFit;
    ra_event    = eventData->recEvent.reconInfo.angleFit.raF;
    theta_event = eventData->recEvent.reconInfo.angleFit.thetaF;
    phi_event   = eventData->recEvent.reconInfo.angleFit.phiF;
    chi_event   = eventData->recEvent.reconInfo.angleFit.chiSq;
    julDate     = eventData->recEvent.reconInfo.clockData.julDate;
    nHit_event  = eventData->recEvent.reconInfo.nPMTs;
    gby_event   = eventData->recEvent.reconInfo.ghRecon.gh_GBY;
    irun        = eventData->subRunInfo2.runNum;
    subirun     = eventData->subRunInfo2.subRunNum;
    xcore_event = eventData->recEvent.reconInfo.coreFit.xCoreF;
    ycore_event = eventData->recEvent.reconInfo.coreFit.yCoreF;
    x2_event    = ((float)eventData->recEvent.reconInfo.poolFit.nPMT2[1])/
                    eventData->recEvent.reconInfo.ghRecon.maxPEmuon;

    /*this code is not used for anything at the moment
    // calculate fraction of PMTs used in the fit 
    if (eventData->recEvent.reconInfo.poolFit.nPMT[0]>0) {
    fracfit_event = (100*nFit_event)/
    eventData->recEvent.reconInfo.poolFit.nPMT[0];
    } else {
    fracfit_event = 0;
    }
    // for event comming in within 1s of the previous event,   
    // add up the times between events to get the average rate 
    timediff=time-previoustime;
    if (timediff>0. && timediff<1.) {
    timedifftot+=timediff;
    ntimediff+=1.;
    }
    previoustime=time;
    */
    

    // try to catch time errors that the decode software misses 
    passed=0;
    bad=0;
    if (time>86400. || time<0.) timeErr=999.; // remove clock errors     
    if (julDate<1200 || julDate>3000) timeErr=999.;
    eventERR=checkEvent(eventData);

    //do not use bad events found by checkEvent
    if(eventERR==1||eventERR==2
       ||(eventERR>=4&&eventERR<=7)||eventERR==9) bad=1;


    // place cuts here 
    if (dec_event<80. && dec_event> -55. &&   //liberal declination cut 
        timeErr<4&&!bad&&eventERR!=10) {                    
 
      passed=1;        //passed cuts 
      nValid+=1.0;     // incement event counter 
    
      if (firstevent) {
        nBuff=0;
        nBuffBack=0;
        nHead=0;
        nTail=0;
        nTailBack=0;
        timelast=time;
        irunlast=irun;
        datelast=julDate;
        itime=0;
        lastCalcTime=-999.;
        firstevent=0;
      }
    
      //Below is for converting to local coordinates. 
      //If lastCalcTime is different from the current 
      //time by more than the amount of time it takes
      //the earth to rotate by 0.2 degrees, recalculate
      //the siderial time (which effects the calculation
      //of hour angle).

      // recalcualte local Siderial Time 
      if ((lastCalcTime-time)>TIMETICK || (lastCalcTime-time)<0.) {
        Angle2Astro(julDate, time, 90. , 0., &localDec, &localRA);
        J2000(julDate,localDec,localRA,&localDec2000,&sidTime);
        sidmin=((float)((int)(sidTime*10.)))/10.;  //keep sidTime to 1 decimal
        timemin=time-(sidTime-sidmin)*TIMETICK/.1;  
        lastCalcTime = timemin;
	//        itime=  (int)((sidmin+BINSIZE/2)/BINSIZE);  not being used
        //        timebin[itime].st      = sidmin+BINSIZE/2.; 
      }

      // now calculate Hour Angle 
      // iha:0-900 -> ha of 180-360. iha:900-1800 -> ha of 0-180.
      // idec:0-750 ->dec of -60-90 
      ha_event  = (ra_event-sidmin); 
      if (ha_event<hamin) ha_event+=360.;
      if (ha_event>hamax) ha_event-=360.;
      iha = (int) ((ha_event-hamin)/BINSIZE)+NHA_BINS/2;
      if (iha>NHA_BINS) iha-=NHA_BINS;
      if (iha==3600) iha=0;
      idec= (int) ((dec_event-decmin)/BINSIZE);
      if (iha<0 || iha>NHA_BINS){
        sprintf(str,"iha out of range : %d %f %f %f\n",
		iha,ra_event,sidTime,ha_event);
	grb_finder_logger(str);
      }

      //increment number of events collected in this time bin 
      //     timebin[itime].nevents+=1.0;  //not currently used

      // create signal maps 
      ira = (int) ((ra_event-ramin)/BINSIZE);
      if (ira==NRA_BINS) ira=0;
      if (ira<0 || ira>=NRA_BINS || idec<0 || idec>=NDEC_BINS) {
        sprintf(str,"ira,idec out of range: ira=%d  idec=%d\n",ira,idec);
	grb_finder_logger(str);
      }
    
      /* when day changes, but run does not, consider event as from previous */
      /* day with time >86400s                                               */
      time += (julDate-datelast)*86400.;    

      /* fill event buffer: It is a circle queue */
      /* nHead is the position of the front of the queue */
      /* nTail is the position of the back of the queue  */
      /* nBuff is the number of entries                  */
 
      evbuffer[nHead].time = time;
      evbuffer[nHead].ira  = ira;
      evbuffer[nHead].iha  = iha;
      evbuffer[nHead].idec = idec;

      if (nHead>=1) {
        time_lastEvent=evbuffer[nHead-1].time;
      } else if (nTail!=0) {
        time_lastEvent=evbuffer[EVBUFFSIZE-1].time;
      } else {
        time_lastEvent=0.;
      }
      
      nHead++;
      if (nHead==EVBUFFSIZE) nHead=0;
      nBuff++;
      nBuffBack++;

      if (nHead==nTail) { 
        nBuff--; 
        nTail++; 
      }
      
      if (nHead==nTailBack) {
        nBuffBack--;
        nTailBack++;
        if (nTailBack==EVBUFFSIZE) nTailBack=0;
        maps.backmap_ha_dec[evbuffer[nHead].iha][evbuffer[nHead].idec]--;
        if (maps.backmap_ha_dec[evbuffer[nHead].iha][evbuffer[nHead].idec]<0) {
          sprintf(str,"grb_finder: Something is wrong with the background map!\n");
	  grb_finder_logger(str);
	}
      }

      // add to HA-DEC background map 
      maps.backmap_ha_dec[iha][idec]++;
        
    } // end if passed cuts 
  } // end if Data 

  ////////////////////////////////////////////////////////////////////////

  backduration = time-evbuffer[nTailBack].time;

  // I added data to the buffer, should I search it yet?

  evaluate = 0;
  if (!Data) evaluate=1;                  // last event             
  if (nBuff>=EVBUFFSIZE) evaluate=2;      // event buffer full
  if (nBuff>1 && passed) {
    // more than 1 hour past 
    if (time-timelast>ANALYSIS_BITE && backduration>MIN_BACK_TIME) evaluate=3; 
    //tese two should be caught by checkEvent
    if (time<time_lastEvent)    evaluate=5;     // time reversal detected
    if (time-time_lastEvent>1.) evaluate=6;     // time gap              
    
    //if() put rate monitor here
  }
  
  if(bad) evaluate=7; //bad data, but don't eval if high nhit low nfit event
  if (irun!=irunlast && passed) evaluate=4;     // run change            
  
  if (evaluate) {

    event_rate = ((float)nBuff)/(time-timelast);
    if(evaluate==7)sprintf(str,
	    "evaluating background for reason: %s, %d events check err %d\n",
	    reason[evaluate],nBuff,eventERR);
    else sprintf(str,
	    "evaluating background for reason: %s, %d events\n",
	    reason[evaluate],nBuff);
    grb_finder_logger(str);
    
    sprintf(str,
	    "End time, Start time, Delta T, rate, julDate:  %f %f %f %f %d\n",
	    time,timelast,time-timelast,event_rate,julDate);
    grb_finder_logger(str);
    if (evaluate==4) {
      sprintf(str,"Run Changed from %d to %d \n",irunlast,irun);
      grb_finder_logger(str);
    }


    /* //do not need this. time gaps and reversals, not added to buffer
       
    if (evaluate==5 || evaluate==6 ) {
    sprintf(str,"time=%f, time Last Event=%f\n",time,time_lastEvent);
    grb_finder_logger(str);
    // Remove last event from search buffer 
    nHead--;
    nBuff--;   
    nBuffBack--; 
    maps.backmap_ha_dec[evbuffer[nHead].iha][evbuffer[nHead].idec]--;
    }
    */
    
    sprintf(str,"Background map contains %d events from %f s\n",
            nBuffBack,backduration);
    grb_finder_logger(str);
    if ( ((float)nBuffBackOld)/((float)nBuffBack) <0.95 ) {
      //   printf("%f %f %g\n",back,sig,prob->value[i][j]);
      grb_finder_backmap(nBuffBack, &prob, &maps);
      nBuffBackOld = nBuffBack;
    }
  
    /* search buffer for grbs */
    /* for short duration searches use grb_finder_eveldata_table()  */
    /* for long duration searches use grb_finder_eveldata_bins()    */
    /* change in method made at 300./event_rate s for optimum speed  */
    
    sum_time = 0.;
    delT = evbuffer[nHead-1].time-evbuffer[nTail].time;
    if (delT<.1 || backduration<600.) { 
      sprintf(str,"skipping short data block\n");
      grb_finder_logger(str);
    } else {
      for (i=0;i<NDUR;i++) {
        start_time = clock();
	sprintf(str,"Duration: %9.5fs ",duration[i]);
	grb_finder_logger(str);
        if (duration[i]>0.2) {   /* not rate, but 2s is cutoff */
	  sprintf(str," bins   ");
	  grb_finder_logger(str);
          grb_finder_evaldata_bins(evbuffer,&maps,&prob,duration[i],i,
                                   nTail,nTailBack,nBuff,julDate,irun,subirun);
        } else {
	  sprintf(str," table  ");
	  grb_finder_logger(str);
          grb_finder_evaldata_table(evbuffer,&maps,&prob,duration[i],i,
                                    nTail,nTailBack,nBuff,julDate,irun,subirun);
        }
        end_time = clock();
        cpuT = (double)(end_time - start_time)/(double)CLOCKS_PER_SEC;
        sum_time+=cpuT;
	sprintf(str,"%7.2fs %7.2f \n",cpuT,delT/cpuT);
	grb_finder_logger(str);
        fflush(0);
      }
      sprintf(str,"Completed search of %7.2fs on %2d timescales in %7.2fs (%7.2f)\n",
	      delT,NDUR,sum_time,delT/sum_time);
      grb_finder_logger(str);
    }

    /* zero out signal and background arrays */
    nTail = nHead;
    nBuff = 0;
/* old code, not getting it done */
/* 
    if (passed) {
      if (time<86400.) {
        timelast=time;
      } else {
        timelast=time-86400.;
      }
      datelast=julDate;
    }
    irunlast=irun;
     sprintf(str,"-----------------\n");
     grb_finder_logger(str);
*/
/* new code should do better */
    if (passed) {
      timelast = time;
    }
    irunlast=irun;
     sprintf(str,"-----------------\n");
     grb_finder_logger(str);
    /* reset binned background map */
    for(i=0;i<NHA_BINS;i++) {
      for(j=0;j<NDEC_BINS;j++) {
        maps.backmap[i][j]= 0.;
      }
    }

    /* reset maps on run change or time reversal */
    if (evaluate==4 || evaluate==5 || evaluate==6) {           
      datelast=julDate;
      for(i=0;i<NHA_BINS;i++) {
        for(j=0;j<NDEC_BINS;j++) {
          maps.backmap_ha_dec[i][j]= 0; 
        }
      }
      nBuff     = 0;
      nBuffBack = 0;
      nTail     = 0;
      nTailBack = 0;
      nHead     = 0;
      if (time>86400.) timelast=time-86400.;
      if (time<86400.) timelast=time;
    }

    /* Fill histograms */
    for(k=0;k<NDUR;k++) {
      sprintf(chfield," ");
      HRESET(k*10+1,chfield);
      HRESET(k*10+2,chfield);
      HRESET(k*10+3,chfield);
      for(i=0;i<MAX_SIG;i++) {
        for (j=0;j<PROB_BINS;j++) {
          if (prob.count[k][i][j]>0) {
            signal = i;
            back   = exp(((float)j)*prob.span/PROB_BINSF+prob.minback);
      
	    HFILL(k*10+1,(float)signal,0.,(float)prob.count[k][i][j]);
            HFILL(k*10+2,log10(back),0.,(float)prob.count[k][i][j]);
            HFILL(k*10+3,log10(prob.value[i][j]),0.,(float)prob.count[k][i][j]);
          }
        }
      }
    }
    sprintf(str,"writing file : %s\n",filename);
    grb_finder_logger(str);
    sprintf(chfield,"N");
    HRPUT(0,filename,chfield);
     /* touch status file to show that program is operational */

    if(ON) system("touch /home/daq/burst/short");
    
  } /* end if evaluates */

} 
