#include "common.h"

extern bool OUTPUT_DATA_COUNT;	//flag to control if showing the current matched record with each operation
extern bool QUERY_WITH_DEGREE;	//flag to control if doing matching using degree information
extern bool QUIET_MODE;				//flag to control if showing the debug information

////////////////////////////////////////////
//
// Class: PathTableWithDegree 
// Usage: To store the patterns with degree information found while DFS traverersal in GraphBuild/GraphGrep
//		  Using map to store different PathTables as inner element.
//	
/////////////////////////////////////////////
class PathTableWithDegree{
	map<string,PathTable*>*  _MapOfTables;	
	string _tablename;
	int _LP;
	int _section_count;
	int _record_count;
	int _outputdatasize;

public:
	~PathTableWithDegree();
	PathTableWithDegree(string& tablename,int lp):_tablename(tablename),_LP(lp),_section_count(0),_record_count(0),_outputdatasize(0){
		_MapOfTables=new map<string,PathTable*>;
	}

	void insert(string& strdegree,NodeType* node_arr);
	NodeType* outputData();
	int getOutputdatasize(){return _outputdatasize;}
};

////////////////////////////////////////////
//
// Class: PathTable
// Usage: To store the patterns without degree information found while DFS traverersal in GraphBuild/GraphGrep
//
///////////////////////////////////////////// 
class PathTable
{
public:
	//Constructor functions
	PathTable(const char* tabname, NodeType* data);		//Takes table name and data array(contain rows,cols information) as parameters
	PathTable(const char* tabname,int rows,int cols,vector<NodeType*> data); //Takes table name, rows, cols and data array as parameters
	PathTable(string tabname,PathTable& intab);			//Takes table name and another reference of PathTable as  paremeters
	PathTable(string tabname,int cols):_name(tabname),_rows(0),_cols(cols),_tmp_counter(100){ //Takes table name and cols as parameters 
		_all_pathes=(NodeType**)operator new(_tmp_counter*sizeof(NodeType*)); //create empty table
	};	

	//Destructor
	~PathTable();
	
	//Simple functions return member datas
	const char* get_Name(){return _name.c_str();};	//Function returns the table name
	int get_rows(){return _rows;};		
	int get_cols(){return _cols;};
	
	NodeType** get_alldata(){return _all_pathes;};	//Function returns the 2D array of the pathes
	NodeType* get_data(int index){return _all_pathes[index];};	//Function returns an array of pattern-data of one specific index position
	
	NodeType get_item(int row,int col){	return _all_pathes[row][col];};	//Function returns the specific Node 
	
	void printTable();		//Output table content to screen
	void print2file(FILE* fp,const char* graphname);	//Output table content to file


	//realloc more memory for all possible paths
	void resetPaths();

	void insertData(NodeType* row);


private:
	string _name;		//Table name
	int  _rows;			//Table rows
	int  _cols;			//Table columns
	int _tmp_counter;	//A Counter use to record current allocated slot for paths. !! Must > _rows
	NodeType** _all_pathes;		//Pointer to a 2D array(Rows x Cols) which contains all the patters and its data

	void CreateTable(const char* tabname,NodeType* pathdata);		//Function actually allocate memory for the class member, take tablename and pathdata as paremeters
	void CreateTablefromResult(const char* tabname,int rows,int cols,const vector<NodeType*>& pathdata); //Function actually allocate memory for the class member
};


class OPFile
{
public:
	OPFile();
	OPFile(char* opfile,char* outfile,Db* db);
	void run();
	void reset();

	~OPFile(){
		fclose(fpout);
	};

	PathTable* loadTable(const string& tableName);
	void releaseTable(const string& tablenames);

	void addTable(PathTable* table);
	string getTableName(const char* tablename);
	
	void setGraphIDs(vector<string>& list){graphIDs=list;};
	vector<string>& getGraphIDs(){return graphIDs;};
	void setCurrentGraphID(string cur){strGraphID=cur;};
	string getCurrentGraphID(){return strGraphID;}

	//get the whole opfile
	char* print();

	FILE* getOutFile(){return fpout;}

private:
	int switchCmd2Code(const string& cmd);

	vector<string> opfile;
	vector<string> graphIDs;
	deque<PathTable*> pool;
	Db* _db;

	int opcount;	//operation count
	string strGraphID;
	FILE* fpout;
};


class Operation
{
public:
	Operation():_in(""){};
	Operation(string inStr,OPFile* opfile):_in(inStr),_opfile(opfile){};
	virtual ~Operation(){}; //should not delete result table. Let OPfile handle it

	//must overide in children
	virtual int getOPType()=0;	
	virtual void execute()=0;
	//virtual vector<string> getNeedTableName(){return NULL;};

	PathTable* getResult(){return tab_result;};
	void setResult(PathTable* result){tab_result=result;};
	void print();
	
protected:
	string _in;
	OPFile* _opfile;
	PathTable* tab_result;
};

class OPInterSect: public Operation{
public:
	OPInterSect(string inStr,OPFile* opfile);
	
	void execute();
	int getOPType(){return INTERSECT;};
	
	void print();
private:
	string str_in1_tab;
	int i_joint1;
	string str_in2_tab;
	int i_joint2;

	string str_out_tab;
};

//Operation OPTestUnique
class OPTestUnique: public Operation{
public:
	OPTestUnique(string inStr,OPFile* opfile);
	~OPTestUnique(){free(i_pos);};

	void execute();
	int getOPType(){return TESTUNIQUE;};

	void print();
private:
	string str_in_tab;
	string str_out_tab;

	int pos;
	int* i_pos;
};

//Operation OPSelect
class OPSelect: public Operation{
public:
	OPSelect(string inStr,OPFile* opfile);
	~OPSelect(){free(i_pos);};

	void execute();
	int getOPType(){return SELECT;};

	void print();
private:
	string str_in_tab;
	string str_out_tab;

	int pos;
	int* i_pos;

};

//Operation OPSelect
class OPCartesianProduct: public Operation{
public:
	OPCartesianProduct(string inStr,OPFile* opfile);

	void execute();
	int getOPType(){return CARTESIANPRODUCT;};

	void print();
private:
	string str_in1_tab;
	string str_in2_tab;
	string str_out_tab;
	
};

//Operation OPSelect
class OPSpit: public Operation{
public:
	OPSpit(string inStr,OPFile* opfile);
	~OPSpit(){};

	void execute();
	int getOPType(){return SPIT;};

	void print();
private:
	string str_in_tab;
};

//Exception class
class GraphGrepExcp: public exception
{
public:
	GraphGrepExcp(const char* err_str){};
};

class ReadGraphExcp: public exception
{
	int graphID;
public:
	ReadGraphExcp(int id):graphID(id){};

	int getID(){return graphID;}
};

