# Generated by Django 2.0.6 on 2018-08-13 15:07

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0009_alter_user_last_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Feedback',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mark', models.PositiveSmallIntegerField(default=4)),
                ('title', models.CharField(blank=True, default=None, max_length=200, null=True)),
            ],
            options={
                'db_table': 'feedback',
                'ordering': ['mark', 'title'],
            },
        ),
        migrations.CreateModel(
            name='FeedbackRawFood',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mark', models.PositiveSmallIntegerField(default=4)),
                ('title', models.CharField(blank=True, default=None, max_length=200, null=True)),
            ],
            options={
                'db_table': 'feedbackrawfood',
                'ordering': ['mark', 'title'],
            },
        ),
        migrations.CreateModel(
            name='Intolerences',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('intolerence_name', models.CharField(default=' ', max_length=100)),
            ],
            options={
                'db_table': 'intolerences',
            },
        ),
        migrations.CreateModel(
            name='PreferenceCuisines',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cuisine_name', models.CharField(default=' ', max_length=100)),
            ],
            options={
                'db_table': 'preference_cuisines',
            },
        ),
        migrations.CreateModel(
            name='PreferenceRawFoods',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('raw_food_name', models.CharField(default=' ', max_length=100)),
            ],
            options={
                'db_table': 'preference_raw_food',
            },
        ),
        migrations.CreateModel(
            name='Recipe',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recipe_id_api', models.IntegerField(default=0)),
                ('title', models.CharField(default=None, max_length=100)),
                ('link', models.CharField(default=None, max_length=1000)),
                ('likes', models.PositiveIntegerField(default=0)),
                ('dislikes_no_opinion', models.PositiveIntegerField(default=0)),
                ('percent', models.FloatField(default=0)),
            ],
            options={
                'db_table': 'recipes',
                'ordering': ['-percent', '-likes'],
            },
        ),
        migrations.CreateModel(
            name='Saved_Recipes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('diet_recipes', models.CharField(default=None, max_length=10000)),
                ('total_nutrients_taken', models.CharField(default=None, max_length=2000)),
            ],
            options={
                'db_table': 'saved_recipes',
            },
        ),
        migrations.CreateModel(
            name='USDAfoods',
            fields=[
                ('NDB_No', models.IntegerField(default=1, primary_key=True, serialize=False)),
                ('desc', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('calorie', models.IntegerField(default=None)),
                ('protein', models.IntegerField(default=None)),
                ('fat', models.IntegerField(default=None)),
                ('carb', models.IntegerField(default=None)),
                ('group_code', models.IntegerField(default=None)),
                ('group_name', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('likes', models.PositiveIntegerField(default=0)),
                ('dislikes_no_opinion', models.PositiveIntegerField(default=0)),
                ('percent', models.FloatField(default=0)),
            ],
            options={
                'db_table': 'usda',
                'ordering': ['-percent', '-likes'],
            },
        ),
        migrations.CreateModel(
            name='UserDB',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('height', models.PositiveSmallIntegerField(default=0)),
                ('weight', models.PositiveSmallIntegerField(default=0)),
                ('birth_date', models.DateField(blank=True, default=None, help_text='Required. Format: MM-DD-YYYY', null=True)),
                ('activity_level', models.CharField(blank=True, choices=[('Sedentary', 'Sedentary'), ('Low Active', 'Low Active'), ('Active', 'Active'), ('Very Active', 'Very Active')], default='Sedentary', max_length=100, null=True)),
                ('diet', models.CharField(blank=True, choices=[('None', 'None'), ('pescetarian', 'Pescetarian'), ('Lacto Vegetarian', 'Lacto Vegetarian'), ('Ovo Vegetarian', 'Ovo Vegetarian'), ('Vegan', 'Vegan'), ('Paleo', 'Paleo'), ('Primal', 'Primal'), ('Vegetarian', 'Vegetarian')], default=None, max_length=100, null=True)),
                ('gender', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female')], default=None, max_length=100, null=True)),
                ('accepts_popups', models.BooleanField(default=True)),
                ('timeToCook', models.PositiveSmallIntegerField(default=30)),
            ],
            options={
                'db_table': 'users',
            },
        ),
        migrations.AddField(
            model_name='saved_recipes',
            name='user',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.UserDB'),
        ),
        migrations.AddField(
            model_name='preferencerawfoods',
            name='userdb',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.UserDB'),
        ),
        migrations.AddField(
            model_name='preferencecuisines',
            name='userdb',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.UserDB'),
        ),
        migrations.AddField(
            model_name='intolerences',
            name='userdb',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.UserDB'),
        ),
        migrations.AddField(
            model_name='feedbackrawfood',
            name='food',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.USDAfoods'),
        ),
        migrations.AddField(
            model_name='feedbackrawfood',
            name='user',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.UserDB'),
        ),
        migrations.AddField(
            model_name='feedback',
            name='recipe',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.Recipe'),
        ),
        migrations.AddField(
            model_name='feedback',
            name='user',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='diet_optimizer_website.UserDB'),
        ),
    ]
