import sqlite3 as lite
import sys

# http://www.footballbabble.com/football/defense/plays/ for football
# http://zetcode.com/db/sqlitepythontutorial/ for sqlite
moreplays = (
	('Trap', '4-3', 3),
	('Trap', 'Four-Man Rush', 8)
)

try:

    con = lite.connect('football.db')
    
    cur = con.cursor() 
    cur.execute("DROP TABLE IF EXISTS play")
    cur.execute("CREATE TABLE play(offenseplay TEXT, defenseplay TEXT, yardsgain INT)")
    cur.execute("INSERT INTO play VALUES ('Dive', '4-3', 13)")
    cur.execute("INSERT INTO play VALUES ('Dive', 'Four-Man Rush', 6)")
    cur.execute("INSERT INTO play VALUES ('Sweep', '4-3', 2)")
    cur.execute("INSERT INTO play VALUES ('Sweep', 'Four-Man Rush', -3)")
    cur.executemany("INSERT INTO play VALUES(?, ?, ?)", moreplays)

    con.commit()

except lite.Error, e:
    
    if con:
        con.rollback()
        
    print "Error %s:" % e.args[0]
    sys.exit(1)
    
finally:
    
    if con:
        con.close() 

