import random
# from client_runner import play
from uuid import uuid4


# for concurrent runs, dont use global state
def compute_bid_state(info, prev_state=None):
    if prev_state is None:
        prev_state = 0
    next_state = prev_state + 1
    bid = compute_bid(info)
    return bid, next_state


order_early = []

# these variables keep track of your priority and opponent's priority
mypick = ""
opppick = ""

# helper function that calculates the order in which the paintings end
# for paintings to end, you need 3 in succession
def calculate_pick(order, dict={}):
    dict = {}
    order_early = []
    
    for el in order:
        if el in dict: dict[el] += 1
        else: dict[el] = 1

        if dict[el] == 3:
            order_early.append(el)
    
    return order_early

    # print(order_early)

# we look at a fixed number of paintings in the beginning of sequence to pick our priority and also opponent's
# using the helper function above
def initial_analysis(info):
    global mypick, opppick, order_early

    perm = info["items"][:20]
    order_early = calculate_pick(perm, info)
    
    mypick = opppick = order_early[0]

def choose_opponent(info):
    opp = ''
    if len(info["others"]) == 1:
        opp = info["others"][0]
    else:
        os = []

        # we take all the players who are going for our pick, and we claim that's our opponent
        for o in info["others"]:
            os.append(o["item_count"][mypick])
        i = os.index(max(os))

        opp = info["others"][i]

    return opp

# main analysis function for subsequent rounds
def analyze(info):
    global opppick, mypick
    round = info["cur_round"]   # current round number
    curr = info["items"][round]     # current painting

    # get what we can almost win
    me_almost_wins = []
    my_count = info["self"]["item_count"]
    for p in my_count:
        if my_count[p] == 2:
            me_almost_wins.append(p)
    
    # bid everything if we're about to win
    # if info["self"]["item_count"][mypick] in me_almost_wins and curr == mypick: return info["self"]["budget"]
    if curr in me_almost_wins: return info["self"]["budget"]

    # early return if it's the first round and we find what we want
    if round == 0 and curr == mypick: return 33
    
    # who's my opponent? for multiplayer
    opp = choose_opponent(info)
    
    # getting opponent's almost wins
    almost_wins = []
    opp_paintings = opp["item_count"]
    for e in opp_paintings:
        if opp_paintings[e] == 2:
            almost_wins.append(e)
    
    #-----HELPER VARIABLES ------
    mybudget = info["self"]["budget"]
    # mypaintings = 3 - info["self"]["item_count"][mypick]
    opp_rem_budget = opp["budget"]
    opp_rem_paintings = 3 - opp["item_count"][opppick]

    # block = int(mybudget - ((opp_rem_budget/opp_rem_paintings)*mypaintings) ) +1
    block = opp_rem_budget + 1
    #------------------------------

    # if opponent close to winning, block with +1
    if (curr in almost_wins):
        # print("im blocking")
        if block <= mybudget:
            return block
    
    # if they aren't about to win
    # change my pick
    # if they have more of their priority painting than us...
    if opp["item_count"][opppick] > info["self"]["item_count"][opppick]:
        # keep outbidding opponent if they spend a lot on the first round
        if curr == mypick and int(opp_rem_budget / opp_rem_paintings) < int(mybudget / (3-info["self"]["item_count"][opppick])):
            bid = int(opp_rem_budget / opp_rem_paintings) + 1
            return bid
        else:
            # if they haven't spent a lot on the first painting, change your pick
            for p in order_early:
                if p != opppick:
                    mypick = p
                    break
    
    
    # some programs might use a specific 'low bid', we can try to outbid that
    low_bid = 1
    filtered = list(filter(lambda h: h["bid"] < 5, info["history"]))
    if len(filtered) >= 1: low_bid = max(filtered, key=(lambda x: x["bid"]))["bid"] + 1

    # if current painting isn't what we want, make a low bid
    if curr != mypick:
        return low_bid
    else:
        # if we want the current painting, but opponent doesn't want it, make a low bid
        if mypick != opppick:
            return low_bid
        else:
            # if both of us want, make max bid
            return 33
      

def compute_bid(info):
    if info["cur_round"] == 0:
        initial_analysis(info)

    # if can't find paintings that end earlier, just don't bother bidding
    if info["items"][info["cur_round"]] not in order_early: return 0
    return analyze(info)


if __name__ == "__main__":
    my_name = "matt-" + uuid4().hex[:6]
    server = "tcp://localhost:50018"
    print(my_name)
    play(my_name, server, compute_bid)


