import copy
import os
import platform
import random
import time
import setupngrok
from math import ceil


class Solver:
  # Our bidding method inside a dedicated class for the following reasons:
  # 1. By encapsulating our state inside a class, the code is cleaner.
  # 2. Testing different bots is significantly simpler.

  def determine_bid(
    self, 
    my_id,
    standings,
    artist_names,
    player_ids,
    auction_items,
    round_number
  ):
    # Function for determining our bid.

    ##################### 
    # Utility functions.

    def find_bid_for_preventing_loss():
      # Function that returns two things:
      # 1. How much money we should spend to prevent losing from any opponent on this round.
      # 2. Whether we should wait when blocking.
      to_spend = 0
      for id in player_ids:
        if id != my_id and standings[id][artist] == 2:
          # This player can potentially win this round.
          needed_to_block = money[id] + 1
          to_spend = max(to_spend, needed_to_block)
      
      should_wait = True
      if to_spend > my_money:
        # We don't have enough money to block someone who is about to win.
        # So instead opt to spend as much money as we have.
        to_spend = my_money
        should_wait = False

      return to_spend, should_wait

    def find_artist_for_fastest_theoretical_win():
      # Function that returns artist with which we can theoretically
      # win the soonest, if we bought every painting from the artist,
      # from the current round onwards.
      # This logic is inside a function because this way we will run this code
      # only when needed, and not every time, which should make our program faster.

      # artist_counts_running[artist] tracks how many times we have seen
      # this artist at some point in time.
      # E.g. artist_names = ['picasso', 'da vinci', 'rembrandt', 'van gogh']
      # ===> artist_counts_running = {'picasso': 1, 'da vinci': 0, 'rembrandt': 2, 'van gogh': 1}
      # Initially this is just a copy of our standings. We copy it because we modify it inside
      # this function, and we don't want to keep those changes after the function ends.
      artist_counts_running = copy.copy(standings[my_id])

      # For each round starting from this round...
      # For example:      
      # auction_items = [D, R, R, D, V, P, P, P, R, V, V, V, D]
      # round_number           2
      # r                      2  3  4  5  6  7  8 ...
      for r in range(round_number, len(auction_items)):
        artist_at_r = auction_items[r]
        
        # In case the item at round r is an empty string or invalid
        # (which does happen at one point, with the current provided server code),
        # skip this item and continue to the next.
        if artist_at_r not in artist_names:
          continue

        # Increase count for this artist.
        artist_counts_running[artist_at_r] += 1

        # If we could theoretically buy all paintings of this artist until
        # round r...
        if artist_counts_running[artist_at_r] == 3:
          # This is the artist we are looking for.
          return artist_at_r

      # We cannot win with any artist.
      return None

    ############################
    # Declaring main variables.

    # Money[id] = how much money a player has.
    money = {id: standings[id]['money'] for id in player_ids}
      
    # my_max_owned_items = max owned items by us for any artist.
    # So if we have 1, 0, 2, and 1 paintings from each artist, it would be 2.
    # This number is just the max of all values in the dictionary for our standings.
    my_max_owned_items = max(standings[my_id][name] for name in artist_names)

    # artist = current artist being bid on.
    artist = auction_items[round_number]
    
    # Our current money.
    my_money = money[my_id]

    # How much we will bid.
    bid = 0

    ##############
    # Main logic.

    # The case when we own two items.
    if my_max_owned_items == 2 and standings[my_id][artist] == 2:
      # This is our artist and we have two paintings of them, so spend everything.
      # Either spend all money if this is our artist, or spend none.
      bid = my_money

    # The case when we own no items.
    elif my_max_owned_items == 0:
      best_artist = find_artist_for_fastest_theoretical_win()
      if best_artist == artist:
        bid = max(bid, my_money * 0.34)
      else:
        bid = max(bid, my_money * random.uniform(0, 0.02))

    # The case when we own one item of an artist, and no more. 
    elif my_max_owned_items == 1:
      if standings[my_id][artist] == 1:
        bid = max(bid, my_money * 0.5)
      else:
        bid = max(bid, my_money * random.uniform(0.02, 0.03))

    # Find bid for preventing loss ('blocking'), if we have to.
    bid_for_preventing_loss, should_wait_when_blocking = find_bid_for_preventing_loss()
    if bid_for_preventing_loss > bid:
      # How hard we try to prevent a loss depends on the number of players.
      # If there are 3 or fewer players, always try to prevent a loss.
      # If there are more, prevent a loss if we would have to spend 
      # at most 30% of our money.
      num_players = len(player_ids)
      prevention_factor = 1 if num_players <= 3 else 0.3

      if bid_for_preventing_loss <= prevention_factor * my_money:
        # Wait a few seconds, so if anyone else also tries to prevent loss,
        # they bid before us.
        if should_wait_when_blocking:
          time.sleep(3)

        bid = bid_for_preventing_loss

    # Return our bid.
    return min(ceil(bid), my_money)


# Seed the random number generator to ensure our random numbers are different
# every time we run the program.
random.seed()

# Create the solver object. We will use solver.determine_bid() to determine our bids.
solver = Solver()

# Our bidder id.
mybidderid = "vlad_sam"

#######################################################





socket = setupngrok.socket

# port = "10849"
# context = zmq.Context()
# print("Connecting to server...")
# socket = context.socket(zmq.REQ)
# socket.connect(f"tcp://4.tcp.ngrok.io:{port}")

# APPLICATION
numberbidders = 0 # Will be given by server.
artists = ['Picasso', 'Rembrandt', 'Van_Gogh', 'Da_Vinci']

def determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round):
  # Call the solver function to determine the bid.
  return solver.determine_bid(mybidderid, standings, artists, players, itemsinauction, round)

# DATA
while len(mybidderid) == 0 or ' ' in mybidderid:
  mybidderid = input("You input an empty string or included a space in your name which is not allowed (_ or / are all allowed)\n for example Emil_And_Nischal is okay\nInput team / player name: ").strip()

moneyleft = 100 # should change over time
winnerarray = [] # who won each round
winneramount = [] # how much they paid

itemsinauction = []
myTypes = {'Picasso': 0, 'Rembrandt': 0, 'Van_Gogh': 0, 'Da_Vinci': 0, 'money': moneyleft}

# EXECUTION

# get list of items and types
getlistflag = 1
socket.send((str(mybidderid)).encode())
while(getlistflag == 1):
  data = socket.recv(5024)
  x = (data.decode("utf-8")).split(" ")
  # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
  #Receives first how many players are in the game and then all 200 items in auction
  if(x[0] != "Not" and len(data) != 0):
    getlistflag = 0
    numberbidders = int(x[0])
    itemsinauction = x[1:]
  else:
    time.sleep(2)

while True:
  socket.send((str(mybidderid) + ' ').encode())
  data = socket.recv(5024)
  x = (data.decode("utf-8")).split(" ")
  #Wait until everyone has connected before bidding
  if (x[0] == 'wait'):
    continue
  #When everyone has connected the server knows all names
  #it can therefore transfer all the names after telling the client that it's ready
  players = []
  for player in range(1, numberbidders + 1):
    players.append(x[player])
  break

#Create initial standings for each player after everyone connected
standings = {name: {'Picasso': 0, 'Van_Gogh': 0, 'Rembrandt': 0, 'Da_Vinci': 0, 'money': 100} for name in players}
# now do bids
continueflag = 1
j = 0
if platform.system() == 'Windows':
  os.system('cls')
else:
  os.system('clear')
while(continueflag == 1):
  #roundStart = time.time()
  print(random.choice(["I'm doing my best, okay?", "Why aren't you cheering louder?", "Aren't you proud of me?", "Damn I'm good, and I don't even have a brain!", "And do you think you could do any better?", "I feel like it's me doing all the work, you're just chilling in your chair", "If I lose this it's your fault not mine... I'm doing EXACTLY what you told me to do!"]))
  print()
  bidflag = 1
  bid = determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, len(winnerarray))
  
  #sleep before sending the bid to make sure the server is ready, currently it's at a very big value 1
  #this should make it safe for any speed of computers or internet, but can probably be lower as I have had
  #it working on Wifi with my computer at 0.2
  time.sleep(1)
  socket.send((str(mybidderid) + " " + str(bid)).encode())
  while(bidflag == 1):
    # print "Have sent data from ", str(mybidderid)
    data = socket.recv(5024)
    x = (data.decode("utf-8")).split(" ")
    # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
    if(x[0] != "Not"):
      bidflag = 0
    else:
      print("exception")
      time.sleep(2)


  resultflag = 1
  while(resultflag == 1):
    socket.send((str(mybidderid)).encode())
    # print "Have sent data from ", str(mybidderid)
    data = socket.recv(5024)
    x = (data.decode("utf-8")).split(" ")
    #Wait for all bids to be received
    if (x[0] == 'wait'):
      continue
    # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
    #Check if the server told client that game is finished
    if len(x) >= 7 and x[7] == 'won.':
      time.sleep(5)
      continueflag = 0
      resultflag = 0
      print(data)
      print()
      print('game over')
    #Else update standings, winnerarray etc.
    if(x[0] != "ready") and (continueflag == 1):
      #roundLength = time.time()-roundStart
      #time.sleep(max(0, 5-roundLength))
      resultflag = 0
      if platform.system() == 'Windows':
        os.system('cls')
      else:
        os.system('clear')
      # print x
      winnerarray.append(x[0])
      winneramount.append(int(x[5]))
      standings[x[0]]['money'] -= int(x[5])
      standings[x[0]][x[3]] += 1
      if (x[0] == mybidderid):
        moneyleft -= int(x[5])
        myTypes[itemsinauction[j]] += 1
      # update moneyleft, winnerarray
    else:
      time.sleep(2)
  j+= 1
